/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.undo.DocumentUndoEvent;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoListener;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.inspect.InspectView;

public enum InspectViewWaveDromListener {
    INSTANCE;

    private static final boolean INSPECT_DISABLED;
    private static final long TRIGGER_JOB_DELAY = 300L;
    private TriggerInspectUpdateJob fTriggerWaveDromViewer = new TriggerInspectUpdateJob();
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            Object source = event.getSource();
            if (!(source instanceof StyledText)) {
                return;
            }
            StyledTextContent styledText = ((StyledText)source).getContent();
            if (styledText == null || styledText.getCharCount() == 0) {
                return;
            }
            InspectViewWaveDromListener.this.triggerInspectViewJob(styledText.getTextRange(0, Math.min(PrefConst.getWaveformMaxLength(), styledText.getCharCount())));
        }
    };
    private IDocumentUndoListener fDocumentUndoListener = new IDocumentUndoListener(){

        public void documentUndoNotification(DocumentUndoEvent event) {
            try {
                InspectViewWaveDromListener.this.triggerInspectViewJob(event.getDocument().get(0, Math.min(PrefConst.getWaveformMaxLength(), event.getDocument().getLength())));
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    };
    private IPartListener fPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
            if (!(part instanceof IEditorPart)) {
                return;
            }
            InspectViewWaveDromListener.this.installListeners((IEditorPart)part);
        }

        public void partClosed(IWorkbenchPart part) {
            ITextOperationTarget target;
            if (!(part instanceof AbstractTextEditor)) {
                return;
            }
            IEditorPart editor = part.getSite().getPage().getActiveEditor();
            if (editor == null || editor instanceof DVTEditor) {
                return;
            }
            Control control = (Control)((AbstractTextEditor)part).getAdapter(Control.class);
            if (!(control instanceof StyledText)) {
                return;
            }
            if (((StyledText)control).isListening(24)) {
                ((StyledText)control).removeModifyListener(InspectViewWaveDromListener.this.fModifyListener);
            }
            if (!((target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class)) instanceof ITextViewer)) {
                return;
            }
            IDocument document = ((ITextViewer)target).getDocument();
            if (document == null) {
                return;
            }
            IDocumentUndoManager documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
            if (documentUndoManager == null) {
                return;
            }
            documentUndoManager.removeDocumentUndoListener(InspectViewWaveDromListener.this.fDocumentUndoListener);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            try {
                if (!(part instanceof AbstractTextEditor)) {
                    return;
                }
                Control control = (Control)((AbstractTextEditor)part).getAdapter(Control.class);
                if (!(control instanceof StyledText)) {
                    return;
                }
                IEditorPart editor = part.getSite().getPage().getActiveEditor();
                if (editor == null) {
                    return;
                }
                IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
                if (file == null) {
                    return;
                }
                ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
                if (!(target instanceof ITextViewer)) {
                    return;
                }
                IDocument document = ((ITextViewer)target).getDocument();
                if (document == null) {
                    return;
                }
                if (editor instanceof DVTEditor) {
                    if (((DVTEditor)editor).getCodePartition().isEmpty()) {
                        return;
                    }
                    String partition = ((IDocumentExtension3)document).getContentType(((DVTEditor)editor).getCodePartition(), ((DVTEditor)editor).getCursor(), false);
                    if (!InspectViewWaveDromListener.this.isCommentPartition(partition)) {
                        return;
                    }
                    String waveform = InspectViewWaveDromListener.this.getWaveform(document, ((DVTEditor)editor).getCursor(), ((DVTEditor)editor).getCodePartition(), partition);
                    if (waveform.isEmpty()) {
                        return;
                    }
                    InspectViewWaveDromListener.this.triggerInspectViewJob(waveform);
                } else {
                    IDocumentUndoManager documentUndoManager;
                    if (!InspectViewWaveDromListener.this.checkValidExtension(file)) {
                        return;
                    }
                    if (!((StyledText)control).isListening(24)) {
                        ((StyledText)control).addModifyListener(InspectViewWaveDromListener.this.fModifyListener);
                    }
                    if ((documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document)) == null) {
                        return;
                    }
                    documentUndoManager.addDocumentUndoListener(InspectViewWaveDromListener.this.fDocumentUndoListener);
                    InspectViewWaveDromListener.this.triggerInspectViewJob(document.get(0, Math.min(PrefConst.getWaveformMaxLength(), document.getLength())));
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    };
    private volatile boolean fWavedromVisible = true;
    private static final String SL_SLASH_COMMENT = "(\n|\r\n?)\\s*[/]{2,}";
    private static final String SL_DASH_COMMENT = "(\n|\r\n?)\\s*[-]{2,}";
    private static final String ML_COMMENT = "(\n|\r\n?)\\s*[*]*";

    static {
        INSPECT_DISABLED = System.getenv("DISABLE_INSPECT_VIEW") != null;
    }

    public void init() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.fPartListener);
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                window.getActivePage().addPartListener(InspectViewWaveDromListener.this.fPartListener);
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                window.getActivePage().removePartListener(InspectViewWaveDromListener.this.fPartListener);
            }

            public void windowActivated(IWorkbenchWindow window) {
            }
        });
        for (IEditorReference editorReference : Utils.getCurrentlyOpenEditorReferences()) {
            IEditorPart editor = editorReference.getEditor(false);
            this.installListeners(editor);
        }
    }

    private void installListeners(IEditorPart editor) {
        if (!(editor instanceof AbstractTextEditor)) {
            return;
        }
        if (editor instanceof DVTEditor) {
            return;
        }
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return;
        }
        if (!this.checkValidExtension(file)) {
            return;
        }
        Control control = (Control)((AbstractTextEditor)editor).getAdapter(Control.class);
        if (!(control instanceof StyledText)) {
            return;
        }
        ((StyledText)control).addModifyListener(this.fModifyListener);
        ITextOperationTarget adapter = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        if (!(adapter instanceof ITextViewer)) {
            return;
        }
        IDocument document = ((ITextViewer)adapter).getDocument();
        if (document == null) {
            return;
        }
        IDocumentUndoManager documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
        if (documentUndoManager == null) {
            return;
        }
        documentUndoManager.addDocumentUndoListener(this.fDocumentUndoListener);
    }

    private boolean checkValidExtension(IFile file) {
        Set<String> wavedromFileExtensions = BuildConfigManager.getWavedromFileExtensions(file.getProject());
        for (String ext : wavedromFileExtensions) {
            if (!file.getName().endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }

    public void setWavedromVisibility(boolean visible) {
        this.fWavedromVisible = visible;
    }

    public boolean wavedromIsVisible() {
        return this.fWavedromVisible;
    }

    private String getCurrentPartition(IDocument document, String editorPartition, int offset) {
        String result = "";
        try {
            result = ((IDocumentExtension3)document).getContentType(editorPartition, offset, false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public String getWaveform(IDocument document, int offset, String editorPartition, String waveformPartition) {
        char currentCharacter;
        StringBuilder firstHalfOfWaveform = new StringBuilder();
        StringBuilder secondHalfOfWaveform = new StringBuilder();
        DVTCharacterScanner scanner = new DVTCharacterScanner(100, document, offset, true);
        boolean potentialPragma = false;
        int waveformEndOffset = Integer.MAX_VALUE;
        StringBuilder pragmaFinder = new StringBuilder();
        while ((currentCharacter = (char)scanner.read()) != '\uffff' && scanner.getOffset() < offset + PrefConst.getWaveformMaxLength()) {
            String currentPartition = this.getCurrentPartition(document, editorPartition, scanner.getOffset() - 1);
            if (!currentPartition.equals(waveformPartition) && (!currentPartition.equals("__dftl_partition_content_type") || !Character.isWhitespace(currentCharacter))) break;
            secondHalfOfWaveform.append(currentCharacter);
            if (currentCharacter == '@') {
                potentialPragma = true;
                pragmaFinder.setLength(0);
            }
            if (potentialPragma) {
                pragmaFinder.append(currentCharacter);
            }
            if (pragmaFinder.length() == "@WAVEDROM_END".length()) {
                if (pragmaFinder.toString().equals("@WAVEDROM_END")) {
                    waveformEndOffset = scanner.getOffset() - pragmaFinder.length();
                    break;
                }
                pragmaFinder.setLength(0);
                potentialPragma = false;
                continue;
            }
            if (pragmaFinder.length() != "@WAVEDROM_START".length() || !pragmaFinder.toString().equals("@WAVEDROM_START")) continue;
            return "";
        }
        if (waveformEndOffset == Integer.MAX_VALUE) {
            return "";
        }
        int charactersRead = scanner.getOffset() - offset;
        int waveformStartOffset = Integer.MAX_VALUE;
        scanner.setOffset(offset);
        scanner.setBackwardDirection();
        pragmaFinder.setLength(0);
        potentialPragma = false;
        while ((currentCharacter = (char)scanner.read()) != '\uffff' && scanner.getOffset() > offset - (PrefConst.getWaveformMaxLength() - charactersRead)) {
            String currentPartition = this.getCurrentPartition(document, editorPartition, scanner.getOffset());
            if (!currentPartition.equals(waveformPartition) && (!currentPartition.equals("__dftl_partition_content_type") || !Character.isWhitespace(currentCharacter))) break;
            firstHalfOfWaveform.append(currentCharacter);
            pragmaFinder.append(currentCharacter);
            if (currentCharacter != '@' || pragmaFinder.length() < "@WAVEDROM_END".length()) continue;
            StringBuilder potentialWavedromPragma = pragmaFinder.reverse();
            if (potentialWavedromPragma.indexOf("@WAVEDROM_END") != -1) break;
            if (pragmaFinder.length() >= "@WAVEDROM_START".length() && potentialWavedromPragma.indexOf("@WAVEDROM_START") != -1) {
                waveformStartOffset = scanner.getOffset() + "@WAVEDROM_START".length();
                firstHalfOfWaveform = firstHalfOfWaveform.reverse();
                break;
            }
            pragmaFinder.setLength(0);
        }
        if (waveformStartOffset != Integer.MAX_VALUE && waveformEndOffset != Integer.MAX_VALUE) {
            String rawWaveform = firstHalfOfWaveform.append((CharSequence)secondHalfOfWaveform).toString();
            return this.formatWaveform(rawWaveform, waveformPartition, editorPartition);
        }
        return "";
    }

    private String formatWaveform(String waveform, String waveformPartiton, String editorPartition) {
        if (waveform == null || waveform.isEmpty()) {
            return "";
        }
        waveform = waveform.replace("@WAVEDROM_START", "").replace("@WAVEDROM_END", "");
        if ("__vlog_partitioning".equals(editorPartition) || "__pss_partitioning".equals(editorPartition) || "__msdl_partitioning".equals(editorPartition)) {
            if (this.isSingleLineComment(waveformPartiton)) {
                return waveform.replaceAll(SL_SLASH_COMMENT, "");
            }
            return waveform.replaceAll(ML_COMMENT, "");
        }
        if ("__vhdl_partitioning".equals(editorPartition)) {
            if (this.isSingleLineComment(waveformPartiton)) {
                return waveform.replaceAll(SL_DASH_COMMENT, "");
            }
            return waveform.replaceAll(ML_COMMENT, "");
        }
        if ("__e_partitioning".equals(editorPartition)) {
            if (this.isSingleLineComment(waveformPartiton)) {
                return waveform.replaceAll(SL_DASH_COMMENT, "").replaceAll(SL_SLASH_COMMENT, "");
            }
            return waveform.replaceAll(ML_COMMENT, "");
        }
        return "";
    }

    public boolean isCommentPartition(String partition) {
        if ("__vlog_sl_comment".equals(partition) || "__vlog_ml_comment".equals(partition)) {
            return true;
        }
        if ("__vhdl_sl_comment".equals(partition) || "__vhdl_ml_comment".equals(partition)) {
            return true;
        }
        if ("__e_sl_comment".equals(partition) || "__e_ml_comment".equals(partition) || "__e_sv_ml_comment".equals(partition)) {
            return true;
        }
        if ("__pss_sl_comment".equals(partition) || "__pss_ml_comment".equals(partition)) {
            return true;
        }
        return "__msdl_sl_comment".equals(partition) || "__msdl_ml_comment".equals(partition);
    }

    private boolean isSingleLineComment(String partition) {
        if ("__e_sl_comment".equals(partition)) {
            return true;
        }
        if ("__vlog_sl_comment".equals(partition)) {
            return true;
        }
        if ("__vhdl_sl_comment".equals(partition)) {
            return true;
        }
        if ("__pss_sl_comment".equals(partition)) {
            return true;
        }
        return "__msdl_sl_comment".equals(partition);
    }

    public void runInspectViewJob(String content) {
        this.triggerInspectViewJobInternal(content, 0L);
    }

    public void triggerInspectViewJob(String content) {
        this.triggerInspectViewJobInternal(content, 300L);
    }

    private void triggerInspectViewJobInternal(String content, long delay) {
        if (INSPECT_DISABLED) {
            return;
        }
        this.fTriggerWaveDromViewer.cancel();
        this.fTriggerWaveDromViewer.setContent(content);
        this.fTriggerWaveDromViewer.schedule(delay);
    }

    private class TriggerInspectUpdateJob
    extends Job {
        private String fContent;
        private String fLastContent;

        public TriggerInspectUpdateJob() {
            super("Trigger WaveDrom Update Job");
            this.fContent = null;
            this.fLastContent = null;
        }

        void setContent(String content) {
            this.fContent = content;
        }

        public IStatus run(IProgressMonitor monitor) {
            Shell activeWorkbenchShell = DVTUiUtils.getActiveWorkbenchShell();
            if (activeWorkbenchShell == null) {
                return this.returnCancel();
            }
            if (!InspectView.isActive()) {
                return this.returnCancel();
            }
            if (this.fLastContent != null && this.fLastContent.equals(this.fContent) && InspectViewWaveDromListener.this.fWavedromVisible) {
                return this.returnCancel();
            }
            this.fLastContent = this.fContent;
            if (!monitor.isCanceled()) {
                InspectView.getInstance().update(new InspectViewUpdateEvent(this.fContent));
            }
            this.fContent = null;
            return Status.OK_STATUS;
        }

        private IStatus returnCancel() {
            this.fContent = null;
            return Status.CANCEL_STATUS;
        }
    }
}

