/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.diagrams.BitfieldViewMode;
import ro.amiq.dvt.diagrams.tables.TableExportFormat;
import ro.amiq.dvt.diagrams.tables.TableExportUtils;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.icons.IconImageDescriptor;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.inspect.WavedromSaveDialog;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.JarUtils;

public class InspectViewWavedromComponent {
    private static final String WAVEDROM_HTML_PAGE_PATH = "/resources/wavedrom/inspect_view_wavedrom.html";
    private static final String WAVEDROM_HTML_PAGE_CONTENT = InspectViewWavedromComponent.getHTMLPageContent();
    private static final String BITFIELD_SINGLE_LANE_IMAGE_BASE64 = InspectViewWavedromComponent.getEncodedImageBase64((IconImageDescriptor)DVTImages.INSPECT_BITFIELD_V_LAYOUT);
    private static final String BITFIELD_MULTIPLE_LANES_IMAGE_BASE64 = InspectViewWavedromComponent.getEncodedImageBase64((IconImageDescriptor)DVTImages.INSPECT_BITFIELD_H_LAYOUT);
    private Browser browser;
    private AtomicBoolean browserPageLoadCompleted = new AtomicBoolean();
    private String browserPageUUID = UUID.randomUUID().toString();
    private final AtomicBoolean bitfieldSplitMode = new AtomicBoolean(PrefConst.getBitfieldViewMode().equals((Object)BitfieldViewMode.SPLIT));
    private static final int ENABLE_ZOOM_BIT_THRESHOLD = 36;
    private Object lastInput;
    private String svgDiagram = "";
    private static final String BITFIELD_LAYOUT_BUTTON_HTML = "<button onclick='changeBitfieldLayout()' style = \"position:relative; left:10px;\" type='submit'><img title=\"Change Bit Field layout\" src=\"{0}\" /></img></button>";

    public InspectViewWavedromComponent(Composite parent) {
        try {
            this.browser = new Browser(parent, 0);
            this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
            new OpenLinkJSFunction(this.browser);
            new ToggleBitfieldLayout(this.browser);
            this.browser.setText(WAVEDROM_HTML_PAGE_CONTENT.replace("CONTENT-UUID", this.browserPageUUID).replace("CONTENT", ""));
            this.browser.addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    boolean isChromium;
                    if (!InspectViewWavedromComponent.this.svgDiagram.isEmpty() && InspectViewWavedromComponent.this.lastInput instanceof BitFieldModel) {
                        ObjectionManager.getInstance().clear(Objection.INSPECT);
                        ObjectionManager.getInstance().clear(Objection.INSPECT_WAVEDROM_BITFIELD);
                    }
                    if (!(isChromium = Objects.equals(System.getProperty("org.eclipse.swt.browser.DefaultType"), "chromium")) && !InspectViewWavedromComponent.this.browser.getText().contains(InspectViewWavedromComponent.this.browserPageUUID)) {
                        return;
                    }
                    InspectViewWavedromComponent.this.browserPageLoadCompleted.set(true);
                    if (Wavedrom.getInstance().isDarkTheme()) {
                        InspectViewWavedromComponent.this.browser.execute("document.documentElement.classList.add('dark-mode');");
                    } else {
                        InspectViewWavedromComponent.this.browser.execute("document.documentElement.classList.remove('dark-mode');");
                    }
                    if (!(InspectViewWavedromComponent.this.lastInput instanceof BitFieldModel)) {
                        return;
                    }
                    if (!EclipseUtils.isAtLeastEclipse411()) {
                        InspectViewWavedromComponent.this.browser.execute("setupOldBrowserMode()");
                    }
                    if (((BitFieldModel)InspectViewWavedromComponent.this.lastInput).isUvmRegister()) {
                        return;
                    }
                    if (((BitFieldModel)InspectViewWavedromComponent.this.lastInput).view == BitfieldViewMode.LINKED && ((BitFieldModel)InspectViewWavedromComponent.this.lastInput).getSize() > 36) {
                        InspectViewWavedromComponent.this.browser.execute("addPanZoom();");
                    }
                }

                public void changed(ProgressEvent event) {
                }
            });
            Menu saveAsMenu = new Menu((Decorations)this.browser.getShell(), 8);
            MenuItem saveAsSVGMenuItem = new MenuItem(saveAsMenu, 8);
            saveAsSVGMenuItem.setText("Save Diagram...");
            saveAsSVGMenuItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_GRAPHVIZ_SAVEAS));
            saveAsSVGMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        String svgDiagramContent = InspectViewWavedromComponent.this.getSVGDiagram().replace("dark-mode", "");
                        WavedromSaveDialog dialog = new WavedromSaveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), svgDiagramContent, InspectViewWavedromComponent.this.lastInput instanceof BitFieldModel ? "bitfields_of_" + ((BitFieldModel)InspectViewWavedromComponent.this.lastInput).getName() : "waveform");
                        dialog.open();
                    }
                    catch (Exception er) {
                        DVTLogger.INSTANCE.logError((Throwable)er);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.createCopyToClipboardMenu(saveAsMenu);
            this.browser.setMenu(saveAsMenu);
            saveAsSVGMenuItem.setEnabled(true);
        }
        catch (SWTError e) {
            DVTLogger.INSTANCE.logError((Throwable)new Exception(e));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void createCopyToClipboardMenu(Menu saveAsMenu) {
        MenuItem copyTableMenuItem = new MenuItem(saveAsMenu, 64);
        copyTableMenuItem.setText("Copy Table As...");
        copyTableMenuItem.setToolTipText("Copy Table to Clipboard As...");
        copyTableMenuItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_GRAPHVIZ_COPY));
        Menu saveType = new Menu((Decorations)this.browser.getShell(), 4);
        copyTableMenuItem.setMenu(saveType);
        TableExportFormat[] tableExportFormatArray = TableExportFormat.values();
        int n = tableExportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TableExportFormat extension = tableExportFormatArray[n2];
            MenuItem format = new MenuItem(saveType, 8);
            format.setText(extension.toString());
            format.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        if (!(InspectViewWavedromComponent.this.lastInput instanceof BitFieldModel)) {
                            return;
                        }
                        TableExportUtils.INSTANCE.copyToClipboard(extension, (BitFieldModel)InspectViewWavedromComponent.this.lastInput);
                    }
                    catch (Exception err) {
                        DVTLogger.INSTANCE.logError((Throwable)err);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++n2;
        }
        saveAsMenu.addListener(22, event -> copyTableMenuItem.setEnabled(this.lastInput instanceof BitFieldModel));
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void generateWavedromDiagram(final Object input) {
        if (this.browser == null || this.browser.isDisposed() || input == null || input.equals(this.lastInput)) {
            ObjectionManager.getInstance().clear(Objection.INSPECT);
            ObjectionManager.getInstance().clear(Objection.INSPECT_WAVEDROM_BITFIELD);
            return;
        }
        if (input instanceof BitFieldModel && this.lastInput instanceof BitFieldModel) {
            if (!((BitFieldModel)input).getName().equals(((BitFieldModel)this.lastInput).getName())) {
                this.bitfieldSplitMode.set(PrefConst.getBitfieldViewMode().equals((Object)BitfieldViewMode.SPLIT));
            }
        } else {
            this.bitfieldSplitMode.set(PrefConst.getBitfieldViewMode().equals((Object)BitfieldViewMode.SPLIT));
        }
        Display.getDefault().asyncExec(() -> this.browser.execute("document.getElementById('content').innerHTML='Computing diagram for Inspect View...'"));
        this.lastInput = input;
        Job job = new Job("Computing diagram for Inspect View..."){

            protected IStatus run(IProgressMonitor monitor) {
                String[] waveform = new String[]{"", ""};
                try {
                    if (input instanceof String) {
                        if (((String)input).startsWith("WaveDrom description exceeds")) {
                            Display.getDefault().asyncExec(() -> InspectViewWavedromComponent.this.browser.execute("document.getElementById('content').innerHTML='" + WaveDromManager.getInstance().getWavedromTooLargeErrorMessage() + "'"));
                            return Status.CANCEL_STATUS;
                        }
                        waveform[0] = Wavedrom.getInstance().generateSVG((String)input);
                        InspectViewWavedromComponent.this.svgDiagram = waveform[0];
                    } else if (input instanceof BitFieldModel) {
                        waveform[0] = Wavedrom.getInstance().generateHTMLBitfieldTitle((BitFieldModel)input);
                        waveform[1] = Wavedrom.getInstance().generateBitfieldSVG((BitFieldModel)input);
                        InspectViewWavedromComponent.this.svgDiagram = waveform[1];
                    }
                    Display.getDefault().asyncExec(() -> {
                        try {
                            if (input instanceof BitFieldModel) {
                                stringArray[0] = waveform[0].replace("</div>", String.valueOf(MessageFormat.format(InspectViewWavedromComponent.BITFIELD_LAYOUT_BUTTON_HTML, InspectViewWavedromComponent.this.bitfieldSplitMode.get() ? BITFIELD_SINGLE_LANE_IMAGE_BASE64 : BITFIELD_MULTIPLE_LANES_IMAGE_BASE64)) + "</div>");
                                InspectViewWavedromComponent.this.browser.setText(WAVEDROM_HTML_PAGE_CONTENT.replace("CONTENT-UUID", InspectViewWavedromComponent.this.browserPageUUID).replace("CONTENT", String.valueOf(waveform[0]) + waveform[1]));
                            } else {
                                if (InspectViewWavedromComponent.this.browserPageLoadCompleted.get()) {
                                    InspectViewWavedromComponent.this.browser.execute("document.getElementById('content').innerHTML='" + StringEscapeUtils.escapeJavaScript((String)waveform[0]) + "'");
                                }
                                ObjectionManager.getInstance().clear(Objection.INSPECT);
                                ObjectionManager.getInstance().clear(Objection.INSPECT_WAVEDROM_BITFIELD);
                            }
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    });
                }
                catch (ScriptException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    Display.getDefault().asyncExec(() -> InspectViewWavedromComponent.this.browser.execute("document.getElementById('content').innerHTML='" + StringEscapeUtils.escapeJavaScript((String)e.getMessage()) + "'"));
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public String getSVGDiagram() {
        return "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n" + this.svgDiagram.replace(" xlink=", " xmlns:xlink=").replace("foreignobject", "foreignObject");
    }

    public void setVisible(boolean isVisible) {
        if (this.browser == null) {
            return;
        }
        Composite parent = this.browser.getParent();
        parent.setVisible(isVisible);
    }

    private static String getHTMLPageContent() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream fileStream = JarUtils.getFileStream(WAVEDROM_HTML_PAGE_PATH, InspectViewWavedromComponent.class);){
                return DVTStringUtil.streamToString(fileStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    private static String getEncodedImageBase64(IconImageDescriptor icon) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream fileStream = JarUtils.getFileStream(icon.getURL().getPath(), InspectViewWavedromComponent.class);){
                return "data:image/gif;base64," + Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)fileStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public String getRegisterModelDescription() {
        if (!(this.lastInput instanceof BitFieldModel)) {
            return "";
        }
        return "Register model " + ((BitFieldModel)this.lastInput).getName() + " WaveJSON format:\n------------------------------------\n" + ((BitFieldModel)this.lastInput).toWaveJSON();
    }

    public String testGetExportTable(TableExportFormat format) {
        StringBuilder sb = new StringBuilder();
        sb.append(TableExportUtils.INSTANCE.exportTableToFormat(format, (BitFieldModel)this.lastInput)).append(System.lineSeparator()).append(System.lineSeparator());
        return sb.toString();
    }

    public String testGetExportTableInAllFormats() {
        if (!(this.lastInput instanceof BitFieldModel)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Stream.of(TableExportFormat.values()).forEach(f2 -> {
            StringBuilder stringBuilder2 = sb.append("[" + f2.toString() + "]").append(System.lineSeparator()).append(TableExportUtils.INSTANCE.exportTableToFormat((TableExportFormat)((Object)f2), (BitFieldModel)this.lastInput)).append(System.lineSeparator()).append(System.lineSeparator());
        });
        return sb.toString();
    }

    private static final class OpenLinkJSFunction
    extends BrowserFunction {
        public OpenLinkJSFunction(Browser browser) {
            super(browser, "DVTOpenLink");
        }

        public Object function(Object[] arguments) {
            File file;
            super.function(arguments);
            if (arguments == null || arguments.length == 0) {
                return null;
            }
            if (!(arguments[0] instanceof String)) {
                return null;
            }
            if (arguments.length == 1) {
                PreferenceDialog preferenceDialog;
                Display.getDefault().getActiveShell().forceFocus();
                if (((String)arguments[0]).contains("ro.amiq.dvt.EditorsPreferencePage") && (preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"ro.amiq.dvt.EditorsPreferencePage", null, null)) != null) {
                    preferenceDialog.open();
                }
                return null;
            }
            if (arguments[1] instanceof Double && arguments[2] instanceof Double && (file = new File((String)arguments[0])).canRead()) {
                DVTFileUtils.getInstance().openEditorWithOffset(file, ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue(), true, "org.eclipse.ui.DefaultTextEditor");
            }
            return null;
        }
    }

    private final class ToggleBitfieldLayout
    extends BrowserFunction {
        public ToggleBitfieldLayout(Browser browser) {
            super(browser, "ToggleBitfieldLayout");
        }

        public Object function(Object[] arguments) {
            super.function(arguments);
            if (InspectViewWavedromComponent.this.lastInput instanceof BitFieldModel) {
                InspectViewWavedromComponent.this.bitfieldSplitMode.set(!InspectViewWavedromComponent.this.bitfieldSplitMode.get());
                InspectViewWavedromComponent.this.generateWavedromDiagram(((BitFieldModel)InspectViewWavedromComponent.this.lastInput).copy((BitFieldModel)InspectViewWavedromComponent.this.lastInput, InspectViewWavedromComponent.this.bitfieldSplitMode.get() ? BitfieldViewMode.SPLIT : BitfieldViewMode.LINKED));
            }
            return null;
        }
    }
}

