/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.undo.DocumentUndoEvent;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoListener;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.inspect.InspectView;

public enum WaveDromListener {
    INSTANCE;

    private static final boolean INSPECT_DISABLED;
    private static final long TRIGGER_JOB_DELAY = 300L;
    private TriggerInspectUpdateJob fTriggerWaveDromViewer = new TriggerInspectUpdateJob();
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            Object source = event.getSource();
            if (!(source instanceof StyledText)) {
                return;
            }
            StyledTextContent styledText = ((StyledText)source).getContent();
            if (styledText == null || styledText.getCharCount() == 0) {
                return;
            }
            WaveDromListener.this.triggerInspectViewJob(styledText.getTextRange(0, Math.min(PrefConst.getWaveformMaxLength(), styledText.getCharCount())));
        }
    };
    private IDocumentUndoListener fDocumentUndoListener = new IDocumentUndoListener(){

        public void documentUndoNotification(DocumentUndoEvent event) {
            try {
                WaveDromListener.this.triggerInspectViewJob(event.getDocument().get(0, Math.min(PrefConst.getWaveformMaxLength(), event.getDocument().getLength())));
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    };
    private IPartListener fPartListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
            if (!(part instanceof IEditorPart)) {
                return;
            }
            WaveDromListener.this.installListeners((IEditorPart)part);
        }

        public void partClosed(IWorkbenchPart part) {
            ITextOperationTarget target;
            if (!(part instanceof AbstractTextEditor)) {
                return;
            }
            IEditorPart editor = part.getSite().getPage().getActiveEditor();
            if (editor == null || editor instanceof DVTEditor) {
                return;
            }
            Control control = (Control)((AbstractTextEditor)part).getAdapter(Control.class);
            if (!(control instanceof StyledText)) {
                return;
            }
            if (((StyledText)control).isListening(24)) {
                ((StyledText)control).removeModifyListener(WaveDromListener.this.fModifyListener);
            }
            if (!((target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class)) instanceof ITextViewer)) {
                return;
            }
            IDocument document = ((ITextViewer)target).getDocument();
            if (document == null) {
                return;
            }
            IDocumentUndoManager documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
            if (documentUndoManager == null) {
                return;
            }
            documentUndoManager.removeDocumentUndoListener(WaveDromListener.this.fDocumentUndoListener);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            try {
                if (!(part instanceof AbstractTextEditor)) {
                    return;
                }
                Control control = (Control)((AbstractTextEditor)part).getAdapter(Control.class);
                if (!(control instanceof StyledText)) {
                    return;
                }
                IEditorPart editor = part.getSite().getPage().getActiveEditor();
                if (editor == null) {
                    return;
                }
                IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
                if (file == null) {
                    return;
                }
                ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
                if (!(target instanceof ITextViewer)) {
                    return;
                }
                IDocument document = ((ITextViewer)target).getDocument();
                if (document == null) {
                    return;
                }
                if (editor instanceof DVTEditor) {
                    if (((DVTEditor)editor).getCodePartition().isEmpty()) {
                        return;
                    }
                    String partition = ((IDocumentExtension3)document).getContentType(((DVTEditor)editor).getCodePartition(), ((DVTEditor)editor).getCursor(), false);
                    if (!DVTEditor.isCommentPartition(partition)) {
                        return;
                    }
                    String waveform = WaveDromManager.getInstance().getWaveform(document, file, ((DVTEditor)editor).getCursor(), ((DVTEditor)editor).getCodePartition(), partition);
                    if (waveform.isEmpty()) {
                        return;
                    }
                    WaveDromListener.this.triggerInspectViewJob(waveform);
                } else {
                    IDocumentUndoManager documentUndoManager;
                    if (!WaveDromListener.this.hasValidExtension(file)) {
                        return;
                    }
                    if (!((StyledText)control).isListening(24)) {
                        ((StyledText)control).addModifyListener(WaveDromListener.this.fModifyListener);
                    }
                    if ((documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document)) == null) {
                        return;
                    }
                    documentUndoManager.addDocumentUndoListener(WaveDromListener.this.fDocumentUndoListener);
                    WaveDromListener.this.triggerInspectViewJob(document.get(0, Math.min(PrefConst.getWaveformMaxLength(), document.getLength())));
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    };

    static {
        INSPECT_DISABLED = System.getenv("DISABLE_INSPECT_VIEW") != null;
    }

    public void init() {
        if (INSPECT_DISABLED || WaveDromManager.WAVEDROM_IS_DISABLED) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.fPartListener);
            PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                    IWorkbenchPage activePage = window.getActivePage();
                    if (activePage != null) {
                        activePage.addPartListener(WaveDromListener.this.fPartListener);
                    }
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                    IWorkbenchPage activePage = window.getActivePage();
                    if (activePage != null) {
                        activePage.removePartListener(WaveDromListener.this.fPartListener);
                    }
                }

                public void windowActivated(IWorkbenchWindow window) {
                }
            });
            for (IEditorReference editorReference : Utils.getCurrentlyOpenEditorReferences()) {
                IEditorPart editor = editorReference.getEditor(false);
                this.installListeners(editor);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void installListeners(IEditorPart editor) {
        if (!(editor instanceof AbstractTextEditor)) {
            return;
        }
        if (editor instanceof DVTEditor) {
            return;
        }
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return;
        }
        if (!this.hasValidExtension(file)) {
            return;
        }
        Control control = (Control)((AbstractTextEditor)editor).getAdapter(Control.class);
        if (!(control instanceof StyledText)) {
            return;
        }
        ((StyledText)control).addModifyListener(this.fModifyListener);
        ITextOperationTarget adapter = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        if (!(adapter instanceof ITextViewer)) {
            return;
        }
        IDocument document = ((ITextViewer)adapter).getDocument();
        if (document == null) {
            return;
        }
        IDocumentUndoManager documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
        if (documentUndoManager == null) {
            return;
        }
        documentUndoManager.addDocumentUndoListener(this.fDocumentUndoListener);
    }

    private boolean hasValidExtension(IFile file) {
        Set<String> wavedromFileExtensions = BuildConfigManager.getWavedromFileExtensions(file.getProject());
        for (String ext : wavedromFileExtensions) {
            if (!file.getName().endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }

    public void runInspectViewJob(Object content) {
        this.triggerInspectViewJobInternal(content, 0L);
    }

    public void triggerInspectViewJob(Object content) {
        this.triggerInspectViewJobInternal(content, 300L);
    }

    private void triggerInspectViewJobInternal(Object content, long delay) {
        if (INSPECT_DISABLED || WaveDromManager.WAVEDROM_IS_DISABLED) {
            return;
        }
        this.fTriggerWaveDromViewer.cancel();
        this.fTriggerWaveDromViewer.setContent(content);
        this.fTriggerWaveDromViewer.schedule(delay);
    }

    private class TriggerInspectUpdateJob
    extends Job {
        private Object fContent;

        public TriggerInspectUpdateJob() {
            super("Trigger WaveDrom Update Job");
            this.fContent = null;
        }

        void setContent(Object content) {
            this.fContent = content;
        }

        public IStatus run(IProgressMonitor monitor) {
            if (!DVTPlugin.getDefault().collect().c()) {
                return Status.CANCEL_STATUS;
            }
            Shell activeWorkbenchShell = DVTUiUtils.getActiveWorkbenchShell();
            if (activeWorkbenchShell == null) {
                return Status.CANCEL_STATUS;
            }
            if (!InspectView.isActive()) {
                return Status.CANCEL_STATUS;
            }
            if (!monitor.isCanceled()) {
                if (this.fContent instanceof BitFieldModel) {
                    InspectView.getInstance().update(new InspectViewUpdateEvent((BitFieldModel)this.fContent));
                } else if (this.fContent instanceof String) {
                    InspectView.getInstance().update(new InspectViewUpdateEvent((String)this.fContent));
                }
            }
            return Status.OK_STATUS;
        }
    }
}

