/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StoppableJob;

public class WavedromSaveDialog
extends Dialog {
    private static final IStatus EMPTY_FILE_STATUS = new Status(4, "ro.amiq.dvt", "Enter a file name.");
    private static final IStatus EMPTY_DIRECTORY_STATUS = new Status(4, "ro.amiq.dvt", "Enter a directory name.");
    private static final IStatus DIRECTORY_IS_FILE_STATUS = new Status(4, "ro.amiq.dvt", "A file with the same name as the directory exists.");
    private static final IStatus DIRECTORY_IS_NOT_WRITABLE_STATUS = new Status(4, "ro.amiq.dvt", "Directory is not writable.");
    private static final IStatus FILE_EXISTS_AS_RO_STATUS = new Status(4, "ro.amiq.dvt", "A file with the same name exists and it is read-only.");
    private static final IStatus FILE_EXISTS_STATUS = new Status(2, "ro.amiq.dvt", "A file with the same name exists, it will be overwritten.");
    private static final IStatus NON_EXISTING_DIRECTORY_STATUS = new Status(2, "ro.amiq.dvt", "Directory doesn't exist, it will be created.");
    private static final String SELECTION_RUNNABLE = "selection.runnable";
    private static final SelectionListener SELECTION_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            WavedromSaveDialog.runWidgetSelectedAction(e.widget);
        }
    };
    private static final String[] EXTENSIONS = new String[]{".svg"};
    private final String svgContent;
    private Composite contentsComposite;
    private IStatus lastStatus;
    private MessageLine statusLine;
    private Text fileText;
    private String fileTextName;
    private Combo extensionCombo;
    private Text directoryText;
    private Button browseButton;
    private Button saveButton;

    public WavedromSaveDialog(Shell parentShell, String svgContent, String fileTextName) {
        super(parentShell);
        this.svgContent = svgContent;
        this.fileTextName = DVTStringUtil.replaceAll(DVTStringUtil.COLON_COLON, fileTextName, "_");
        this.lastStatus = new Status(0, "org.eclipse.jface", 0, "", null);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Save Diagram");
    }

    protected final Control createContents(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(this.contentsComposite);
        this.createMainArea(this.contentsComposite);
        this.createStatusLineArea(this.contentsComposite);
        this.createBottomArea(this.contentsComposite);
        this.setDefaults();
        this.addListeners();
        Dialog.applyDialogFont((Control)this.contentsComposite);
        return this.contentsComposite;
    }

    private void createStatusLineArea(Composite parent) {
        this.statusLine = new MessageLine(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.statusLine);
        this.statusLine.setErrorStatus(this.lastStatus);
    }

    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Label fileLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)fileLabel);
        fileLabel.setText("Name:");
        this.fileText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).minSize(300, -1).applyTo((Control)this.fileText);
        this.extensionCombo = new Combo(composite, 12);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.extensionCombo);
        Label directoryLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)directoryLabel);
        directoryLabel.setText("Directory:");
        this.directoryText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).minSize(300, -1).applyTo((Control)this.directoryText);
        this.browseButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.browseButton);
        this.browseButton.setText("Browse...");
    }

    protected void createBottomArea(Composite parent) {
        Composite buttonsComposite = this.createButtonsComposite(parent, 2);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.saveButton = this.createButton(buttonsComposite, 8, "Save", () -> this.save());
    }

    protected Composite createButtonsComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(columns).equalWidth(true).applyTo(composite);
        return composite;
    }

    protected void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WavedromSaveDialog.this.validate();
            }
        };
        this.fileText.addModifyListener(modifyListener);
        this.directoryText.addModifyListener(modifyListener);
        this.extensionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WavedromSaveDialog.this.validate();
            }
        });
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WavedromSaveDialog.this.openDirectoryBrowser();
                WavedromSaveDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void setDefaults() {
        this.fileText.setText(this.fileTextName);
        int i = 0;
        while (i < EXTENSIONS.length) {
            this.extensionCombo.add(EXTENSIONS[i]);
            if (i == 0) {
                this.extensionCombo.select(i);
            }
            ++i;
        }
        this.directoryText.setText(DVTFileUtils.getInstance().getLastDirectory());
        this.validate();
    }

    protected Button createButton(Composite composite, int style, String text, Runnable action) {
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, true);
        Button button = new Button(composite, style);
        if (text != null) {
            button.setText(text);
        }
        if (gridDataFactory != null) {
            gridDataFactory.applyTo((Control)button);
        }
        if (action != null) {
            button.setData(SELECTION_RUNNABLE, (Object)action);
            button.addSelectionListener(SELECTION_LISTENER);
        }
        return button;
    }

    protected static void runWidgetSelectedAction(Widget widget) {
        Object action = widget.getData(SELECTION_RUNNABLE);
        if (action == null) {
            return;
        }
        ((Runnable)action).run();
    }

    protected void updateStatus(IStatus status) {
        this.lastStatus = status;
        if (this.statusLine != null && !this.statusLine.isDisposed()) {
            this.updateButtonsForStatus(status);
            this.statusLine.setErrorStatus(status);
        }
    }

    protected void updateButtonsForStatus(IStatus status) {
        if (this.saveButton != null && !this.saveButton.isDisposed()) {
            this.saveButton.setEnabled(!status.matches(4));
        }
    }

    private void openDirectoryBrowser() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
        String directoryName = dialog.open();
        if (directoryName == null) {
            return;
        }
        this.directoryText.setText(directoryName);
        DVTFileUtils.getInstance().setLastDirectory(directoryName);
    }

    private void validate() {
        String fileName = this.fileText.getText();
        if (fileName == null || fileName.isEmpty()) {
            this.updateStatus(EMPTY_FILE_STATUS);
            return;
        }
        String directoryName = this.directoryText.getText();
        if (directoryName == null || directoryName.isEmpty()) {
            this.updateStatus(EMPTY_DIRECTORY_STATUS);
            return;
        }
        File directory = new File(directoryName);
        if (!directory.exists()) {
            this.updateStatus(NON_EXISTING_DIRECTORY_STATUS);
            return;
        }
        if (!directory.isDirectory()) {
            this.updateStatus(DIRECTORY_IS_FILE_STATUS);
            return;
        }
        if (!directory.canWrite() || !directory.canExecute()) {
            this.updateStatus(DIRECTORY_IS_NOT_WRITABLE_STATUS);
            return;
        }
        String extension = this.extensionCombo.getItem(this.extensionCombo.getSelectionIndex());
        File file = new File(directory, String.valueOf(fileName) + extension);
        if (file.exists()) {
            if (!file.canWrite()) {
                this.updateStatus(FILE_EXISTS_AS_RO_STATUS);
                return;
            }
            this.updateStatus(FILE_EXISTS_STATUS);
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private void save() {
        final String fileName = this.fileText.getText();
        final String extension = EXTENSIONS[this.extensionCombo.getSelectionIndex()];
        final String directoryName = this.directoryText.getText();
        this.close();
        StoppableJob job = new StoppableJob("Saving Diagram"){

            @Override
            protected IStatus stoppableRun(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask(fileName, -1);
                        Files.write(new File(directoryName, String.valueOf(fileName) + extension).toPath(), WavedromSaveDialog.this.svgContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        WavedromSaveDialog.this.displayStatusNotification("Diagram saved successfully!", false);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        WavedromSaveDialog.this.displayStatusNotification("Diagram was not saved!", true);
                        Status status = new Status(4, "ro.amiq.dvt", "Error while saving diagram.", (Throwable)e);
                        monitor.done();
                        return status;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
    }

    private void displayStatusNotification(String message, boolean isError) {
        Display.getDefault().asyncExec(() -> {
            if (isError) {
                SmartCopyUtils.updateStatusBarWithError(message);
            } else {
                SmartCopyUtils.updateStatusBarWithInfo(message);
            }
        });
    }

    private static class MessageLine
    extends CLabel {
        public MessageLine(Composite parent) {
            super(parent, 16384);
        }

        private Image findImage(IStatus status) {
            if (status.isOK()) {
                return null;
            }
            if (status.matches(4)) {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            if (status.matches(2)) {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            if (status.matches(1)) {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            return null;
        }

        public void setErrorStatus(IStatus status) {
            String message;
            if (status != null && !status.isOK() && (message = status.getMessage()) != null && message.length() > 0) {
                this.setText(LegacyActionTools.escapeMnemonics((String)message));
                this.setImage(this.findImage(status));
                DVTColorUtil.INSTANCE.setBackground((Control)this, DVTColorUtil.INSTANCE.getBackground((Control)this.getParent()), true);
                return;
            }
            DVTColorUtil.INSTANCE.setBackground((Control)this, DVTColorUtil.INSTANCE.getBackground((Control)this.getParent()), true);
            this.setText("");
            this.setImage(null);
        }
    }
}

