/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.layers;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.history.HistoryAction;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.ui.views.layers.LayersViewCommon;
import ro.amiq.dvt.ui.views.layers.LayersViewInput;
import ro.amiq.dvt.ui.views.layers.LayersViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class LayersView
extends LayersViewCommon
implements IUpdateJobImpl {
    private final Map<LanguageKind, ILayersViewContributor> fAllLayerContributorsByLanguageKind = new EnumMap<LanguageKind, ILayersViewContributor>(LanguageKind.class);
    private final UpdateJob fUpdateJob;
    private DVTLabelProviderProxy<ILayersViewContributor> fLabelProvider = new DVTLabelProviderProxy<ILayersViewContributor>(ILayersViewContributor.class, "default-tree");
    private Label fInfo;
    private Tree fTree;
    private TreeViewContentProvider fLazyContentProvider;
    private boolean fShowScopeColumn;
    private boolean fShowECollectMethodLayers;
    private LayersHistoryAction fLayersHistoryAction = new LayersHistoryAction();
    private ShowVlogTypeAction fShowVlogTypeAction = new ShowVlogTypeAction();
    private ShowVlogSubtypeAction fShowVlogSubtypeAction = new ShowVlogSubtypeAction();
    private ShowVlogSupertypeAction fShowVlogSupertypeAction = new ShowVlogSupertypeAction();
    private EMethodLayersCollect fEMethodLayersCollectAction = new EMethodLayersCollect();
    private ShowETypeAction fShowETypeAction = new ShowETypeAction();
    private ShowESubtypeAction fShowESubtypeAction = new ShowESubtypeAction();
    private ShowESubtypeSupertypeAction fShowESubSupertypeAction = new ShowESubtypeSupertypeAction();
    private ShowESupertypeAction fShowESupertypeAction = new ShowESupertypeAction();
    private TreeColumn fNameColumn;
    private TreeColumn fScopeColumn;
    private TreeColumn fCommentColumn;
    private TreeColumn fPackageColumn;
    private TreeColumn fLineColumn;
    private TreeColumn fSourceColumn;
    public static final int COLUMN_SIZE_METHOD_NAME = 20;
    public static final int COLUMN_SIZE_NAME = 30;
    public static final int COLUMN_SIZE_SCOPE = 20;
    public static final int COLUMN_SIZE_E_PCKG = 10;
    public static final int COLUMN_SIZE_METHOD_COMMENT = 30;
    public static final int COLUMN_SIZE_COMMENT = 40;
    public static final int COLUMN_SIZE_FILE = 20;
    public static final int COLUMN_SIZE_FILE_E = 15;
    public static final int COLUMN_SIZE_LINE = 10;
    public static final int COLUMN_SIZE_LINE_E = 5;

    public LayersView() {
        this.fUpdateJob = new UpdateJob("Update Layers View", this);
        for (ILayersViewContributor contrib : fAllLayersContributors) {
            this.fAllLayerContributorsByLanguageKind.put(contrib.getLanguageKind(), contrib);
        }
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.fInfo = new Label(parent, 16384);
        this.fInfo.setLayoutData((Object)new GridData(768));
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: name");
        Composite composite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        composite.setLayoutData((Object)compositeGridData);
        composite.setLayout((Layout)new FillLayout(256));
        this.fTree = new Tree(composite, 268436228);
        this.fTree.setHeaderVisible(true);
        this.fLazyContentProvider = new TreeViewContentProvider(this.fTree, this.fLabelProvider);
        this.fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LayersView.this.gotoSelectedElement("default-tree");
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.installContextMenuAndSelectionListener((Control)this.fTree);
    }

    private void createToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.removeAll();
        tbm.add((IAction)this.fLayersHistoryAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new Action("Jump to Next Layer", DVTImages.SEARCH_NEXT_A){

            public void run() {
                LayersView.this.moveTableSelection(1, true);
            }
        });
        tbm.add((IAction)new Action("Jump to Previous Layer", DVTImages.SEARCH_PREV_A){

            public void run() {
                LayersView.this.moveTableSelection(-1, true);
            }
        });
        tbm.add((IContributionItem)new Separator());
        HistoryItem historyItem = this.getHistoryItem();
        if (historyItem != null && historyItem.getLanguage() == LanguageKind.E) {
            tbm.add((IAction)this.fShowETypeAction);
            tbm.add((IAction)this.fShowESubSupertypeAction);
            tbm.add((IAction)this.fShowESubtypeAction);
            tbm.add((IAction)this.fShowESupertypeAction);
            tbm.add((IContributionItem)new Separator());
            tbm.add((IAction)this.fEMethodLayersCollectAction);
            this.fShowESubtypeAction.setEnabled(this.fShowScopeColumn);
            this.fShowESubSupertypeAction.setEnabled(this.fShowScopeColumn);
            this.fShowESupertypeAction.setEnabled(this.fShowScopeColumn);
            this.fShowETypeAction.setEnabled(this.fShowScopeColumn);
            this.fEMethodLayersCollectAction.setEnabled(this.fShowECollectMethodLayers);
        } else if (historyItem != null && historyItem.getLanguage() == LanguageKind.VLOG) {
            tbm.add((IAction)this.fShowVlogTypeAction);
            tbm.add((IAction)this.fShowVlogSubtypeAction);
            tbm.add((IAction)this.fShowVlogSupertypeAction);
            this.fShowVlogTypeAction.setEnabled(this.fShowScopeColumn);
            this.fShowVlogSubtypeAction.setEnabled(this.fShowScopeColumn);
            this.fShowVlogSupertypeAction.setEnabled(this.fShowScopeColumn);
        }
        this.getViewSite().getActionBars().updateActionBars();
        tbm.update(true);
    }

    private void moveTableSelection(int step, boolean wrap) {
        if (this.fTree == null) {
            return;
        }
        TreeItem[] selection = this.fTree.getSelection();
        TreeItem[] allItems = this.fTree.getItems();
        if (selection == null || selection.length == 0 || selection[0].getData() == null) {
            return;
        }
        if (!(selection[0].getData() instanceof IDVTElementWrapper)) {
            return;
        }
        int currentIndex = -1;
        TreeItem[] treeItemArray = allItems;
        int n = allItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            ++currentIndex;
            if (treeItem.equals(selection[0])) break;
            ++n2;
        }
        int nextIndex = currentIndex + step;
        if (currentIndex == allItems.length - 1 && step == 1) {
            if (wrap) {
                nextIndex = 0;
            } else {
                return;
            }
        }
        if (currentIndex == 0 && step == -1) {
            if (wrap) {
                nextIndex = allItems.length - 1;
            } else {
                return;
            }
        }
        this.fTree.setSelection(allItems[nextIndex]);
        this.gotoSelectedElement("default-tree");
    }

    private void addToHistory() {
        HistoryItem historyItem = this.getHistoryItem();
        if (historyItem == null) {
            return;
        }
        this.fLayersHistoryAction.addElement(historyItem);
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        if (dataContainer != null) {
            UpdateViewEvent remoteEv = (UpdateViewEvent)dataContainer.getHistoryItem();
            UpdateViewEvent localEv = (UpdateViewEvent)this.getHistoryItem();
            if (remoteEv != null && localEv != null && remoteEv.getLanguage() == LanguageKind.E) {
                this.fShowAssociatedType = remoteEv.getEdtIsTriggeredFromAction() && !this.fTree.isFocusControl() && remoteEv.getEdtHasAssociatedType() && remoteEv.equals(localEv) ? !this.fShowAssociatedType : false;
            }
        }
        super.setInput(dataContainer);
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            if (this.getHistoryItem() == null) {
                this.fShowScopeColumn = false;
                this.fShowECollectMethodLayers = false;
            } else {
                UpdateViewEvent ev = (UpdateViewEvent)this.getHistoryItem();
                if (ev.getUpdateHistory() == 1) {
                    this.addToHistory();
                }
            }
            if (this.fTree == null) {
                return;
            }
            if (this.getHistoryItem() == null) {
                this.resetElementCount();
                this.fInfo.setText("");
                ProjectColorUtils.setFgBg(this, null);
                this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_LAYERS_VIEW), this.fExpandLevel);
                return;
            }
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            this.fUpdateJob.cancel();
            this.fUpdateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.resetElementCount();
            this.fElements = new ArrayList();
            HistoryItem historyItem = this.getHistoryItem();
            ILayersViewContributor contentProvider = this.getViewContributor(historyItem);
            if (contentProvider == null) {
                return;
            }
            if (ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            LayersViewInput input = contentProvider.getInput(new LayersViewInputConfigurator(historyItem, this.getStringMatcher("default-filter"), updateJob, this.fShowAssociatedType));
            List<IDVTElementWrapper> origElems = input.getElements();
            ViewsUtils.selectElement(contentProvider, null, origElems, historyItem);
            this.fElements.addAll(origElems);
            this.fNrLayers = input.getTotalLayers();
            this.fNrFiles = input.getTotalFiles();
            this.fNrNotFilteredLayers = input.getNotFilteredLayers();
            this.fNrNotFilteredFiles = input.getNotFilteredFiles();
            this.fShowScopeColumn = input.showScopeColumn();
            this.fShowECollectMethodLayers = input.showECollectMethodLayers();
            this.fBulkDataInfo = input.getBulkDataInfo();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            IProject project = this.getProject();
            this.redrawView();
            if (this.fLazyContentProvider != null && this.fElements != null && this.fInfo != null && project != null) {
                this.fExpandLevel = -1;
                StringMatcher sm = this.getStringMatcher("default-filter");
                if (this.fElements.isEmpty()) {
                    if (sm != null && !sm.getPattern().isEmpty()) {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND), this.fExpandLevel);
                    } else {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
                    }
                } else {
                    this.fLazyContentProvider.setInput(this.fElements, this.fExpandLevel);
                }
                if (this.fBulkDataInfo == null) {
                    this.fBulkDataInfo = "";
                }
                this.fInfo.setText(this.computeLayersViewInfo(this.getHistoryItem(), project, ""));
                ProjectColorUtils.setFgBg(this, project.getName());
                this.fInfo.setToolTipText(this.fBulkDataInfo);
            }
            if (this.fInfo == null) {
                return;
            }
            this.fInfo.getParent().layout();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.dispose();
        }
        if (this.fInfo != null && !this.fInfo.isDisposed()) {
            this.fInfo.dispose();
        }
        if (this.fNameColumn != null) {
            this.fNameColumn.dispose();
        }
        if (this.fScopeColumn != null) {
            this.fScopeColumn.dispose();
        }
        if (this.fCommentColumn != null) {
            this.fCommentColumn.dispose();
        }
        if (this.fPackageColumn != null) {
            this.fPackageColumn.dispose();
        }
        if (this.fLineColumn != null) {
            this.fLineColumn.dispose();
        }
        if (this.fSourceColumn != null) {
            this.fSourceColumn.dispose();
        }
        this.fTree = null;
        this.fInfo = null;
        this.fLazyContentProvider = null;
        this.fInfo = null;
        super.dispose();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    private void redrawView() {
        this.createToolbar();
        int n = this.fTree.getSize().x;
        if (n == 0) {
            n = 1000;
        }
        if (this.fNameColumn == null) {
            this.fNameColumn = new TreeColumn(this.fTree, 16384, 0);
            this.fNameColumn.setText("Name");
            this.fNameColumn.setMoveable(true);
        }
        this.fNameColumn.setWidth(n * (this.fShowScopeColumn ? 20 : 30) / 100);
        if (this.fScopeColumn == null) {
            this.fScopeColumn = new TreeColumn(this.fTree, 16384);
            this.fScopeColumn.setMoveable(true);
        }
        LanguageKind languageKind = this.getHistoryItem().getLanguage();
        this.fScopeColumn.setText(this.getHistoryItem() != null && this.isELikeLanguage(languageKind) ? "Struct Layer" : "Scope");
        this.fScopeColumn.setWidth(n * (this.fShowScopeColumn ? 20 : 0) / 100);
        if (this.fCommentColumn == null) {
            this.fCommentColumn = new TreeColumn(this.fTree, 16384);
            this.fCommentColumn.setText("Comment");
            this.fCommentColumn.setMoveable(true);
        }
        this.fCommentColumn.setWidth(n * (this.fShowScopeColumn ? 30 : 40) / 100);
        if (this.getHistoryItem() != null && this.isELikeLanguage(languageKind)) {
            if (this.fPackageColumn == null) {
                this.fPackageColumn = new TreeColumn(this.fTree, 16384);
                this.fPackageColumn.setText("Package");
                this.fPackageColumn.setMoveable(true);
            }
            this.fPackageColumn.setWidth(n * 10 / 100);
        }
        if (this.fSourceColumn == null) {
            this.fSourceColumn = new TreeColumn(this.fTree, 16384);
            this.fSourceColumn.setMoveable(true);
        }
        this.fSourceColumn.setText(this.getHistoryItem() != null && this.isELikeLanguage(languageKind) ? "Source Module" : "Source File");
        this.fSourceColumn.setWidth(n * (this.getHistoryItem() != null && this.isELikeLanguage(languageKind) ? 15 : 20) / 100);
        if (this.fLineColumn == null) {
            this.fLineColumn = new TreeColumn(this.fTree, 16384);
            this.fLineColumn.setText("Line");
            this.fLineColumn.setMoveable(true);
        }
        this.fLineColumn.setWidth(n * (this.getHistoryItem() != null && this.isELikeLanguage(languageKind) ? 5 : 10) / 100);
    }

    private boolean isELikeLanguage(LanguageKind languageKind) {
        return languageKind == LanguageKind.E || languageKind == LanguageKind.SLN;
    }

    private ILayersViewContributor getViewContributor(HistoryItem historyItem) {
        if (historyItem == null) {
            return null;
        }
        return this.fAllLayerContributorsByLanguageKind.get((Object)historyItem.getLanguage());
    }

    @Override
    public Tree getTree(String treeId) {
        return this.fTree;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return this.fElements;
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.fTree.setRedraw(false);
            this.update(null);
            this.fTree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    private void resetElementCount() {
        this.fNrFiles = 0;
        this.fNrLayers = 0;
        this.fNrNotFilteredFiles = 0;
        this.fNrNotFilteredLayers = 0;
    }

    @Override
    public void clean() {
        this.fUpdateJob.cancel();
        this.resetElementCount();
        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
        IProject project = this.getProject();
        if (project != null && this.fBulkDataInfo != null) {
            this.fInfo.setText("[" + project.getName() + "] " + DVTStringUtil.replaceAll(DVTStringUtil.NEW_LINE, this.fBulkDataInfo, ""));
            ProjectColorUtils.setFgBg(this, project.getName());
            this.fInfo.setToolTipText(this.fBulkDataInfo);
        }
    }

    public DVTBaseLabelProvider testGetLabelProvider() {
        return this.fLabelProvider;
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return this.fLazyContentProvider;
    }

    @Override
    public Control getControlToColorBg() {
        return this.fInfo;
    }

    @Override
    public Control getControlToColorFg() {
        return this.fInfo;
    }

    private class EMethodLayersCollect
    extends Action {
        EMethodLayersCollect() {
            super("Method Layers Collect", DVTImages.METHOD_LAYERS_COLLECT);
        }

        public void run() {
            if (LayersView.this.getHistoryItem() == null || LayersView.this.fElements == null || LayersView.this.fElements.isEmpty()) {
                return;
            }
            ILayersViewContributor layersViewContentProvider = LayersView.this.getViewContributor(LayersView.this.getHistoryItem());
            if (layersViewContentProvider == null) {
                return;
            }
            layersViewContentProvider.collectEMethodLayers(LayersView.this.fElements);
        }
    }

    class LayersHistoryAction
    extends HistoryAction {
        LayersHistoryAction() {
        }

        @Override
        public void openHistoryItem(HistoryItem item) {
            IProject newProject = Utils.getProject(((UpdateViewEvent)item).getProjectName());
            LayersView.this.setInput(new ViewDataContainer(newProject, item));
            LayersView.this.update(null);
        }

        @Override
        public boolean checkHistoryItem(HistoryItem item) {
            return true;
        }
    }

    class ShowESubtypeAction
    extends Action {
        ShowESubtypeAction() {
            super("Show Subtype Layers", 8);
            this.setDescription("Show Subtype Layers");
            this.setToolTipText("Show Subtype Layers");
            this.setImageDescriptor(DVTImages.SUB_CO);
            this.setChecked(PrefConst.getLayersViewShowESubtypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowESubtypeLayers(this.isChecked());
            if (this.isChecked()) {
                LayersView.this.update(null);
            }
        }
    }

    class ShowESubtypeSupertypeAction
    extends Action {
        ShowESubtypeSupertypeAction() {
            super("Show Subtype && Supertype Layers", 8);
            this.setDescription("Show Subtype && Supertype Layers");
            this.setToolTipText("Show Subtype && Supertype  Layers");
            this.setImageDescriptor(DVTImages.HIERARCHY_CO);
            this.setChecked(PrefConst.getLayersViewShowESubtypeSupertypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowESubtypeSupertypeLayers(this.isChecked());
            if (this.isChecked()) {
                LayersView.this.update(null);
            }
        }
    }

    class ShowESupertypeAction
    extends Action {
        ShowESupertypeAction() {
            super("Show Supertype Layers", 8);
            this.setDescription("Show Supertype Layers");
            this.setToolTipText("Show Supertype Layers");
            this.setImageDescriptor(DVTImages.SUPER_CO);
            this.setChecked(PrefConst.getLayersViewShowESupertypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowESupertypeLayers(this.isChecked());
            if (this.isChecked()) {
                LayersView.this.update(null);
            }
        }
    }

    class ShowETypeAction
    extends Action {
        ShowETypeAction() {
            super("Show Full Type Layers", 8);
            this.setDescription("Show Full Type Layers");
            this.setToolTipText("Show Full Type Layers");
            this.setImageDescriptor(DVTImages.ALL_CO);
            this.setChecked(PrefConst.getLayersViewShowETypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowETypeLayers(this.isChecked());
            if (this.isChecked()) {
                LayersView.this.update(null);
            }
        }
    }

    class ShowVlogSubtypeAction
    extends Action {
        ShowVlogSubtypeAction() {
            super("Show Subtype Layers", 8);
            this.setDescription("Show Subtype Layers");
            this.setToolTipText("Show Subtype Layers");
            this.setImageDescriptor(DVTImages.SUB_CO);
            this.setChecked(PrefConst.getLayersViewShowVlogSubtypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowVlogSubtypeLayers(this.isChecked());
            if (this.isChecked()) {
                LayersView.this.update(null);
            }
        }
    }

    class ShowVlogSupertypeAction
    extends Action {
        ShowVlogSupertypeAction() {
            super("Show Supertype Layers", 8);
            this.setDescription("Show Supertype Layers");
            this.setToolTipText("Show Supertype Layers");
            this.setImageDescriptor(DVTImages.SUPER_CO);
            this.setChecked(PrefConst.getLayersViewShowVlogSupertypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowVlogSupertypeLayers(this.isChecked());
            if (this.isChecked()) {
                LayersView.this.update(null);
            }
        }
    }

    class ShowVlogTypeAction
    extends Action {
        ShowVlogTypeAction() {
            super("Show Full Type Layers", 8);
            this.setDescription("Show Full Type Layers");
            this.setToolTipText("Show Full Type Layers");
            this.setImageDescriptor(DVTImages.HIERARCHY_CO);
            this.setChecked(PrefConst.getLayersViewShowVlogTypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowVlogTypeLayers(this.isChecked());
            if (this.isChecked()) {
                LayersView.this.update(null);
            }
        }
    }
}

