/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.layers;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class LayersViewCommon
extends AbstractFilteredView {
    protected static final List<ILayersViewContributor> fAllLayersContributors = DVTViewContributors.getInstance().getAllInstanceOf(ILayersViewContributor.class);
    public static final String ID = "ro.amiq.dvt.ui.views.LayersView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.FIXED_ELEMENT_INFORMATION, ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS);
    protected List<IDVTElementWrapper> fElements;
    protected int fNrLayers;
    protected int fNrFiles;
    protected int fNrNotFilteredLayers;
    protected int fNrNotFilteredFiles;
    protected String fBulkDataInfo;
    protected boolean fShowAssociatedType;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    protected ILayersViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, ILayersViewContributor.class);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper(treeId);
        if (selectedWrapper == null || this.getViewContributor(selectedWrapper) == null) {
            return;
        }
        this.getViewContributor(selectedWrapper).gotoElement(this.getProject(), selectedWrapper);
    }

    protected String computeLayersViewInfo(HistoryItem historyItem, IProject project, String layersType) {
        String infoTextAppend = "";
        String elementName = " file";
        if (historyItem.getLanguage() == LanguageKind.E) {
            elementName = " module";
            UpdateViewEvent ev = (UpdateViewEvent)historyItem;
            if (ev.getEdtIsTriggeredFromAction() && ev.getEdtHasAssociatedType() && !this.fShowAssociatedType) {
                infoTextAppend = "\nPerform 'Show Layers' once more to see the layers of the element's associated type";
            }
        }
        String layersInfo = (this.fNrNotFilteredLayers > 0 && this.fNrNotFilteredLayers != this.fNrLayers ? String.valueOf(this.fNrNotFilteredLayers) + "/" + this.fNrLayers : Integer.valueOf(this.fNrLayers)) + " layer" + (this.fNrLayers == 1 ? "" : "s");
        String filesInfo = (this.fNrNotFilteredFiles > 0 && this.fNrNotFilteredFiles != this.fNrFiles ? String.valueOf(this.fNrNotFilteredFiles) + "/" + this.fNrFiles : Integer.valueOf(this.fNrFiles)) + elementName + (this.fNrFiles == 1 ? "" : "s");
        return "[" + project.getName() + "] " + DVTStringUtil.replaceAll(DVTStringUtil.NEW_LINE, String.valueOf(layersType) + this.fBulkDataInfo, "") + " [" + layersInfo + ", " + filesInfo + "] " + infoTextAppend;
    }
}

