/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.layers;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.AbstractTreeInformationControl;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.ui.views.layers.LayersViewInput;
import ro.amiq.dvt.ui.views.layers.LayersViewInputConfigurator;

public class QuickLayersView
extends AbstractTreeInformationControl
implements IUpdateJobImpl {
    public static final String ID = "ro.amiq.dvt.ui.views.QuickLayersView";
    public static final String TITLE = "Quick Layers";
    private static final String DEFAULT_FILTER_HELPER_TEXT = "Filter by: layer name";
    private static final List<IDVTElementWrapper> WARNING_MESSAGE_INPUT = new ArrayList<IDVTElementWrapper>(6){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("WARNING!"));
            this.add(new BasicElementWrapper("Functionality for files"));
            this.add(new BasicElementWrapper("outside a project is"));
            this.add(new BasicElementWrapper("limited. Create a project"));
            this.add(new BasicElementWrapper("or use linked resources"));
            this.add(new BasicElementWrapper("to existing project."));
        }
    };
    private static final List<IDVTElementWrapper> UPDATE_JOB_MESSAGE_INPUT = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Updating..."));
        }
    };
    private static final List<ILayersViewContributor> fAllLayersContributors = DVTViewContributors.getInstance().getAllInstanceOf(ILayersViewContributor.class);
    private final Map<LanguageKind, ILayersViewContributor> fAllLayerContributorsByLanguageKind = new EnumMap<LanguageKind, ILayersViewContributor>(LanguageKind.class);
    private final UpdateJob fUpdateJob;
    private HistoryItem fHistoryItem;
    DVTLabelProviderProxy<ILayersViewContributor> fLabelProvider = new DVTLabelProviderProxy<ILayersViewContributor>(ILayersViewContributor.class, "default-tree");
    private List<IDVTElementWrapper> fElements;
    private boolean fShouldShowAssociatedType = false;

    public QuickLayersView(Shell parent, IProject project) {
        super(null, parent, 16, 768, project);
        this.fUpdateJob = new UpdateJob("Update Quick Layers View", this);
        for (ILayersViewContributor contrib : fAllLayersContributors) {
            this.fAllLayerContributorsByLanguageKind.put(contrib.getLanguageKind(), contrib);
        }
        this.setTextFilterMessage("default-filter", DEFAULT_FILTER_HELPER_TEXT);
    }

    @Override
    protected String getTitle() {
        return TITLE + (this.fProject != null ? " [" + this.fProject.getName() + "]" : "");
    }

    @Override
    protected DVTBaseLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DVTLabelProviderProxy<ILayersViewContributor>(ILayersViewContributor.class, "default-tree");
        }
        return this.fLabelProvider;
    }

    @Override
    protected String getId() {
        return ID;
    }

    @Override
    protected void fillDialogMenu(IMenuManager viewMenu) {
        super.fillDialogMenu(viewMenu);
    }

    @Override
    public void update() {
        if (this.fProject == null || !this.fProject.isAccessible()) {
            this.setInputWrappers(new ArrayList<IDVTElementWrapper>(WARNING_MESSAGE_INPUT));
            return;
        }
        this.setInputWrappers(new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT));
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.fElements = new ArrayList<IDVTElementWrapper>();
            ILayersViewContributor contentProvider = this.getViewContributor(this.fHistoryItem);
            if (contentProvider == null) {
                return;
            }
            if (ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            LayersViewInput input = contentProvider.getQuickViewInput(new LayersViewInputConfigurator(this.fHistoryItem, this.getStringMatcher("default-filter"), updateJob, this.fShouldShowAssociatedType));
            List<IDVTElementWrapper> origElems = input.getElements();
            if (this.getStringMatcher("default-filter") == null) {
                ViewsUtils.selectElement(contentProvider, null, origElems, this.fHistoryItem);
            } else {
                ViewsUtils.selectFirstElement(contentProvider, this.getStringMatcher("default-filter"), origElems);
            }
            this.fElements.addAll(input.getElements());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            if (this.fElements != null) {
                this.setInputWrappers(this.fElements);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void gotoSelectedElement() {
        Object selectedElement;
        if (this.fProject == null) {
            return;
        }
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper();
        ILayersViewContributor contrib = DVTViewContributors.getInstance().getViewContributor(selectedWrapper, ILayersViewContributor.class);
        if (contrib != null) {
            contrib.gotoElement(this.fProject, selectedWrapper);
        }
        if (!((selectedElement = selectedWrapper.getRfElement()) instanceof DVTLanguageElement) && !(selectedElement instanceof String)) {
            this.close();
        }
    }

    private ILayersViewContributor getViewContributor(HistoryItem historyItem) {
        if (historyItem == null) {
            return null;
        }
        return this.fAllLayerContributorsByLanguageKind.get((Object)this.fHistoryItem.getLanguage());
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control dialogArea = super.createDialogArea(parent);
        this.getTextFilterObject("default-filter").getTextFilter().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (QuickLayersView.this.fHistoryItem != null && ((UpdateViewEvent)QuickLayersView.this.fHistoryItem).getEdtHasAssociatedType() && e.keyCode == 111 && (e.stateMask & 0x20000) != 0 && (e.stateMask & 0x40000) != 0) {
                    QuickLayersView.this.fShouldShowAssociatedType = !QuickLayersView.this.fShouldShowAssociatedType;
                    QuickLayersView.this.update();
                }
            }
        });
        return dialogArea;
    }

    public void setInput(Object information) {
        try {
            if (!DVTPlugin.getDefault().collect().c(this.fProject, "F636F7265")) {
                return;
            }
            this.setInfoText("Search patterns may contain: * = any string, ? = any character.");
            if (!(information instanceof UpdateViewEvent)) {
                return;
            }
            this.fHistoryItem = (HistoryItem)information;
            this.update();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean close() {
        return super.close();
    }
}

