/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import com.google.re2j.Pattern;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.config.db.ConfigDBView;
import ro.amiq.dvt.ui.views.lazy.tree.CustomExpandStateInfo;
import ro.amiq.dvt.ui.views.lazy.tree.ExpandCollapseState;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IELModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.ITreeIteratorStateListener;
import ro.amiq.dvt.ui.views.lazy.tree.LazyELTrimModel;
import ro.amiq.dvt.ui.views.lazy.tree.MatchCache;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEvent;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEventType;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorGoToElementEvent;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderModel;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTDHLabelProvider;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class AbstractTreeIterator {
    private static final int NUM_OF_NODES_TO_UPDATE_PROGRESS = 10000;
    private IDVTLazyView lazyView;
    private TextFilterObject filter;
    private ExpandCollapseState state = ExpandCollapseState.EXPANDED;
    private MatchCache matchCache;
    private Set<TreePath> toggledStatePaths = new HashSet<TreePath>();
    private static Set<TreePath> boldedPaths;
    private Deque<TreePath> window = new ArrayDeque<TreePath>();
    private int targetWindowSize = 20;
    private List<ITreeIteratorStateListener> stateListeners = new ArrayList<ITreeIteratorStateListener>();
    private TreePath startTreePath;
    private TreePath selection;
    private int matchesCounter;
    private boolean isSearchChanged;
    private CustomExpandStateInfo customExpandStateInfo;
    public static final Pattern REVEAL_CONFIG_DB_PATTERN;

    static {
        REVEAL_CONFIG_DB_PATTERN = Pattern.compile((String)"((set|get) \\[[0-9]+\\])( \\| ((set|get) \\[[0-9]+\\]))*");
    }

    public AbstractTreeIterator(IDVTLazyView lazyView) {
        this.matchCache = new MatchCache();
        this.lazyView = lazyView;
        this.stateListeners.add(new ITreeIteratorStateListener(){

            @Override
            public void stateChanged(TreeIteratorEvent event) {
                if (event.getEventType() != TreeIteratorEventType.SEARCH_CHANGED) {
                    return;
                }
                AbstractTreeIterator.this.isSearchChanged = true;
            }
        });
    }

    public AbstractTreeIterator(IDVTLazyView lazyView, Comparator<TreePath> matchCacheComparator) {
        this.matchCache = new MatchCache(matchCacheComparator);
        this.lazyView = lazyView;
        this.stateListeners.add(new ITreeIteratorStateListener(){

            @Override
            public void stateChanged(TreeIteratorEvent event) {
                if (event.getEventType() != TreeIteratorEventType.SEARCH_CHANGED) {
                    return;
                }
                AbstractTreeIterator.this.isSearchChanged = true;
            }
        });
    }

    public void addStateListener(ITreeIteratorStateListener l) {
        this.stateListeners.add(l);
    }

    public void clearStateListeners() {
        this.stateListeners.clear();
    }

    public void setTargetWindowSize(int newWindowSize, IProgressMonitor monitor) {
        this.targetWindowSize = newWindowSize;
    }

    public int getTargetWindowSize() {
        return this.targetWindowSize;
    }

    public Deque<TreePath> getWindow() {
        return this.window;
    }

    public void recompute(boolean isCheckFirstPathToAddToTree, boolean isComputeOnlyFirstElement, IProgressMonitor monitor) {
        this.growOrShrinkToSize(isCheckFirstPathToAddToTree, isComputeOnlyFirstElement, null, null, monitor);
    }

    public void recompute(IProgressMonitor monitor) {
        this.growOrShrinkToSize(false, false, null, null, monitor);
    }

    private void growOrShrinkToSize(boolean isCheckFirstPathToAddToTree, boolean isComputeOnlyFirstElement, CustomExpandStateInfo customExpandArguments, ExpandCollapseState customExpandState, IProgressMonitor monitor) {
        this.matchesCounter = 0;
        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.ENABLE_SLIDER_ARROWS));
        if (this.window.size() == 0) {
            int expandLevel;
            TreePath expandedTreePath;
            if (this.startTreePath == null || this.startTreePath == TreePath.TOP_DUMMY_TREE_PATH) {
                this.lazyView.swapToTreeComposite();
                this.addPathLast(AbstractTreeIterator.getDummyOperatioNode(TreePath.TOP_DUMMY_TREE_PATH));
                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                TreePath firstRoot = this.getFirstChildOfPath(TreePath.TOP_DUMMY_TREE_PATH, monitor);
                if (firstRoot != null && firstRoot.equals(AbstractTreeIterator.getDummyOperatioNode(TreePath.TOP_DUMMY_TREE_PATH))) {
                    this.addPathLast(AbstractTreeIterator.getDummyOperatioNode(TreePath.TOP_DUMMY_TREE_PATH));
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                    return;
                }
                if (firstRoot == null || firstRoot.getElement() == null) {
                    this.window.clear();
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.END_OF_TREE));
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.START_OF_TREE));
                    if (this.lazyView.shouldShowSelectTopOption()) {
                        this.lazyView.swapToButtonComposite();
                    } else if (!this.isSearchChanged) {
                        this.lazyView.swapToMessageComposite();
                    } else {
                        this.lazyView.swapToTreeComposite();
                        this.addPathLast(AbstractTreeIterator.getDummyOperatioNode(TreePath.TOP_DUMMY_TREE_PATH));
                        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                        this.isSearchChanged = false;
                    }
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.UPDATE_GUI_FILTERED_INDICATION));
                    return;
                }
                this.startTreePath = firstRoot;
                if (customExpandArguments != null) {
                    expandedTreePath = customExpandArguments.getExpandedTreePath();
                    expandLevel = customExpandArguments.getExpandLevel();
                    if (customExpandState == ExpandCollapseState.COLLAPSED && this.isHierarchyParentOf(expandedTreePath, this.startTreePath, expandLevel)) {
                        this.toggledStatePaths.add(this.startTreePath);
                    }
                }
                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.START_OF_TREE));
            }
            this.lazyView.swapToTreeComposite();
            if (this.startTreePath != null) {
                this.addPathLast(AbstractTreeIterator.getDummyOperatioNode(TreePath.TOP_DUMMY_TREE_PATH));
                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                boolean addFirstPathToWindow = false;
                if (customExpandArguments != null) {
                    expandedTreePath = customExpandArguments.getExpandedTreePath();
                    expandLevel = customExpandArguments.getExpandLevel();
                    if (customExpandState == ExpandCollapseState.COLLAPSED && this.isHierarchyParentOf(expandedTreePath, this.startTreePath, expandLevel)) {
                        this.toggledStatePaths.add(this.startTreePath);
                    }
                }
                if (isCheckFirstPathToAddToTree) {
                    if (this.matches(this.startTreePath, monitor)) {
                        addFirstPathToWindow = true;
                        if (isComputeOnlyFirstElement) {
                            this.window.clear();
                            this.lazyView.swapToTreeComposite();
                            this.notifyStateListeners(new TreeIteratorGoToElementEvent(TreeIteratorEventType.WINDOW_GO_TO_FIRST_ELEMENT, this.startTreePath));
                            this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.UPDATE_GUI_FILTERED_INDICATION));
                            this.isSearchChanged = false;
                            return;
                        }
                    } else {
                        TreePath computeNextMatch = this.computeNextMatch(this.startTreePath, monitor);
                        if (computeNextMatch == null) {
                            TreePath prevMatch = this.prevFiltered(this.startTreePath, monitor);
                            if (prevMatch == null) {
                                this.window.clear();
                                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.END_OF_TREE));
                                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.START_OF_TREE));
                                if (this.lazyView.shouldShowSelectTopOption()) {
                                    this.lazyView.swapToButtonComposite();
                                } else if (!this.isSearchChanged) {
                                    this.lazyView.swapToMessageComposite();
                                } else {
                                    this.addPathLast(AbstractTreeIterator.getDummyOperatioNode(TreePath.TOP_DUMMY_TREE_PATH));
                                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                                    this.isSearchChanged = false;
                                }
                                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.UPDATE_GUI_FILTERED_INDICATION));
                                return;
                            }
                            if (TreePath.isParent(prevMatch, this.startTreePath)) {
                                addFirstPathToWindow = true;
                            }
                        } else if (isComputeOnlyFirstElement) {
                            this.window.clear();
                            this.lazyView.swapToTreeComposite();
                            this.notifyStateListeners(new TreeIteratorGoToElementEvent(TreeIteratorEventType.WINDOW_GO_TO_FIRST_ELEMENT, computeNextMatch));
                            this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.UPDATE_GUI_FILTERED_INDICATION));
                            this.isSearchChanged = false;
                            return;
                        }
                        if (computeNextMatch != null && TreePath.isParent(this.startTreePath, computeNextMatch)) {
                            addFirstPathToWindow = true;
                        }
                    }
                } else {
                    addFirstPathToWindow = true;
                }
                if (addFirstPathToWindow) {
                    this.window.clear();
                    this.addPathFirst(this.startTreePath);
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                }
            }
        }
        this.lazyView.swapToTreeComposite();
        this.removeOperationNode(true);
        int currentWindowSize = this.window.size();
        if (this.targetWindowSize == currentWindowSize) {
            this.isSearchChanged = false;
            return;
        }
        if (this.targetWindowSize < currentWindowSize) {
            int i = this.targetWindowSize;
            while (i < currentWindowSize) {
                if (monitor.isCanceled()) {
                    this.isSearchChanged = false;
                    return;
                }
                this.removeLastPath();
                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_REMOVE_LAST));
                ++i;
            }
        } else {
            int expandLevel;
            TreePath expandedTreePath;
            int i = currentWindowSize;
            while (i < this.targetWindowSize) {
                TreePath next;
                TreePath last = this.getLastNode();
                if (last == null) {
                    TreePath treePath = last = this.startTreePath != null ? this.startTreePath : TreePath.TOP_DUMMY_TREE_PATH;
                }
                if (monitor.isCanceled()) {
                    this.removeOperationNode(true);
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.ENABLE_SLIDER_ARROWS));
                    this.isSearchChanged = false;
                    return;
                }
                if (i == currentWindowSize) {
                    this.addPathLast(AbstractTreeIterator.getDummyOperatioNode(last));
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_LAST));
                }
                if ((next = this.nextFiltered(last, monitor)) == null) {
                    this.removeOperationNode(true);
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.END_OF_TREE));
                    break;
                }
                if (customExpandArguments != null) {
                    expandedTreePath = customExpandArguments.getExpandedTreePath();
                    expandLevel = customExpandArguments.getExpandLevel();
                    if (customExpandState == ExpandCollapseState.COLLAPSED && this.isHierarchyParentOf(expandedTreePath, next, expandLevel)) {
                        this.toggledStatePaths.add(next);
                    }
                }
                this.addPathLast(next);
                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_LAST));
                if (i == this.targetWindowSize - 1) {
                    this.removeOperationNode(true);
                }
                ++i;
            }
            currentWindowSize = this.window.size();
            this.removeOperationNode(true);
            this.removeOperationNode(false);
            if (this.targetWindowSize > currentWindowSize) {
                i = currentWindowSize;
                while (i < this.targetWindowSize) {
                    TreePath firstNode = this.getFirstNode();
                    if (firstNode == null) {
                        TreePath treePath = firstNode = this.startTreePath != null ? this.startTreePath : TreePath.TOP_DUMMY_TREE_PATH;
                    }
                    if (monitor.isCanceled()) {
                        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.ENABLE_SLIDER_ARROWS));
                        this.removeOperationNode(false);
                        this.isSearchChanged = false;
                        return;
                    }
                    if (i == currentWindowSize) {
                        this.addPathFirst(AbstractTreeIterator.getDummyOperatioNode(firstNode.getParent()));
                        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_LAST));
                    }
                    TreePath prev = this.prevFiltered(firstNode, monitor);
                    if (customExpandArguments != null) {
                        expandedTreePath = customExpandArguments.getExpandedTreePath();
                        expandLevel = customExpandArguments.getExpandLevel();
                        if (customExpandState == ExpandCollapseState.COLLAPSED && this.isHierarchyParentOf(expandedTreePath, prev, expandLevel)) {
                            this.toggledStatePaths.add(prev);
                        }
                    }
                    if (prev == null) {
                        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.START_OF_TREE));
                        this.removeOperationNode(false);
                        break;
                    }
                    this.addPathFirst(prev);
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                    if (i == this.targetWindowSize - 1) {
                        this.removeOperationNode(false);
                    }
                    ++i;
                }
            }
        }
        if (this.window.size() == 0) {
            this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.END_OF_TREE));
            this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.START_OF_TREE));
            if (this.lazyView.shouldShowSelectTopOption()) {
                this.lazyView.swapToButtonComposite();
            } else if (!this.isSearchChanged) {
                this.lazyView.swapToMessageComposite();
            } else {
                this.addPathLast(AbstractTreeIterator.getDummyOperatioNode(TreePath.TOP_DUMMY_TREE_PATH));
                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                this.isSearchChanged = false;
            }
        }
        this.isSearchChanged = false;
        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.UPDATE_GUI_FILTERED_INDICATION));
    }

    private TreePath getLastNode() {
        TreePath last;
        int windowSize = this.window.size();
        TreePath treePath = last = windowSize == 0 ? null : this.window.getLast();
        if (last != null && "...".equals(last.getLastSegment())) {
            TreePath prevPath = this.window.getFirst();
            for (TreePath path : this.window) {
                if ("...".equals(path.getLastSegment())) {
                    return prevPath;
                }
                prevPath = path;
            }
        }
        return last;
    }

    private TreePath getFirstNode() {
        return this.getFirstNode(false);
    }

    public TreePath getFirstInWindow() {
        if (this.window == null) {
            return null;
        }
        int windowSize = this.window.size();
        return windowSize == 0 ? null : this.window.getFirst();
    }

    private TreePath getFirstNode(boolean excludeDummyTop) {
        TreePath first;
        int windowSize = this.window.size();
        TreePath treePath = first = windowSize == 0 ? null : this.window.getFirst();
        if (first != null && "...".equals(first.getLastSegment())) {
            TreePath next;
            Iterator<TreePath> it = this.window.iterator();
            while (it.hasNext()) {
                next = it.next();
                if ("...".equals(next.getLastSegment())) break;
            }
            TreePath treePath2 = next = it.hasNext() ? it.next() : null;
            if (excludeDummyTop && next != null && next == TreePath.TOP_DUMMY_TREE_PATH) {
                next = it.hasNext() ? it.next() : null;
            }
            return next;
        }
        if (excludeDummyTop && first != null && first == TreePath.TOP_DUMMY_TREE_PATH) {
            Iterator<TreePath> it = this.window.iterator();
            it.next();
            return it.hasNext() ? it.next() : null;
        }
        return first;
    }

    private void removeLastPath() {
        if (this.window.size() == 0) {
            return;
        }
        TreePath last = this.window.getLast();
        if (last != null && "...".equals(last.getLastSegment())) {
            List<TreePath> windowCopy = new ArrayList<TreePath>(this.window);
            windowCopy = windowCopy.subList(0, windowCopy.size() - 1);
            this.window.clear();
            this.window.addAll(windowCopy);
            return;
        }
        this.window.removeLast();
    }

    public void addPathLast(TreePath path) {
        TreePath last;
        int windowSize = this.window.size();
        TreePath treePath = last = windowSize == 0 ? null : this.window.getLast();
        if (last != null && "...".equals(last.getLastSegment())) {
            if ("...".equals(path.getLastSegment())) {
                return;
            }
            List<TreePath> windowCopy = new ArrayList<TreePath>(this.window);
            windowCopy = windowCopy.subList(0, windowCopy.size() - 1);
            windowCopy.add(path);
            last = AbstractTreeIterator.getDummyOperatioNode(path);
            windowCopy.add(last);
            this.window.clear();
            this.window.addAll(windowCopy);
            return;
        }
        this.window.addLast(path);
    }

    private void removeFirstPath() {
        if (this.window.size() == 0) {
            return;
        }
        TreePath first = this.window.getFirst();
        if (first != null && "...".equals(first.getLastSegment())) {
            List<TreePath> windowCopy = new ArrayList<TreePath>(this.window);
            windowCopy = windowCopy.subList(1, windowCopy.size());
            windowCopy.add(first);
            this.window.clear();
            this.window.addAll(windowCopy);
            return;
        }
        this.window.removeFirst();
    }

    private void addPathFirst(TreePath path) {
        TreePath first;
        int windowSize = this.window.size();
        TreePath treePath = first = windowSize == 0 ? null : this.window.getFirst();
        if (first != null && "...".equals(first.getLastSegment())) {
            if ("...".equals(path.getLastSegment())) {
                return;
            }
            first = AbstractTreeIterator.getDummyOperatioNode(path.getParent());
            List<TreePath> windowCopy = new ArrayList<TreePath>(this.window);
            windowCopy = windowCopy.subList(1, windowCopy.size());
            windowCopy.add(0, path);
            windowCopy.add(0, first);
            this.window.clear();
            this.window.addAll(windowCopy);
            return;
        }
        this.window.addFirst(path);
    }

    private boolean isDummyOperationNode(TreePath last) {
        if (last == null) {
            return false;
        }
        String lastSegment = last.getLastSegment();
        return lastSegment != null && lastSegment.equals("...");
    }

    public void notifyStateListeners(TreeIteratorEvent event) {
        for (ITreeIteratorStateListener l : this.stateListeners) {
            l.stateChanged(event);
        }
    }

    protected boolean matches(TreePath next, IProgressMonitor monitor) {
        boolean matches;
        IDVTElementWrapper elementWrapper;
        if (this.filter == null) {
            return true;
        }
        ++this.matchesCounter;
        if (this.matchesCounter > 0 && this.lazyView.hasTotalNumOfNodes()) {
            long totalNumOfNodes = this.lazyView.getTotalNumOfNodes();
            if (totalNumOfNodes > 0L) {
                long prevPercent;
                long currPercent = (long)(this.matchesCounter * 100) / totalNumOfNodes;
                long l = prevPercent = this.matchesCounter < 1 ? 0L : (long)((this.matchesCounter - 1) * 100) / totalNumOfNodes;
                if (this.matchesCounter % 10000 == 0) {
                    monitor.setTaskName(MessageFormat.format("{0} nodes visited", this.matchesCounter));
                }
                if (currPercent > 0L && currPercent > prevPercent) {
                    monitor.worked(1);
                }
            }
        } else if (this.matchesCounter > 0 && this.matchesCounter % 10000 == 0) {
            monitor.setTaskName(MessageFormat.format("{0} nodes visited", this.matchesCounter));
            monitor.worked(1);
        }
        boolean isGenerate = false;
        boolean dhViewHideGenerates = false;
        ILabelProvider labelProvider = this.lazyView.getLabelProvider();
        if (labelProvider instanceof DVTDHLabelProvider) {
            dhViewHideGenerates = ((DVTDHLabelProvider)labelProvider).getHideGenerates();
        }
        if (dhViewHideGenerates && (DesignUtils.getDesignKind(next.getElement()) == IRfNamedElement.ElementKind.VLOG_GENERATE || DesignUtils.getDesignKind(next.getElement()) == IRfNamedElement.ElementKind.VHDL_BLOCK)) {
            isGenerate = true;
        }
        if (!this.filter.isFiltered()) {
            return !isGenerate;
        }
        if (next.getElement() instanceof IDVTElementWrapper && (elementWrapper = (IDVTElementWrapper)next.getElement()).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.IS_MESSAGE) != null) {
            return false;
        }
        StringMatcher[] segments = this.filter.getSearchSegments();
        boolean matchesPath = false;
        if (this.lazyView instanceof ConfigDBView && segments.length == 1 && AbstractTreeIterator.matchesRevealGrammer(segments[0])) {
            String substring = segments[0].getPattern().substring(1, segments[0].getPattern().length() - 1);
            String[] split = DVTStringUtil.split("| ", substring);
            StringMatcher[] newMatches = new StringMatcher[split.length];
            int i = 0;
            while (i < split.length) {
                newMatches[i] = ViewsUtils.createCamelCaseOrRegexMatcher(split[i].isEmpty() ? "*" : split[i].trim(), true, false);
                ++i;
            }
            boolean[] isSegmentStrict = new boolean[]{true};
            int i2 = 0;
            while (i2 < newMatches.length) {
                StringMatcher[] matchStep = new StringMatcher[]{newMatches[i2]};
                if (!(matchesPath |= ViewsUtils.matchesPath(next, this.lazyView.getLabelProvider(), matchStep, isSegmentStrict, null, this.lazyView.getViewColumnCount()))) {
                    ++i2;
                    continue;
                }
                break;
            }
        } else {
            matchesPath = ViewsUtils.matchesPath(next, this.lazyView.getLabelProvider(), segments, this.filter.getSearchTextStrictness(), null, this.lazyView.getViewColumnCount());
        }
        boolean matchesPort = true;
        if (this.filter.getSearchPort() != null && this.lazyView instanceof IRfFilterableTreeAccessor) {
            matchesPort = ViewsUtils.matchesPort(next, (IRfFilterableTreeAccessor)((Object)this.lazyView));
        }
        boolean bl = matches = matchesPath && matchesPort;
        if (matches) {
            if (isGenerate) {
                StringMatcher stringMatcher = this.filter.getStringMatcher();
                if (stringMatcher.getPattern().endsWith("/*")) {
                    return false;
                }
                if (!this.hasInstanceChildren(next, monitor)) {
                    return false;
                }
            }
            this.addBoldPath(next);
        }
        return matches;
    }

    public void slide(int n, IProgressMonitor monitor) {
        this.matchesCounter = 0;
        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.ENABLE_SLIDER_ARROWS));
        if (n == 0 || this.window.size() == 0) {
            return;
        }
        int i = 0;
        while (i < Math.abs(n)) {
            TreePath next;
            if (monitor.isCanceled()) {
                this.removeOperationNode(n > 0);
                return;
            }
            if (i == 0) {
                if (n > 0) {
                    TreePath last = this.getLastNode();
                    if (last == null) {
                        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.ENABLE_SLIDER_ARROWS));
                        this.removeOperationNode(true);
                        break;
                    }
                    this.addPathLast(AbstractTreeIterator.getDummyOperatioNode(last));
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_LAST));
                } else {
                    TreePath first = this.getFirstNode();
                    if (first == null) {
                        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.ENABLE_SLIDER_ARROWS));
                        this.removeOperationNode(false);
                        break;
                    }
                    this.addPathFirst(AbstractTreeIterator.getDummyOperatioNode(first.getParent()));
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
                }
            }
            TreePath treePath = next = n > 0 ? this.nextFiltered(this.getLastNode(), monitor) : this.prevFiltered(this.getFirstNode(), monitor);
            if (next == null || next == TreePath.TOP_DUMMY_TREE_PATH) {
                this.removeOperationNode(n > 0);
                if (n > 0) {
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.END_OF_TREE));
                } else {
                    this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.START_OF_TREE));
                }
                return;
            }
            if (n > 0) {
                this.removeFirstPath();
                this.addPathLast(next);
                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_LAST));
            } else {
                this.removeLastPath();
                this.addPathFirst(next);
                this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_ADD_FIRST));
            }
            if (i == Math.abs(n) - 1) {
                this.removeOperationNode(n > 0);
            }
            ++i;
        }
    }

    private void removeOperationNode(boolean isLast) {
        TreePath node;
        if (this.window.size() == 0) {
            return;
        }
        TreePath treePath = node = isLast ? this.window.getLast() : this.window.getFirst();
        if (!this.isDummyOperationNode(node)) {
            return;
        }
        if (isLast) {
            this.window.removeLast();
        } else {
            this.window.removeFirst();
        }
        this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.WINDOW_REMOVE_STATE_NODE));
    }

    public void resetHard(IDVTLazyView lazyView, ExpandCollapseState state, TreePath first, TextFilterObject filter, boolean resetToggledPathsState, boolean resetState, boolean isKeepSelection, boolean restorePaths, boolean isResetMatchCache, IProgressMonitor monitor) {
        this.lazyView = lazyView;
        if (state != null) {
            this.state = state;
        }
        this.filter = filter;
        this.targetWindowSize = 1;
        if (resetToggledPathsState) {
            this.toggledStatePaths.clear();
        }
        if (resetState) {
            this.state = ExpandCollapseState.EXPANDED;
            this.customExpandStateInfo = null;
        }
        this.cleanBoldPaths();
        this.window.clear();
        this.startTreePath = first;
        if (this.startTreePath != null && restorePaths) {
            this.restoreStartPathAndStatePaths(monitor);
        }
        if (!isKeepSelection) {
            this.setSelection(null);
        }
        if (isResetMatchCache) {
            this.getMatchCache().clear();
        }
        this.cleanBoldPaths();
        if (lazyView != null) {
            lazyView.resetModelSpecifiCaches();
        }
        this.resetHardInternal();
    }

    public void resetSoft(TextFilterObject filter, boolean resetExpandState) {
        this.filter = filter;
        if (resetExpandState) {
            this.toggledStatePaths.clear();
        }
        this.resetSoftInternal();
    }

    public void customExpandTreePaths(CustomExpandStateInfo customExpandArguments, ExpandCollapseState state) {
        TreePath expandedTreePath = customExpandArguments.getExpandedTreePath();
        if (customExpandArguments.getExpandLevel() > 0 && state == ExpandCollapseState.COLLAPSED) {
            this.toggledStatePaths.add(expandedTreePath);
        }
        Iterator<TreePath> iterator = this.window.iterator();
        while (iterator.hasNext()) {
            TreePath cursor = iterator.next();
            if (cursor == expandedTreePath) break;
        }
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.growOrShrinkToSize(true, false, customExpandArguments, state, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setState(TreePath treePath, ExpandCollapseState state, IProgressMonitor monitor) {
        if (state == this.state) {
            this.toggledStatePaths.remove(treePath);
        } else {
            this.toggledStatePaths.add(treePath);
        }
        Iterator<TreePath> iterator = this.window.iterator();
        while (iterator.hasNext()) {
            TreePath cursor = iterator.next();
            if (cursor == treePath) break;
        }
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.growOrShrinkToSize(true, false, null, null, monitor);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("-------------------------------");
        int index = 0;
        for (TreePath path : this.window) {
            result.append(String.valueOf(index) + ". " + Arrays.asList(path.getSegments()).stream().collect(Collectors.joining("/")));
            ++index;
        }
        result.append("-------------------------------");
        return result.toString();
    }

    private static final TreePath getNoMatchesFoundElement() {
        TreePath noMatchElement = TreePath.of(null, new String[]{""}, new int[1]);
        noMatchElement.setElement("No matches found.");
        return noMatchElement;
    }

    public static final TreePath getDummyOperatioNode(TreePath parent) {
        if (parent == null) {
            parent = TreePath.TOP_DUMMY_TREE_PATH;
        }
        String[] segments = null;
        if (parent.getSegments() != null) {
            segments = new String[parent.segments.length + 1];
            System.arraycopy(parent.segments, 0, segments, 0, parent.segments.length);
        }
        if (segments == null) {
            segments = new String[1];
        }
        segments[segments.length - 1] = "...";
        TreePath noDataElement = TreePath.of(parent, segments, new int[1]);
        return noDataElement;
    }

    public TreePath getSelection() {
        return this.selection;
    }

    public void setSelection(TreePath selection) {
        if (selection != null && selection.getLastSegment().equals("...")) {
            selection = null;
        }
        IDVTModel model = this.getModel(IModel.class);
        if (selection != null && model instanceof CompileOrderModel && ViewsUtilsCommon.hasMoreThanOneDVTNature(this.getProject())) {
            selection = ((CompileOrderModel)model).getEquivalentTreePath(selection);
        }
        this.selection = selection;
    }

    public TreePath getFirst(boolean excludeDummyTop) {
        return this.getFirstNode(excludeDummyTop);
    }

    public TreePath getFirst() {
        return this.getFirstNode();
    }

    public TreePath getLast() {
        return this.getLastNode();
    }

    public void addBoldPath(TreePath path) {
        if (boldedPaths == null) {
            boldedPaths = new HashSet<TreePath>();
        }
        boldedPaths.add(path);
    }

    public void cleanBoldPaths() {
        if (boldedPaths == null) {
            return;
        }
        boldedPaths.clear();
        boldedPaths = null;
    }

    public boolean isBolded(TreePath path) {
        return boldedPaths != null && boldedPaths.contains(path);
    }

    protected IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.lazyView.getModel(modelClass);
    }

    public CustomExpandStateInfo getCustomExpandStateInfo() {
        return this.customExpandStateInfo;
    }

    public Set<TreePath> getToggledStatePaths() {
        return this.toggledStatePaths;
    }

    public TreePath getStartTreePath() {
        return this.startTreePath;
    }

    protected void resetStartTreePath() {
        this.startTreePath = null;
    }

    protected void resetToggleStatePaths() {
        this.toggledStatePaths.clear();
    }

    protected void resetSelection() {
        this.selection = null;
    }

    public void setStartTreePath(TreePath startTreePath) {
        this.startTreePath = startTreePath;
    }

    public void setToggledStatePaths(Set<TreePath> toggledStatePaths) {
        this.toggledStatePaths = toggledStatePaths;
    }

    protected boolean isFiltered() {
        return this.filter != null && this.filter.getSearchSegments() != null;
    }

    protected ExpandCollapseState getState() {
        return this.state;
    }

    protected TreePath nextFiltered(TreePath treePath, IProgressMonitor monitor) {
        TreePath next = treePath;
        while ((next = this.next(next, true, monitor)) != null) {
            if (monitor.isCanceled()) {
                return null;
            }
            this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.START_SEARCH));
            TreePath nextMatch = this.computeNextMatch(next, monitor);
            this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.DONE_SEARCH));
            if (nextMatch == null) {
                return null;
            }
            if (!TreePath.isParent(next, nextMatch)) continue;
            return next;
        }
        return null;
    }

    protected TreePath computeNextMatch(TreePath treePath, IProgressMonitor monitor) {
        MatchCache.MatchCacheResult result = this.matchCache.nextMatch(treePath);
        if (result.match != null) {
            return result.match;
        }
        TreePath next = treePath;
        do {
            if (monitor.isCanceled()) {
                return null;
            }
            if (next.equals(result.nextAnchor)) {
                result.extendNextAnchor(treePath);
                return result.nextAnchorMatch;
            }
            if (!this.matches(next, monitor)) continue;
            this.matchCache.put(treePath, next);
            return next;
        } while ((next = this.next(next, false, monitor)) != null);
        return null;
    }

    protected TreePath computePrevMatch(TreePath treePath, IProgressMonitor monitor) {
        TreePath prev = treePath;
        do {
            if (monitor.isCanceled()) {
                return null;
            }
            if (!this.matches(prev, monitor)) continue;
            return prev;
        } while ((prev = this.prev(prev, monitor, false)) != null);
        return null;
    }

    protected TreePath prevFiltered(TreePath treePath, IProgressMonitor monitor) {
        TreePath prev = treePath;
        while ((prev = this.prev(prev, monitor, true)) != null) {
            if (TreePath.TOP_DUMMY_TREE_PATH == prev) {
                return null;
            }
            this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.START_SEARCH));
            TreePath nextMatch = this.computeNextMatch(prev, monitor);
            this.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.DONE_SEARCH));
            if (nextMatch == null || !TreePath.isParent(prev, nextMatch)) continue;
            return prev;
        }
        return null;
    }

    protected IProject getProject() {
        if (this.lazyView == null) {
            return null;
        }
        return this.lazyView.getProject();
    }

    public boolean trimInvisibleParents() {
        return this.lazyView.getModel(IELModel.class) instanceof LazyELTrimModel;
    }

    public MatchCache getMatchCache() {
        return this.matchCache;
    }

    public boolean isCachedTreePath(TreePath treePath) {
        return this.matchCache.checkMatch(treePath);
    }

    public IDVTLazyView getLazyView() {
        return this.lazyView;
    }

    protected boolean isHierarchyParentOf(TreePath parent, TreePath path, int parentLevel) {
        if (parent == null || path == null) {
            return false;
        }
        String[] parentCandidateSegments = TreePathUtils.getSegmentsFromTreePath(parent, true);
        String[] pathSegments = TreePathUtils.getSegmentsFromTreePath(path, true);
        if (parentCandidateSegments == null || parentCandidateSegments.length == 0 || pathSegments == null || pathSegments.length == 0) {
            return false;
        }
        if (parentCandidateSegments.length != pathSegments.length - parentLevel) {
            return false;
        }
        int i = 0;
        while (i < parentCandidateSegments.length) {
            if (!parentCandidateSegments[i].equals(pathSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isDirectParentOf(String[] parentCandidateSegments, String[] pathSegments) {
        if (parentCandidateSegments == null || parentCandidateSegments.length == 0 || pathSegments == null || pathSegments.length == 0) {
            return false;
        }
        if (parentCandidateSegments.length != pathSegments.length - 1) {
            return false;
        }
        int i = 0;
        while (i < parentCandidateSegments.length) {
            if (!parentCandidateSegments[i].equals(pathSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract TreePath getFirstChildOfPath(TreePath var1, IProgressMonitor var2);

    protected abstract TreePath next(TreePath var1, boolean var2, IProgressMonitor var3);

    protected abstract TreePath prev(TreePath var1, IProgressMonitor var2, boolean var3);

    protected abstract void restoreStartPathAndStatePaths(IProgressMonitor var1);

    protected abstract void resetHardInternal();

    protected abstract void resetSoftInternal();

    public abstract boolean isCollapsedAndHasChildren(TreePath var1, IProgressMonitor var2);

    public abstract boolean hasInstanceChildren(TreePath var1, IProgressMonitor var2);

    public abstract TreePath getEndTreePath(TreePath var1, IProgressMonitor var2);

    public abstract boolean isCollapsed(TreePath var1);

    private static boolean matchesRevealGrammer(StringMatcher stringMatcher) {
        int beginIndex = 1;
        int endIndex = stringMatcher.getPattern().length() - beginIndex;
        if (endIndex - beginIndex < 0) {
            return false;
        }
        return REVEAL_CONFIG_DB_PATTERN.matches(stringMatcher.getPattern().substring(beginIndex, endIndex));
    }
}

