/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.ElTreeIteratorConfig;
import ro.amiq.dvt.ui.views.lazy.tree.ExpandCollapseState;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IELModel;
import ro.amiq.dvt.ui.views.lazy.tree.ITrimmedTreePath;
import ro.amiq.dvt.ui.views.lazy.tree.LazyELTrimModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorException;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.AbstractElDesignHierarchyModel;

public class ELTreeIterator
extends AbstractTreeIterator {
    private final Predicate<ElementPath> hasCollapsedParentsPredicate = path -> this.hasCollapsedParents((ElementPath)path, (IProgressMonitor)new NullProgressMonitor());
    private RfMixedLangProject mixedLangProject;

    public ELTreeIterator(IDVTLazyView lazyView) {
        super(lazyView);
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        this.mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
    }

    @Override
    public boolean isCollapsedAndHasChildren(TreePath treePath, IProgressMonitor monitor) {
        String[] pathElementPathegments = TreePathUtils.getSegmentsFromTreePath(treePath);
        if (!this.isCollapsed(pathElementPathegments, true, monitor)) {
            return false;
        }
        TreePath children = this.getFirstChildOfPath(treePath, monitor);
        return children != null;
    }

    @Override
    public boolean hasInstanceChildren(TreePath treePath, IProgressMonitor monitor) {
        if (treePath == null || monitor.isCanceled()) {
            return false;
        }
        IDVTModel model = this.getModel(IELModel.class);
        if (!(model instanceof AbstractElDesignHierarchyModel)) {
            return false;
        }
        return ((AbstractElDesignHierarchyModel)model).hasInstanceChildren(treePath, this.getManager());
    }

    @Override
    protected TreePath getFirstChildOfPath(TreePath treePath, IProgressMonitor monitor) {
        IDVTModel dvtModel = this.getModel(IELModel.class);
        if (!(dvtModel instanceof IELModel)) {
            return null;
        }
        IELModel elModel = (IELModel)dvtModel;
        return elModel.getFirstChildOfPath(treePath, monitor);
    }

    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        IDVTModel dvtModel = this.getModel(IELModel.class);
        if (!(dvtModel instanceof IELModel)) {
            return null;
        }
        IELModel elModel = (IELModel)dvtModel;
        return elModel.getElEndTreePath(path, monitor);
    }

    @Override
    protected void resetHardInternal() {
        IDVTModel model = this.getModel(IELModel.class);
        if (model instanceof AbstractElDesignHierarchyModel) {
            ((AbstractElDesignHierarchyModel)model).resetCache();
        }
    }

    @Override
    protected void resetSoftInternal() {
        if (this.getLazyView() != null) {
            this.getLazyView().resetModelSpecifiCaches();
        }
        this.getMatchCache().clear();
    }

    @Override
    protected void restoreStartPathAndStatePaths(IProgressMonitor monitor) {
        HashSet<TreePath> toggleStatePathsCopy = new HashSet<TreePath>(this.getToggledStatePaths());
        TreePath startTreePathCopy = this.getStartTreePath();
        TreePath selectionCopy = this.getSelection();
        TreePath relativePathCopy = startTreePathCopy instanceof ITrimmedTreePath ? ((ITrimmedTreePath)((Object)startTreePathCopy)).getRelativeToPath() : null;
        boolean isTrimmedPath = relativePathCopy != null;
        HashSet<TreePath> restoredTogglePaths = new HashSet<TreePath>();
        this.resetStartTreePath();
        this.resetToggleStatePaths();
        this.resetSelection();
        IDVTModel dvtModel = this.getModel(IELModel.class);
        if (!(dvtModel instanceof IELModel)) {
            return;
        }
        ELManager manager = this.getManager();
        if (manager == null) {
            return;
        }
        ElementPath elementPath = TreePathUtils.getElementPathFromTreePath(startTreePathCopy);
        ELInstance elInstance = manager.getMemory().instanceFor(elementPath);
        if (elInstance == null) {
            return;
        }
        TreePath startTreePathCandidate = TreePathUtils.getTreePathFromELInstance(null, elInstance, manager, isTrimmedPath, monitor);
        if (startTreePathCandidate == null) {
            return;
        }
        if (isTrimmedPath) {
            TreePath relativePathCandidate;
            ElementPath relativePathElementPath = TreePathUtils.getElementPathFromTreePath(relativePathCopy);
            ELInstance relativePathElInstance = manager.getMemory().instanceFor(relativePathElementPath);
            if (relativePathElInstance != null && (relativePathCandidate = TreePathUtils.getTreePathFromELInstance(null, elInstance, manager, isTrimmedPath, monitor)) != null && startTreePathCandidate instanceof ITrimmedTreePath) {
                ((ITrimmedTreePath)((Object)startTreePathCandidate)).setRelativeToPath(relativePathCandidate);
            }
        }
        this.setStartTreePath(startTreePathCandidate);
        if (selectionCopy != null) {
            TreePath selectionTreePathCandidate;
            ElementPath selectionPath = TreePathUtils.getElementPathFromTreePath(selectionCopy);
            ELInstance selectionPathElInstance = manager.getMemory().instanceFor(selectionPath);
            if (selectionPathElInstance != null && (selectionTreePathCandidate = TreePathUtils.getTreePathFromELInstance(null, selectionPathElInstance, manager, isTrimmedPath, monitor)) != null) {
                this.setSelection(selectionTreePathCandidate);
            }
        }
        for (TreePath toggleStatePath : toggleStatePathsCopy) {
            TreePath toggleStatePathCandidate;
            if (monitor.isCanceled()) {
                return;
            }
            ElementPath toggleStateElementPath = TreePathUtils.getElementPathFromTreePath(toggleStatePath);
            ELInstance toggleStatePathElInstance = manager.getMemory().instanceFor(toggleStateElementPath);
            if (toggleStatePathElInstance == null || (toggleStatePathCandidate = TreePathUtils.getTreePathFromELInstance(null, toggleStatePathElInstance, manager, isTrimmedPath, monitor)) == null) continue;
            restoredTogglePaths.add(toggleStatePathCandidate);
        }
        this.setToggledStatePaths(restoredTogglePaths);
    }

    @Override
    public boolean isCollapsed(TreePath path) {
        String[] pathSegments = TreePathUtils.getSegmentsFromTreePath(path);
        return this.isCollapsed(pathSegments, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean isCollapsed(String[] pathSegments, boolean includeExactPath, IProgressMonitor monitor) {
        if (this.getState() == ExpandCollapseState.EXPANDED) {
            return this.isInToggledPaths(pathSegments, includeExactPath, monitor);
        }
        if (this.getState() == ExpandCollapseState.COLLAPSED) {
            return !this.isInToggledPaths(pathSegments, includeExactPath, monitor);
        }
        throw new TreeIteratorException();
    }

    private boolean isInToggledPaths(String[] pathSegments, boolean includeExactPath, IProgressMonitor monitor) {
        for (TreePath togglePath : this.getToggledStatePaths()) {
            if (monitor.isCanceled()) {
                return false;
            }
            Object[] togglePathSegments = TreePathUtils.getSegmentsFromTreePath(togglePath);
            if (includeExactPath && Arrays.equals(togglePathSegments, pathSegments)) {
                return true;
            }
            if (includeExactPath || !this.isDirectParentOf((String[])togglePathSegments, pathSegments)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isDirectParentOf(String[] parentCandidateSegments, String[] pathSegments) {
        if (parentCandidateSegments == null || parentCandidateSegments.length == 0 || pathSegments == null || pathSegments.length == 0) {
            return false;
        }
        if (parentCandidateSegments.length != pathSegments.length - 1) {
            return false;
        }
        int i = 0;
        while (i < parentCandidateSegments.length) {
            if (!parentCandidateSegments[i].equals(pathSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected TreePath next(TreePath treePath, boolean isSkipCollapsed, IProgressMonitor monitor) {
        if (treePath == null || monitor.isCanceled()) {
            return null;
        }
        IDVTModel dvtModel = this.getModel(IELModel.class);
        if (!(dvtModel instanceof IELModel)) {
            return null;
        }
        ELManager manager = this.getManager();
        if (manager == null) {
            return null;
        }
        ElementPath elementPath = TreePathUtils.getElementPathFromTreePath(treePath);
        boolean isPrevPathCollapsed = this.isCollapsed(treePath);
        ElTreeIteratorConfig elTreeIteratorConfig = new ElTreeIteratorConfig(isSkipCollapsed);
        elTreeIteratorConfig.setPrevPathCollapsed(isPrevPathCollapsed);
        Map<ElementPath, ELInstance> nextElInstances = ((IELModel)dvtModel).getElNextInstances(elementPath, manager, elTreeIteratorConfig, monitor);
        if (nextElInstances == null) {
            return null;
        }
        for (Map.Entry<ElementPath, ELInstance> elInstanceEntry : nextElInstances.entrySet()) {
            if (monitor.isCanceled()) {
                return null;
            }
            ElementPath elInstancePath = elInstanceEntry.getKey();
            if (elementPath.equals(elInstancePath)) continue;
            ELInstance elInstance = elInstanceEntry.getValue();
            if (isSkipCollapsed && isPrevPathCollapsed && elementPath.isPrefixOf(elInstancePath)) continue;
            return TreePathUtils.getTreePathFromELInstance(treePath, elInstance, manager, dvtModel instanceof LazyELTrimModel, monitor);
        }
        return null;
    }

    @Override
    protected TreePath prev(TreePath treePath, IProgressMonitor monitor, boolean isSkipCollapsed) {
        if (treePath == null) {
            return null;
        }
        IDVTModel dvtModel = this.getModel(IELModel.class);
        if (!(dvtModel instanceof IELModel)) {
            return null;
        }
        ELManager manager = this.getManager();
        if (manager == null) {
            return null;
        }
        ElementPath elementPath = TreePathUtils.getElementPathFromTreePath(treePath);
        ElTreeIteratorConfig elTreeIteratorConfig = new ElTreeIteratorConfig(isSkipCollapsed);
        elTreeIteratorConfig.setHasCollapsedParentsPredicate(this.hasCollapsedParentsPredicate);
        Map<ElementPath, ELInstance> prevElInstances = ((IELModel)dvtModel).getElPrevInstances(elementPath, manager, elTreeIteratorConfig, monitor);
        if (prevElInstances == null || prevElInstances.isEmpty()) {
            return null;
        }
        for (Map.Entry<ElementPath, ELInstance> prevElEntry : prevElInstances.entrySet()) {
            if (monitor.isCanceled()) {
                return null;
            }
            ElementPath elInstancePath = prevElEntry.getKey();
            if (elementPath.equals(elInstancePath) || isSkipCollapsed && this.hasCollapsedParents(elInstancePath, monitor)) continue;
            ELInstance elInstance = prevElEntry.getValue();
            return TreePathUtils.getTreePathFromELInstance(treePath, elInstance, manager, dvtModel instanceof LazyELTrimModel, monitor);
        }
        return null;
    }

    private boolean hasCollapsedParents(ElementPath elementPath, IProgressMonitor monitor) {
        if (elementPath == null || elementPath.isEmpty() || elementPath.length() < 2) {
            return false;
        }
        String[] segments = elementPath.getSegments();
        int i = segments.length - 1;
        while (i >= 0) {
            if (this.isCollapsedParent(segments, i, monitor)) {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean isCollapsedParent(String[] segments, int parentIndex, IProgressMonitor monitor) {
        if (this.getState() == ExpandCollapseState.EXPANDED) {
            return this.hasParentsInToggledPaths(segments, parentIndex, monitor);
        }
        if (this.getState() == ExpandCollapseState.COLLAPSED) {
            return !this.hasParentsInToggledPaths(segments, parentIndex, monitor);
        }
        throw new TreeIteratorException();
    }

    private boolean hasParentsInToggledPaths(String[] segments, int parentIndex, IProgressMonitor monitor) {
        for (TreePath toggledPath : this.getToggledStatePaths()) {
            if (monitor.isCanceled()) {
                return false;
            }
            if (!this.isDirectParentOf(TreePathUtils.getSegmentsFromTreePath(toggledPath), segments, parentIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean isDirectParentOf(String[] candidateParentSegments, String[] pathSegments, int parentIndex) {
        if (candidateParentSegments == null || candidateParentSegments.length == 0 || pathSegments == null || pathSegments.length == 0 || parentIndex >= pathSegments.length) {
            return false;
        }
        if (candidateParentSegments.length != parentIndex && (parentIndex != 0 || candidateParentSegments.length != 1)) {
            return false;
        }
        int i = 0;
        while (i < candidateParentSegments.length) {
            if (!candidateParentSegments[i].equals(pathSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ELManager getManager() {
        if (this.mixedLangProject == null) {
            return null;
        }
        return this.mixedLangProject.getELManager();
    }
}

