/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.CustomExpandStateInfo;
import ro.amiq.dvt.ui.views.lazy.tree.ExpandCollapseState;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyTable;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyViewListener;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTMultipleSelectionLazyView;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.ITreeIteratorStateListener;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorFactory;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeNotifyListenersCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeProvider;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeSliderSeparatorSide;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeStateLabel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyViewSliderPosition;
import ro.amiq.dvt.ui.views.lazy.tree.MultipleSelectionTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEvent;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEventType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.TreeSelectionMode;
import ro.amiq.dvt.ui.views.lazy.tree.VerticalLazyViewSlider;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeDecorateCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeDecorateCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeExpandCollapseActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeGoToStartEndOfTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeOperation;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeQuickSearchGoToElementActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRecomputeCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRedrawCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRedrawCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetForTopActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetHardCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetModelCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetSoftCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetCustomExpandStateCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetMultipleSelectionActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetMultipleSelectionCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetSelectionActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetSelectionCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetSelectionCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetStateCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSlideActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSlideCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderModel;

public class LazyTree {
    private Composite tableAndTreeComposite;
    private LazyTreeProvider treeProvider;
    private AbstractTreeIterator treeIterator;
    private Tree tree;
    private IDVTLazyView lazyView;
    private ILabelProvider labelProvider;
    public int fExpandLevel;
    private TextFilterObject searchText;
    private VerticalLazyViewSlider verticalSlider;
    private ScrolledComposite scrolledComposite;
    private Composite treeComposite;
    private Composite stackComposite;
    private Composite controlParent;
    private Table topTable;
    private LazyViewSliderPosition sliderPosition;
    private KeyListener setSelectionUsingKeysListener;

    public LazyTree(IDVTLazyView lazyView, LazyViewSliderPosition sliderPosition) {
        this.lazyView = lazyView;
        this.sliderPosition = sliderPosition;
    }

    public LazyTree(IDVTLazyView lazyView) {
        this.lazyView = lazyView;
        this.sliderPosition = LazyViewSliderPosition.RIGHT;
    }

    public void setLabelProvider(final ILabelProvider labelProvider, boolean hasDecorators) {
        this.labelProvider = labelProvider;
        if (hasDecorators && this.labelProvider != null) {
            ILabelProviderListener listener = new ILabelProviderListener(){

                public void labelProviderChanged(LabelProviderChangedEvent event) {
                    Object[] elements = event.getElements();
                    if (elements == null || elements.length == 0) {
                        return;
                    }
                    LazyTreeDecorateCmd decorate = (LazyTreeDecorateCmd)LazyTreeOperation.DECORATE.makeCommand(new LazyTreeDecorateCmdArgs(null));
                    decorate.decorate(elements, LazyTree.this.treeIterator, LazyTree.this.tree, labelProvider, (IProgressMonitor)new NullProgressMonitor(), null);
                }
            };
            labelProvider.addListener(listener);
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public TreePath getSelection() {
        if (this.treeIterator == null) {
            return null;
        }
        return this.treeIterator.getSelection();
    }

    public List<TreePath> getSelections() {
        if (this.treeIterator == null || !(this.treeIterator instanceof MultipleSelectionTreeIterator)) {
            return null;
        }
        return ((MultipleSelectionTreeIterator)this.treeIterator).getSelections();
    }

    public TreeItem[] getTreeItemSelection() {
        return this.tree.getSelection();
    }

    public void install(Composite parent) {
        Composite controlParent = new Composite(parent, 16);
        this.setControlParent(controlParent);
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.marginBottom = 0;
        parentLayout.marginLeft = 0;
        parentLayout.marginRight = 0;
        parentLayout.marginTop = 0;
        parentLayout.horizontalSpacing = 0;
        parentLayout.numColumns = 2;
        controlParent.setLayout((Layout)parentLayout);
        GridData parentGridData = new GridData(4, 4, true, true);
        controlParent.setLayoutData((Object)parentGridData);
        if (this.sliderPosition == LazyViewSliderPosition.LEFT) {
            this.verticalSlider = new VerticalLazyViewSlider(controlParent, this, LazyTreeSliderSeparatorSide.RIGHT);
            GridData gridLayoutData = new GridData(4, 4, false, false);
            this.verticalSlider.getSliderComposite().setLayoutData((Object)gridLayoutData);
        }
        this.scrolledComposite = new ScrolledComposite(controlParent, 272);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        this.scrolledComposite.setLayout((Layout)layout);
        GridData gdScrolledData = new GridData(4, 4, true, true);
        this.scrolledComposite.setLayoutData((Object)gdScrolledData);
        this.stackComposite = new Composite((Composite)this.scrolledComposite, 16);
        StackLayout stackCompositeLayout = new StackLayout();
        stackCompositeLayout.marginHeight = 0;
        stackCompositeLayout.marginWidth = 0;
        stackCompositeLayout.marginHeight = 0;
        stackCompositeLayout.marginWidth = 0;
        this.stackComposite.setLayout((Layout)stackCompositeLayout);
        this.tableAndTreeComposite = new Composite(this.stackComposite, 16);
        GridLayout tblLayout = new GridLayout();
        tblLayout.marginHeight = 0;
        tblLayout.marginWidth = 0;
        tblLayout.marginBottom = 0;
        tblLayout.marginLeft = 0;
        tblLayout.marginRight = 0;
        tblLayout.marginTop = 0;
        tblLayout.verticalSpacing = 0;
        this.tableAndTreeComposite.setLayout((Layout)tblLayout);
        this.topTable = null;
        if (this.lazyView instanceof IDVTLazyTable) {
            this.topTable = ((IDVTLazyTable)((Object)this.lazyView)).createTable(this.tableAndTreeComposite);
        }
        this.treeComposite = new Composite(this.tableAndTreeComposite, 16);
        GridLayout tcLayout = new GridLayout();
        tcLayout.marginHeight = 0;
        tcLayout.marginWidth = 0;
        tcLayout.marginBottom = 0;
        tcLayout.marginLeft = 0;
        tcLayout.marginRight = 0;
        tcLayout.marginTop = 0;
        this.treeComposite.setLayout((Layout)tcLayout);
        GridData gridData = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)gridData);
        stackCompositeLayout.topControl = this.tableAndTreeComposite;
        this.tree = this.lazyView instanceof IDVTMultipleSelectionLazyView ? new Tree(this.treeComposite, 18) : new Tree(this.treeComposite, 16);
        GridLayout tLayout = new GridLayout();
        tLayout.marginHeight = 0;
        tLayout.marginWidth = 0;
        tLayout.marginBottom = 0;
        tLayout.marginLeft = 0;
        tLayout.marginRight = 0;
        tLayout.marginTop = 0;
        this.tree.setLayout((Layout)tLayout);
        GridData treeGrd = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)treeGrd);
        if (this.lazyView instanceof IDVTLazyTable) {
            ((IDVTLazyTable)((Object)this.lazyView)).createAndSyncTreeColumns(this.topTable, this.tree, this.scrolledComposite);
        }
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setFont(parent.getFont());
        this.scrolledComposite.setContent((Control)this.stackComposite);
        if (this.sliderPosition == LazyViewSliderPosition.RIGHT) {
            this.verticalSlider = new VerticalLazyViewSlider(controlParent, this, LazyTreeSliderSeparatorSide.LEFT);
            GridData gridLayoutData = new GridData(4, 4, false, false);
            this.verticalSlider.getSliderComposite().setLayoutData((Object)gridLayoutData);
        }
        this.tree.addListener(37, new Listener(){

            public void handleEvent(Event mouseEvent) {
                mouseEvent.doit = false;
                LazyTree.this.doAction(LazyTreeAction.MOUSE_WHEEL, new LazyTreeSlideActionArguments(-mouseEvent.count, null));
            }
        });
        this.setSelectionUsingKeysListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                TreePath selectionFromTree = LazyTree.this.getSelectionFromTree();
                switch (e.keyCode) {
                    case 0x1000007: {
                        boolean setSelectionForFirstItem = true;
                        if ((e.stateMask & SWT.MODIFIER_MASK) == 262144) {
                            setSelectionForFirstItem = false;
                        }
                        LazyTree.this.doAction(LazyTreeAction.GO_TO_START_OF_TREE, new LazyTreeGoToStartEndOfTreeActionArguments(setSelectionForFirstItem, Objection.LAZY_TREE_SLIDER_DRAG));
                        break;
                    }
                    case 0x1000008: {
                        boolean setSelectionForLastItem = true;
                        if ((e.stateMask & SWT.MODIFIER_MASK) == 262144) {
                            setSelectionForLastItem = false;
                        }
                        LazyTree.this.doAction(LazyTreeAction.GO_TO_END_OF_TREE, new LazyTreeGoToStartEndOfTreeActionArguments(setSelectionForLastItem, Objection.LAZY_TREE_SLIDER_DRAG));
                        break;
                    }
                    case 0x1000001: {
                        TreePath firstVisible = this.getFirstVisibleElementInTree(LazyTree.this.tree);
                        if (firstVisible != null && selectionFromTree != null && !selectionFromTree.equals(firstVisible)) {
                            if (LazyTree.this.treeIterator instanceof MultipleSelectionTreeIterator) {
                                ArrayList<TreePath> selections = new ArrayList<TreePath>();
                                selections.add(DVTLazyViewUtils.getPrevSelectionFromTree(LazyTree.this.getTree()));
                                LazyTree.this.doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(selections, null));
                                return;
                            }
                            LazyTree.this.doAction(LazyTreeAction.SET_SELECTION, new LazyTreeSetSelectionActionArguments(DVTLazyViewUtils.getPrevSelectionFromTree(LazyTree.this.getTree()), null));
                            return;
                        }
                        e.doit = false;
                        LazyTree.this.doAction(LazyTreeAction.ARROW_UP, new LazyTreeActionArguments(Objection.LAZY_TREE_SLIDER_DRAG));
                        break;
                    }
                    case 0x1000002: {
                        TreePath lastTreeItem = LazyTree.this.treeIterator.getLast();
                        if (lastTreeItem != null && selectionFromTree != null && !selectionFromTree.equals(lastTreeItem)) {
                            if (LazyTree.this.treeIterator instanceof MultipleSelectionTreeIterator) {
                                ArrayList<TreePath> selections = new ArrayList<TreePath>();
                                selections.add(DVTLazyViewUtils.getNextSelectionFromTree(LazyTree.this.getTree()));
                                LazyTree.this.doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(selections, null));
                                return;
                            }
                            LazyTree.this.doAction(LazyTreeAction.SET_SELECTION, new LazyTreeSetSelectionActionArguments(DVTLazyViewUtils.getNextSelectionFromTree(LazyTree.this.getTree()), null));
                            return;
                        }
                        e.doit = false;
                        LazyTree.this.doAction(LazyTreeAction.ARROW_DOWN, new LazyTreeActionArguments(Objection.LAZY_TREE_SLIDER_DRAG));
                        break;
                    }
                    case 0x1000005: {
                        e.doit = false;
                        LazyTree.this.doAction(LazyTreeAction.PAGE_UP, new LazyTreeActionArguments(Objection.LAZY_TREE_SLIDER_DRAG));
                        break;
                    }
                    case 0x1000006: {
                        e.doit = false;
                        LazyTree.this.doAction(LazyTreeAction.PAGE_DOWN, new LazyTreeActionArguments(Objection.LAZY_TREE_SLIDER_DRAG));
                    }
                }
            }

            private TreePath getFirstVisibleElementInTree(Tree tree) {
                if (tree == null || tree.isDisposed()) {
                    return null;
                }
                TreeItem[] items = tree.getItems();
                if (items == null) {
                    return null;
                }
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item != null && !item.isDisposed() && item.getData() instanceof TreePath) {
                        if (!this.isInvisibleParent(item)) {
                            return (TreePath)item.getData();
                        }
                        TreePath element = this.getFirstVisibleTreePathInTreeInternal(item);
                        if (element != null) {
                            return element;
                        }
                    }
                    ++n2;
                }
                return null;
            }

            private TreePath getFirstVisibleTreePathInTreeInternal(TreeItem rootItem) {
                if (rootItem == null || rootItem.isDisposed()) {
                    return null;
                }
                TreeItem[] items = rootItem.getItems();
                if (items == null) {
                    return null;
                }
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item != null && !item.isDisposed() && item.getData() instanceof TreePath) {
                        if (!this.isInvisibleParent(item)) {
                            return (TreePath)item.getData();
                        }
                        TreePath visibleTreePathCandidate = this.getFirstVisibleTreePathInTreeInternal(item);
                        if (visibleTreePathCandidate != null) {
                            return visibleTreePathCandidate;
                        }
                    }
                    ++n2;
                }
                return null;
            }

            private boolean isInvisibleParent(TreeItem item) {
                if (item == null || item.isDisposed() || !(item.getData() instanceof TreePath)) {
                    return true;
                }
                String itemText = item.getText();
                if (itemText == null || itemText.isEmpty()) {
                    return true;
                }
                return itemText.startsWith("--- ");
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        this.tree.addKeyListener(this.setSelectionUsingKeysListener);
        this.tree.addListener(18, new Listener(){

            public void handleEvent(Event event) {
                TreePath treePath = (TreePath)((TreeItem)event.item).getData();
                LazyTree.this.doAction(LazyTreeAction.COLLAPSE, new LazyTreeExpandCollapseActionArguments(treePath, Objection.LAZY_TREE_COLLAPSE));
            }
        });
        this.tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreePath treePath = (TreePath)((TreeItem)event.item).getData();
                LazyTree.this.doAction(LazyTreeAction.EXPAND, new LazyTreeExpandCollapseActionArguments(treePath, Objection.LAZY_TREE_EXPAND));
            }
        });
        this.treeComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                LazyTree.this.doAction(LazyTreeAction.RESIZE, null);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
                if (LazyTree.this.treeIterator instanceof MultipleSelectionTreeIterator) {
                    return;
                }
                LazyTreeCmd setSelectionCommand = LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(LazyTree.this.getSelectionFromTree(), false));
                ((LazyTreeSetSelectionCmd)setSelectionCommand).setSelection(LazyTree.this.treeIterator);
            }
        });
        this.treeIterator = LazyTreeIteratorFactory.INSTANCE.getIterator(this.lazyView.getIteratorType(), this.lazyView);
        this.addAllListeners();
        this.treeProvider = new LazyTreeProvider(this.treeComposite, this.tree, this.treeIterator, this.scrolledComposite, this.labelProvider, this);
        this.treeIterator.resetHard(this.lazyView, ExpandCollapseState.EXPANDED, null, null, true, true, false, false, true, (IProgressMonitor)new NullProgressMonitor());
        this.lazyView.createToolBar();
    }

    public KeyListener getSetSelectionUsingKeysListener() {
        return this.setSelectionUsingKeysListener;
    }

    private TreePath getSelectionFromTree() {
        TreeItem[] treeSelection = this.tree.getSelection();
        if (treeSelection.length == 0) {
            return null;
        }
        return (TreePath)treeSelection[0].getData();
    }

    public void doAction(LazyTreeAction actionType, LazyTreeActionArguments actionArg) {
        TreePath first;
        if (this.treeIterator == null) {
            this.treeIterator = LazyTreeIteratorFactory.INSTANCE.getIterator(this.lazyView.getIteratorType(), this.lazyView);
            this.addAllListeners();
            this.treeProvider = new LazyTreeProvider(this.treeComposite, this.tree, this.treeIterator, this.scrolledComposite, this.labelProvider, this);
        }
        TreePath firstNode = (first = this.treeIterator.getFirst()) != null && first.getElement() != null ? first : null;
        LinkedBlockingQueue<LazyTreeCmd> actionListCommands = new LinkedBlockingQueue<LazyTreeCmd>();
        Objection objection = actionArg != null ? actionArg.getObjection() : null;
        switch (actionType) {
            case RESIZE: {
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.RESIZE, new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case MOUSE_WHEEL: 
            case SLIDER_DRAG: {
                if (!(actionArg instanceof LazyTreeSlideActionArguments)) {
                    return;
                }
                int count = ((LazyTreeSlideActionArguments)actionArg).getCount();
                actionListCommands.add(LazyTreeOperation.SLIDE.makeCommandWithLabel(LazyTreeStateLabel.SLIDE, new LazyTreeSlideCmdArgs(count)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case ARROW_UP: {
                actionListCommands.add(LazyTreeOperation.SLIDE.makeCommandWithLabel(LazyTreeStateLabel.SLIDE, new LazyTreeSlideCmdArgs(-1)));
                actionListCommands.add(LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(TreeSelectionMode.FIRST, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case ARROW_DOWN: {
                actionListCommands.add(LazyTreeOperation.SLIDE.makeCommandWithLabel(LazyTreeStateLabel.SLIDE, new LazyTreeSlideCmdArgs(1)));
                actionListCommands.add(LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(TreeSelectionMode.LAST, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case PAGE_UP: {
                actionListCommands.add(LazyTreeOperation.SLIDE.makeCommandWithLabel(LazyTreeStateLabel.SLIDE, new LazyTreeSlideCmdArgs(-(this.treeIterator.getTargetWindowSize() - 1))));
                actionListCommands.add(LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(TreeSelectionMode.FIRST, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case PAGE_DOWN: {
                actionListCommands.add(LazyTreeOperation.SLIDE.makeCommandWithLabel(LazyTreeStateLabel.SLIDE, new LazyTreeSlideCmdArgs(this.treeIterator.getTargetWindowSize() - 1)));
                actionListCommands.add(LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(TreeSelectionMode.LAST, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case SEARCH: {
                if (!(actionArg instanceof LazyTreeSearchActionArguments)) {
                    return;
                }
                boolean isRestoreTreePaths = ((LazyTreeSearchActionArguments)actionArg).isRestoreTreePaths();
                boolean isResetModel = ((LazyTreeSearchActionArguments)actionArg).isResetModel();
                IDVTModel model = ((LazyTreeSearchActionArguments)actionArg).getModel();
                if (isResetModel) {
                    actionListCommands.add(LazyTreeOperation.RESET_MODEL.makeCommand(new LazyTreeResetModelCmdArgs(model, isResetModel)));
                }
                TreePath selection = this.treeIterator != null ? this.treeIterator.getSelection() : null;
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, null, (TreePath)(this.searchText != null && this.searchText.isFiltered() ? null : selection), this.searchText, true, true, true, isRestoreTreePaths, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.SEARCH, new LazyTreeRecomputeCmdArgs(true, true)));
                if (this.searchText != null && !this.searchText.isFiltered() && selection != null) {
                    actionListCommands.add(LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(selection, false)));
                }
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case COLLAPSE_ALL: {
                TreePath firstTop = firstNode != null ? firstNode.getTopParent() : null;
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, ExpandCollapseState.COLLAPSED, firstTop == null ? TreePath.TOP_DUMMY_TREE_PATH : firstTop, this.searchText, true, false, true, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.COLLAPSE_ALL, new LazyTreeRecomputeCmdArgs(false, false)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case COLLAPSE: {
                if (!(actionArg instanceof LazyTreeExpandCollapseActionArguments)) {
                    return;
                }
                TreePath collapsedTreePath = ((LazyTreeExpandCollapseActionArguments)actionArg).getExpandedCollapsedTreePath();
                actionListCommands.add(LazyTreeOperation.RESET_SOFT.makeCommand(new LazyTreeResetSoftCmdArgs(this.searchText, false)));
                actionListCommands.add(LazyTreeOperation.SET_STATE.makeCommandWithLabel(LazyTreeStateLabel.COLLAPSE, new LazyTreeSetStateCmdArgs(collapsedTreePath, ExpandCollapseState.COLLAPSED)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case EXPAND_ALL: {
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, ExpandCollapseState.EXPANDED, this.getSelection(), this.searchText, true, false, true, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.EXPAND_ALL, new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case EXPAND: {
                if (!(actionArg instanceof LazyTreeExpandCollapseActionArguments)) {
                    return;
                }
                TreePath expandedTreePath = ((LazyTreeExpandCollapseActionArguments)actionArg).getExpandedCollapsedTreePath();
                actionListCommands.add(LazyTreeOperation.RESET_SOFT.makeCommand(new LazyTreeResetSoftCmdArgs(this.searchText, false)));
                actionListCommands.add(LazyTreeOperation.SET_STATE.makeCommandWithLabel(LazyTreeStateLabel.EXPAND, new LazyTreeSetStateCmdArgs(expandedTreePath, ExpandCollapseState.EXPANDED)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case PREPEND_LIBRARY: {
                actionListCommands.add(LazyTreeOperation.RESET_SOFT.makeCommand(new LazyTreeResetSoftCmdArgs(this.searchText, false)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.PREPEND_LIBRARY, new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case PREPEND_PACKAGE: {
                actionListCommands.add(LazyTreeOperation.RESET_SOFT.makeCommand(new LazyTreeResetSoftCmdArgs(this.searchText, false)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.PREPEND_PACKAGE, new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case HIDE_GENERATES: {
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, this.treeIterator.getState(), firstNode, this.searchText, false, false, true, true, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.HIDE_GENERATES, new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case SHOW_ONLY_FILES_WITH_ERRORS: {
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, ExpandCollapseState.EXPANDED, null, this.searchText, true, true, false, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.SHOW_ONLY_FILES_WITH_ERRORS, new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case SHOW_BUILD_CONFIG_ARG_FILES: {
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, ExpandCollapseState.EXPANDED, null, this.searchText, true, true, false, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.SHOW_BUILD_CONFIG_ARG_FILES, new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case GO_TO_START_OF_TREE: 
            case GO_TO_END_OF_TREE: {
                if (!(actionArg instanceof LazyTreeGoToStartEndOfTreeActionArguments)) {
                    return;
                }
                TreePath top = actionType == LazyTreeAction.GO_TO_START_OF_TREE ? TreePath.TOP_DUMMY_TREE_PATH : this.treeIterator.getEndTreePath(TreePath.TOP_DUMMY_TREE_PATH, (IProgressMonitor)new NullProgressMonitor());
                TreeSelectionMode selectionMode = actionType == LazyTreeAction.GO_TO_START_OF_TREE ? TreeSelectionMode.FIRST : TreeSelectionMode.LAST;
                boolean setSelection = ((LazyTreeGoToStartEndOfTreeActionArguments)actionArg).isSetSelection();
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, ExpandCollapseState.EXPANDED, top, this.searchText, true, true, true, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommand(new LazyTreeRecomputeCmdArgs(false, true)));
                if (setSelection) {
                    actionListCommands.add(LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(selectionMode, false)));
                }
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case SHOW_ALL_TOPS: {
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, ExpandCollapseState.EXPANDED, null, this.searchText, true, true, false, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommand(new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case RESET_FOR_TOP: {
                if (!(actionArg instanceof LazyTreeResetForTopActionArguments)) {
                    return;
                }
                TreePath topPath = ((LazyTreeResetForTopActionArguments)actionArg).getTopPath();
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, ExpandCollapseState.EXPANDED, topPath, this.searchText, true, true, false, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommand(new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case UPDATE_LABELS: {
                actionListCommands.add(LazyTreeOperation.RESET_SOFT.makeCommand(new LazyTreeResetSoftCmdArgs(this.searchText, false)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case UPDATE_VIEW: {
                if (!(actionArg instanceof LazyTreeUpdateViewActionArguments)) {
                    return;
                }
                ExpandCollapseState collapesedState = ((LazyTreeUpdateViewActionArguments)actionArg).getCollapesedState();
                CustomExpandStateInfo customExpandCollapsedState = ((LazyTreeUpdateViewActionArguments)actionArg).getCustomExpandStateInfo();
                boolean resetSelection = ((LazyTreeUpdateViewActionArguments)actionArg).isResetSelection();
                boolean resetTop = ((LazyTreeUpdateViewActionArguments)actionArg).isResetTop();
                if (resetSelection || resetTop) {
                    this.treeIterator = LazyTreeIteratorFactory.INSTANCE.getIterator(this.lazyView.getIteratorType(), this.lazyView);
                    this.addAllListeners();
                    this.treeProvider.cancelOperation();
                    this.treeProvider = new LazyTreeProvider(this.treeComposite, this.tree, this.treeIterator, this.scrolledComposite, this.labelProvider, this);
                }
                boolean isResetModelUpdate = ((LazyTreeUpdateViewActionArguments)actionArg).isResetModel();
                IDVTModel modelUpdate = ((LazyTreeUpdateViewActionArguments)actionArg).getModel();
                if (isResetModelUpdate) {
                    actionListCommands.add(LazyTreeOperation.RESET_MODEL.makeCommand(new LazyTreeResetModelCmdArgs(modelUpdate, isResetModelUpdate)));
                }
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, collapesedState, resetTop ? null : firstNode, this.searchText, false, false, !resetSelection, true, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                if (customExpandCollapsedState != null) {
                    actionListCommands.add(LazyTreeOperation.SET_CUSTOM_EXPAND.makeCommand(new LazyTreeSetCustomExpandStateCmdArgs(customExpandCollapsedState)));
                } else {
                    actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.UPDATE, new LazyTreeRecomputeCmdArgs(false, true)));
                }
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                List<IDVTLazyViewListener> updateListeners = ((LazyTreeUpdateViewActionArguments)actionArg).getUpdateListeners();
                if (updateListeners == null || updateListeners.isEmpty()) break;
                actionListCommands.add(LazyTreeOperation.NOTIFY_LISTENERS.makeCommand(new LazyTreeNotifyListenersCmdArgs(updateListeners)));
                break;
            }
            case CLEAN: {
                if (this.treeIterator != null) {
                    this.treeIterator.clearStateListeners();
                    this.treeIterator = null;
                }
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, null, null, null, true, true, false, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommand(new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case CLEAN_SOFT: {
                if (this.treeIterator != null) {
                    this.treeIterator.clearStateListeners();
                    this.treeIterator = null;
                }
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, null, null, null, false, false, true, true, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommand(new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case CLEAR_CACHE: {
                if (this.treeIterator != null) {
                    this.treeIterator.clearStateListeners();
                    this.treeIterator = null;
                }
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, null, null, null, true, true, false, false, true)));
                break;
            }
            case SET_SELECTION: {
                if (!(actionArg instanceof LazyTreeSetSelectionActionArguments)) {
                    return;
                }
                TreePath selectedPath = ((LazyTreeSetSelectionActionArguments)actionArg).getSelectedTreePath();
                actionListCommands.add(LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(selectedPath, false)));
                break;
            }
            case SET_MULTIPLE_SELECTION: {
                if (!(actionArg instanceof LazyTreeSetMultipleSelectionActionArguments)) {
                    return;
                }
                List<TreePath> selectedPaths = ((LazyTreeSetMultipleSelectionActionArguments)actionArg).getSelectedTreePaths();
                actionListCommands.add(LazyTreeOperation.SET_MULTIPLE_SELECTION.makeCommand(new LazyTreeSetMultipleSelectionCmdArgs(selectedPaths)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case QUICK_SEARCH_GO_TO_ELEMENT: {
                if (!(actionArg instanceof LazyTreeQuickSearchGoToElementActionArguments)) {
                    return;
                }
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, null, null, this.searchText, true, true, false, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.SEARCH, new LazyTreeRecomputeCmdArgs(true, true, true)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
            case REVEAL_IN_VIEW: {
                if (!(actionArg instanceof LazyTreeRevealInViewActionArguments)) {
                    return;
                }
                TreePath selectedTreePath = ((LazyTreeRevealInViewActionArguments)actionArg).getSelectedTreePath();
                TreePath firstTreePath = ((LazyTreeRevealInViewActionArguments)actionArg).getFirstTreePath();
                boolean resetExpandState = ((LazyTreeRevealInViewActionArguments)actionArg).isResetExpandState();
                boolean fireSelection = ((LazyTreeRevealInViewActionArguments)actionArg).isFireSelection();
                actionListCommands.add(LazyTreeOperation.RESET_HARD.makeCommand(new LazyTreeResetHardCmdArgs(this.lazyView, null, firstTreePath, this.searchText, resetExpandState, true, false, false, true)));
                actionListCommands.add(LazyTreeOperation.COMPUTE_TREE_SIZE.makeCommand(new LazyTreeCmdArgs()));
                actionListCommands.add(LazyTreeOperation.RECOMPUTE.makeCommandWithLabel(LazyTreeStateLabel.SEARCH, new LazyTreeRecomputeCmdArgs(false, true)));
                actionListCommands.add(LazyTreeOperation.SET_SELECTION.makeCommand(new LazyTreeSetSelectionCmdArgs(selectedTreePath, fireSelection)));
                actionListCommands.add(LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(objection)));
                break;
            }
        }
        this.treeProvider.doLazyTreeAction(actionType, actionListCommands);
    }

    private void addAllListeners() {
        this.treeIterator.addStateListener(new ITreeIteratorStateListener(){

            @Override
            public void stateChanged(TreeIteratorEvent event) {
                TreeIteratorEventType eventType = event.getEventType();
                if (eventType == TreeIteratorEventType.WINDOW_ADD_LAST || eventType == TreeIteratorEventType.WINDOW_ADD_FIRST || eventType == TreeIteratorEventType.WINDOW_REMOVE_STATE_NODE) {
                    LazyTreeRedrawCmd redraw = (LazyTreeRedrawCmd)LazyTreeOperation.REDRAW.makeCommand(new LazyTreeRedrawCmdArgs(null));
                    redraw.redraw(LazyTree.this.treeIterator, LazyTree.this.tree, LazyTree.this.treeComposite, LazyTree.this.scrolledComposite, LazyTree.this.labelProvider, (IProgressMonitor)new NullProgressMonitor(), null);
                } else if (eventType == TreeIteratorEventType.END_OF_TREE) {
                    Display.getDefault().asyncExec(() -> LazyTree.this.verticalSlider.setEnableArrowButtons(true, false));
                } else if (eventType == TreeIteratorEventType.START_OF_TREE) {
                    Display.getDefault().asyncExec(() -> LazyTree.this.verticalSlider.setEnableArrowButtons(false, false));
                } else if (eventType == TreeIteratorEventType.ENABLE_SLIDER_ARROWS) {
                    Display.getDefault().asyncExec(() -> {
                        LazyTree.this.verticalSlider.setEnableArrowButtons(true, true);
                        LazyTree.this.verticalSlider.setEnableArrowButtons(false, true);
                    });
                }
            }
        });
        this.lazyView.addViewSpecificListeners(this.treeIterator);
    }

    public void setSearchBar(TextFilterObject filterText) {
        this.searchText = filterText;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.tree.addSelectionListener(listener);
    }

    public Tree getTree() {
        return this.tree;
    }

    public Table getTopTable() {
        return this.topTable;
    }

    public ScrolledComposite getScrolledComposite() {
        return this.scrolledComposite;
    }

    public TreePath getFirstVisibleElement() {
        if (this.treeIterator == null) {
            return null;
        }
        return this.treeIterator.getFirst(true);
    }

    public TreePath getRoot() {
        if (this.treeIterator == null) {
            return null;
        }
        TreePath first = this.treeIterator.getFirst(true);
        if (first == null) {
            return null;
        }
        List<TreePath> parents = TreePath.parentsList(first, false);
        if (parents == null || parents.isEmpty()) {
            return first;
        }
        return parents.get(parents.size() - 1);
    }

    public List<TreePath> getViewContent() {
        ArrayList<TreePath> viewContent = new ArrayList<TreePath>();
        if (this.treeIterator == null || this.treeIterator.getWindow() == null) {
            return null;
        }
        viewContent.addAll(this.treeIterator.getWindow());
        return viewContent;
    }

    public int testGetElementCount() {
        IDVTModel model = this.treeIterator.getModel(IModel.class);
        if (model instanceof CompileOrderModel) {
            return ((CompileOrderModel)model).getElementCount();
        }
        return 0;
    }

    public void testSetSelection(TreePath selection) {
        this.treeIterator.setSelection(selection);
    }

    public void cancelOperations() {
        this.treeProvider.cancelOperation();
    }

    public void setCancelActionEnabled(boolean isEnabled) {
        this.lazyView.setCancelActionEnabled(isEnabled);
    }

    public int getMatchCacheSize() {
        if (this.treeIterator instanceof TreeIterator) {
            return ((TreeIterator)this.treeIterator).getMatchCacheSize();
        }
        return 0;
    }

    public int getLazyTreeCacheSize() {
        if (this.treeIterator instanceof TreeIterator) {
            return ((TreeIterator)this.treeIterator).getLazyTreeCacheSize();
        }
        return 0;
    }

    public Composite getStackComposite() {
        return this.stackComposite;
    }

    public Composite getTableAndTreeComposite() {
        return this.tableAndTreeComposite;
    }

    public TextFilterObject testGetTextFilter() {
        return this.searchText;
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    public void setControlParent(Composite controlParent) {
        this.controlParent = controlParent;
    }

    public void addStateListener(ITreeIteratorStateListener listener) {
        this.treeIterator.addStateListener(listener);
    }

    public boolean isMatched(TreePath treePath) {
        return this.treeIterator.isCachedTreePath(treePath);
    }

    public AbstractTreeIterator getTreeIterator() {
        return this.treeIterator;
    }

    public static enum ScrollSpeed {
        NOP(0, 0),
        SLOW_POSITIVE(100, 1),
        MED_POSTIVE(50, 1),
        FAST_POSITIVE(20, 2),
        SLOW_NEGATIVE(100, -1),
        MED_NEGATIVE(50, -1),
        FAST_NEGATIVE(50, -2);

        int delay = 50;
        int count = 0;

        private ScrollSpeed(int delay, int count) {
            this.delay = delay;
            this.count = count;
        }

        public static ScrollSpeed compute(int sliderThumb, int sliderMiddleValue) {
            if (sliderMiddleValue == sliderThumb) {
                return NOP;
            }
            float thumbRatio = (float)(sliderThumb - sliderMiddleValue) / (float)sliderMiddleValue * 3.0f;
            int ratio = thumbRatio > 0.0f ? 1 + (int)thumbRatio : -1 + (int)thumbRatio;
            switch (ratio) {
                case 1: {
                    return SLOW_POSITIVE;
                }
                case -1: {
                    return SLOW_NEGATIVE;
                }
                case 2: {
                    return MED_POSTIVE;
                }
                case -2: {
                    return MED_NEGATIVE;
                }
                case 3: {
                    return FAST_POSITIVE;
                }
                case -3: {
                    return FAST_NEGATIVE;
                }
            }
            return NOP;
        }
    }
}

