/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.LinkedHashMap;
import java.util.Map;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.TreePathChildProvider;

public class LazyTreeCache {
    private Map<TreePath, TreePathChildProvider> childrenCache = new LinkedHashMap<TreePath, TreePathChildProvider>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<TreePath, TreePathChildProvider> eldest) {
            return this.size() > 150000;
        }
    };

    public void put(TreePath path, TreePathChildProvider children) {
        if (path == null || "...".equals(path.getLastSegment())) {
            return;
        }
        this.childrenCache.put(path, children);
    }

    public TreePathChildProvider get(TreePath path, IModel model) {
        TreePathChildProvider children = this.childrenCache.get(path);
        if (children == null) {
            children = new TreePathChildProvider(path, model);
            this.put(path, children);
        }
        return children;
    }

    public void clear() {
        this.childrenCache.clear();
    }

    public static LazyTreeCache newInstance() {
        return new LazyTreeCache();
    }

    public int getLazyTreeCacheSize() {
        return this.childrenCache.size();
    }
}

