/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.Comparator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewModel;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.ELTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.MultipleSelectionTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.BCCompileOrderModelCommon;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderModel;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderView;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryComparator;

public enum LazyTreeIteratorFactory {
    INSTANCE;


    public AbstractTreeIterator getIterator(LazyTreeIteratorType iteratorType, IDVTLazyView lazyView) {
        switch (iteratorType) {
            case LAZY_DESIGN_HIERARCHY: {
                if (lazyView == null) {
                    return null;
                }
                return new ELTreeIterator(lazyView);
            }
            case LAZY_COMPILE_ORDER: 
            case QUICK_COMPILE_ORDER: {
                return new TreeIterator(lazyView, (t1, t2) -> {
                    boolean isBuildConfigMode = lazyView instanceof CompileOrderView && ((CompileOrderView)lazyView).getShowBuildConfigArgFiles();
                    return !isBuildConfigMode ? CompileOrderModel.TreePathComparator.compare(t1, t2) : BCCompileOrderModelCommon.TreePathComparator.compare((TreePath)t1, (TreePath)t2);
                });
            }
            case LAZY_TYPES: {
                return new TreeIterator(lazyView, new Comparator<TreePath>(){

                    @Override
                    public int compare(TreePath o1, TreePath o2) {
                        if (o1 == null || o2 == null) {
                            return 0;
                        }
                        if (TreePath.isParent(o1, o2)) {
                            return -1;
                        }
                        if (TreePath.isParent(o2, o1)) {
                            return 1;
                        }
                        Object wr1 = o1.getElement();
                        Object wr2 = o2.getElement();
                        if (!(wr1 instanceof IDVTElementWrapper) || !(wr2 instanceof IDVTElementWrapper)) {
                            return -1;
                        }
                        Object index1 = ((IDVTElementWrapper)wr1).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TYPES_INDEX);
                        Object index2 = ((IDVTElementWrapper)wr2).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TYPES_INDEX);
                        if (index1 instanceof Integer && index2 instanceof Integer) {
                            return (Integer)index1 - (Integer)index2;
                        }
                        return -1;
                    }
                });
            }
            case LAZY_MACROS: {
                return new TreeIterator(lazyView, new Comparator<TreePath>(){

                    @Override
                    public int compare(TreePath o1, TreePath o2) {
                        if (o1 == null || o2 == null || o1.equals(o2)) {
                            return 0;
                        }
                        if (TreePath.isParent(o1, o2)) {
                            return -1;
                        }
                        if (TreePath.isParent(o2, o1)) {
                            return 1;
                        }
                        int[] inds1 = o1.getIndices();
                        int[] inds2 = o2.getIndices();
                        int i = 0;
                        while (i < Math.min(inds1.length, inds2.length)) {
                            if (inds1[i] != inds2[i]) {
                                return inds1[i] - inds2[i];
                            }
                            ++i;
                        }
                        Object wr1 = o1.getElement();
                        Object wr2 = o2.getElement();
                        if (wr1 instanceof DVTLanguageElement && wr2 instanceof DVTLanguageElement) {
                            return ((DVTLanguageElement)wr1).getKind().compareTo(((DVTLanguageElement)wr2).getKind());
                        }
                        if (wr1 instanceof IRfNamedElement && wr2 instanceof IRfNamedElement) {
                            String name1 = ((IRfNamedElement)wr1).getName();
                            String name2 = ((IRfNamedElement)wr2).getName();
                            if (o1.getParent().equals(o2.getParent()) && name1.equals(name2)) {
                                return o1.getIndexInParent() - o2.getIndexInParent();
                            }
                            return name1.compareTo(name2);
                        }
                        return -1;
                    }
                });
            }
            case LAZY_OUTLINE: {
                return new TreeIterator(lazyView, ((DVTLazyOutlinePage)lazyView).getComparator());
            }
            case QUICK_LAZY_OUTLINE: {
                return new TreeIterator(lazyView, ((QuickLazyOutlineView)lazyView).getComparator());
            }
            case QUICK_QUERY_VIEW: {
                return new TreeIterator(lazyView, QuickQueryComparator.INSTANCE);
            }
            case LAZY_WAVE_VIEW_SIGNAL_TABLE: 
            case LAZY_WAVE_VIEW_SELECTED_SIGNALS_PANEL: {
                return new MultipleSelectionTreeIterator(lazyView);
            }
            case LAZY_CONFIG_DB: {
                return new TreeIterator(lazyView, ConfigDBViewModel.treePathComparator);
            }
        }
        return new TreeIterator(lazyView);
    }
}

