/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEvent;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEventType;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeComputeTreeSizeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeNotifyListenersCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRecomputeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRedrawCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetHardCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetModelCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetSoftCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetCustomExpandStateCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetMultipleSelectionCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetSelectionCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetStateCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSlideCmd;

public class LazyTreeProvider {
    private static final String LAZY_TREE_OPERATION = "View Operation";
    private Composite treeComposite;
    private ScrolledComposite scrolledComposite;
    private AbstractTreeIterator treeIterator;
    private Tree tree;
    private ILabelProvider labelProvider;
    private LazyTreeJob operationJob = new LazyTreeJob("View Operation");
    private LazyTree lazyTree;

    public LazyTreeProvider(Composite treeComposite, Tree tree, AbstractTreeIterator treeIterator, ScrolledComposite scrolledComposite, ILabelProvider labelProvider, LazyTree lazyTree) {
        this.treeComposite = treeComposite;
        this.tree = tree;
        this.scrolledComposite = scrolledComposite;
        this.treeIterator = treeIterator;
        this.labelProvider = labelProvider;
        this.lazyTree = lazyTree;
    }

    public void doLazyTreeAction(LazyTreeAction newActionType, Queue<LazyTreeCmd> actionListCommands) {
        LazyTreeActionInfo lazyTreeActionInfo = new LazyTreeActionInfo(newActionType, actionListCommands);
        if (this.operationJob.getState() == 0) {
            this.operationJob.addLazyTreeActionInfo(lazyTreeActionInfo);
            this.operationJob.schedule();
        } else {
            LazyTreeAction currentLazyTreeAction = this.operationJob.getRunningAction();
            if (currentLazyTreeAction == null) {
                return;
            }
            if (newActionType.getActionsToCancel() != null && newActionType.getActionsToCancel().contains((Object)currentLazyTreeAction)) {
                this.cancelOperation();
                this.operationJob.addLazyTreeActionInfo(lazyTreeActionInfo);
                this.operationJob.schedule();
                return;
            }
            if (currentLazyTreeAction == LazyTreeAction.SEARCH && newActionType == LazyTreeAction.SEARCH) {
                this.treeIterator.notifyStateListeners(new TreeIteratorEvent(TreeIteratorEventType.SEARCH_CHANGED));
                this.cancelOperation();
                this.operationJob.addLazyTreeActionInfo(lazyTreeActionInfo);
                this.operationJob.schedule();
            }
        }
    }

    private void doOperationInternal(LazyTreeCmd currOperation, IProgressMonitor monitor) {
        if (currOperation instanceof LazyTreeSlideCmd) {
            ((LazyTreeSlideCmd)currOperation).slide(this.treeIterator, monitor);
        }
        if (currOperation instanceof LazyTreeResetHardCmd) {
            ((LazyTreeResetHardCmd)currOperation).reset(this.treeIterator, monitor);
        }
        if (currOperation instanceof LazyTreeRedrawCmd) {
            ((LazyTreeRedrawCmd)currOperation).redraw(this.treeIterator, this.tree, this.treeComposite, this.scrolledComposite, this.labelProvider, monitor);
        }
        if (currOperation instanceof LazyTreeRecomputeCmd) {
            ((LazyTreeRecomputeCmd)currOperation).recompute(this.treeIterator, monitor);
        }
        if (currOperation instanceof LazyTreeSetStateCmd) {
            ((LazyTreeSetStateCmd)currOperation).setState(this.treeIterator, monitor);
        }
        if (currOperation instanceof LazyTreeResetSoftCmd) {
            ((LazyTreeResetSoftCmd)currOperation).reset(this.treeIterator);
        }
        if (currOperation instanceof LazyTreeSetSelectionCmd) {
            ((LazyTreeSetSelectionCmd)currOperation).setSelection(this.treeIterator);
        }
        if (currOperation instanceof LazyTreeSetMultipleSelectionCmd) {
            ((LazyTreeSetMultipleSelectionCmd)currOperation).setSelections(this.treeIterator);
        }
        if (currOperation instanceof LazyTreeComputeTreeSizeCmd) {
            ((LazyTreeComputeTreeSizeCmd)currOperation).setTreeSize(this.lazyTree, this.treeIterator, monitor);
        }
        if (currOperation instanceof LazyTreeResetModelCmd) {
            ((LazyTreeResetModelCmd)currOperation).resetModel(this.treeIterator, monitor);
        }
        if (currOperation instanceof LazyTreeSetCustomExpandStateCmd) {
            ((LazyTreeSetCustomExpandStateCmd)currOperation).setCustomExpandAruguments(this.treeIterator, monitor);
        }
        if (currOperation instanceof LazyTreeNotifyListenersCmd) {
            ((LazyTreeNotifyListenersCmd)currOperation).notifyListeners();
        }
    }

    public void cancelOperation() {
        this.operationJob.clearJobActionBuffer();
        this.operationJob.cancel();
    }

    static class LazyTreeActionInfo {
        private LazyTreeAction lazyTreeAction;
        private Queue<LazyTreeCmd> lazyTreeActionCommands;

        public LazyTreeActionInfo(LazyTreeAction lazyTreeAction, Queue<LazyTreeCmd> lazyTreeActionCommands) {
            this.lazyTreeAction = lazyTreeAction;
            this.lazyTreeActionCommands = lazyTreeActionCommands;
        }

        public LazyTreeAction getLazyTreeAction() {
            return this.lazyTreeAction;
        }

        public Queue<LazyTreeCmd> getLazyTreeActionCommands() {
            return this.lazyTreeActionCommands;
        }

        public boolean hasRecomputeCommand() {
            for (LazyTreeCmd command : this.lazyTreeActionCommands) {
                if (!(command instanceof LazyTreeRecomputeCmd)) continue;
                return true;
            }
            return false;
        }
    }

    class LazyTreeJob
    extends Job {
        private Queue<LazyTreeActionInfo> lazyTreeActionBuffer;
        private LazyTreeActionInfo currentActionInfo;

        public LazyTreeJob(String name) {
            super(name);
            this.lazyTreeActionBuffer = new LinkedBlockingQueue<LazyTreeActionInfo>(1);
        }

        public void clearJobActionBuffer() {
            this.lazyTreeActionBuffer.clear();
        }

        public void addLazyTreeActionInfo(LazyTreeActionInfo actionInfo) {
            this.lazyTreeActionBuffer.add(actionInfo);
        }

        public LazyTreeActionInfo getCurrentAction() {
            return this.lazyTreeActionBuffer.peek();
        }

        public int getBufferSize() {
            return this.lazyTreeActionBuffer.size();
        }

        public LazyTreeAction getRunningAction() {
            if (this.currentActionInfo == null) {
                return null;
            }
            return this.currentActionInfo.getLazyTreeAction();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                LazyTreeProvider.this.lazyTree.setCancelActionEnabled(true);
                this.currentActionInfo = this.lazyTreeActionBuffer.poll();
                if (this.currentActionInfo == null) {
                    LazyTreeProvider.this.lazyTree.setCancelActionEnabled(false);
                    this.setName(LazyTreeProvider.LAZY_TREE_OPERATION);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                Queue<LazyTreeCmd> commandList = this.currentActionInfo.getLazyTreeActionCommands();
                if (commandList == null) {
                    LazyTreeProvider.this.lazyTree.setCancelActionEnabled(false);
                    this.setName(LazyTreeProvider.LAZY_TREE_OPERATION);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                while (true) {
                    if (commandList.isEmpty()) {
                        LazyTreeProvider.this.lazyTree.setCancelActionEnabled(false);
                        this.setName(LazyTreeProvider.LAZY_TREE_OPERATION);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    LazyTreeCmd currentCommand = commandList.poll();
                    if (monitor.isCanceled()) {
                        this.setName(LazyTreeProvider.LAZY_TREE_OPERATION);
                        LazyTreeProvider.this.lazyTree.setCancelActionEnabled(false);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    this.setName(String.valueOf(this.getName()) + (currentCommand.getLabel() != null ? " - " + currentCommand.getLabel() : ""));
                    LazyTreeProvider.this.doOperationInternal(currentCommand, monitor);
                    this.setName(LazyTreeProvider.LAZY_TREE_OPERATION);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.clearJobActionBuffer();
                LazyTreeProvider.this.lazyTree.setCancelActionEnabled(false);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                this.currentActionInfo = null;
            }
        }
    }
}

