/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.draw.utils.GCFactory;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeSliderSeparatorSide;

public abstract class LazyViewSlider {
    protected Composite sliderComposite;
    protected static final String HOVER = "hover";
    protected static final String CLICKED = "clicked";
    protected static final int SEPARATOR_WIDTH = 1;
    protected static final int SPACER_MIN_WH = 1;
    protected static final int MIN_BUTTON_WH = 10;
    protected static final int OUTER_PADDING = 4;
    protected static final int INNER_PADDING = 3;
    protected static final int ARC_RADIUS = 10;
    protected static final float BLEND_HOVER = 0.8f;
    protected static final float BLEND_CLICK = 0.7f;
    protected Color COLOR_BUTTON_TEXT = DVTColorUtil.INSTANCE.getSystemColor(24);
    protected Color COLOR_TREE_BG = DVTColorUtil.INSTANCE.getSystemColor(25);
    protected Color COLOR_BUTTON_HOVER_BG;
    protected Color COLOR_BUTTON_HOVER_FG = this.COLOR_BUTTON_HOVER_BG = DVTColorUtil.INSTANCE.blend(this.COLOR_BUTTON_TEXT, this.COLOR_TREE_BG, 0.8f);
    protected Color COLOR_BUTTON_CLICK;
    protected Color COLOR_SEPARATOR = this.COLOR_BUTTON_CLICK = DVTColorUtil.INSTANCE.blend(this.COLOR_BUTTON_TEXT, this.COLOR_TREE_BG, 0.7f);
    protected Canvas goToStartButton;
    protected Canvas prevPageButton;
    protected Canvas prevStepButton;
    protected Canvas nextStepButton;
    protected Canvas nextPageButton;
    protected Canvas goToEndButton;
    protected LazyTreeSliderSeparatorSide separatorSide;
    protected static final int NOF_SPACERS = 3;
    protected static final int NOF_ARROWS = 6;

    protected LazyViewSlider(Composite parent, LazyTreeSliderSeparatorSide separatorSide) {
        this.sliderComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(0, 0, 0, 0).margins(0, 0).spacing(0, 0).applyTo(this.sliderComposite);
        DVTColorUtil.INSTANCE.setBackground((Control)this.sliderComposite, this.COLOR_TREE_BG);
        this.separatorSide = separatorSide;
    }

    protected void makeSpacers(Composite composite) {
        int i = 0;
        while (i < 3) {
            Composite spacer = new Composite(composite, 0);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(1, 1).applyTo((Control)spacer);
            DVTColorUtil.INSTANCE.setBackground((Control)spacer, this.COLOR_TREE_BG);
            ++i;
        }
    }

    public void setEnableArrowButtons(boolean isNextArrows, boolean isEnable) {
        if (isNextArrows) {
            this.nextStepButton.setEnabled(isEnable);
            this.nextPageButton.setEnabled(isEnable);
            this.goToEndButton.setEnabled(isEnable);
            this.sliderComposite.redraw();
            return;
        }
        this.goToStartButton.setEnabled(isEnable);
        this.prevPageButton.setEnabled(isEnable);
        this.prevStepButton.setEnabled(isEnable);
        this.sliderComposite.redraw();
    }

    protected abstract Canvas makeCanvas(Composite var1, Arrow var2);

    public Composite getSliderComposite() {
        return this.sliderComposite;
    }

    public static final class Arrow
    extends Enum<Arrow> {
        public static final /* enum */ Arrow TOP;
        public static final /* enum */ Arrow PAGE_UP;
        public static final /* enum */ Arrow UP;
        public static final /* enum */ Arrow DOWN;
        public static final /* enum */ Arrow PAGE_DOWN;
        public static final /* enum */ Arrow BOTTOM;
        public static final /* enum */ Arrow START;
        public static final /* enum */ Arrow PAGE_LEFT;
        public static final /* enum */ Arrow LEFT;
        public static final /* enum */ Arrow RIGHT;
        public static final /* enum */ Arrow PAGE_RIGHT;
        public static final /* enum */ Arrow END;
        private int[] coords;
        private String tooltip;
        private static final /* synthetic */ Arrow[] ENUM$VALUES;

        static {
            int[] nArray = new int[24];
            nArray[1] = -5;
            nArray[2] = 5;
            nArray[6] = 5;
            nArray[7] = 5;
            nArray[8] = -5;
            nArray[9] = 5;
            nArray[12] = -5;
            nArray[15] = -5;
            nArray[16] = -5;
            nArray[17] = -5;
            nArray[18] = -5;
            nArray[19] = -7;
            nArray[20] = 5;
            nArray[21] = -7;
            nArray[22] = 5;
            nArray[23] = -5;
            TOP = new Arrow("Top", nArray);
            int[] nArray2 = new int[14];
            nArray2[1] = -5;
            nArray2[2] = 5;
            nArray2[6] = 5;
            nArray2[7] = 5;
            nArray2[8] = -5;
            nArray2[9] = 5;
            nArray2[12] = -5;
            PAGE_UP = new Arrow("Page Up", nArray2);
            int[] nArray3 = new int[6];
            nArray3[1] = -3;
            nArray3[2] = 5;
            nArray3[3] = 3;
            nArray3[4] = -5;
            nArray3[5] = 3;
            UP = new Arrow("Up", nArray3);
            DOWN = new Arrow("Down", Arrow.mirrorY(UP.getCoords()));
            PAGE_DOWN = new Arrow("Page Down", Arrow.mirrorY(PAGE_UP.getCoords()));
            BOTTOM = new Arrow("Bottom", Arrow.mirrorY(TOP.getCoords()));
            int[] nArray4 = new int[24];
            nArray4[0] = -5;
            nArray4[3] = 5;
            nArray4[6] = 5;
            nArray4[7] = 5;
            nArray4[8] = 5;
            nArray4[9] = -5;
            nArray4[13] = -5;
            nArray4[14] = -5;
            nArray4[16] = -5;
            nArray4[17] = -5;
            nArray4[18] = -7;
            nArray4[19] = -5;
            nArray4[20] = -7;
            nArray4[21] = 5;
            nArray4[22] = -5;
            nArray4[23] = 5;
            START = new Arrow("Start", nArray4);
            int[] nArray5 = new int[14];
            nArray5[0] = -5;
            nArray5[3] = 5;
            nArray5[6] = 5;
            nArray5[7] = 5;
            nArray5[8] = 5;
            nArray5[9] = -5;
            nArray5[13] = -5;
            PAGE_LEFT = new Arrow("Page Left", nArray5);
            int[] nArray6 = new int[6];
            nArray6[0] = -3;
            nArray6[2] = 3;
            nArray6[3] = 5;
            nArray6[4] = 3;
            nArray6[5] = -5;
            LEFT = new Arrow("Left", nArray6);
            RIGHT = new Arrow("Right", Arrow.mirrorX(LEFT.getCoords()));
            PAGE_RIGHT = new Arrow("Page Right", Arrow.mirrorX(PAGE_LEFT.getCoords()));
            END = new Arrow("End", Arrow.mirrorX(START.getCoords()));
            ENUM$VALUES = new Arrow[]{TOP, PAGE_UP, UP, DOWN, PAGE_DOWN, BOTTOM, START, PAGE_LEFT, LEFT, RIGHT, PAGE_RIGHT, END};
        }

        private Arrow(String tooltip, int[] coords) {
            this.tooltip = tooltip;
            this.coords = coords;
        }

        private int[] getCoords() {
            return this.coords;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public static int[] mirrorY(int[] coords) {
            int[] result = (int[])coords.clone();
            int i = 1;
            while (i < result.length) {
                result[i] = -result[i];
                i += 2;
            }
            return result;
        }

        public static int[] mirrorX(int[] coords) {
            int[] result = (int[])coords.clone();
            int i = 0;
            while (i < result.length) {
                result[i] = -result[i];
                i += 2;
            }
            return result;
        }

        public static Arrow[] values() {
            Arrow[] arrowArray = ENUM$VALUES;
            int n = arrowArray.length;
            Arrow[] arrowArray2 = new Arrow[n];
            System.arraycopy(ENUM$VALUES, 0, arrowArray2, 0, n);
            return arrowArray2;
        }

        public static Arrow valueOf(String string) {
            return Enum.valueOf(Arrow.class, string);
        }
    }

    public class CanvasPaintListener
    implements PaintListener {
        Arrow arrow;

        public CanvasPaintListener(Arrow arrow) {
            this.arrow = arrow;
        }

        public void paintControl(PaintEvent e) {
            try {
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                Canvas canvas = (Canvas)e.widget;
                Rectangle clientArea = canvas.getClientArea();
                GCFactory.INSTANCE.setMaxQuality(e.gc);
                Color bgColor = null;
                if (canvas.getData(LazyViewSlider.CLICKED) != null) {
                    bgColor = LazyViewSlider.this.COLOR_BUTTON_CLICK;
                    e.gc.setForeground(LazyViewSlider.this.COLOR_BUTTON_HOVER_FG);
                } else if (canvas.getData(LazyViewSlider.HOVER) != null) {
                    bgColor = LazyViewSlider.this.COLOR_BUTTON_HOVER_BG;
                    e.gc.setForeground(LazyViewSlider.this.COLOR_BUTTON_HOVER_FG);
                }
                if (bgColor != null) {
                    e.gc.setBackground(bgColor);
                    e.gc.fillRoundRectangle(4, 4, clientArea.width - 8, clientArea.height - 8, 10, 10);
                    e.gc.drawRoundRectangle(4, 4, clientArea.width - 8, clientArea.height - 8, 10, 10);
                }
                Transform tr = new Transform((Device)Display.getDefault());
                tr.translate((float)clientArea.width / 2.0f, (float)clientArea.height / 2.0f);
                e.gc.setTransform(tr);
                Color arrowsCollor = canvas.isEnabled() ? LazyViewSlider.this.COLOR_BUTTON_TEXT : LazyViewSlider.this.COLOR_BUTTON_CLICK;
                e.gc.setBackground(arrowsCollor);
                tr.dispose();
                e.gc.fillPolygon(this.arrow.getCoords());
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        }
    }
}

