/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class MatchCache {
    private TreeMap<TreePath, TreePath> matchCache;

    public MatchCache() {
        this.matchCache = new TreeMap();
    }

    public MatchCache(Comparator<TreePath> comparator) {
        this.matchCache = new TreeMap(comparator);
    }

    public MatchCacheResult nextMatch(TreePath treePath) {
        MatchCacheResult result = new MatchCacheResult();
        Map.Entry<TreePath, TreePath> floorEntry = this.matchCache.floorEntry(treePath);
        if (floorEntry != null && floorEntry.getValue().compareTo(treePath) >= 0) {
            result.anchor = floorEntry.getKey();
            result.match = floorEntry.getValue();
            return result;
        }
        Map.Entry<TreePath, TreePath> higherEntry = this.matchCache.higherEntry(treePath);
        if (higherEntry == null) {
            return result;
        }
        result.nextAnchor = higherEntry.getKey();
        result.nextAnchorMatch = higherEntry.getValue();
        return result;
    }

    public void put(TreePath anchor, TreePath match) {
        if (this.matchCache.size() > 8000) {
            this.matchCache.pollFirstEntry();
        }
        this.matchCache.put(anchor, match);
    }

    public void clear() {
        this.matchCache.clear();
    }

    public int getCacheSize() {
        return this.matchCache.size();
    }

    public boolean checkMatch(TreePath key) {
        Map.Entry<TreePath, TreePath> floorEntry = this.matchCache.floorEntry(key);
        if (floorEntry == null) {
            return false;
        }
        return floorEntry.getValue().compareTo(key) == 0 || TreePath.isParent(key, floorEntry.getValue());
    }

    public class MatchCacheResult {
        TreePath anchor;
        TreePath match;
        TreePath nextAnchor;
        TreePath nextAnchorMatch;

        public void extendNextAnchor(TreePath treePath) {
            MatchCache.this.matchCache.remove(this.nextAnchor);
            MatchCache.this.matchCache.put(treePath, this.nextAnchorMatch);
        }

        public String toString() {
            return "[" + this.anchor + " -> " + this.match + "][" + this.nextAnchor + " -> " + this.nextAnchorMatch + "]";
        }
    }
}

