/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.diagrams.wave.WaveViewerDesignHierarchyView;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTMultipleSelectionLazyView;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.MultipleSelectionTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetMultipleSelectionActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;

public class MultipleSelectionEventHandler {
    DVTLazyView view;

    public MultipleSelectionEventHandler(DVTLazyView view) {
        this.view = view;
    }

    public SelectionListener createSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Widget source = e.item;
                if (!(source instanceof TreeItem)) {
                    return;
                }
                Object data = ((TreeItem)source).getData();
                if (!(data instanceof TreePath)) {
                    return;
                }
                if (MultipleSelectionEventHandler.this.view == null || !(MultipleSelectionEventHandler.this.view instanceof IDVTMultipleSelectionLazyView)) {
                    return;
                }
                LazyTree lazyTree = MultipleSelectionEventHandler.this.view.getLazyTree();
                if (lazyTree == null) {
                    return;
                }
                if (lazyTree.getViewContent() == null || lazyTree.getViewContent().isEmpty()) {
                    return;
                }
                AbstractTreeIterator treeIterator = lazyTree.getTreeIterator();
                if (!(treeIterator instanceof MultipleSelectionTreeIterator)) {
                    return;
                }
                MultipleSelectionTreeIterator multipleSelectionTreeIterator = (MultipleSelectionTreeIterator)treeIterator;
                TreePath currentSelection = (TreePath)data;
                if ((e.stateMask & 0x20000) != 0) {
                    TreePath lastSelection = multipleSelectionTreeIterator.getLastSelection();
                    if (lastSelection == null) {
                        return;
                    }
                    if (!(lastSelection.getElement() instanceof WSignalsTableElement) || !(currentSelection.getElement() instanceof WSignalsTableElement)) {
                        return;
                    }
                    WSignalsTableElement currentSelectionElement = (WSignalsTableElement)currentSelection.getElement();
                    WSignalsTableElement lastSelectionElement = (WSignalsTableElement)lastSelection.getElement();
                    List<TreePath> treePathsInBetween = ((IDVTMultipleSelectionLazyView)((Object)MultipleSelectionEventHandler.this.view)).getSignalsTableTreePathsInBetween(currentSelectionElement, lastSelectionElement);
                    multipleSelectionTreeIterator.setSelections(treePathsInBetween);
                    lazyTree.doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(multipleSelectionTreeIterator.getSelections(), null));
                    return;
                }
                if ((e.stateMask & 0x40000) != 0) {
                    if (multipleSelectionTreeIterator.containsSelection(currentSelection)) {
                        multipleSelectionTreeIterator.removeSelection(currentSelection);
                    } else {
                        multipleSelectionTreeIterator.addSelection(currentSelection);
                    }
                    lazyTree.doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(multipleSelectionTreeIterator.getSelections(), null));
                    return;
                }
                multipleSelectionTreeIterator.setLastSelection(currentSelection);
                ArrayList<TreePath> newSelection = new ArrayList<TreePath>();
                newSelection.add(currentSelection);
                multipleSelectionTreeIterator.setSelections(newSelection);
                lazyTree.doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(multipleSelectionTreeIterator.getSelections(), null));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
    }

    public KeyListener createKeySelectionListener() {
        return new KeyListener(){
            private boolean ctrlPressed;
            private long ctrlPressedTime;

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f' && MultipleSelectionEventHandler.this.view instanceof WaveViewerSignalTableView) {
                    if (MultipleSelectionEventHandler.this.view == null || !(MultipleSelectionEventHandler.this.view instanceof IDVTMultipleSelectionLazyView)) {
                        return;
                    }
                    WaveViewerDesignHierarchyView dhView = ((WaveViewerSignalTableView)MultipleSelectionEventHandler.this.view).getDHView();
                    LazyTree lazyTree = MultipleSelectionEventHandler.this.view.getLazyTree();
                    if (lazyTree == null) {
                        return;
                    }
                    List<TreePath> selections = lazyTree.getSelections();
                    if (selections == null) {
                        return;
                    }
                    WViewport viewport = ((WaveViewerSignalTableView)MultipleSelectionEventHandler.this.view).getViewport();
                    for (TreePath selection : selections) {
                        viewport.removeSignalsTableElement(selection);
                        if (dhView == null) continue;
                        dhView.updateOnRemove(selection);
                    }
                    MultipleSelectionTreeIterator treeIterator = (MultipleSelectionTreeIterator)lazyTree.getTreeIterator();
                    treeIterator.clearLastSelections();
                    treeIterator.clearSelections();
                    ((WaveViewerSignalTableView)MultipleSelectionEventHandler.this.view).update();
                    DVTVCDUtils.refreshWaveDiagram(((WaveViewerSignalTableView)MultipleSelectionEventHandler.this.view).getCanvas());
                    return;
                }
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 97) {
                    MultipleSelectionEventHandler.this.selectAll();
                    return;
                }
                if ((e.stateMask & 0x40000) != 0 || e.keyCode == 262144) {
                    this.ctrlPressed = true;
                    this.ctrlPressedTime = System.currentTimeMillis();
                    return;
                }
                if (e.keyCode == 97 && this.ctrlPressed && System.currentTimeMillis() - this.ctrlPressedTime < 500L) {
                    MultipleSelectionEventHandler.this.selectAll();
                    this.ctrlPressed = false;
                    return;
                }
                if (this.ctrlPressed && System.currentTimeMillis() - this.ctrlPressedTime >= 500L) {
                    this.ctrlPressed = false;
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        };
    }

    public void selectAll() {
        if (this.view == null || !(this.view instanceof IDVTMultipleSelectionLazyView)) {
            return;
        }
        LazyTree lazyTree = this.view.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        if (lazyTree.getViewContent() == null || lazyTree.getViewContent().isEmpty()) {
            return;
        }
        AbstractTreeIterator treeIterator = lazyTree.getTreeIterator();
        if (!(treeIterator instanceof MultipleSelectionTreeIterator)) {
            return;
        }
        MultipleSelectionTreeIterator multipleSelectionTreeIterator = (MultipleSelectionTreeIterator)treeIterator;
        List<TreePath> allTreePaths = ((IDVTMultipleSelectionLazyView)((Object)this.view)).getAllSignalsTableTreePaths();
        multipleSelectionTreeIterator.setSelections(allTreePaths);
        multipleSelectionTreeIterator.clearLastSelections();
        lazyTree.doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(multipleSelectionTreeIterator.getSelections(), null));
    }
}

