/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;

public class MultipleSelectionTreeIterator
extends TreeIterator {
    private List<TreePath> selections = new ArrayList<TreePath>();
    private Deque<TreePath> lastSelectionsDeque = new ArrayDeque<TreePath>();

    public MultipleSelectionTreeIterator(IDVTLazyView lazyView) {
        super(lazyView);
    }

    public List<TreePath> getSelections() {
        return this.selections;
    }

    public void setSelections(List<TreePath> selections) {
        this.selections = selections;
    }

    public void clearSelections() {
        this.selections = new ArrayList<TreePath>();
    }

    public void addSelection(TreePath selection) {
        if (this.selections == null) {
            this.selections = new ArrayList<TreePath>();
        }
        this.selections.add(selection);
        this.addLastSelection(selection);
    }

    public void removeSelection(TreePath selection) {
        if (this.selections == null) {
            return;
        }
        this.selections.remove(selection);
        this.removeLastSelection(selection);
    }

    public boolean containsSelection(TreePath selection) {
        return this.selections.contains(selection);
    }

    public TreePath getLastSelection() {
        if (this.lastSelectionsDeque == null || this.lastSelectionsDeque.isEmpty()) {
            return null;
        }
        return this.lastSelectionsDeque.peek();
    }

    public void setLastSelection(TreePath lastSelection) {
        if (this.lastSelectionsDeque == null) {
            this.lastSelectionsDeque = new ArrayDeque<TreePath>();
        } else {
            this.lastSelectionsDeque.clear();
        }
        this.lastSelectionsDeque.add(lastSelection);
    }

    public void addLastSelection(TreePath lastSelection) {
        if (lastSelection == null) {
            return;
        }
        if (this.lastSelectionsDeque == null) {
            this.lastSelectionsDeque = new ArrayDeque<TreePath>();
        }
        this.lastSelectionsDeque.push(lastSelection);
    }

    public void removeLastSelection(TreePath selection) {
        if (selection == null || this.lastSelectionsDeque == null || this.lastSelectionsDeque.isEmpty()) {
            return;
        }
        this.lastSelectionsDeque.remove(selection);
    }

    public void clearLastSelections() {
        this.lastSelectionsDeque.clear();
    }

    @Override
    protected void restoreStartPathAndStatePaths(IProgressMonitor monitor) {
        HashSet<TreePath> toggleStatePathsCopy = new HashSet<TreePath>(this.getToggledStatePaths());
        TreePath startTreePathCopy = this.getStartTreePath();
        List<TreePath> selectionsCopy = this.getSelections();
        HashSet<TreePath> restoredTogglePaths = new HashSet<TreePath>();
        this.resetStartTreePath();
        this.resetToggleStatePaths();
        this.clearSelections();
        IDVTModel dvtModel = this.getModel(IModel.class);
        if (!(dvtModel instanceof IModel)) {
            return;
        }
        IModel model = (IModel)dvtModel;
        List<TreePath> tops = model.getChildren(TreePath.TOP_DUMMY_TREE_PATH, 0, Integer.MAX_VALUE, monitor);
        if (tops == null || tops.isEmpty()) {
            return;
        }
        TreePath startTreePathCandidate = TreePathUtils.restorePathsStartingFromRootPath(startTreePathCopy, tops, toggleStatePathsCopy, restoredTogglePaths, this.getLazyView(), monitor);
        if (startTreePathCandidate == null) {
            return;
        }
        this.setStartTreePath(startTreePathCandidate);
        if (selectionsCopy != null) {
            for (TreePath selectionCopy : selectionsCopy) {
                TreePath selectionTreePathCandidate = TreePathUtils.restorePathsStartingFromRootPath(selectionCopy, tops, toggleStatePathsCopy, restoredTogglePaths, this.getLazyView(), monitor);
                if (selectionTreePathCandidate == null) continue;
                this.addSelection(selectionTreePathCandidate);
            }
        }
        ArrayList<TreePath> remainingToggleStatePaths = new ArrayList<TreePath>(toggleStatePathsCopy);
        for (TreePath toggleStatePath : remainingToggleStatePaths) {
            TreePath startPathRestored;
            if (monitor.isCanceled()) {
                this.setToggledStatePaths(restoredTogglePaths);
                return;
            }
            if (restoredTogglePaths.contains(toggleStatePath) || (startPathRestored = TreePathUtils.restorePathsStartingFromRootPath(toggleStatePath, tops, toggleStatePathsCopy, restoredTogglePaths, this.getLazyView(), monitor)) == null) continue;
            restoredTogglePaths.add(startPathRestored);
        }
        this.setToggledStatePaths(restoredTogglePaths);
    }

    @Override
    public void setSelection(TreePath selection) {
        if (this.selections == null) {
            this.selections = new ArrayList<TreePath>();
        }
        this.selections.clear();
        if (selection != null) {
            this.selections.add(selection);
        }
    }
}

