/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.ExpandCollapseState;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeCache;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorException;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.TreePathChildProvider;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;

public class TreeIterator
extends AbstractTreeIterator {
    private LazyTreeCache cache;

    public TreeIterator(IDVTLazyView lazyView) {
        super(lazyView);
        if (this.cache == null) {
            this.cache = LazyTreeCache.newInstance();
        }
    }

    public TreeIterator(IDVTLazyView lazyView, Comparator<TreePath> matchCacheComparator) {
        super(lazyView, matchCacheComparator);
        if (this.cache == null) {
            this.cache = LazyTreeCache.newInstance();
        }
    }

    @Override
    public boolean isCollapsedAndHasChildren(TreePath treePath, IProgressMonitor monitor) {
        if (!this.isCollapsed(treePath)) {
            return false;
        }
        return this.getCachedChildren(treePath, monitor) != null;
    }

    @Override
    public boolean hasInstanceChildren(TreePath treePath, IProgressMonitor monitor) {
        return false;
    }

    @Override
    protected TreePath getFirstChildOfPath(TreePath treePath, IProgressMonitor monitor) {
        TreePathChildProvider roots = this.getCachedChildren(treePath, monitor);
        if (roots == null) {
            return null;
        }
        return roots.get(0, monitor);
    }

    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        IDVTModel dvtModel = this.getModel(IModel.class);
        if (!(dvtModel instanceof IModel)) {
            return null;
        }
        IModel model = (IModel)dvtModel;
        return model.getEndTreePath(path, monitor);
    }

    @Override
    protected void restoreStartPathAndStatePaths(IProgressMonitor monitor) {
        TreePath selectionTreePathCandidate;
        HashSet<TreePath> toggleStatePathsCopy = new HashSet<TreePath>(this.getToggledStatePaths());
        TreePath startTreePathCopy = this.getStartTreePath();
        TreePath selectionCopy = this.getSelection();
        HashSet<TreePath> restoredTogglePaths = new HashSet<TreePath>();
        this.resetStartTreePath();
        this.resetToggleStatePaths();
        this.resetSelection();
        IDVTModel dvtModel = this.getModel(IModel.class);
        if (!(dvtModel instanceof IModel)) {
            return;
        }
        IModel model = (IModel)dvtModel;
        List<TreePath> tops = model.getChildren(TreePath.TOP_DUMMY_TREE_PATH, 0, Integer.MAX_VALUE, monitor);
        if (tops == null || tops.isEmpty()) {
            return;
        }
        TreePath startTreePathCandidate = TreePathUtils.restorePathsStartingFromRootPath(startTreePathCopy, tops, toggleStatePathsCopy, restoredTogglePaths, this.getLazyView(), monitor);
        if (startTreePathCandidate == null) {
            return;
        }
        this.setStartTreePath(startTreePathCandidate);
        if (selectionCopy != null && (selectionTreePathCandidate = TreePathUtils.restorePathsStartingFromRootPath(selectionCopy, tops, toggleStatePathsCopy, restoredTogglePaths, this.getLazyView(), monitor)) != null) {
            this.setSelection(selectionTreePathCandidate);
        }
        ArrayList<TreePath> remainingToggleStatePaths = new ArrayList<TreePath>(toggleStatePathsCopy);
        for (TreePath toggleStatePath : remainingToggleStatePaths) {
            TreePath startPathRestored;
            if (monitor.isCanceled()) {
                this.setToggledStatePaths(restoredTogglePaths);
                return;
            }
            if (restoredTogglePaths.contains(toggleStatePath) || (startPathRestored = TreePathUtils.restorePathsStartingFromRootPath(toggleStatePath, tops, toggleStatePathsCopy, restoredTogglePaths, this.getLazyView(), monitor)) == null) continue;
            restoredTogglePaths.add(startPathRestored);
        }
        this.setToggledStatePaths(restoredTogglePaths);
    }

    protected TreePathChildProvider getCachedChildren(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        IDVTModel dvtModel = this.getModel(IModel.class);
        if (!(dvtModel instanceof IModel)) {
            return null;
        }
        TreePathChildProvider result = this.cache.get(treePath, (IModel)dvtModel);
        return result.isEmpty(monitor) ? null : result;
    }

    protected TreePathChildProvider getCachedNonCollapsedChildren(TreePath treePath, IProgressMonitor monitor) {
        if (this.isCollapsed(treePath)) {
            return null;
        }
        return this.getCachedChildren(treePath, monitor);
    }

    @Override
    protected TreePath next(TreePath treePath, boolean skipCollapsed, IProgressMonitor monitor) {
        TreePathChildProvider children;
        TreePathChildProvider treePathChildProvider = children = skipCollapsed ? this.getCachedNonCollapsedChildren(treePath, monitor) : this.getCachedChildren(treePath, monitor);
        if (children != null) {
            return children.get(0, monitor);
        }
        TreePath nextSibling = this.nextSibling(treePath, monitor);
        if (nextSibling != null) {
            return nextSibling;
        }
        TreePath parent = treePath;
        while ((parent = parent.parent()) != null) {
            if (monitor.isCanceled()) {
                return null;
            }
            TreePath parentSibling = this.nextSibling(parent, monitor);
            if (parentSibling == null) continue;
            return parentSibling;
        }
        return null;
    }

    private TreePath nextSibling(TreePath treePath, IProgressMonitor monitor) {
        TreePathChildProvider siblings;
        block5: {
            block4: {
                try {
                    if (treePath != null) break block4;
                    return null;
                }
                catch (TreeIteratorException treeIteratorException) {
                    return null;
                }
            }
            TreePath parentPath = treePath.parent();
            siblings = this.getCachedChildren(parentPath, monitor);
            if (siblings != null) break block5;
            return null;
        }
        return siblings.get(treePath.getIndexInParent() + 1, monitor);
    }

    @Override
    protected TreePath prev(TreePath treePath, IProgressMonitor monitor, boolean skipCollapsed) {
        TreePath prevSibling = this.prevSibling(treePath, monitor);
        if (prevSibling == null) {
            return treePath.parent();
        }
        TreePathChildProvider prevSiblingChildren = null;
        while ((prevSiblingChildren = skipCollapsed ? this.getCachedNonCollapsedChildren(prevSibling, monitor) : this.getCachedChildren(prevSibling, monitor)) != null) {
            if (monitor.isCanceled()) {
                return null;
            }
            prevSibling = prevSiblingChildren.getLast(monitor);
        }
        return prevSibling;
    }

    private TreePath prevSibling(TreePath treePath, IProgressMonitor monitor) {
        TreePathChildProvider siblings;
        block3: {
            try {
                TreePath parentPath = treePath.parent();
                siblings = this.getCachedChildren(parentPath, monitor);
                if (siblings != null) break block3;
                return null;
            }
            catch (TreeIteratorException treeIteratorException) {
                return null;
            }
        }
        return siblings.get(treePath.getIndexInParent() - 1, monitor);
    }

    @Override
    public boolean isCollapsed(TreePath treePath) {
        if (this.getState() == ExpandCollapseState.EXPANDED) {
            return this.getToggledStatePaths().contains(treePath);
        }
        if (this.getState() == ExpandCollapseState.COLLAPSED) {
            return !this.getToggledStatePaths().contains(treePath);
        }
        throw new TreeIteratorException();
    }

    public int getLazyTreeCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return this.cache.getLazyTreeCacheSize();
    }

    public int getMatchCacheSize() {
        if (this.getMatchCache() == null) {
            return 0;
        }
        return this.getMatchCache().getCacheSize();
    }

    @Override
    protected void resetHardInternal() {
        this.cache.clear();
    }

    @Override
    protected void resetSoftInternal() {
        this.getMatchCache().clear();
    }
}

