/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.views.designhierarchy.InstancesToBindContainer;
import ro.amiq.dvt.ui.views.lazy.tree.ITrimmedTreePath;

public class TreePath
implements Comparable<TreePath> {
    public static final TreePath TOP_DUMMY_TREE_PATH = TreePath.of(null, new String[]{"."}, new int[1]);
    public static final String DUMMY_OPERATION_NODE = "...";
    protected String[] segments;
    private int[] indices;
    protected TreePath parent;
    protected Object element;
    public InstancesToBindContainer instancesToBind;
    public Comparator<TreePath> customComparator;
    public Collection<? extends IRfConfigurationRule> rules;

    public boolean equals(Object obj) {
        if (!(obj instanceof TreePath)) {
            return false;
        }
        return Arrays.equals(((TreePath)obj).segments, this.segments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    @Deprecated
    protected TreePath() {
    }

    private TreePath(TreePath parent, String[] segments, int[] indices) {
        this(parent, segments, indices, null);
    }

    private TreePath(TreePath parent, String[] segments, int[] indices, Comparator<TreePath> comparator) {
        this.segments = segments;
        this.setIndices(indices);
        this.parent = parent;
        this.customComparator = comparator;
    }

    public String[] getSegments() {
        return this.segments;
    }

    public static TreePath of(TreePath parent, String[] segments, int[] indices) {
        return TreePath.of(parent, segments, indices, null);
    }

    public static TreePath of(TreePath parent, String[] segments, int[] indices, Comparator<TreePath> comparator) {
        return new TreePath(parent, segments, indices, comparator);
    }

    public String toString() {
        if (this.segments.length == 0 || this == TOP_DUMMY_TREE_PATH) {
            return "/";
        }
        return "/".concat(Arrays.asList(this.segments).stream().collect(Collectors.joining("/")));
    }

    public String toString(String separator) {
        if (this.segments.length == 0 || this == TOP_DUMMY_TREE_PATH) {
            return "/";
        }
        return Arrays.asList(this.segments).stream().collect(Collectors.joining(separator));
    }

    public TreePath parent() {
        return this.parent;
    }

    public static TreePath child(TreePath parent, String name, int index) {
        return TreePath.child(parent, name, index, null);
    }

    public static TreePath child(TreePath parent, String name, int index, Comparator<TreePath> comparator) {
        if (parent == null) {
            return TreePath.of(parent, new String[]{name}, new int[]{index}, comparator);
        }
        if (parent == TOP_DUMMY_TREE_PATH) {
            return TreePath.of(parent, new String[]{name}, new int[]{index}, comparator);
        }
        String[] segments = new String[parent.segments.length + 1];
        System.arraycopy(parent.segments, 0, segments, 0, parent.segments.length);
        segments[segments.length - 1] = name;
        int[] indices = new int[parent.getIndices().length + 1];
        System.arraycopy(parent.getIndices(), 0, indices, 0, parent.getIndices().length);
        indices[indices.length - 1] = index;
        return TreePath.of(parent, segments, indices, comparator);
    }

    public String getName() {
        return this.segments[this.segments.length - 1];
    }

    public String toNiceString() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return this.getElement().toString();
        }
        return String.valueOf(DesignUtils.getDesign(DesignUtils.DesignRequest.of(namedElement)).getName()) + " : " + this.getName();
    }

    public boolean isEmpty() {
        return this.segments.length == 0 || this == TOP_DUMMY_TREE_PATH;
    }

    /*
     * Unable to fully structure code
     */
    public static List<TreePath> parentsList(TreePath first, boolean relativeTo) {
        block4: {
            block3: {
                result = new ArrayList<TreePath>();
                if (!(first instanceof ITrimmedTreePath) || !relativeTo) break block3;
                parents = ((ITrimmedTreePath)first).getParentsRelativeTo();
                if (parents == null) {
                    return null;
                }
                for (TreePath parent : parents) {
                    if (parent == TreePath.TOP_DUMMY_TREE_PATH) continue;
                    result.add(parent);
                }
                break block4;
            }
            parent = first;
            if (first != null) ** GOTO lbl19
            return null;
lbl-1000:
            // 1 sources

            {
                if (parent == TreePath.TOP_DUMMY_TREE_PATH) continue;
                result.add(parent);
lbl19:
                // 3 sources

                ** while ((parent = parent.parent()) != null)
            }
        }
        return result;
    }

    public static boolean isRoot(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        if (treePath instanceof ITrimmedTreePath) {
            List<TreePath> parentsRelativeTo = ((ITrimmedTreePath)((Object)treePath)).getParentsRelativeTo();
            return parentsRelativeTo == null || parentsRelativeTo.isEmpty();
        }
        return treePath.getParent() == TOP_DUMMY_TREE_PATH || treePath.segments.length == 1;
    }

    public static boolean isParent(TreePath parent, TreePath child) {
        if (parent == child) {
            return true;
        }
        if (parent.segments.length > child.segments.length) {
            return false;
        }
        Object[] childSlice = Arrays.copyOf(child.segments, parent.segments.length);
        return Arrays.equals(parent.segments, childSlice);
    }

    @Override
    public int compareTo(TreePath o) {
        if (this.customComparator != null) {
            return this.customComparator.compare(this, o);
        }
        return this.compareDefaultOrder(o);
    }

    public int compareDefaultOrder(TreePath o) {
        if (this == o) {
            return 0;
        }
        int i = 0;
        while (i < Math.min(o.segments.length, this.segments.length)) {
            int result = this.segments[i].compareTo(o.segments[i]);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return this.segments.length - o.segments.length;
    }

    public void setElement(Object element) {
        this.element = element;
    }

    public Object getElement() {
        return this.element;
    }

    public IRfNamedElement getNamedElement() {
        return this.element instanceof IRfNamedElement ? (IRfNamedElement)this.element : null;
    }

    public String lastSegment() {
        if (this.segments.length == 0) {
            return "";
        }
        return this.segments[this.segments.length - 1];
    }

    public int getIndexInParent() {
        return this.getIndices()[this.getIndices().length - 1];
    }

    public String getLastSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public TreePath getParent() {
        return this.parent;
    }

    public void setParent(TreePath parent) {
        this.parent = parent;
    }

    public TreePath getTopParent() {
        List<TreePath> parentsList = TreePath.parentsList(this, true);
        if (parentsList == null || parentsList.isEmpty()) {
            return this;
        }
        return parentsList.get(parentsList.size() - 1);
    }

    public void append(String string) {
        String lastSegment;
        if (this.segments == null || this.segments.length == 0) {
            return;
        }
        this.segments[this.segments.length - 1] = lastSegment = String.valueOf(this.getLastSegment()) + string;
    }

    public void removeDuplicatePathExtension() {
        if (this.segments == null || this.segments.length == 0) {
            return;
        }
        String lastSegment = this.getLastSegment();
        int duplicateExtensionIndex = lastSegment.indexOf("(");
        if (duplicateExtensionIndex < 0) {
            return;
        }
        this.segments[this.segments.length - 1] = lastSegment = lastSegment.substring(0, duplicateExtensionIndex);
    }

    public boolean equals(Object obj, boolean removeDuplicateExtension) {
        if (!(obj instanceof TreePath)) {
            return false;
        }
        Object[] objSegments = ((TreePath)obj).segments;
        Object[] thisSegments = this.segments;
        if (removeDuplicateExtension) {
            String thisLastSegment;
            int thisIndexOf;
            String objLastSegment = ((TreePath)obj).getLastSegment();
            int indexOf = objLastSegment.indexOf("@(");
            if (indexOf >= 0) {
                objSegments = (String[])Arrays.copyOf(objSegments, objSegments.length);
                objSegments[objSegments.length - 1] = objLastSegment.substring(0, indexOf);
            }
            if ((thisIndexOf = (thisLastSegment = this.getLastSegment()).indexOf("@(")) >= 0) {
                thisSegments = (String[])Arrays.copyOf(thisSegments, thisSegments.length);
                thisSegments[thisSegments.length - 1] = thisLastSegment.substring(0, thisIndexOf);
            }
        }
        return Arrays.equals(objSegments, thisSegments);
    }

    public int[] getIndices() {
        return this.indices;
    }

    public void setIndices(int[] indices) {
        this.indices = indices;
    }
}

