/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class TreePathChildProvider {
    private IModel model;
    private int chunk;
    private TreePath path;
    private Boolean empty;
    private List<TreePath> childrenInMemory;

    public TreePathChildProvider(TreePath path, IModel model) {
        this.model = model;
        this.path = path;
    }

    public boolean isEmpty(IProgressMonitor monitor) {
        if (this.empty == null) {
            this.empty = this.model == null || this.model.hasChildren(this.path, monitor) == false;
        }
        return this.empty;
    }

    public TreePath getLast(IProgressMonitor monitor) {
        return this.model.getLastChild(this.path, monitor);
    }

    public TreePath get(int i, IProgressMonitor monitor) {
        if (i < 0 || this.model == null) {
            return null;
        }
        int chunk = i / 150000;
        if (this.chunk != chunk || this.childrenInMemory == null && !this.empty.booleanValue()) {
            this.chunk = chunk;
            this.childrenInMemory = this.model.getChildren(this.path, chunk * 150000, (chunk + 1) * 150000, monitor);
        }
        if (this.childrenInMemory == null || this.childrenInMemory.isEmpty()) {
            return null;
        }
        return i % 150000 < this.childrenInMemory.size() ? this.childrenInMemory.get(i % 150000) : null;
    }
}

