/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeSliderSeparatorSide;
import ro.amiq.dvt.ui.views.lazy.tree.LazyViewSlider;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeGoToStartEndOfTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSlideActionArguments;

public class VerticalLazyViewSlider
extends LazyViewSlider {
    protected DragJob dragJob = new DragJob("Drag...");
    protected LazyTree lazyTree;

    public VerticalLazyViewSlider(Composite parent, LazyTree lazyTree, LazyTreeSliderSeparatorSide side) {
        super(parent, side);
        this.lazyTree = lazyTree;
        if (side == LazyTreeSliderSeparatorSide.LEFT) {
            Composite leftBar = new Composite(this.sliderComposite, 0);
            GridDataFactory.fillDefaults().align(1, 4).grab(true, true).hint(1, -1).span(1, 9).applyTo((Control)leftBar);
            DVTColorUtil.INSTANCE.setBackground((Control)leftBar, this.COLOR_SEPARATOR);
        }
        Composite composite = new Composite(this.sliderComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(0, 0, 0, 0).margins(0, 0).spacing(0, 0).applyTo(composite);
        DVTColorUtil.INSTANCE.setBackground((Control)this.sliderComposite, this.COLOR_TREE_BG);
        GridDataFactory.fillDefaults().align(1, 4).grab(true, true).applyTo((Control)composite);
        this.goToStartButton = this.makeCanvas(composite, LazyViewSlider.Arrow.TOP);
        this.prevPageButton = this.makeCanvas(composite, LazyViewSlider.Arrow.PAGE_UP);
        this.prevStepButton = this.makeCanvas(composite, LazyViewSlider.Arrow.UP);
        this.makeSpacers(composite);
        this.nextStepButton = this.makeCanvas(composite, LazyViewSlider.Arrow.DOWN);
        this.nextPageButton = this.makeCanvas(composite, LazyViewSlider.Arrow.PAGE_DOWN);
        this.goToEndButton = this.makeCanvas(composite, LazyViewSlider.Arrow.BOTTOM);
        if (side == LazyTreeSliderSeparatorSide.RIGHT) {
            Composite rightBar = new Composite(this.sliderComposite, 0);
            GridDataFactory.fillDefaults().align(1, 4).grab(true, true).hint(1, -1).span(1, 9).applyTo((Control)rightBar);
            DVTColorUtil.INSTANCE.setBackground((Control)rightBar, this.COLOR_SEPARATOR);
        }
    }

    @Override
    protected Canvas makeCanvas(Composite parent, LazyViewSlider.Arrow arrow) {
        Canvas c = new Canvas(parent, 0);
        c.setToolTipText(arrow.getTooltip());
        c.addPaintListener((PaintListener)new LazyViewSlider.CanvasPaintListener(arrow));
        c.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                e.widget.setData("hover", null);
                ((Canvas)e.widget).redraw();
            }

            public void mouseEnter(MouseEvent e) {
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                e.widget.setData("hover", (Object)true);
                ((Canvas)e.widget).redraw();
            }
        });
        c.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Tree tree;
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                e.widget.setData("clicked", null);
                ((Canvas)e.widget).redraw();
                VerticalLazyViewSlider.this.dragJob.cancel();
                Tree tree2 = tree = VerticalLazyViewSlider.this.lazyTree == null ? null : VerticalLazyViewSlider.this.lazyTree.getTree();
                if (tree != null && !tree.isDisposed()) {
                    tree.setFocus();
                }
            }

            public void mouseDown(MouseEvent e) {
                if (!(e.widget instanceof Canvas)) {
                    return;
                }
                e.widget.setData("clicked", (Object)true);
                ((Canvas)e.widget).redraw();
                if (VerticalLazyViewSlider.this.dragJob.getState() == 0) {
                    Tree tree = VerticalLazyViewSlider.this.lazyTree.getTree();
                    if (tree == null || tree.isDisposed()) {
                        return;
                    }
                    int rows = VerticalLazyViewSlider.this.lazyTree.getStackComposite().getSize().y / tree.getItemHeight();
                    if (tree.getColumnCount() > 1) {
                        --rows;
                    }
                    VerticalLazyViewSlider.this.dragJob.setTreeSize(rows);
                    VerticalLazyViewSlider.this.dragJob.setEvent(e);
                    VerticalLazyViewSlider.this.dragJob.schedule();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, true).align(4, 4).hint(24, 24).applyTo((Control)c);
        return c;
    }

    class DragJob
    extends Job {
        private MouseEvent event;
        private int rows;

        public DragJob(String name) {
            super(name);
            this.rows = 20;
        }

        public void setTreeSize(int rows) {
            this.rows = rows;
        }

        public void setEvent(MouseEvent event) {
            this.event = event;
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!monitor.isCanceled()) {
                if (VerticalLazyViewSlider.this.lazyTree == null) {
                    return Status.OK_STATUS;
                }
                Widget widget = this.event.widget;
                if (widget == VerticalLazyViewSlider.this.goToStartButton) {
                    VerticalLazyViewSlider.this.lazyTree.doAction(LazyTreeAction.GO_TO_START_OF_TREE, new LazyTreeGoToStartEndOfTreeActionArguments(false, null));
                    break;
                }
                if (widget == VerticalLazyViewSlider.this.prevPageButton) {
                    VerticalLazyViewSlider.this.lazyTree.doAction(LazyTreeAction.SLIDER_DRAG, new LazyTreeSlideActionArguments(-this.rows, Objection.LAZY_TREE_SLIDER_DRAG));
                } else if (widget == VerticalLazyViewSlider.this.prevStepButton) {
                    VerticalLazyViewSlider.this.lazyTree.doAction(LazyTreeAction.SLIDER_DRAG, new LazyTreeSlideActionArguments(-1, Objection.LAZY_TREE_SLIDER_DRAG));
                } else if (widget == VerticalLazyViewSlider.this.nextStepButton) {
                    VerticalLazyViewSlider.this.lazyTree.doAction(LazyTreeAction.SLIDER_DRAG, new LazyTreeSlideActionArguments(1, Objection.LAZY_TREE_SLIDER_DRAG));
                } else if (widget == VerticalLazyViewSlider.this.nextPageButton) {
                    VerticalLazyViewSlider.this.lazyTree.doAction(LazyTreeAction.SLIDER_DRAG, new LazyTreeSlideActionArguments(this.rows, Objection.LAZY_TREE_SLIDER_DRAG));
                } else if (widget == VerticalLazyViewSlider.this.goToEndButton) {
                    VerticalLazyViewSlider.this.lazyTree.doAction(LazyTreeAction.GO_TO_END_OF_TREE, new LazyTreeGoToStartEndOfTreeActionArguments(false, null));
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

