/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.utils.LazyTreeUtils;

public class LazyTreeComputeTreeSizeCmd
extends LazyTreeCmd {
    public LazyTreeComputeTreeSizeCmd(LazyTreeCmdArgs args) {
        super(args);
    }

    @Override
    protected void initArguments(LazyTreeCmdArgs args) {
    }

    public void setTreeSize(LazyTree tree, AbstractTreeIterator iterator, IProgressMonitor monitor) {
        Display.getDefault().syncExec(() -> iterator.setTargetWindowSize(this.getRows(tree), monitor));
    }

    private int getRows(LazyTree lazyTree) {
        if (TestHelper.isTestMode() && TestHelper.isComputingFullSizeLazyTree()) {
            return Integer.MAX_VALUE;
        }
        if (TestHelper.isTestMode() && TestHelper.isComputingFixedSizeLazyTree()) {
            return TestHelper.getLazyTreeNodesFixedSize();
        }
        Tree tree = lazyTree.getTree();
        if (tree == null || tree.isDisposed()) {
            return 0;
        }
        int stackCompositeHeight = lazyTree.getStackComposite().getSize().y;
        int itemHeight = LazyTreeUtils.treeItemHeight;
        if (itemHeight == 0) {
            itemHeight = tree.getItemHeight();
        }
        int rows = stackCompositeHeight / itemHeight;
        if (tree.getColumnCount() > 1) {
            --rows;
        }
        return rows;
    }
}

