/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree.commands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeStateLabel;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeDecorateCmdArgs;

public class LazyTreeDecorateCmd
extends LazyTreeCmd {
    private Objection objection;
    private boolean decorated;

    public LazyTreeDecorateCmd(LazyTreeStateLabel label, LazyTreeCmdArgs args) {
        super(label, args);
    }

    public LazyTreeDecorateCmd(LazyTreeCmdArgs args) {
        super(args);
    }

    @Override
    protected void initArguments(LazyTreeCmdArgs args) {
        if (!(args instanceof LazyTreeDecorateCmdArgs)) {
            return;
        }
        this.objection = ((LazyTreeDecorateCmdArgs)args).getObjection();
    }

    public void decorate(Object[] elements, AbstractTreeIterator treeIterator, Tree tree, ILabelProvider labelProvider, IProgressMonitor monitor, Object object) {
        this.decorate(elements, treeIterator, tree, labelProvider, monitor, this.objection);
    }

    public void decorate(Object[] elements, AbstractTreeIterator treeIterator, Tree tree, ILabelProvider labelProvider, IProgressMonitor monitor, Objection objection) {
        this.decorateTree(elements, treeIterator, tree, labelProvider, monitor, objection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decorateTree(Object[] elements, AbstractTreeIterator treeIterator, Tree tree, ILabelProvider labelProvider, IProgressMonitor monitor, Objection objection) {
        if (tree == null) return;
        if (tree.isDisposed()) return;
        if (treeIterator == null) {
            return;
        }
        if (elements == null) return;
        if (elements.length == 0) {
            return;
        }
        HashSet<Object> elementsSet = new HashSet<Object>(Arrays.asList(elements));
        try {
            tree.setRedraw(false);
            LinkedBlockingDeque<TreeItem> allItems = new LinkedBlockingDeque<TreeItem>();
            TreeItem[] items = tree.getItems();
            if (items == null) return;
            if (items.length == 0) {
                return;
            }
            allItems.addAll(Arrays.asList(items));
            {
                if (!allItems.isEmpty()) {
                }
                return;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        finally {
            if (this.decorated) {
                ObjectionManager.getInstance().clear(Objection.LAZY_TREE_DECORATE_ELEMENTS);
                this.decorated = false;
            }
            tree.setRedraw(true);
            if (objection != null) {
                ObjectionManager.getInstance().clear(objection);
            }
        }
    }
}

