/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree.commands;

import java.lang.reflect.Constructor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeStateLabel;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeComputeTreeSizeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeDecorateCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeNotifyListenersCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRecomputeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRedrawCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetHardCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetModelCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetSoftCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetCustomExpandStateCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetMultipleSelectionCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetSelectionCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetStateCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSlideCmd;

public enum LazyTreeOperation {
    SET_STATE(LazyTreeSetStateCmd.class),
    SLIDE(LazyTreeSlideCmd.class),
    RECOMPUTE(LazyTreeRecomputeCmd.class),
    REDRAW(LazyTreeRedrawCmd.class),
    DECORATE(LazyTreeDecorateCmd.class),
    RESET_MODEL(LazyTreeResetModelCmd.class),
    RESET_SOFT(LazyTreeResetSoftCmd.class),
    RESET_HARD(LazyTreeResetHardCmd.class),
    SET_SELECTION(LazyTreeSetSelectionCmd.class),
    SET_MULTIPLE_SELECTION(LazyTreeSetMultipleSelectionCmd.class),
    COMPUTE_TREE_SIZE(LazyTreeComputeTreeSizeCmd.class),
    SET_CUSTOM_EXPAND(LazyTreeSetCustomExpandStateCmd.class),
    NOTIFY_LISTENERS(LazyTreeNotifyListenersCmd.class);

    private Class<? extends LazyTreeCmd> commandClass;

    private LazyTreeOperation(Class<? extends LazyTreeCmd> commandClass) {
        this.commandClass = commandClass;
    }

    public LazyTreeCmd makeCommandWithLabel(LazyTreeStateLabel label, LazyTreeCmdArgs args) {
        try {
            Class<? extends LazyTreeCmd> clazz = this.commandClass;
            Constructor<? extends LazyTreeCmd> ctor = clazz.getDeclaredConstructor(LazyTreeStateLabel.class, LazyTreeCmdArgs.class);
            ctor.setAccessible(true);
            LazyTreeCmd newInstance = ctor.newInstance(new Object[]{label, args});
            return newInstance;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public LazyTreeCmd makeCommand(LazyTreeCmdArgs args) {
        try {
            Class<? extends LazyTreeCmd> clazz = this.commandClass;
            Constructor<? extends LazyTreeCmd> ctor = clazz.getDeclaredConstructor(LazyTreeCmdArgs.class);
            ctor.setAccessible(true);
            LazyTreeCmd newInstance = ctor.newInstance(args);
            return newInstance;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

