/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree.commands;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.ui.DVTSelectionChangedEvent;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeStateLabel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.TreeSelectionMode;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmd;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeCmdArgs;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetSelectionCmdArgs;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTDebugLazyTreeViewer;

public class LazyTreeSetSelectionCmd
extends LazyTreeCmd {
    private TreePath givenSelection;
    private TreeSelectionMode selectionMode;
    private boolean isFireSelection;

    public LazyTreeSetSelectionCmd(LazyTreeStateLabel label, LazyTreeCmdArgs args) {
        super(label, args);
    }

    public LazyTreeSetSelectionCmd(LazyTreeCmdArgs args) {
        super(args);
    }

    @Override
    protected void initArguments(LazyTreeCmdArgs args) {
        if (!(args instanceof LazyTreeSetSelectionCmdArgs)) {
            return;
        }
        this.selectionMode = ((LazyTreeSetSelectionCmdArgs)args).getSelectionMode();
        this.givenSelection = ((LazyTreeSetSelectionCmdArgs)args).getGivenSelection();
        this.isFireSelection = ((LazyTreeSetSelectionCmdArgs)args).isFireSelection();
    }

    public void setSelection(AbstractTreeIterator treeIterator) {
        TreePath pathToSelect;
        if (treeIterator == null) {
            return;
        }
        if (this.selectionMode != null) {
            switch (this.selectionMode) {
                case FIRST: {
                    pathToSelect = treeIterator.getFirst(true);
                    break;
                }
                case LAST: {
                    pathToSelect = treeIterator.getLast();
                    break;
                }
                case GIVEN: {
                    pathToSelect = this.givenSelection;
                    break;
                }
                default: {
                    pathToSelect = null;
                    break;
                }
            }
        } else {
            return;
        }
        if (pathToSelect == null) {
            return;
        }
        treeIterator.setSelection(pathToSelect);
        IDVTLazyView lazyView = treeIterator.getLazyView();
        if (this.isFireSelection && lazyView instanceof ISelectionProvider) {
            IDVTElementWrapper wrapper;
            Object element = pathToSelect.getElement();
            if (element instanceof IDVTElementWrapper) {
                wrapper = (IDVTElementWrapper)element;
            } else {
                wrapper = new DVTTreeElementWrapper(element);
                wrapper.setProject(lazyView.getProject());
                TreePath parent = pathToSelect.getParent();
                if (parent != null && parent.equals(TreePath.TOP_DUMMY_TREE_PATH)) {
                    wrapper.setParent(new DVTTreeElementWrapper(parent));
                }
            }
            wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TREE_PATH, pathToSelect);
            Display display = Display.getDefault();
            display.asyncExec(() -> {
                DVTSelectionChangedEvent event = new DVTSelectionChangedEvent((ISelectionProvider)lazyView, (ISelection)new StructuredSelection(new Object[]{wrapper}), null);
                if (lazyView instanceof DVTDebugLazyTreeViewer) {
                    lazyView.fireSelectionChanged(event);
                    return;
                }
                display.timerExec(300, () -> lazyView.fireSelectionChanged(event));
            });
        }
    }
}

