/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public class BenchmarkModel
implements IModel {
    public static final String INPUT_FILE = "/tmp/dh_dump/dh_dump.txt";
    private static QuickModel quickModel = new QuickModel();

    static {
        try {
            File inputFile = new File(INPUT_FILE);
            if (!inputFile.exists()) {
                inputFile.createNewFile();
            }
            BufferedReader br = new BufferedReader(new FileReader(inputFile));
            String line = "";
            StopWatch.start("READ_DH_DUMP");
            while ((line = br.readLine()) != null) {
                String[] segmentsLine = line.split("/");
                TreePath child = TreePath.of(null, segmentsLine, null);
                child.setElement(segmentsLine[segmentsLine.length - 1]);
                quickModel.put(child);
            }
            StopWatch.stop("READ_DH_DUMP").print("");
            br.close();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        List<TreePath> childrenInternal = this.getChildrenInternal(treePath, childStartIndex, childEndIndex, monitor);
        return childrenInternal;
    }

    public List<TreePath> getChildrenInternal(TreePath treePath, int startChunkIndex, int endChunkIndex, IProgressMonitor monitor) {
        if (treePath == null || treePath.isEmpty()) {
            TreePath childTreePath = TreePath.child(treePath, "grand_top", endChunkIndex);
            childTreePath.setElement("grand_top");
            return Collections.singletonList(childTreePath);
        }
        if (startChunkIndex < 0 || endChunkIndex < 0) {
            return null;
        }
        List<TreePath> children = quickModel.getChildren(treePath);
        if (children == null) {
            return null;
        }
        if (startChunkIndex > children.size()) {
            return null;
        }
        return children.subList(startChunkIndex, Math.min(children.size(), endChunkIndex));
    }

    public void createToolBar() {
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public Boolean hasChildren(TreePath path, IProgressMonitor monitor) {
        return true;
    }

    public IProject getProject() {
        return null;
    }

    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        return null;
    }

    public void swapToSelectRootMessageComposite() {
    }

    public void swapToTreeComposite() {
    }

    @Override
    public void clearModelCaches() {
    }

    public static class QuickModel {
        public Map<TreePath, List<TreePath>> database = new HashMap<TreePath, List<TreePath>>();

        private void put(TreePath treePath) {
            TreePath parent = treePath.parent();
            List<TreePath> siblings = this.database.get(parent);
            if (siblings == null) {
                siblings = new ArrayList<TreePath>();
                this.database.put(parent, siblings);
            }
            siblings.add(treePath);
        }

        public List<TreePath> getChildren(TreePath treePath) {
            return this.database.get(treePath);
        }
    }
}

