/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree.utils;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderView;
import ro.amiq.dvt.ui.views.lazy.views.types.QuickTypesView;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesView;

@ForTestingOrDebuggingOnly
public interface ILazyTreeTestUtils {
    public IDVTLazyView getLazyView();

    default public void search(String textString) {
        this.search(textString, true);
    }

    default public void search(String textString, boolean viewNeedsToWaitForExtraObjection) {
        IDVTLazyView lazyView = this.getLazyView();
        if (lazyView == null) {
            throw new RuntimeException("Unable to find lazy view! (this might be a synchronization problem)");
        }
        LazyTree lazyTree = lazyView.getLazyTree();
        if (lazyTree == null) {
            throw new RuntimeException("Unable to find lazy tree! (this might be a synchronization problem)");
        }
        TextFilterObject textFilter = lazyTree.testGetTextFilter();
        if (textFilter == null) {
            throw new RuntimeException("Unable to find search filter! (this might be a synchronization problem)");
        }
        Text text = textFilter.getTextFilter();
        if (text == null) {
            throw new RuntimeException("Unable to find search filter! (this might be a synchronization problem)");
        }
        Objection objection = this.getObjection();
        text.setText(textString);
        lazyTree.doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(false, objection));
        ArrayList<Objection> objections = new ArrayList<Objection>();
        if (lazyView instanceof CompileOrderView || lazyView instanceof QuickTypesView) {
            objections.add(objection);
        } else {
            objections.add(objection);
            if (viewNeedsToWaitForExtraObjection) {
                objections.add(objection);
            }
            if (lazyView instanceof TypesView) {
                objections.add(Objection.TYPES_LABEL_INFO);
            }
        }
        Objection[] objs = new Objection[objections.size()];
        ObjectionManager.getInstance().waitFor(objections.toArray(objs));
    }

    default public void resetSearch() {
        IDVTLazyView lazyView = this.getLazyView();
        if (lazyView == null) {
            return;
        }
        LazyTree lazyTree = lazyView.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        TextFilterObject textFilter = lazyTree.testGetTextFilter();
        if (textFilter == null) {
            return;
        }
        Text text = textFilter.getTextFilter();
        if (text == null) {
            return;
        }
        text.setText("");
        ArrayList<Objection> objections = new ArrayList<Objection>();
        objections.add(this.getObjection());
        if (lazyView instanceof TypesView) {
            objections.add(Objection.TYPES_LABEL_INFO);
        }
        Objection[] objs = new Objection[objections.size()];
        ObjectionManager.getInstance().waitFor(objections.toArray(objs));
    }

    default public void doAction(LazyTreeAction action, LazyTreeActionArguments args) {
        IDVTLazyView lazyView = this.getLazyView();
        if (lazyView == null) {
            return;
        }
        LazyTree lazyTree = lazyView.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        lazyTree.doAction(action, args);
    }

    default public TreePath getSelectionInTree() {
        IDVTLazyView lazyView = this.getLazyView();
        if (lazyView == null) {
            return null;
        }
        LazyTree lazyTree = ((DVTLazyView)lazyView).getLazyTree();
        if (lazyTree == null) {
            return null;
        }
        return lazyTree.getSelection();
    }

    default public String getMessageText() {
        IDVTLazyView lazyView = this.getLazyView();
        if (lazyView == null) {
            return null;
        }
        return lazyView.getMessageText();
    }

    public boolean selectInLazyTree(String var1, int var2);

    default public boolean searchAndSelectInLazyView(String searchedInstanceName, int instanceCount) {
        this.search(searchedInstanceName);
        Tree designHierarchyTree = this.testGetViewTree();
        if (designHierarchyTree == null) {
            return false;
        }
        TreeItem[] treeItems = designHierarchyTree.getItems();
        if (treeItems == null || treeItems.length == 0) {
            return false;
        }
        TreeItem searchedTreeItem = this.searchTreeItemInTree(treeItems, searchedInstanceName, new AtomicInteger(instanceCount));
        if (searchedTreeItem == null) {
            throw new RuntimeException("Unable to select non-existing node " + searchedInstanceName);
        }
        Object data = searchedTreeItem.getData();
        TreePath searchedPath = null;
        if (data instanceof TreePath) {
            searchedPath = (TreePath)data;
        }
        if (searchedPath == null) {
            throw new RuntimeException("Unable to select non-existing node " + searchedInstanceName);
        }
        designHierarchyTree.setSelection(searchedTreeItem);
        this.testSetSelection(searchedPath);
        designHierarchyTree.showSelection();
        designHierarchyTree.notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        this.resetSearch();
        return true;
    }

    default public TreeItem searchTreeItemInTree(TreeItem[] treeItems, String searchedInstanceName, AtomicInteger searchedInstanceNameInDH) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof TreePath) {
                TreeItem searchedTreeItem;
                TreeItem[] childrenTreeItems;
                String instanceName = ((TreePath)data).getLastSegment();
                if (instanceName != null && instanceName.equals(searchedInstanceName)) {
                    searchedInstanceNameInDH.set(searchedInstanceNameInDH.get() - 1);
                    if (searchedInstanceNameInDH.get() < 0) {
                        return treeItem;
                    }
                }
                if ((childrenTreeItems = treeItem.getItems()) != null && childrenTreeItems.length > 0 && (searchedTreeItem = this.searchTreeItemInTree(childrenTreeItems, searchedInstanceName, searchedInstanceNameInDH)) != null) {
                    return searchedTreeItem;
                }
            }
            ++n2;
        }
        return null;
    }

    default public Tree testGetViewTree() {
        return this.getLazyTree().getTree();
    }

    default public void testSetSelection(TreePath path) {
        this.getLazyTree().testSetSelection(path);
    }

    default public LazyTree getLazyTree() {
        return null;
    }

    public Objection getObjection();
}

