/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree.utils;

import java.util.HashMap;
import java.util.Map;

public enum LazyTreeStatistics {
    INSTANCE;

    private Map<String, Integer> alivePathsByViewId = new HashMap<String, Integer>();

    public void registerTreePath(String viewId) {
        Integer alivePaths = this.alivePathsByViewId.get(viewId);
        if (alivePaths == null) {
            alivePaths = 0;
        }
        alivePaths = alivePaths + 1;
        this.alivePathsByViewId.put(viewId, alivePaths);
    }

    public void unRegisterTreePath(String viewId) {
        Integer alivePaths = this.alivePathsByViewId.get(viewId);
        alivePaths = alivePaths - 1;
        this.alivePathsByViewId.put(viewId, alivePaths);
    }

    public void resetTreeStatistics(String viewId) {
        this.alivePathsByViewId.put(viewId, 0);
    }

    public int getAlivePathForView(String viewId) {
        Integer alivePaths = this.alivePathsByViewId.get(viewId);
        if (alivePaths == null) {
            return 0;
        }
        return alivePaths;
    }
}

