/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.tree.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.DummyDesignElement;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathAndDiffSegments;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DHTrimmedTreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;

public class TreePathUtils {
    public static final String DUPLICATE_TREE_PATH_INDICATIOR_PREF = "@(";
    public static final String DUPLICATE_TREE_PATH_INDICATIOR_SUF = ")@";

    public static List<IRfVHBreadcrumbElement> getElementsFromVHPath(TreePath path, boolean includeSelf) {
        List<TreePath> parents;
        ArrayList<IRfVHBreadcrumbElement> result = new ArrayList<IRfVHBreadcrumbElement>();
        Object element = path.getElement();
        if (!(element instanceof IRfVHBreadcrumbElement)) {
            return Collections.emptyList();
        }
        if (includeSelf) {
            result.add((IRfVHBreadcrumbElement)element);
        }
        if ((parents = TreePath.parentsList(path, false)) == null || parents.isEmpty()) {
            return result;
        }
        for (TreePath parent : parents) {
            Object parentElement = parent.getElement();
            if (!(parentElement instanceof IRfVHBreadcrumbElement)) continue;
            result.add((IRfVHBreadcrumbElement)parentElement);
        }
        Collections.reverse(result);
        return result;
    }

    public static List<IRfNamedElement> getElementsFromPath(TreePath path, boolean includeSelf) {
        List<TreePath> parents;
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        Object element = path.getElement();
        if (!(element instanceof IRfNamedElement)) {
            return Collections.emptyList();
        }
        if (includeSelf) {
            result.add((IRfNamedElement)element);
        }
        if ((parents = TreePath.parentsList(path, false)) == null || parents.isEmpty()) {
            return result;
        }
        for (TreePath parent : parents) {
            Object parentElement = parent.getElement();
            if (!(parentElement instanceof IRfNamedElement)) continue;
            result.add((IRfNamedElement)parentElement);
        }
        Collections.reverse(result);
        return result;
    }

    public static List<ElementPath> getELElementsFromPath(TreePath path, boolean includeSelf) {
        LinkedList<ElementPath> result = new LinkedList<ElementPath>();
        ElementPath elementPath = ElementPath.from(path.toString("."), ".");
        if (!includeSelf) {
            elementPath = elementPath.removeLastSegment();
        }
        while (!elementPath.isEmpty()) {
            result.addFirst(ElementPath.join(ElementPath.$ROOT_NAME_PATH, elementPath));
            elementPath = elementPath.removeLastSegment();
        }
        result.addFirst(ElementPath.$ROOT_NAME_PATH);
        return result;
    }

    public static ElementPath getElementPathFromTreePath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        String[] segments = Arrays.copyOf(treePath.getSegments(), treePath.getSegments().length);
        int i = 0;
        while (i < segments.length - 1) {
            String segment = segments[i];
            int indexOf = segment.indexOf(DUPLICATE_TREE_PATH_INDICATIOR_PREF);
            if (indexOf >= 0) {
                segments[i] = segment.substring(0, indexOf);
            }
            ++i;
        }
        return ElementPath.create(segments);
    }

    public static ElementPath getElementPathFromTreePath(TreePath treePath, boolean relativeTo) {
        if (treePath == null) {
            return null;
        }
        if (relativeTo && treePath instanceof DHTrimmedTreePath && ((DHTrimmedTreePath)treePath).getRelativeToPath() != null) {
            TreePath relativeToPath = ((DHTrimmedTreePath)treePath).getRelativeToPath();
            if (relativeToPath == null) {
                return null;
            }
            ElementPath relativeToElementPath = TreePathUtils.getElementPathFromTreePath(relativeToPath);
            ElementPath elementPath = TreePathUtils.getElementPathFromTreePath(treePath);
            String[] segments = Arrays.copyOfRange(elementPath.getSegments(), relativeToElementPath.length() - 1, elementPath.length());
            return ElementPath.create(segments);
        }
        return TreePathUtils.getElementPathFromTreePath(treePath);
    }

    public static String[] getSegmentsFromTreePath(TreePath treePath) {
        return TreePathUtils.getSegmentsFromTreePath(treePath, false);
    }

    public static String[] getSegmentsFromTreePath(TreePath treePath, boolean includeDummyTop) {
        if (treePath == null) {
            return null;
        }
        int length = treePath.getSegments().length;
        if (includeDummyTop && treePath != TreePath.TOP_DUMMY_TREE_PATH) {
            length += TreePath.TOP_DUMMY_TREE_PATH.getSegments().length;
        }
        String[] segments = new String[length];
        if (includeDummyTop && treePath != TreePath.TOP_DUMMY_TREE_PATH) {
            System.arraycopy(TreePath.TOP_DUMMY_TREE_PATH.getSegments(), 0, segments, 0, TreePath.TOP_DUMMY_TREE_PATH.getSegments().length);
        }
        int startFromIndex = includeDummyTop && treePath != TreePath.TOP_DUMMY_TREE_PATH ? TreePath.TOP_DUMMY_TREE_PATH.getSegments().length : 0;
        System.arraycopy(treePath.getSegments(), 0, segments, startFromIndex, treePath.getSegments().length);
        int i = 0;
        while (i < segments.length - 1) {
            String segment = segments[i];
            int indexOf = segment.indexOf(DUPLICATE_TREE_PATH_INDICATIOR_PREF);
            if (indexOf >= 0) {
                segments[i] = segment.substring(0, indexOf);
            }
            ++i;
        }
        return segments;
    }

    public static TreePath getTreePathFromBreadcrumb(List<BreadcrumbSegment> bcSegments, IVHLabelProvider ivhLabelProvider) {
        if (bcSegments == null || bcSegments.isEmpty()) {
            return null;
        }
        String[] segments = (String[])bcSegments.stream().map(bcSegm -> ivhLabelProvider.getText(bcSegm.getElement())).toArray(String[]::new);
        TreePath topTreePath = TreePath.of(null, new String[]{segments[0]}, new int[1]);
        topTreePath.setElement(bcSegments.get(0).getElement());
        if (bcSegments.size() <= 1) {
            return topTreePath;
        }
        TreePath treePath = topTreePath;
        int i = 1;
        while (i < bcSegments.size()) {
            treePath = TreePath.of(topTreePath, Arrays.copyOfRange(segments, 0, i + 1), new int[]{i});
            treePath.setElement(bcSegments.get(i).getElement());
            topTreePath = treePath;
            ++i;
        }
        return treePath;
    }

    public static TreePath getTreePathFromELInstance(TreePath lastComputedTreePath, ELInstance elInstance, ELManager manager, boolean isTrimmedPath, IProgressMonitor monitor) {
        if (elInstance == null || monitor.isCanceled()) {
            return null;
        }
        ElementPath elInstanceHierarchyPath = elInstance.getHierarchyPath();
        TreePathAndDiffSegments commonParentAndRemainingSegments = TreePathUtils.getCommonParentAndDiffSegments(lastComputedTreePath, elInstanceHierarchyPath);
        TreePath commonParent = commonParentAndRemainingSegments.getTreePath();
        String[] diffSegments = commonParentAndRemainingSegments.getDiffSegments();
        TreePath result = null;
        if (diffSegments != null && diffSegments.length != 0) {
            TreePath lastParent = commonParent;
            String[] stringArray = diffSegments;
            int n = diffSegments.length;
            int n2 = 0;
            while (n2 < n) {
                String diffSegment = stringArray[n2];
                if (lastParent != null) {
                    TreePath currTreePath;
                    String[] lastParentSegments = lastParent == TreePath.TOP_DUMMY_TREE_PATH ? null : lastParent.getSegments();
                    String[] currPathSegments = TreePathUtils.addSegment(lastParentSegments, diffSegment);
                    ElementPath currSegmentPath = ElementPath.create(currPathSegments);
                    ELInstance currParentElInstance = manager.getMemory().instanceFor(currSegmentPath);
                    result = currTreePath = TreePathUtils.createTreePathFromElInstance(lastParent, currParentElInstance, isTrimmedPath);
                    lastParent = currTreePath;
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            result = commonParent;
        }
        return result;
    }

    private static String[] addSegment(String[] segments, String toAdd) {
        String[] result = null;
        if (segments == null || segments.length == 0) {
            result = new String[]{toAdd};
        } else {
            result = new String[segments.length + 1];
            System.arraycopy(segments, 0, result, 0, segments.length);
            result[segments.length] = toAdd;
        }
        return result;
    }

    private static TreePathAndDiffSegments getCommonParentAndDiffSegments(TreePath treePath, ElementPath elementPath) {
        if (treePath == null) {
            return new TreePathAndDiffSegments(TreePath.TOP_DUMMY_TREE_PATH, elementPath.getSegments());
        }
        String[] diffSegments = null;
        TreePath commonParent = null;
        String[] treePathSegments = treePath.getSegments();
        String[] elementPathSegments = elementPath.getSegments();
        int commonParentIndex = -1;
        int i = 0;
        while (i < treePathSegments.length) {
            if (i >= elementPathSegments.length) break;
            if (!treePathSegments[i].equals(elementPathSegments[i])) {
                diffSegments = new String[elementPathSegments.length - i];
                System.arraycopy(elementPathSegments, i, diffSegments, 0, elementPathSegments.length - i);
                break;
            }
            if (i == treePathSegments.length - 1 && i < elementPathSegments.length) {
                diffSegments = new String[elementPathSegments.length - i - 1];
                System.arraycopy(elementPathSegments, i + 1, diffSegments, 0, elementPathSegments.length - i - 1);
            }
            ++commonParentIndex;
            ++i;
        }
        if (commonParentIndex >= 0) {
            List<TreePath> parents = TreePath.parentsList(treePath, false);
            commonParent = commonParentIndex < parents.size() ? parents.get(parents.size() - 1 - commonParentIndex) : treePath;
        }
        if (commonParent == null) {
            commonParent = TreePath.TOP_DUMMY_TREE_PATH;
        }
        return new TreePathAndDiffSegments(commonParent, diffSegments);
    }

    public static TreePath createTreePathFromElInstance(TreePath parent, ELInstance elInstance, boolean isTrimmedPath) {
        if (elInstance == null || parent == null) {
            return null;
        }
        IRfNamedElement binding = elInstance.getBinding(false);
        String elPathSegment = elInstance.getHierarchyPath().lastSegment();
        if (binding == ELConstants.RECURRENCE_INSTANCE_TYPE) {
            TreePath reccurenceNode = TreePath.child(parent, elPathSegment, 0);
            reccurenceNode.setElement(DummyElement.RECURRENCE_NODE);
            return reccurenceNode;
        }
        IRfNamedElement elInstanceRfElement = elInstance.getDescription() instanceof DummyInstance ? binding : elInstance.getDescription();
        TreePath parentRelativeToPath = parent instanceof DHTrimmedTreePath ? ((DHTrimmedTreePath)parent).getRelativeToPath() : null;
        TreePath elInstanceTreePath = isTrimmedPath ? DHTrimmedTreePath.child(parent, elPathSegment, 0, parentRelativeToPath) : TreePath.child(parent, elPathSegment, 0);
        elInstanceTreePath.setElement(elInstanceRfElement);
        return elInstanceTreePath;
    }

    public static TreePath getElabTopTrimmedTreePath(IProject iproject, IRfNamedElement topNamedElement) {
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(iproject, false);
        if (mixedLangProject == null) {
            return null;
        }
        TreePath top = null;
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        IRfDesignElement topDesignElement = DesignUtils.getDesign(DesignUtils.DesignRequest.of(topNamedElement));
        IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(topDesignElement);
        if (designKind == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || designKind == IRfNamedElement.ElementKind.VHDL_CONFIGURATION) {
            topDesignElement = ((IRfEntityComplement)((Object)topDesignElement)).getEntity();
        }
        if (topDesignElement == null) {
            return null;
        }
        IELMemory memory = manager.getMemory();
        ELInstance topInstance = memory.instanceFor(ElementPath.from(topDesignElement.elementPathName(), "."));
        if (topInstance != null) {
            TreePath topPathCandidate;
            top = topPathCandidate = TreePathUtils.getTreePathFromELInstance(null, topInstance, manager, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            List<ElementPath> instancePathsFor = memory.getInstancePathsFor(topDesignElement, 1);
            if (instancePathsFor != null && !instancePathsFor.isEmpty()) {
                ElementPath elementPath = instancePathsFor.get(0);
                ELInstance elInstance = memory.instanceFor(elementPath);
                top = DHTrimmedTreePath.of(TreePath.TOP_DUMMY_TREE_PATH, new String[]{topNamedElement.getName()}, new int[1], null, null);
                top.setElement(topNamedElement);
                ((DHTrimmedTreePath)top).setRelativeToPath(top);
                if (elInstance == null) {
                    return top;
                }
                TreePath topPathCandidate = TreePathUtils.getTreePathFromELInstance(null, elInstance, manager, true, (IProgressMonitor)new NullProgressMonitor());
                if (topPathCandidate == null) {
                    return top;
                }
                ((DHTrimmedTreePath)topPathCandidate).setRelativeToPath(topPathCandidate);
                TreePath parent = topPathCandidate;
                while ((parent = parent.getParent()) != null) {
                    if (parent == TreePath.TOP_DUMMY_TREE_PATH || !(parent instanceof DHTrimmedTreePath)) continue;
                    ((DHTrimmedTreePath)parent).setRelativeToPath(topPathCandidate);
                }
                top = topPathCandidate;
            }
        }
        return top;
    }

    public static TreePath computeTreePathFromBreadrumbElementPath(ElementPath path, IProject project) {
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        String[] pathSegments = path.getSegments();
        TreePath lastParent = TreePath.TOP_DUMMY_TREE_PATH;
        int i = 0;
        while (i < pathSegments.length) {
            TreePath currPath;
            String[] newSegments = new String[i + 1];
            System.arraycopy(pathSegments, 0, newSegments, 0, i + 1);
            lastParent = currPath = TreePathUtils.createTreePathFromElInstance(lastParent, manager.getMemory().instanceFor(ElementPath.create(newSegments)), false);
            ++i;
        }
        return lastParent;
    }

    public static ElementPath getTopParentElementPath(TreePath path, boolean relativeTo) {
        if (path == null) {
            return null;
        }
        List<TreePath> parentsList = TreePath.parentsList(path, relativeTo);
        if (parentsList == null || parentsList.isEmpty()) {
            return TreePathUtils.getElementPathFromTreePath(path);
        }
        TreePath topParent = parentsList.get(parentsList.size() - 1);
        if (topParent == null) {
            return null;
        }
        return TreePathUtils.getElementPathFromTreePath(topParent);
    }

    public static TreePath restorePathsStartingFromRootPath(TreePath rootTreePath, List<TreePath> tops, Set<TreePath> pathsToRestoreCopy, Set<TreePath> restoredPaths, IDVTLazyView lazyView, IProgressMonitor monitor) {
        if (rootTreePath == null || tops == null || monitor.isCanceled()) {
            return null;
        }
        List<TreePath> parentsList = TreePath.parentsList(rootTreePath, true);
        if (parentsList == null) {
            return null;
        }
        Collections.reverse(parentsList);
        parentsList.add(rootTreePath);
        TreePath firstParent = parentsList.get(0);
        int indexOfFirstParentInTop = tops.indexOf(firstParent);
        if (indexOfFirstParentInTop < 0) {
            return null;
        }
        TreePath firstPathRestored = tops.get(indexOfFirstParentInTop);
        ArrayList<TreePath> remainigParents = parentsList.size() == 1 ? Collections.emptyList() : new ArrayList<TreePath>(parentsList.subList(1, parentsList.size()));
        return TreePathUtils.restorePathsStartingFromRootPathRecursively(firstPathRestored, remainigParents, restoredPaths, pathsToRestoreCopy, lazyView, monitor);
    }

    private static TreePath restorePathsStartingFromRootPathRecursively(TreePath currentParent, List<TreePath> remainingParents, Set<TreePath> restoredTogglePaths, Set<TreePath> toggleStatePathsCopy, IDVTLazyView lazyView, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        if (remainingParents == null || remainingParents.isEmpty()) {
            return currentParent;
        }
        IDVTModel dvtModel = lazyView.getModel(IModel.class);
        if (!(dvtModel instanceof IModel)) {
            return null;
        }
        IModel model = (IModel)dvtModel;
        List<TreePath> children = model.getChildren(currentParent, 0, Integer.MAX_VALUE, monitor);
        if (children == null || children.isEmpty()) {
            return null;
        }
        ArrayList<TreePath> childrenCopy = new ArrayList<TreePath>(children);
        childrenCopy.retainAll(toggleStatePathsCopy);
        restoredTogglePaths.addAll(childrenCopy);
        toggleStatePathsCopy.removeAll(childrenCopy);
        TreePath searchedPath = remainingParents.get(0);
        int indexOfSearchedPathInChildren = children.indexOf(searchedPath);
        if (indexOfSearchedPathInChildren < 0) {
            return null;
        }
        remainingParents.remove(0);
        return TreePathUtils.restorePathsStartingFromRootPathRecursively(children.get(indexOfSearchedPathInChildren), remainingParents, restoredTogglePaths, toggleStatePathsCopy, lazyView, monitor);
    }

    public static List<BreadcrumbSegment> getAllElementsToRoot(TreePath treePath, boolean addSelf, boolean forVH) {
        if (treePath == null) {
            return null;
        }
        Object element = treePath.getElement();
        if (element instanceof IXXVMComponent) {
            IXXVMComponent parentXVMComponent = (IXXVMComponent)element;
            ArrayList<BreadcrumbSegment> elementsList = new ArrayList<BreadcrumbSegment>();
            if (addSelf) {
                TreePathUtils.addSegment(parentXVMComponent, elementsList, forVH);
            }
            TreePath parentTreePath = treePath.getParent();
            while (parentTreePath != null) {
                Object elementTreePath = parentTreePath.getElement();
                if (!(elementTreePath instanceof IXXVMComponent)) {
                    if (elementTreePath == null || elementTreePath instanceof DummyDesignElement || element instanceof ErrorDesignElement) {
                        Collections.reverse(elementsList);
                        return elementsList;
                    }
                    return null;
                }
                TreePathUtils.addSegment((IRfBreadcrumbElement)elementTreePath, elementsList, forVH);
                parentXVMComponent = (IXXVMComponent)elementTreePath;
                parentTreePath = parentTreePath.getParent();
            }
            Collections.reverse(elementsList);
            return elementsList;
        }
        if (!(element instanceof IRfBreadcrumbElement)) {
            return null;
        }
        IRfBreadcrumbElement currentElement = (IRfBreadcrumbElement)element;
        ArrayList<BreadcrumbSegment> elementsList = new ArrayList<BreadcrumbSegment>();
        if (addSelf) {
            TreePathUtils.addSegment(currentElement, elementsList, forVH);
        }
        TreePath parentWrapper = treePath.getParent();
        while (parentWrapper != null) {
            currentElement = (IRfBreadcrumbElement)parentWrapper.getElement();
            if (currentElement == null || currentElement instanceof DummyDesignElement || element instanceof ErrorDesignElement) {
                if (elementsList.isEmpty()) {
                    TreePathUtils.addSegment(currentElement, elementsList, forVH);
                }
                Collections.reverse(elementsList);
                return elementsList;
            }
            TreePathUtils.addSegment(currentElement, elementsList, forVH);
            parentWrapper = parentWrapper.getParent();
        }
        Collections.reverse(elementsList);
        if (elementsList.isEmpty()) {
            TreePathUtils.addSegment(currentElement, elementsList, forVH);
        }
        return elementsList;
    }

    private static void addSegment(IRfBreadcrumbElement currentElement, List<BreadcrumbSegment> elementsList, boolean forVH) {
        if (!forVH) {
            elementsList.add(new BreadcrumbSegment(currentElement));
            return;
        }
        if (currentElement instanceof IRfNamedElement) {
            currentElement = (IRfBreadcrumbElement)((Object)((IRfNamedElement)currentElement).getDeclaration());
        }
        elementsList.add(new BreadcrumbSegment(currentElement));
    }
}

