/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTSelectionChangedEvent;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.MenuCommandInstaller;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeExpandCollapseActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewCommon;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyViewCommon;

public abstract class DVTLazyView
extends DVTLazyViewCommon
implements IPropertyChangeListener {
    protected static final String DEFAULT_FILTER_HELPER_TEXT = "Filter by: hierarchical name .port";
    private static final String SELECT_TOP_MESSAGE = "You have not yet selected a top.";
    private LazyTree lazyTree;
    private ListenerList<ISelectionChangedListener> fSelectionChangedListeners = new ListenerList();
    private Map<String, TextFilterObject> fTextFilters = new HashMap<String, TextFilterObject>();
    private Text selectRootTextBox;
    private Composite textBoxComposite;
    private Composite buttonComposite;
    private Label selectTopTextBox;
    private Button selectTopButton;

    @Override
    public void updateLabels(EnumSet<TreeViewContentProvider.LabelUpdateKind> labelUpdateKind) {
        if (this.lazyTree == null) {
            return;
        }
        this.lazyTree.doAction(LazyTreeAction.UPDATE_LABELS, new LazyTreeActionArguments(this.getObjection()));
    }

    public void createPartControl(Composite parent) {
        this.createViewSpecificPartControl(parent);
        this.lazyTree.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DVTLazyView.this.gotoSelectedElement("default-tree");
            }
        });
        MenuManager menuManager = this.installContextMenu();
        if (menuManager == null) {
            return;
        }
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DVTLazyView.this.createCustomContextMenu(manager);
            }
        });
        this.createCustomContextMenu((IMenuManager)menuManager);
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().registerView(this);
    }

    @Override
    public LazyTree getLazyTree() {
        return this.lazyTree;
    }

    public void setLazyTree(LazyTree lazyTree) {
        this.lazyTree = lazyTree;
    }

    public void setFocus() {
        this.lazyTree.getTree().setFocus();
    }

    public ListenerList getSelectionChangedListeners() {
        return this.fSelectionChangedListeners;
    }

    public void setSelectionChangedListeners(ListenerList selectionChangedListeners) {
        this.fSelectionChangedListeners = selectionChangedListeners;
    }

    public ISelection getSelection() {
        if (this.lazyTree == null) {
            return null;
        }
        ArrayList<IDVTElementWrapper> list = new ArrayList<IDVTElementWrapper>();
        TreeItem[] treeItemArray = this.lazyTree.getTreeItemSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            TreeItem i = treeItemArray[n2];
            if (i.getData() != null && (data = i.getData()) instanceof TreePath) {
                IDVTElementWrapper wrapper;
                Object element = ((TreePath)data).getElement();
                if (element instanceof IDVTElementWrapper) {
                    wrapper = (IDVTElementWrapper)element;
                } else {
                    DVTPFModel pfModel;
                    wrapper = new DVTTreeElementWrapper(element);
                    wrapper.setProject(this.getProject());
                    TreePath parent = ((TreePath)data).getParent();
                    if (parent != null && parent.equals(TreePath.TOP_DUMMY_TREE_PATH)) {
                        wrapper.setParent(new DVTTreeElementWrapper(parent));
                    }
                    if ((pfModel = DVTPFUtils.getUpfModel(this.getProject())) != null && pfModel.hasPowerDomains()) {
                        String path = ((TreePath)data).toString("/");
                        String pfInfo = pfModel.getPDNameForPath(ElementPath.from(path, "/"));
                        wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.POWER_DOMAIN_NAME, pfInfo);
                    }
                }
                wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TREE_PATH, data);
                list.add(wrapper);
            }
            ++n2;
        }
        return new StructuredSelection(list.toArray());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    protected TextFilterObject getTextFilterObject(String textFilterId) {
        if (textFilterId == null) {
            return null;
        }
        if (this.fTextFilters == null) {
            return null;
        }
        return this.fTextFilters.get(textFilterId);
    }

    public void init(IViewSite site) throws PartInitException {
        site.setSelectionProvider((ISelectionProvider)this);
        super.init(site);
    }

    private MenuManager installContextMenu() {
        Tree control = this.getLazyTree().getTree();
        if (control == null || control.isDisposed()) {
            return null;
        }
        control.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DVTLazyView.this.fireSelectionChanged(new DVTSelectionChangedEvent(DVTLazyView.this, DVTLazyView.this.getSelection(), event));
            }
        });
        control.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent event) {
            }

            public void focusGained(FocusEvent event) {
                DVTLazyView.this.fireSelectionChanged(new DVTSelectionChangedEvent(DVTLazyView.this, DVTLazyView.this.getSelection(), null));
            }
        });
        return MenuCommandInstaller.installContextMenu((IWorkbenchPart)this, (Control)control);
    }

    @Override
    public void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts) {
        this.createTextFilter(textFilterId, parent, treeId, searchForPorts, null);
    }

    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts, List<String> quickSearchPreferences) {
        this.fTextFilters.put(textFilterId, new TextFilterObject(this, textFilterId, parent, treeId, searchForPorts, quickSearchPreferences));
    }

    public Text getTextFilter(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        Text textFilter = textFilterObject.getTextFilter();
        if (textFilter.isDisposed()) {
            return null;
        }
        return textFilter;
    }

    @Override
    public void setFocusOnTree(String treeId) {
        Tree tree = this.getLazyTree().getTree();
        if (tree == null) {
            return;
        }
        tree.setFocus();
    }

    public Text createNewTextFilter(Composite parent) {
        this.createTextFilter("default-filter", parent, "default-tree", true);
        return this.getTextFilter("default-filter");
    }

    @Override
    public void swapToMessageComposite() {
        Display.getDefault().syncExec(() -> {
            String selectRootTextBoxMessage;
            LazyTree lazyTree = this.getLazyTree();
            Composite stackComposite = lazyTree.getStackComposite();
            if (stackComposite == null || stackComposite.isDisposed()) {
                return;
            }
            Layout layout = stackComposite.getLayout();
            if (!(layout instanceof StackLayout)) {
                return;
            }
            if (this.textBoxComposite == null || this.textBoxComposite.isDisposed() || this.selectRootTextBox == null || this.selectRootTextBox.isDisposed()) {
                this.textBoxComposite = new Composite(stackComposite, 16);
                GridLayout textBox = new GridLayout();
                textBox.marginBottom = 0;
                textBox.marginHeight = 0;
                textBox.marginLeft = 0;
                textBox.marginRight = 0;
                textBox.marginTop = 0;
                textBox.marginWidth = 0;
                this.textBoxComposite.setLayout((Layout)textBox);
                GridData textBoxCompositeGridData = new GridData(4, 4, true, true);
                this.textBoxComposite.setLayoutData((Object)textBoxCompositeGridData);
                this.selectRootTextBox = new Text(this.textBoxComposite, 74);
                GridData textBoxGridData = new GridData(4, 4, true, true);
                this.selectRootTextBox.setLayoutData((Object)textBoxGridData);
            }
            if ((selectRootTextBoxMessage = this.getMessageText()) != null) {
                this.selectRootTextBox.setText(selectRootTextBoxMessage);
            }
            ((StackLayout)layout).topControl = this.textBoxComposite;
            stackComposite.layout();
        });
    }

    @Override
    public void swapToButtonComposite() {
        Display.getDefault().syncExec(() -> {
            IProject project;
            LazyTree lazyTree = this.getLazyTree();
            Composite stackComposite = lazyTree.getStackComposite();
            if (stackComposite == null || stackComposite.isDisposed()) {
                return;
            }
            Layout layout = stackComposite.getLayout();
            if (!(layout instanceof StackLayout)) {
                return;
            }
            if (this.buttonComposite == null || this.buttonComposite.isDisposed() || this.selectTopTextBox == null || this.selectTopTextBox.isDisposed()) {
                this.buttonComposite = new Composite(stackComposite, 16);
                GridLayout textBox = new GridLayout();
                textBox.marginBottom = 0;
                textBox.marginHeight = 0;
                textBox.marginLeft = 0;
                textBox.marginRight = 0;
                textBox.marginTop = 0;
                textBox.marginWidth = 0;
                this.buttonComposite.setLayout((Layout)textBox);
                GridData textBoxCompositeGridData = new GridData(4, 4, true, false);
                this.buttonComposite.setLayoutData((Object)textBoxCompositeGridData);
                this.selectTopTextBox = new Label(this.buttonComposite, 72);
                GridData textBoxGridData = new GridData(4, 16384, true, false);
                this.selectTopTextBox.setLayoutData((Object)textBoxGridData);
                this.selectTopButton = new Button(this.buttonComposite, 8);
                this.selectTopButton.setText("Select Top");
                GridData layoutData = new GridData(16384, 16384, true, false);
                layoutData.heightHint = 30;
                layoutData.widthHint = 240;
                layoutData.horizontalIndent = 10;
                this.selectTopButton.setLayoutData((Object)layoutData);
                this.selectTopButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        DVTLazyView.this.selectTop();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
            if ((project = this.getProject()) == null) {
                this.selectRootTextBox.setEnabled(false);
            } else if (this instanceof VerificationHierarchyViewCommon) {
                this.selectTopButton.setEnabled(VHViewUtils.hasAnySelectTopNature(this.getProject()));
            } else {
                this.selectTopButton.setEnabled(true);
            }
            this.selectTopTextBox.setText(SELECT_TOP_MESSAGE);
            ((StackLayout)layout).topControl = this.buttonComposite;
            stackComposite.layout();
        });
    }

    @Override
    public void swapToTreeComposite() {
        Display.getDefault().syncExec(() -> {
            LazyTree lazyTree = this.getLazyTree();
            Composite stackComposite = lazyTree.getStackComposite();
            if (stackComposite == null || stackComposite.isDisposed()) {
                return;
            }
            Layout layout = stackComposite.getLayout();
            if (!(layout instanceof StackLayout)) {
                return;
            }
            ((StackLayout)layout).topControl = lazyTree.getTableAndTreeComposite();
            stackComposite.layout();
        });
    }

    protected KeyAdapter getKeyListener(String filterTextId, String treeId) {
        return new CustomKeyAdapter(filterTextId, treeId);
    }

    public void dispose() {
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        for (TextFilterObject textFilter : this.fTextFilters.values()) {
            textFilter.dispose();
        }
        this.fTextFilters.clear();
        this.fTextFilters = null;
        this.removeSelectionChangedListener(InspectViewSelectionListener.getInstance());
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        IDVTModel model = this.getModel(IDVTModel.class);
        if (model != null) {
            model.clearModelCaches();
        }
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAR_CACHE, new LazyTreeActionArguments(this.getObjection()));
        }
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    protected abstract void createViewSpecificPartControl(Composite var1);

    protected abstract void createCustomContextMenu(IMenuManager var1);

    class CustomKeyAdapter
    extends KeyAdapter {
        private final String fFilterObjectId;
        private final String fTreeId;

        public CustomKeyAdapter(String filterObjectId, String treeId) {
            this.fFilterObjectId = filterObjectId;
            this.fTreeId = treeId;
        }

        public String getFilterObjectId() {
            return this.fFilterObjectId;
        }

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                DVTLazyView.this.gotoSelectedElement(this.fTreeId);
            } else if (event.keyCode == 8) {
                TextFilterObject textFilterObject = DVTLazyView.this.fTextFilters.get(this.fFilterObjectId);
                if (textFilterObject == null) {
                    return;
                }
                Text filterText = textFilterObject.getTextFilter();
                if (filterText == null) {
                    return;
                }
                String currentText = filterText.getText();
                filterText.setFocus();
                filterText.setText(currentText.substring(0, Math.max(0, currentText.length() - 1)));
                filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
            } else if (event.character != '\u0000' && (Character.isJavaIdentifierPart(event.character) && event.keyCode != 27 && event.keyCode != 127 || event.character == '*' || event.character == '.' || event.character == '?')) {
                if (event.character != (char)event.keyCode) {
                    return;
                }
                TextFilterObject textFilterObject = DVTLazyView.this.fTextFilters.get(this.fFilterObjectId);
                if (textFilterObject == null) {
                    return;
                }
                Text filterText = textFilterObject.getTextFilter();
                if (filterText == null) {
                    return;
                }
                filterText.setText(String.valueOf(filterText.getText()) + event.character);
                filterText.setFocus();
                filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
            } else if (event.keyCode == 0x1000003) {
                ISelection selection = DVTLazyView.this.getSelection();
                if (selection == null || !(selection instanceof StructuredSelection)) {
                    return;
                }
                Object selectedElement = ((StructuredSelection)selection).getFirstElement();
                if (!(selectedElement instanceof DVTTreeElementWrapper)) {
                    return;
                }
                Object selectedTreePath = ((DVTTreeElementWrapper)selectedElement).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
                if (!(selectedTreePath instanceof TreePath)) {
                    return;
                }
                DVTLazyView.this.getLazyTree().doAction(LazyTreeAction.COLLAPSE, new LazyTreeExpandCollapseActionArguments((TreePath)selectedTreePath, Objection.LAZY_TREE_COLLAPSE));
            } else if (event.keyCode == 0x1000004) {
                ISelection selection = DVTLazyView.this.getSelection();
                if (selection == null || !(selection instanceof StructuredSelection)) {
                    return;
                }
                Object selectedElement = ((StructuredSelection)selection).getFirstElement();
                if (!(selectedElement instanceof DVTTreeElementWrapper)) {
                    return;
                }
                Object selectedTreePath = ((DVTTreeElementWrapper)selectedElement).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
                if (!(selectedTreePath instanceof TreePath)) {
                    return;
                }
                DVTLazyView.this.getLazyTree().doAction(LazyTreeAction.EXPAND, new LazyTreeExpandCollapseActionArguments((TreePath)selectedTreePath, Objection.LAZY_TREE_EXPAND));
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

