/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class DVTLazyViewUtils {
    public static final GridLayout LAYOUT = new GridLayout(1, true);
    public static final GridLayout TWO_PART_LAYOUT;
    public static final List<String> ALL_LAZY_VIEWS;

    static {
        DVTLazyViewUtils.LAYOUT.marginWidth = 0;
        DVTLazyViewUtils.LAYOUT.marginHeight = 0;
        DVTLazyViewUtils.LAYOUT.verticalSpacing = 0;
        TWO_PART_LAYOUT = new GridLayout(2, false);
        DVTLazyViewUtils.TWO_PART_LAYOUT.marginWidth = 0;
        DVTLazyViewUtils.TWO_PART_LAYOUT.marginHeight = 0;
        DVTLazyViewUtils.TWO_PART_LAYOUT.verticalSpacing = 0;
        ALL_LAZY_VIEWS = Arrays.asList("ro.amiq.dvt.ui.views.TypesView", "ro.amiq.dvt.ui.views.CompileOrderView", "ro.amiq.dvt.ui.views.LazyDesignHierarchyView", "ro.amiq.dvt.ui.views.VerificationHierarchyView", "ro.amiq.dvt.ui.views.MacrosView", "ro.amiq.dvt.ui.views.PowerDomainView");
    }

    public static TreePath getPrevSelectionFromTree(Tree tree) {
        TreeItem[] treeSelection = tree.getSelection();
        if (treeSelection.length == 0) {
            return null;
        }
        TreeItem[] items = tree.getItems();
        if (items == null || items.length == 0) {
            return null;
        }
        TreeItem selection = treeSelection[0];
        List<TreeItem> allTreeItems = DVTLazyViewUtils.getAllTreeItems(tree);
        if (allTreeItems == null || allTreeItems.isEmpty() || !allTreeItems.contains(selection)) {
            return null;
        }
        int indexOfSelection = allTreeItems.indexOf(selection);
        if (indexOfSelection >= 0 && indexOfSelection - 1 >= 0) {
            int i = 1;
            while (indexOfSelection - i >= 0) {
                TreeItem treeItem = allTreeItems.get(indexOfSelection - i);
                if (treeItem != null && treeItem.getData() instanceof TreePath) {
                    return (TreePath)treeItem.getData();
                }
                ++i;
            }
        }
        return null;
    }

    public static TreePath getNextSelectionFromTree(Tree tree) {
        TreeItem[] treeSelection = tree.getSelection();
        if (treeSelection.length == 0) {
            return null;
        }
        TreeItem selection = treeSelection[0];
        TreeItem[] items = tree.getItems();
        if (items == null || items.length == 0) {
            return null;
        }
        List<TreeItem> allTreeItems = DVTLazyViewUtils.getAllTreeItems(tree);
        if (allTreeItems == null || allTreeItems.isEmpty() || !allTreeItems.contains(selection)) {
            return null;
        }
        int indexOfSelection = allTreeItems.indexOf(selection);
        if (indexOfSelection >= 0 && indexOfSelection + 1 < allTreeItems.size()) {
            int i = 1;
            while (i + indexOfSelection < allTreeItems.size()) {
                TreeItem treeItem = allTreeItems.get(indexOfSelection + i);
                if (treeItem != null && treeItem.getData() instanceof TreePath) {
                    return (TreePath)treeItem.getData();
                }
                ++i;
            }
        }
        return null;
    }

    private static List<TreeItem> getAllTreeItems(Tree tree) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        TreeItem[] items = tree.getItems();
        if (items == null || items.length == 0) {
            return null;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getText() != null && !item.getText().isEmpty()) {
                result.add(item);
                TreeItem[] childrenItems = item.getItems();
                if (items != null && items.length != 0) {
                    DVTLazyViewUtils.getAllItemsInternal(childrenItems, result);
                }
            }
            ++n2;
        }
        return result;
    }

    private static void getAllItemsInternal(TreeItem[] items, List<TreeItem> result) {
        if (items == null || items.length == 0) {
            return;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            result.add(item);
            TreeItem[] childrenItems = item.getItems();
            if (items != null && items.length != 0) {
                DVTLazyViewUtils.getAllItemsInternal(childrenItems, result);
            }
            ++n2;
        }
    }
}

