/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.TreeItem;

public interface IDVTLazyViewStyledCellLabelProvider
extends IBaseLabelProvider {
    public static final Rule COLON = new OneCharRule(){

        @Override
        public int getChar() {
            return 58;
        }
    };
    public static final Rule BRACKETS = new TwoCharsRule(){

        @Override
        public int getChar1() {
            return 91;
        }

        @Override
        public int getChar2() {
            return 93;
        }
    };

    default public Rule getStylingRule(Object wrapper) {
        return COLON;
    }

    default public StyleRange[] getStyleRanges(TreeItem treeItem) {
        Rule rule = this.getStylingRule(treeItem);
        if (rule == null) {
            return null;
        }
        String text = treeItem.getText();
        StyledString styledString = new StyledString(text, null);
        IRegion region = rule.getRegion(text);
        if (region == null) {
            return null;
        }
        if (region.getOffset() < 0 || region.getLength() == 0 || region.getOffset() + region.getLength() > text.length()) {
            return null;
        }
        styledString.setStyle(region.getOffset(), region.getLength(), rule.getStyler());
        return styledString.getStyleRanges();
    }

    public static abstract class OneCharRule
    extends Rule {
        @Override
        public IRegion getRegion(String text) {
            int offset = text.indexOf(this.getChar());
            if (offset == -1) {
                return null;
            }
            return new Region(offset, text.length() - offset);
        }

        public abstract int getChar();
    }

    public static abstract class Rule {
        public abstract IRegion getRegion(String var1);

        public StyledString.Styler getStyler() {
            return StyledString.QUALIFIER_STYLER;
        }
    }

    public static abstract class TwoCharsRule
    extends Rule {
        @Override
        public IRegion getRegion(String text) {
            int offset1 = -1;
            int offset2 = -1;
            offset1 = text.indexOf(this.getChar1());
            offset2 = text.indexOf(this.getChar2());
            if (offset1 == -1 || offset2 == -1 || offset1 >= offset2) {
                return null;
            }
            return new Region(offset1, offset2 - offset1 + 1);
        }

        public abstract int getChar1();

        public abstract int getChar2();
    }
}

