/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.compileorder;

import antlr.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BCDvtInit;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.LanguageElementFileInstance;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.views.BCCompileOrderViewContributor;
import ro.amiq.dvt.model.reflection.views.BCTreeElementWrapper;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.ui.views.compileorder.ICompileOrderViewContributor;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public abstract class BCCompileOrderModelCommon
implements IModel {
    public static final String DEFAULT_FILTER_ID = "default-filter";
    private List<IDVTElementWrapper> allFiles = new ArrayList<IDVTElementWrapper>();
    ICompileOrderViewContributor bcContributor = new BCCompileOrderViewContributor();
    public IRfFilterableTreeAccessor compileOrderView;
    private Map<String, BCFileInstance> parsedBCFiles = new HashMap<String, BCFileInstance>();
    private DVTBaseLabelProvider labelProvider;
    private boolean showBuildConfigArgFiles;
    private boolean hasGUIFilteredElements;
    private boolean hasSearchedElementFiltered;
    private IProject project;
    private int elementCount;
    private int notFilteredElementCount;
    private String tableInfo;
    private int fBCIndex;
    private static final Comparator<IDVTElementWrapper> CompileIndexComparator = (w1, w2) -> {
        if (w1 == null || w2 == null || !(w1 instanceof BCTreeElementWrapper) || !(w2 instanceof BCTreeElementWrapper)) {
            return -1;
        }
        BCTreeElementWrapper elem1 = (BCTreeElementWrapper)w1;
        BCTreeElementWrapper elem2 = (BCTreeElementWrapper)w2;
        if (!elem1.getParent().equals(elem2.getParent())) {
            return -1;
        }
        Object rfElement1 = w1.getRfElement();
        Object rfElement2 = w2.getRfElement();
        if (rfElement1 instanceof BCDvtInit && rfElement2 instanceof BCDvtInit) {
            return ((BCDvtInit)rfElement1).getInvocNumber() - ((BCDvtInit)rfElement2).getInvocNumber();
        }
        if (rfElement1 instanceof BCDvtInit && rfElement2 instanceof BCFileInstance) {
            return ((BCDvtInit)rfElement1).getOffset() - ((BCFileInstance)rfElement2).getOffset();
        }
        if (rfElement1 instanceof BCFileInstance && rfElement2 instanceof BCDvtInit) {
            return ((BCFileInstance)rfElement1).getOffset() - ((BCDvtInit)rfElement2).getOffset();
        }
        if (rfElement1 instanceof BCFileInstance && rfElement2 instanceof BCFileInstance) {
            return ((BCFileInstance)rfElement1).getIndex() - ((BCFileInstance)rfElement2).getIndex();
        }
        if (rfElement1 instanceof LanguageElementFileInstance && rfElement2 instanceof LanguageElementFileInstance) {
            return -((LanguageElementFileInstance)rfElement1).getLanguageKind().ordinal() + ((LanguageElementFileInstance)rfElement2).getLanguageKind().ordinal();
        }
        return 0;
    };
    public static final Comparator<TreePath> TreePathComparator = (t1, t2) -> {
        if (t1 == null || t2 == null) {
            return 0;
        }
        if (TreePath.isParent(t1, t2)) {
            return -1;
        }
        if (TreePath.isParent(t2, t1)) {
            return 1;
        }
        Object w1 = t1.getElement();
        Object w2 = t2.getElement();
        if (!(w1 instanceof IDVTElementWrapper) || !(w2 instanceof IDVTElementWrapper)) {
            return -1;
        }
        Object f1 = ((IDVTElementWrapper)w1).getRfElement();
        Object f2 = ((IDVTElementWrapper)w2).getRfElement();
        if (!(f1 instanceof IDVTFileInstance) || !(f2 instanceof IDVTFileInstance)) {
            return -1;
        }
        return CompileIndexComparator.compare((IDVTElementWrapper)w1, (IDVTElementWrapper)w2);
    };

    protected BCCompileOrderModelCommon(DVTBaseLabelProvider labelProvider, IProject project, IRfFilterableTreeAccessor view, boolean showBuildConfigArgFiles) {
        this.labelProvider = labelProvider;
        this.project = project;
        this.showBuildConfigArgFiles = showBuildConfigArgFiles;
        this.tableInfo = "";
        this.compileOrderView = view;
    }

    private List<IDVTElementWrapper> computeAllElements(CompileOrderViewInputConfigurator inputSourceConfigurator) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        this.notFilteredElementCount = 0;
        this.tableInfo = "";
        this.hasGUIFilteredElements = false;
        this.hasSearchedElementFiltered = false;
        CompileOrderViewInput input = this.bcContributor.getInput(inputSourceConfigurator);
        this.hasGUIFilteredElements = this.hasGUIFilteredElements() || input.hasGUIFilteredElements();
        this.hasSearchedElementFiltered = this.hasSearchedElementFiltered || input.hasSearchedElementFiltered();
        List<IDVTElementWrapper> inputElements = input.getElements();
        if (inputElements == null) {
            return result;
        }
        this.elementCount = input.getElementCount();
        this.notFilteredElementCount = this.getNotFilteredElementCount() + input.getNotFilteredElementCount();
        this.tableInfo = input.getTableInfo();
        result.addAll(inputElements);
        Collections.sort(result, CompileIndexComparator);
        return result;
    }

    public void recompute(IProject project, boolean showBuildConfigArgFiles, StringMatcher[] searchSegments, boolean[] searchTextStrictness) {
        this.setElementCount(0);
        this.allFiles.clear();
        this.setShowBuildConfigArgFiles(showBuildConfigArgFiles);
        this.allFiles.addAll(this.computeAllElements(new CompileOrderViewInputConfigurator(project, searchSegments, searchTextStrictness, ViewsUtils.hasMoreThanOneDVTNature(project), false, this.compileOrderView, this.parsedBCFiles)));
    }

    @Override
    public void clearModelCaches() {
        this.parsedBCFiles.clear();
        this.allFiles.clear();
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        return this.getChildrenInternal(treePath, childStartIndex, childEndIndex, monitor);
    }

    private List<TreePath> getChildrenInternal(TreePath treePath, int startIndex, int endIndex, IProgressMonitor monitor) {
        try {
            CompileOrderViewInputConfigurator inputSourceConfigurator;
            List<IDVTElementWrapper> elems;
            if (treePath == null) {
                return Collections.emptyList();
            }
            ArrayList<TreePath> result = new ArrayList<TreePath>();
            if (this.allFiles.isEmpty() && (elems = this.computeAllElements(inputSourceConfigurator = new CompileOrderViewInputConfigurator(this.project, null, null, ViewsUtils.hasMoreThanOneDVTNature(this.project), false, this.compileOrderView, this.parsedBCFiles))) != null && !elems.isEmpty()) {
                this.allFiles.addAll(elems);
            }
            if (this.allFiles.isEmpty()) {
                return Collections.emptyList();
            }
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            List<Object> elements = new ArrayList();
            if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
                elements = this.allFiles;
            } else if (treePath.getElement() instanceof IDVTElementWrapper) {
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                IDVTElementWrapper elementWrapper = (IDVTElementWrapper)treePath.getElement();
                if (elementWrapper == null) {
                    return Collections.emptyList();
                }
                List children = elementWrapper.getChildren();
                if (children == null || children.isEmpty()) {
                    return Collections.emptyList();
                }
                elements.addAll(children);
                Collections.sort(elements, CompileIndexComparator);
            }
            if (elements == null || elements.isEmpty()) {
                return Collections.emptyList();
            }
            if (startIndex >= elements.size()) {
                return Collections.emptyList();
            }
            int i = startIndex;
            while (i < Math.min(endIndex, elements.size())) {
                TreePath prevChild;
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                IDVTElementWrapper dvtElementWrapper = (IDVTElementWrapper)elements.get(i);
                TreePath child = TreePath.child(treePath, this.labelProvider.getText(dvtElementWrapper), i, TreePathComparator);
                child.setElement(dvtElementWrapper);
                TreePath treePath2 = prevChild = result.isEmpty() ? null : (TreePath)result.get(result.size() - 1);
                if (child.equals(prevChild, true)) {
                    child.append("@(" + i + ")@");
                }
                result.add(child);
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Boolean hasChildren(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildrenInternal(path, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        currentPath = path;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl7
        return currentPath;
lbl-1000:
        // 1 sources

        {
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl7:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl8:
        // 1 sources

        return currentPath;
    }

    public List<IDVTElementWrapper> getParsedFiles() {
        return this.allFiles;
    }

    public boolean isShowBuildConfigArgFiles() {
        return this.showBuildConfigArgFiles;
    }

    public void setShowBuildConfigArgFiles(boolean showBuildConfigArgFiles) {
        this.showBuildConfigArgFiles = showBuildConfigArgFiles;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public void setElementCount(int elementCount) {
        this.elementCount = elementCount;
    }

    public int getNotFilteredElementCount() {
        return this.notFilteredElementCount;
    }

    public void setNotFilteredElementCount(int notFilteredElementCount) {
        this.notFilteredElementCount = notFilteredElementCount;
    }

    public String getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(String tableInfo) {
        this.tableInfo = tableInfo;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public DVTBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(DVTBaseLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public boolean hasGUIFilteredElements() {
        return this.hasGUIFilteredElements;
    }

    public boolean hasSearchedElementFiltered() {
        return this.hasSearchedElementFiltered;
    }

    public void setHasGUIFilteredElements(boolean hasGUIFilteredElements) {
        this.hasGUIFilteredElements = hasGUIFilteredElements;
    }

    public void initBuildConfigHierarchy() {
        this.parsedBCFiles.clear();
        List<BuildConfigProperty> includeProps = BuildConfigManager.getIncludeProperties(this.project);
        if (includeProps == null || includeProps.isEmpty()) {
            return;
        }
        for (BuildConfigProperty property : includeProps) {
            BuildConfigToken tokenConfigFile = (BuildConfigToken)property.getAttributes().get("ATTRIBUTE_TOKEN");
            if (tokenConfigFile == null) {
                String propertyFileAbsolutePath = Path.fromOSString((String)property.getValue()).isAbsolute() ? property.getValue() : this.makeAbsolutePath(property.getValue());
                this.parsedBCFiles.put("default", new BCFileInstance(1, propertyFileAbsolutePath, new ParserPath(propertyFileAbsolutePath), 1));
                continue;
            }
            this.createBCFileInstance((Token)tokenConfigFile, property.getValue(), "-f");
        }
        List<Invocation> invocations = BuildConfigManager.getInvocations(this.project);
        for (Invocation invocation : invocations) {
            this.createEmptyInvocationForBCFileInstance(invocation);
        }
        RfMixedLangManager.getInstance().updateInvocationsInfo(this.project, this.parsedBCFiles);
    }

    private void createBCFileInstance(Token token, String cannonicCmdFilePath, String directiveString) {
        IPath path;
        if (this.parsedBCFiles.containsKey(cannonicCmdFilePath)) {
            return;
        }
        if (!directiveString.startsWith("-f") && !directiveString.startsWith("-F)")) {
            directiveString = token.getText();
        }
        if ((path = DVTFileUtils.getInstance().pathOf(token.getFilename())) == null) {
            return;
        }
        BCFileInstance parentFileInstance = this.parsedBCFiles.get(path.toOSString());
        if (parentFileInstance == null && (parentFileInstance = this.parsedBCFiles.get("default")) == null) {
            return;
        }
        BCFileInstance bcFileInstance = new BCFileInstance(cannonicCmdFilePath, -1, token.getLength(), token.getLine(), token.getOffset(), parentFileInstance, directiveString, new ParserPath(cannonicCmdFilePath), ++this.fBCIndex);
        this.parsedBCFiles.put(cannonicCmdFilePath, bcFileInstance);
        List<BCFileInstance> parentBCChildren = parentFileInstance.getBCChildren();
        if (parentBCChildren == null) {
            return;
        }
        parentBCChildren.add(bcFileInstance);
    }

    private void createEmptyInvocationForBCFileInstance(Invocation invocation) {
        BCFileInstance bcFileInstance;
        if (this.parsedBCFiles == null) {
            this.parsedBCFiles = new HashMap<String, BCFileInstance>();
        }
        if ((bcFileInstance = this.parsedBCFiles.get(invocation.getState().fStartFile)) == null) {
            bcFileInstance = this.parsedBCFiles.get("default");
        }
        if (bcFileInstance == null) {
            return;
        }
        ArrayList<BCDvtInit> invocations = bcFileInstance.getInvocations();
        if (invocations == null) {
            return;
        }
        BuildConfigParser.InvocationState invocationState = invocation.getState();
        if (invocationState == null) {
            return;
        }
        int stringLength = 0;
        if (invocationState.invocationString != null && invocationState.fKind != BuildConfigParser.InvocationKind.REUSE_CONFIG) {
            stringLength = invocationState.invocationString.length();
        }
        BCDvtInit dvtInit = new BCDvtInit(invocationState.invocationNumber, invocationState.fStartLine, invocationState.fStartOffset, bcFileInstance.getFilePath(), stringLength, this.project);
        invocations.add(dvtInit);
    }

    protected abstract boolean[] getTreeSearchStrictness();

    protected abstract StringMatcher[] getTreeSearchSegments();

    private String makeAbsolutePath(String value) {
        return this.project.getLocation().append(value).toOSString();
    }
}

