/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.compileorder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.ui.views.compileorder.ICompileOrderViewContributor;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public abstract class CompileOrderModelCommon
implements IModel {
    public static final String DEFAULT_FILTER_ID = "default-filter";
    private List<IDVTElementWrapper> allFiles = new ArrayList<IDVTElementWrapper>();
    List<ICompileOrderViewContributor> allCompileOrderContributors = DVTViewContributors.getInstance().getAllInstanceOf(ICompileOrderViewContributor.class);
    public IRfFilterableTreeAccessor compileOrderView;
    private DVTBaseLabelProvider labelProvider;
    private boolean showFilesWithErrors;
    private boolean hasGUIFilteredElements;
    private boolean hasSearchedElementFiltered;
    private IProject project;
    private int elementCount;
    private int notFilteredElementCount;
    private String tableInfo;
    private static final Comparator<IDVTElementWrapper> CompileIndexComparator = (w1, w2) -> {
        if (w1 == null || w2 == null) {
            return -1;
        }
        Object rfElement1 = w1.getRfElement();
        Object rfElement2 = w2.getRfElement();
        if (rfElement1 instanceof DVTLanguageElement && rfElement2 instanceof DVTLanguageElement) {
            return 0;
        }
        if (!rfElement1.getClass().equals(rfElement2.getClass())) {
            return -1;
        }
        if (!(rfElement1 instanceof IDVTFileInstance) || !(rfElement2 instanceof IDVTFileInstance)) {
            return 0;
        }
        IDVTFileInstance f1 = (IDVTFileInstance)rfElement1;
        IDVTFileInstance f2 = (IDVTFileInstance)rfElement2;
        if (f1.getIndex() <= 0 && f2.getIndex() <= 0) {
            if (f1.getParserPath().path.endsWith(".libfile")) {
                return -1;
            }
            if (f2.getParserPath().path.endsWith(".libfile")) {
                return 1;
            }
            return f1.getParserPath().compareTo(f2.getParserPath());
        }
        if (f1.getIndex() <= 0) {
            return 1;
        }
        if (f2.getIndex() <= 0) {
            return -1;
        }
        return f1.getIndex() - f2.getIndex();
    };
    public static final Comparator<TreePath> TreePathComparator = (t1, t2) -> {
        if (t1 == null || t2 == null) {
            return 0;
        }
        Object w1 = t1.getElement();
        Object w2 = t2.getElement();
        if (!(w1 instanceof IDVTElementWrapper) || !(w2 instanceof IDVTElementWrapper)) {
            return -1;
        }
        Object f1 = ((IDVTElementWrapper)w1).getRfElement();
        Object f2 = ((IDVTElementWrapper)w2).getRfElement();
        if (!(f1 instanceof IDVTFileInstance) || !(f2 instanceof IDVTFileInstance)) {
            return -1;
        }
        return CompileIndexComparator.compare((IDVTElementWrapper)w1, (IDVTElementWrapper)w2);
    };

    protected CompileOrderModelCommon(DVTBaseLabelProvider labelProvider, IProject project, IRfFilterableTreeAccessor view, boolean showFilesWithErrors) {
        this.labelProvider = labelProvider;
        this.project = project;
        this.showFilesWithErrors = showFilesWithErrors;
        this.tableInfo = "";
        this.compileOrderView = view;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public int getNotFilteredElementCount() {
        return this.notFilteredElementCount;
    }

    public String getTableInfo() {
        return this.tableInfo;
    }

    public boolean hasGUIFilteredElements() {
        return this.hasGUIFilteredElements;
    }

    public boolean hasSearchedElementFiltered() {
        return this.hasSearchedElementFiltered;
    }

    public void recompute(IProject project, boolean showFilesWithErrors, StringMatcher[] searchSegments, boolean[] searchTextStrictness) {
        this.elementCount = 0;
        this.allFiles.clear();
        this.showFilesWithErrors = showFilesWithErrors;
        this.allFiles.addAll(this.computeAllElements(new CompileOrderViewInputConfigurator(project, searchSegments, searchTextStrictness, ViewsUtils.hasMoreThanOneDVTNature(project), showFilesWithErrors, this.compileOrderView)));
    }

    private List<IDVTElementWrapper> computeAllElements(CompileOrderViewInputConfigurator inputSourceConfigurator) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        this.notFilteredElementCount = 0;
        this.tableInfo = "";
        this.hasGUIFilteredElements = false;
        this.hasSearchedElementFiltered = false;
        this.tableInfo = "";
        for (ICompileOrderViewContributor compileOrderViewContentProvider : this.allCompileOrderContributors) {
            CompileOrderViewInput input = compileOrderViewContentProvider.getInput(inputSourceConfigurator);
            this.hasGUIFilteredElements = this.hasGUIFilteredElements || input.hasGUIFilteredElements();
            this.hasSearchedElementFiltered = this.hasSearchedElementFiltered || input.hasSearchedElementFiltered();
            List<IDVTElementWrapper> inputElements = input.getElements();
            if (inputElements == null) continue;
            this.elementCount += input.getElementCount();
            this.notFilteredElementCount += input.getNotFilteredElementCount();
            String info = input.getTableInfo();
            if (this.tableInfo.isEmpty()) {
                this.tableInfo = info;
            }
            result.addAll(inputElements);
        }
        Collections.sort(result, CompileIndexComparator);
        return result;
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int startIndex, int endIndex, IProgressMonitor monitor) {
        return this.getChildrenInternal(treePath, startIndex, endIndex, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TreePath> getChildrenInternal(TreePath treePath, int startIndex, int endIndex, IProgressMonitor monitor) {
        try {
            if (treePath == null) {
                return Collections.emptyList();
            }
            CompileOrderModelCommon compileOrderModelCommon = this;
            synchronized (compileOrderModelCommon) {
                if (this.allFiles.isEmpty()) {
                    CompileOrderViewInputConfigurator inputSourceConfigurator = new CompileOrderViewInputConfigurator(this.project, null, null, ViewsUtils.hasMoreThanOneDVTNature(this.project), this.showFilesWithErrors, this.compileOrderView);
                    this.allFiles.addAll(this.computeAllElements(inputSourceConfigurator));
                }
            }
            if (this.allFiles.isEmpty()) {
                return Collections.emptyList();
            }
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            List<Object> elements = new ArrayList();
            ArrayList<TreePath> result = new ArrayList<TreePath>();
            if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
                elements = this.allFiles;
            } else if (treePath.getElement() instanceof IDVTElementWrapper) {
                TreePath equivalentTreePath;
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                IDVTElementWrapper elementWrapper = (IDVTElementWrapper)treePath.getElement();
                if (elementWrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.IS_DUMMY) != null && (equivalentTreePath = this.getEquivalentTreePath(treePath)) != null) {
                    elementWrapper = (IDVTElementWrapper)equivalentTreePath.getElement();
                }
                if (elementWrapper == null) {
                    return Collections.emptyList();
                }
                List children = elementWrapper.getChildren();
                if (children == null || children.isEmpty()) {
                    return Collections.emptyList();
                }
                elements.addAll(children);
                Collections.sort(elements, CompileIndexComparator);
            }
            if (elements == null || elements.isEmpty()) {
                return Collections.emptyList();
            }
            if (startIndex >= elements.size()) {
                return Collections.emptyList();
            }
            int i = startIndex;
            while (i < Math.min(endIndex, elements.size())) {
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                IDVTElementWrapper dvtElementWrapper = (IDVTElementWrapper)elements.get(i);
                String text = this.labelProvider.getText(dvtElementWrapper);
                if (dvtElementWrapper != null && dvtElementWrapper.getRfElement() instanceof DVTLanguageElement) {
                    text = this.computeTextForLanguageElement(dvtElementWrapper, text);
                }
                TreePath child = TreePath.child(treePath, text, i, TreePathComparator);
                child.setElement(dvtElementWrapper);
                result.add(child);
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    public TreePath getEquivalentTreePath(TreePath treePath) {
        ArrayList<TreePath> ancestors = new ArrayList<TreePath>();
        TreePath aux = treePath;
        while ((aux = aux.getParent()) != null) {
            if (aux == TreePath.TOP_DUMMY_TREE_PATH) continue;
            ancestors.add(aux);
        }
        TreePath result = null;
        Collections.reverse(ancestors);
        ancestors.add(treePath);
        List<IDVTElementWrapper> viewWrappers = this.allFiles;
        block1: for (TreePath ancestor : ancestors) {
            if (!(ancestor.getElement() instanceof IDVTElementWrapper)) continue;
            if (viewWrappers == null || viewWrappers.isEmpty()) break;
            IDVTElementWrapper ancestorWrapper = (IDVTElementWrapper)ancestor.getElement();
            int i = 0;
            while (i < viewWrappers.size()) {
                boolean isEquivalent = false;
                IDVTElementWrapper wrapper = viewWrappers.get(i);
                if (wrapper.getRfElement() instanceof DVTLanguageElement && ancestorWrapper.getRfElement() instanceof DVTLanguageElement) {
                    LanguageKind wrapperKind = ((DVTLanguageElement)wrapper.getRfElement()).getKind();
                    LanguageKind ancestorKind = ((DVTLanguageElement)ancestorWrapper.getRfElement()).getKind();
                    isEquivalent = wrapperKind.equals((Object)ancestorKind);
                }
                if (wrapper.getRfElement() instanceof IDVTFileInstance && ancestorWrapper.getRfElement() instanceof IDVTFileInstance) {
                    parserPath = ((IDVTFileInstance)wrapper.getRfElement()).getParserPath();
                    parserPath2 = ((IDVTFileInstance)ancestorWrapper.getRfElement()).getParserPath();
                    isEquivalent = parserPath.equals(parserPath2);
                } else if (wrapper.getRfElement() instanceof IRfFileDef && ancestorWrapper.getRfElement() instanceof IRfFileDef) {
                    parserPath = ((IRfFileDef)wrapper.getRfElement()).getParserPath();
                    parserPath2 = ((IRfFileDef)ancestorWrapper.getRfElement()).getParserPath();
                    isEquivalent = parserPath.equals(parserPath2);
                }
                if (isEquivalent) {
                    ancestorWrapper = wrapper;
                    ancestor.setElement(wrapper);
                    ancestor.setIndices(new int[]{i});
                    ancestor.customComparator = TreePathComparator;
                    viewWrappers = wrapper.getAllChildren();
                    String text = this.labelProvider.getText(wrapper);
                    if (wrapper != null && wrapper.getRfElement() instanceof DVTLanguageElement) {
                        text = this.computeTextForLanguageElement(wrapper, text);
                    }
                    result = TreePath.child(result, text, i, TreePathComparator);
                    result.setElement(wrapper);
                    continue block1;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public Boolean hasChildren(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildrenInternal(treePath, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        currentPath = path;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl7
        return currentPath;
lbl-1000:
        // 1 sources

        {
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl7:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl8:
        // 1 sources

        return currentPath;
    }

    private String computeTextForLanguageElement(IDVTElementWrapper dvtElementWrapper, String text) {
        if (dvtElementWrapper == null || !(dvtElementWrapper.getRfElement() instanceof DVTLanguageElement)) {
            return text;
        }
        DVTLanguageElement dvtLanguageElement = (DVTLanguageElement)dvtElementWrapper.getRfElement();
        String langElementInfo = dvtLanguageElement.getInfo() instanceof String ? (String)dvtLanguageElement.getInfo() : "";
        int bracketIndex = langElementInfo.indexOf("[");
        if (bracketIndex >= 0) {
            text = langElementInfo.substring(0, bracketIndex).trim();
        }
        return text;
    }

    public List<IDVTElementWrapper> getCompiledFiles() {
        return this.allFiles;
    }

    @Override
    public void clearModelCaches() {
        this.allFiles.clear();
    }

    protected abstract boolean[] getTreeSearchStrictness();

    protected abstract StringMatcher[] getTreeSearchSegments();

    public boolean isShowFilesWithErrors() {
        return this.showFilesWithErrors;
    }
}

