/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.compileorder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderView;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.QuickCompileOrderView;
import ro.amiq.dvt.utils.DVTStringUtil;

@ForTestingOrDebuggingOnly
public class CompileOrderTestUtils
implements ILazyTreeTestUtils {
    private IDVTLazyView lazyView;

    public CompileOrderTestUtils(IDVTLazyView lazyView) {
        this.lazyView = lazyView;
    }

    @Override
    public LazyTree getLazyTree() {
        if (this.lazyView instanceof CompileOrderView) {
            return ((CompileOrderView)this.lazyView).getLazyTree();
        }
        if (this.lazyView instanceof QuickCompileOrderView) {
            return ((QuickCompileOrderView)this.lazyView).getLazyTree();
        }
        return null;
    }

    public Control getControlParent() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree != null) {
            return lazyTree.getControlParent();
        }
        return null;
    }

    @Override
    public Tree testGetViewTree() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree != null) {
            return lazyTree.getTree();
        }
        return null;
    }

    public Label getLabelProjectInfo() {
        if (this.lazyView instanceof CompileOrderView) {
            return ((CompileOrderView)this.lazyView).getLabelProjectInfo();
        }
        return null;
    }

    @Override
    public boolean selectInLazyTree(String searchedFileName, int searchedFileNum) {
        TreePath searchedPath = null;
        for (TreePath path : this.getViewContent()) {
            String instanceName = path.getLastSegment();
            if (instanceName == null || !instanceName.equals(searchedFileName)) continue;
            searchedPath = path;
            break;
        }
        if (searchedPath == null) {
            throw new RuntimeException("Unable to select non-existing node " + searchedFileName);
        }
        Tree compileOrderTree = this.testGetViewTree();
        if (compileOrderTree == null) {
            return false;
        }
        TreeItem[] treeItems = compileOrderTree.getItems();
        TreeItem selection = null;
        String[] stringArray = searchedPath.getSegments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            selection = null;
            TreeItem[] treeItemArray = treeItems;
            int n3 = treeItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem candidate = treeItemArray[n4];
                Object data = candidate.getData();
                if (!(data instanceof TreePath)) {
                    return false;
                }
                if (((TreePath)data).getLastSegment().equals(segment)) {
                    treeItems = candidate.getItems();
                    selection = candidate;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (selection == null) {
            throw new RuntimeException("Unable to select non-existing node " + DVTStringUtil.join(searchedPath.getSegments(), "/"));
        }
        compileOrderTree.setSelection(selection);
        this.testSetSelection(searchedPath);
        compileOrderTree.showSelection();
        compileOrderTree.notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        return true;
    }

    @Override
    public Objection getObjection() {
        if (this.lazyView instanceof CompileOrderView) {
            return Objection.COMPILEORDER;
        }
        if (this.lazyView instanceof QuickCompileOrderView) {
            return Objection.QUICK_COMPILEORDER;
        }
        return null;
    }

    @Override
    public IDVTLazyView getLazyView() {
        return this.lazyView;
    }

    public List<TreePath> getViewContent() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree != null) {
            return lazyTree.getViewContent();
        }
        return Collections.emptyList();
    }

    @Override
    public void testSetSelection(TreePath path) {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree != null) {
            lazyTree.testSetSelection(path);
        }
    }

    public void goToSelectedElement() {
        if (this.lazyView instanceof CompileOrderView) {
            ((CompileOrderView)this.lazyView).gotoSelectedElement("default-tree");
        }
    }

    public void goToIncludeAction() {
        if (this.lazyView instanceof CompileOrderView) {
            ((CompileOrderView)this.lazyView).gotoIncludeAction();
        }
    }

    public void goToImportAction() {
        if (this.lazyView instanceof CompileOrderView) {
            ((CompileOrderView)this.lazyView).gotoImportAction();
        }
    }

    public void showOnlyFilesWithErrorsAction() {
        if (this.lazyView instanceof CompileOrderView) {
            ((CompileOrderView)this.lazyView).setShowFilesWithErrors(true);
        }
        ((CompileOrderView)this.lazyView).getLazyTree().doAction(LazyTreeAction.SHOW_ONLY_FILES_WITH_ERRORS, new LazyTreeActionArguments(Objection.COMPILEORDER));
    }

    public void showAllFiles() {
        if (this.lazyView instanceof CompileOrderView) {
            ((CompileOrderView)this.lazyView).setShowFilesWithErrors(false);
            ((CompileOrderView)this.lazyView).setShowBuildConfigArgFiles(false);
        }
        ((CompileOrderView)this.lazyView).getLazyTree().doAction(LazyTreeAction.SHOW_ONLY_FILES_WITH_ERRORS, new LazyTreeActionArguments(Objection.COMPILEORDER));
    }

    public void showBuildConfigArgFilesAction() {
        if (this.lazyView instanceof CompileOrderView) {
            ((CompileOrderView)this.lazyView).setShowBuildConfigArgFiles(true);
        }
        ((CompileOrderView)this.lazyView).getLazyTree().doAction(LazyTreeAction.SHOW_BUILD_CONFIG_ARG_FILES, new LazyTreeActionArguments(Objection.COMPILEORDER));
    }

    public Object getRoots() {
        ArrayList<Object> result = new ArrayList<Object>();
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return result;
        }
        List<TreePath> testGetViewContent = lazyTree.getViewContent();
        if (testGetViewContent == null) {
            return result;
        }
        for (TreePath path : testGetViewContent) {
            if (!TreePath.isRoot(path)) continue;
            result.add(path.getElement());
        }
        return result;
    }

    public int getElementCount() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return 0;
        }
        return lazyTree.testGetElementCount();
    }

    public List<IDVTElementWrapper> getCompiledFiles() {
        if (this.lazyView instanceof CompileOrderView) {
            return ((CompileOrderView)this.lazyView).getCompiledFiles();
        }
        if (this.lazyView instanceof QuickCompileOrderView) {
            return ((QuickCompileOrderView)this.lazyView).getCompiledFiles();
        }
        return Collections.emptyList();
    }

    public ILabelProvider getLabelProvider() {
        return this.lazyView.getLabelProvider();
    }

    public String getLabelInfo() {
        if (this.lazyView instanceof CompileOrderView) {
            return ((CompileOrderView)this.lazyView).getLabelProjectInfo().getText();
        }
        return "";
    }
}

