/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.compileorder;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.compileorder.ICompileOrderViewContributor;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.BCCompileOrderModel;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.BCCompileOrderModelCommon;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderModel;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderViewCommon;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.ShowBuildConfigArgFilesAction;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.ShowOnlyFilesWithErrorsAction;
import ro.amiq.dvt.utils.Utils;

public class CompileOrderView
extends CompileOrderViewCommon {
    DVTLabelProviderProxy<ICompileOrderViewContributor> fLabelProvider = new DVTLabelProviderProxy<ICompileOrderViewContributor>(ICompileOrderViewContributor.class, "default-tree");
    private Label contentFiltersLabel;
    private boolean fHasGUIFilteredElements;
    private Image contentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image contentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);
    private Label infoLabel;
    private Composite childComposite;
    public static final String FILTER_BY_HIERARCHICAL_NAME = "Filter by: hierarchical name";
    private Action cancelAction;
    private CompileOrderModel lazyCompileOrderModel = new CompileOrderModel((DVTBaseLabelProvider)this.getLabelProvider(), this.getProject(), this, false);
    private BCCompileOrderModelCommon lazyBCCompileOrderModel = new BCCompileOrderModel((DVTBaseLabelProvider)this.getLabelProvider(), this.getProject(), this, false);
    private Composite labelContainer;
    private final CompileOrderTestUtils lazyTreeTestUtils = new CompileOrderTestUtils(this);
    private Action fGoToIncludeMenuItem = new GoToInclude();
    private Action fGoToImportMenuItem = new GoToImport();
    private ShowBuildConfigArgFilesAction showBuildConfigArgFilesAction;
    private ShowOnlyFilesWithErrorsAction showOnlyFilesWithErrorsAction;

    public Label getLabelProjectInfo() {
        return this.infoLabel;
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            LazyTree lazyTree;
            IProject project = this.getProject();
            if (project == null || project != null && !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            if (updateEvent == null) {
                RfMixedLangProject rfProject;
                this.clean();
                this.infoLabel.setText("[" + project.getName() + "]");
                if (project.isAccessible() && Utils.hasDvtNature(project)) {
                    ProjectColorUtils.setFgBg(this, this.getProject().getName());
                }
                if (!(rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false)).isBuildDone() && !rfProject.isState(RfProjectState.RESTORED)) {
                    return;
                }
            }
            if ((lazyTree = this.getLazyTree()) == null) {
                return;
            }
            this.fHasGUIFilteredElements = false;
            if (this.getShowBuildConfigArgFiles()) {
                this.initBuildConfigHirearchy();
                this.lazyBCCompileOrderModel.recompute(this.getProject(), this.getShowBuildConfigArgFiles(), this.getTreeSearchSegments(), this.getTreeSearchStrictness());
            } else {
                this.lazyCompileOrderModel.recompute(this.getProject(), this.fShowFilesWithErrors.get(), this.getTreeSearchSegments(), this.getTreeSearchStrictness());
            }
            this.updateViewLabelInfo();
            lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.getShowBuildConfigArgFiles() ? this.lazyBCCompileOrderModel : this.lazyCompileOrderModel, true, true, false, Objection.COMPILEORDER));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void clean() {
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(null));
        }
        this.lazyCompileOrderModel.clearModelCaches();
        this.lazyBCCompileOrderModel.clearModelCaches();
        IProject project = this.getProject();
        if (project == null || project != null && !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.infoLabel.setText("[no DVT Project or file selected]");
            ProjectColorUtils.setFgBg(this, null);
        } else {
            this.infoLabel.setText(project.getName());
            ProjectColorUtils.setFgBg(this, null);
        }
    }

    @Override
    public Control getControlToColorBg() {
        return this.getLabelProjectInfo().getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.getLabelProjectInfo();
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        try {
            TreeItem[] sel = this.getLazyTree().getTree().getSelection();
            if (sel == null || sel.length == 0 || !(sel[0].getData() instanceof TreePath)) {
                return;
            }
            TreePath wrapper = (TreePath)sel[0].getData();
            Object element = wrapper.getElement();
            if (!(element instanceof IDVTElementWrapper)) {
                return;
            }
            IResource adapter = (IResource)((IDVTElementWrapper)element).getAdapter(IResource.class);
            if (adapter == null) {
                return;
            }
            adapter.setSessionProperty(IDVTConstants.FILE_INSTANCE_QN, element);
            this.getViewContributor((IDVTElementWrapper)element).gotoElement(this.getProject(), element);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        this.cancelAction = new Action("", DVTImages.STOP_CURRENT_BUILD_PROCESS){

            public void run() {
                CompileOrderView.this.getLazyTree().cancelOperations();
                this.setEnabled(false);
            }
        };
        this.cancelAction.setEnabled(false);
        this.cancelAction.setToolTipText("Cancel Current Operation");
        toolBarManager.add((IAction)this.cancelAction);
        LazyTree lazyTree = this.getLazyTree();
        this.showBuildConfigArgFilesAction = new ShowBuildConfigArgFilesAction(this);
        this.showOnlyFilesWithErrorsAction = new ShowOnlyFilesWithErrorsAction(this);
        toolBarManager.add((IAction)this.showBuildConfigArgFilesAction);
        toolBarManager.add((IAction)this.showOnlyFilesWithErrorsAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
        toolBarManager.update(true);
    }

    @Override
    public void setCancelActionEnabled(boolean isEnabled) {
        this.cancelAction.setEnabled(isEnabled);
    }

    @Override
    public IProject getProject() {
        if (this.dataContainer == null || this.dataContainer.getProject() == null) {
            return null;
        }
        return this.dataContainer.getProject();
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        if (modelClass == null) {
            return null;
        }
        if (modelClass == IModel.class) {
            if (this.lazyBCCompileOrderModel != null && this.lazyBCCompileOrderModel.isShowBuildConfigArgFiles()) {
                return this.lazyBCCompileOrderModel;
            }
            if (this.lazyCompileOrderModel != null) {
                return this.lazyCompileOrderModel;
            }
        }
        return null;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DVTLabelProviderProxy<ICompileOrderViewContributor>(ICompileOrderViewContributor.class, "default-tree");
        }
        return this.fLabelProvider;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.fLabelProvider;
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_COMPILE_ORDER;
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        if (this.lazyBCCompileOrderModel.isShowBuildConfigArgFiles()) {
            this.lazyBCCompileOrderModel.recompute(this.getProject(), this.getShowBuildConfigArgFiles(), this.getTreeSearchSegments(), this.getTreeSearchStrictness());
        } else {
            this.lazyCompileOrderModel.recompute(this.getProject(), this.fShowFilesWithErrors.get(), this.getTreeSearchSegments(), this.getTreeSearchStrictness());
        }
        this.updateViewLabelInfo();
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, Objection.COMPILEORDER));
    }

    private void updateViewLabelInfo() {
        if (this.lazyCompileOrderModel == null && this.lazyBCCompileOrderModel == null) {
            return;
        }
        IProject project = this.getProject();
        this.infoLabel.setText(this.getHeader(project, true));
        if (project != null && project.isAccessible() && Utils.hasDvtNature(project)) {
            ProjectColorUtils.setFgBg(this, this.getProject().getName());
        }
        if (this.lazyBCCompileOrderModel.isShowBuildConfigArgFiles()) {
            this.fHasGUIFilteredElements = this.fHasGUIFilteredElements || this.lazyBCCompileOrderModel.hasGUIFilteredElements();
        } else {
            boolean bl = this.fHasGUIFilteredElements = this.fHasGUIFilteredElements || this.lazyCompileOrderModel.hasGUIFilteredElements();
        }
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.contentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
        }
        this.contentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        IDVTModel model = this.getModel(IModel.class);
        if (model instanceof CompileOrderModel) {
            if (!this.getTextFilter("default-filter").getText().isEmpty()) {
                if (((CompileOrderModel)model).hasSearchedElementFiltered()) {
                    return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
                }
                return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
            }
            if (((CompileOrderModel)model).hasGUIFilteredElements()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_DATA.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        lazyTree.setLabelProvider(this.getLabelProvider(), true);
        this.childComposite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        this.childComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.childComposite.setLayout((Layout)layout);
        this.labelContainer = new Composite(this.childComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(this.labelContainer);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)this.labelContainer);
        this.contentFiltersLabel = new Label(this.labelContainer, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.contentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
        } else {
            this.contentFiltersLabel.setImage(this.contentFiltersEnabledIcon);
        }
        this.contentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.contentFiltersLabel.setToolTipText("Content Filters matched!");
        this.contentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
        this.infoLabel = new Label(this.labelContainer, 16384);
        this.infoLabel.setLayoutData((Object)new GridData(768));
        this.createTextFilter("default-filter", this.childComposite, "default-tree", false);
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        filter.setTextFilterMessage(FILTER_BY_HIERARCHICAL_NAME);
        lazyTree.setSearchBar(filter);
        lazyTree.install(this.childComposite);
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        lazyTree.getTree().addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
    }

    @Override
    public void updateLabels(EnumSet<TreeViewContentProvider.LabelUpdateKind> labelUpdateKind) {
        super.updateLabels(labelUpdateKind);
    }

    @Override
    public CompileOrderTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        Object element = selection.getElement();
        if (!(element instanceof IDVTElementWrapper)) {
            return;
        }
        ICompileOrderViewContributor viewContributor = this.getViewContributor((IDVTElementWrapper)element);
        if (viewContributor.canShowGotoIncludeMenu((IDVTElementWrapper)element)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fGoToIncludeMenuItem);
        }
        if (viewContributor.canShowGotoImportMenu((IDVTElementWrapper)element)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fGoToImportMenuItem);
        }
    }

    public void gotoIncludeAction() {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper();
        if (selectedWrapper == null || this.getViewContributor(selectedWrapper) == null) {
            return;
        }
        this.getViewContributor(selectedWrapper).gotoInclude(this.getProject(), selectedWrapper);
    }

    public void gotoImportAction() {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper();
        if (selectedWrapper == null || this.getViewContributor(selectedWrapper) == null) {
            return;
        }
        this.getViewContributor(selectedWrapper).gotoImport(this.getProject(), selectedWrapper);
    }

    public IDVTElementWrapper getSelectedWrapper() {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null || !(selection.getElement() instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)selection.getElement();
    }

    @Override
    public Objection getObjection() {
        return Objection.COMPILEORDER;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    @Override
    public void setShowFilesWithErrors(boolean checked) {
        this.fShowFilesWithErrors.set(checked);
        this.lazyCompileOrderModel.recompute(this.getProject(), this.fShowFilesWithErrors.get(), this.getTreeSearchSegments(), this.getTreeSearchStrictness());
        this.updateViewLabelInfo();
    }

    @Override
    public void setShowBuildConfigArgFiles(boolean checked) {
        this.fShowBuildConfigArgFiles.set(checked);
        this.lazyBCCompileOrderModel.setShowBuildConfigArgFiles(checked);
        if (!checked) {
            this.lazyCompileOrderModel.recompute(this.getProject(), this.fShowFilesWithErrors.get(), this.getTreeSearchSegments(), this.getTreeSearchStrictness());
        } else {
            this.initBuildConfigHirearchy();
            this.lazyBCCompileOrderModel.recompute(this.getProject(), this.fShowBuildConfigArgFiles.get(), this.getTreeSearchSegments(), this.getTreeSearchStrictness());
        }
        this.updateViewLabelInfo();
    }

    @Override
    public boolean supportsDecorations() {
        return true;
    }

    public List<IDVTElementWrapper> getCompiledFiles() {
        if (this.getShowBuildConfigArgFiles()) {
            return this.lazyCompileOrderModel == null ? Collections.emptyList() : this.lazyBCCompileOrderModel.getParsedFiles();
        }
        return this.lazyCompileOrderModel == null ? Collections.emptyList() : this.lazyCompileOrderModel.getCompiledFiles();
    }

    public ShowBuildConfigArgFilesAction getShowBuildConfigArgFilesAction() {
        return this.showBuildConfigArgFilesAction;
    }

    public ShowOnlyFilesWithErrorsAction getShowOnlyFilesWithErrorsAction() {
        return this.showOnlyFilesWithErrorsAction;
    }

    public void initBuildConfigHirearchy() {
        this.lazyBCCompileOrderModel.setProject(this.getProject());
        this.lazyBCCompileOrderModel.initBuildConfigHierarchy();
    }

    class GoToImport
    extends Action {
        public GoToImport() {
            super("Go To Import", 1);
            this.setDescription("Go To Import");
            this.setToolTipText("Go To Import");
        }

        public void run() {
            CompileOrderView.this.gotoImportAction();
        }
    }

    class GoToInclude
    extends Action {
        public GoToInclude() {
            super("Go To Include", 1);
            this.setDescription("Go To Include");
            this.setToolTipText("Go To Include");
        }

        public void run() {
            CompileOrderView.this.gotoIncludeAction();
        }
    }
}

