/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.compileorder;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.compileorder.ICompileOrderViewContributor;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.BCCompileOrderModel;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderModel;

public abstract class CompileOrderViewCommon
extends DVTLazyView {
    public static final String ID = "ro.amiq.dvt.ui.views.CompileOrderView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.PROJECT_INFORMATION, ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS, ViewKind.CAN_HANDLE_RESOURCE_SELECTION_CHANGED, ViewKind.CAN_HANDLE_GUI_FILTERS);
    protected boolean dirty;
    protected ViewDataContainer dataContainer;
    protected AtomicBoolean fShowFilesWithErrors = new AtomicBoolean(false);
    protected AtomicBoolean fShowBuildConfigArgFiles = new AtomicBoolean(false);

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.getLabelProvider();
    }

    public String getHeader(IProject project, boolean displayProjectName) {
        String projectName;
        IDVTModel model = this.getModel(IModel.class);
        String header = "";
        int nofTotalElements = 0;
        int nofFilteredElements = 0;
        if (!(model instanceof CompileOrderModel) && !(model instanceof BCCompileOrderModel)) {
            return "";
        }
        if (model instanceof CompileOrderModel) {
            CompileOrderModel compileModel = (CompileOrderModel)model;
            nofTotalElements = compileModel.getElementCount();
            nofFilteredElements = compileModel.getNotFilteredElementCount();
            if (ViewsUtilsCommon.hasMoreThanOneDVTNature(project)) {
                header = "[" + (this.getTreeSearchSegments() != null && this.getTreeSearchSegments().length > 0 ? String.valueOf(nofFilteredElements) + "/" + nofTotalElements : Integer.valueOf(nofTotalElements)) + ViewsUtilsCommon.getUnitName("file", nofTotalElements, " ", "") + "]";
            } else if (project != null) {
                header = compileModel.getTableInfo();
            }
        } else if (model instanceof BCCompileOrderModel) {
            BCCompileOrderModel bcCompileModel = (BCCompileOrderModel)model;
            nofTotalElements = bcCompileModel.getElementCount();
            nofFilteredElements = bcCompileModel.getNotFilteredElementCount();
            header = bcCompileModel.getTableInfo();
        }
        String string = projectName = project != null ? project.getName() : "";
        if (displayProjectName) {
            return "[" + projectName + "]" + header;
        }
        return header;
    }

    public ICompileOrderViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, ICompileOrderViewContributor.class);
    }

    public abstract void setShowFilesWithErrors(boolean var1);

    public abstract void setShowBuildConfigArgFiles(boolean var1);

    public boolean getShowBuildConfigArgFiles() {
        return this.fShowBuildConfigArgFiles.get();
    }
}

