/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.compileorder;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.compileorder.ICompileOrderViewContributor;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderModel;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.quick.DVTQuickLazyView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public class QuickCompileOrderView
extends DVTQuickLazyView
implements IRfFilterableTreeAccessor {
    public static final String ID = "ro.amiq.dvt.ui.views.QuickCompileOrderView";
    public static final String TITLE = "Quick Compile Order";
    private static final String DEFAULT_FILTER_HELPER_TEXT = "Filter by: file name (use / for hierarchy)";
    private static final String INFO_TEXT = "Search patterns may contain: * = any string, ? = any character.";
    DVTLabelProviderProxy<ICompileOrderViewContributor> labelProvider = new DVTLabelProviderProxy<ICompileOrderViewContributor>(ICompileOrderViewContributor.class, "default-tree");
    private boolean hasGUIFilteredElements;
    private CompileOrderModel quickCompileOrderModel;
    private final CompileOrderTestUtils lazyTreeTestUtils = new CompileOrderTestUtils(this);

    public QuickCompileOrderView(Shell parent, IProject project) {
        super(parent, 48, project);
        this.quickCompileOrderModel = new CompileOrderModel(this.getLabelProvider(), project, this, false);
        this.setTextFilterMessage("default-filter", DEFAULT_FILTER_HELPER_TEXT);
    }

    @Override
    protected String getTitle() {
        return String.valueOf(this.hasGUIFilteredElements ? "*" : "") + TITLE + (this.project != null ? " [" + this.project.getName() + "]" : "");
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new DVTLabelProviderProxy<ICompileOrderViewContributor>(ICompileOrderViewContributor.class, "default-tree");
        }
        return this.labelProvider;
    }

    @Override
    protected String getId() {
        return ID;
    }

    @Override
    public void update() {
        try {
            IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
            if (!(activeEditor instanceof DVTEditor)) {
                this.getLazyTree().doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.quickCompileOrderModel, true, false, false, Objection.QUICK_COMPILEORDER));
                return;
            }
            IFile currentFile = ((DVTEditor)activeEditor).getCurrentFile();
            List<? extends IDVTFileInstance> fileInstances = RfMixedLangManager.getInstance().getFileInstances(this.project, DVTFileUtils.getInstance().resource2parser((IResource)currentFile));
            if (fileInstances == null || fileInstances.isEmpty()) {
                this.getLazyTree().doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.quickCompileOrderModel, true, false, false, Objection.QUICK_COMPILEORDER));
                return;
            }
            IDVTFileInstance fileInstance = fileInstances.get(0);
            ICompileOrderViewContributor viewContributor = this.getViewContributor(fileInstance);
            if (viewContributor == null) {
                this.getLazyTree().doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.quickCompileOrderModel, true, false, false, Objection.QUICK_COMPILEORDER));
                return;
            }
            TreePath treePathCurrentFile = viewContributor.getTreePath(fileInstance, ViewsUtils.hasMoreThanOneDVTNature(this.project));
            this.getLazyTree().doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(treePathCurrentFile, false, Objection.QUICK_COMPILEORDER));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private ICompileOrderViewContributor getViewContributor(IDVTFileInstance fileInstance) {
        return DVTViewContributors.getInstance().getViewContributor(fileInstance, ICompileOrderViewContributor.class);
    }

    @Override
    protected void gotoSelectedElement() {
        if (this.project == null) {
            return;
        }
        TreePath selectedPath = this.getSelectedPath();
        if (selectedPath == null) {
            return;
        }
        this.goToElement(selectedPath);
    }

    @Override
    protected void goToElement(TreePath selectedPath) {
        Object element;
        Object selectedElement = selectedPath.getElement();
        if (!(selectedElement instanceof IDVTElementWrapper)) {
            return;
        }
        IDVTElementWrapper selectedWrapper = (IDVTElementWrapper)selectedElement;
        ICompileOrderViewContributor contrib = DVTViewContributors.getInstance().getViewContributor(selectedWrapper, ICompileOrderViewContributor.class);
        if (contrib != null) {
            contrib.gotoElement(this.project, selectedWrapper);
        }
        if (!((element = selectedWrapper.getRfElement()) instanceof DVTLanguageElement) && !(element instanceof String)) {
            this.close();
        }
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.quickCompileOrderModel;
    }

    @Override
    public Objection getObjection() {
        return Objection.QUICK_COMPILEORDER;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.QUICK_COMPILE_ORDER;
    }

    @Override
    public CompileOrderTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public void setInput(Object information) {
        try {
            if (!DVTPlugin.getDefault().collect().c(this.project, "F636F7265")) {
                return;
            }
            this.getShell().setText(this.getTitle());
            this.setTitleText(this.getTitle());
            this.setInfoText(INFO_TEXT);
            this.update();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.getLazyTree().setSearchBar(this.getTextFilterObject("default-filter"));
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, this.getObjection()));
    }

    @Override
    public String getMessageText() {
        IDVTModel model = this.getModel(IModel.class);
        if (model instanceof CompileOrderModel) {
            if (!this.getTextFilterObject("default-filter").getTextFilterText().isEmpty()) {
                if (((CompileOrderModel)model).hasSearchedElementFiltered()) {
                    return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
                }
                return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
            }
            if (((CompileOrderModel)model).hasGUIFilteredElements()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_DATA.getMessage();
        }
        return "Select a DVT Project or file.";
    }

    @Override
    public boolean supportsDecorations() {
        return true;
    }

    public List<IDVTElementWrapper> getCompiledFiles() {
        if (this.quickCompileOrderModel == null) {
            return Collections.emptyList();
        }
        return this.quickCompileOrderModel.getCompiledFiles();
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        return this.getSearchSegments("default-filter");
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        return this.getSearchStrictness("default-filter");
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public boolean isFiltered() {
        return this.hasGUIFilteredElements;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }
}

