/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThreadKindGroup;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class DVTDebugLazyTreeModel
implements IModel {
    private Launch launch;
    private boolean groupThreadsByKind;

    public DVTDebugLazyTreeModel(Launch launch) {
        this.launch = launch;
    }

    @Override
    public void clearModelCaches() {
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (treePath == null) {
            return Collections.emptyList();
        }
        if (this.launch == null || this.launch.isTerminated()) {
            return Collections.emptyList();
        }
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            return this.getLaunchTreePath(treePath);
        }
        Object element = treePath.getElement();
        if (element instanceof ILaunch) {
            return this.getDebugTargetTreePath(treePath, element);
        }
        if (element instanceof IntrpDebugTarget) {
            return this.getThreadsTreePaths(treePath, childStartIndex, childEndIndex, element);
        }
        if (element instanceof IntrpDebugThreadKindGroup) {
            return this.getKindGroupThreads(treePath, childStartIndex, childEndIndex, element);
        }
        if (element instanceof IntrpDebugThread) {
            return this.getStackFramesTreePaths(treePath, childStartIndex, childEndIndex, element);
        }
        return Collections.emptyList();
    }

    private List<TreePath> getLaunchTreePath(TreePath treePath) {
        ILaunchConfiguration launchConfiguration = this.launch.getLaunchConfiguration();
        if (launchConfiguration == null) {
            return Collections.emptyList();
        }
        TreePath launchTreePath = TreePath.child(treePath, launchConfiguration.getName(), 0);
        launchTreePath.setElement(this.launch);
        return Arrays.asList(launchTreePath);
    }

    private List<TreePath> getDebugTargetTreePath(TreePath treePath, Object element) {
        IDebugTarget debugTarget = ((ILaunch)element).getDebugTarget();
        if (!(debugTarget instanceof IntrpDebugTarget)) {
            return Collections.emptyList();
        }
        TreePath debugTargetTreePath = TreePath.child(treePath, ((IntrpDebugTarget)debugTarget).getText(), 0);
        debugTargetTreePath.setElement(debugTarget);
        return Arrays.asList(debugTargetTreePath);
    }

    private List<TreePath> getThreadsTreePaths(TreePath treePath, int childStartIndex, int childEndIndex, Object element) {
        IntrpDebugTarget debugTarget = (IntrpDebugTarget)element;
        if (!debugTarget.isSuspended() || debugTarget.isTerminated()) {
            return Collections.emptyList();
        }
        IThread[] threads = debugTarget.getThreads();
        if (threads == null || threads.length == 0) {
            return Collections.emptyList();
        }
        int index = 0;
        ArrayList<TreePath> threadsTreePaths = new ArrayList<TreePath>();
        int i = 0;
        while (i < threads.length) {
            if (index >= childStartIndex) {
                if (index >= childEndIndex) {
                    return threadsTreePaths;
                }
                IThread thread = threads[i];
                if (thread instanceof IntrpDebugThread || thread instanceof IntrpDebugThreadKindGroup && this.isGroupThreadsByKind()) {
                    threadsTreePaths.add(this.getThreadTreePath(treePath, thread, index));
                    ++index;
                } else if (thread instanceof IntrpDebugThreadKindGroup && !this.isGroupThreadsByKind()) {
                    List<IThread> groupedThreads = ((IntrpDebugThreadKindGroup)thread).getThreads();
                    int j = 0;
                    while (j < groupedThreads.size()) {
                        if (index >= childStartIndex) {
                            if (index >= childEndIndex) {
                                return threadsTreePaths;
                            }
                            threadsTreePaths.add(this.getThreadTreePath(treePath, groupedThreads.get(j), index));
                            ++index;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return threadsTreePaths;
    }

    private List<TreePath> getKindGroupThreads(TreePath treePath, int childStartIndex, int childEndIndex, Object element) {
        IntrpDebugThreadKindGroup threadKindGroup = (IntrpDebugThreadKindGroup)element;
        if (threadKindGroup.isTerminated()) {
            return Collections.emptyList();
        }
        List<IThread> groupedThreads = threadKindGroup.getThreads();
        ArrayList<TreePath> threadsTreePaths = new ArrayList<TreePath>();
        int i = 0;
        while (i < groupedThreads.size()) {
            if (i >= childStartIndex) {
                if (i >= childEndIndex) break;
                IThread thread = groupedThreads.get(i);
                if (thread instanceof IntrpDebugThread) {
                    threadsTreePaths.add(this.getThreadTreePath(treePath, thread, i));
                }
            }
            ++i;
        }
        return threadsTreePaths;
    }

    private TreePath getThreadTreePath(TreePath treePath, IThread thread, int i) {
        String text = thread instanceof IntrpDebugThread ? ((IntrpDebugThread)thread).getText() : ((IntrpDebugThreadKindGroup)thread).getText();
        TreePath threadTreePath = TreePath.child(treePath, text, i);
        threadTreePath.setElement(thread);
        return threadTreePath;
    }

    private List<TreePath> getStackFramesTreePaths(TreePath treePath, int childStartIndex, int childEndIndex, Object element) {
        IntrpDebugThread thread = (IntrpDebugThread)element;
        if (!thread.isSuspended() || thread.isTerminated()) {
            return Collections.emptyList();
        }
        IStackFrame[] stackFrames = thread.getStackFrames();
        if (stackFrames == null || stackFrames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> stackFramesTreePaths = new ArrayList<TreePath>();
        int i = 0;
        while (i < stackFrames.length) {
            if (i >= childStartIndex) {
                if (i >= childEndIndex) break;
                IStackFrame stackFrame = stackFrames[i];
                if (stackFrame instanceof IntrpStackFrame) {
                    stackFramesTreePaths.add(this.getStackFrameTreePath(treePath, (IntrpStackFrame)stackFrame, i, true));
                }
            }
            ++i;
        }
        return stackFramesTreePaths;
    }

    private TreePath getStackFrameTreePath(TreePath treePath, IntrpStackFrame intrpStackFrame, int index, boolean setTreePathOnStackFrame) {
        TreePath stackFrameTreePath = TreePath.child(treePath, intrpStackFrame.getText(), index);
        stackFrameTreePath.append("@(" + index + ")@");
        stackFrameTreePath.setElement(intrpStackFrame);
        if (setTreePathOnStackFrame) {
            intrpStackFrame.setTreePath(stackFrameTreePath);
        }
        return stackFrameTreePath;
    }

    @Override
    public Boolean hasChildren(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return treePath;
        }
        currentPath = treePath;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl11
        return currentPath;
lbl-1000:
        // 1 sources

        {
            if (monitor.isCanceled()) {
                return currentPath;
            }
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl11:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl12:
        // 1 sources

        return currentPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TreePath getSuspendTreePath(IntrpDebugThread suspendedThread) {
        try {
            if (this.launch == null || this.launch.isTerminated()) {
                return null;
            }
            ILaunchConfiguration launchConfiguration = this.launch.getLaunchConfiguration();
            if (launchConfiguration == null) {
                return null;
            }
            TreePath treePath = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, launchConfiguration.getName(), 0);
            treePath.setElement(this.launch);
            IDebugTarget debugTarget = this.launch.getDebugTarget();
            if (!(debugTarget instanceof IntrpDebugTarget)) {
                return null;
            }
            treePath = TreePath.child(treePath, ((IntrpDebugTarget)debugTarget).getText(), 0);
            treePath.setElement(debugTarget);
            IThread[] threads = debugTarget.getThreads();
            if (threads.length == 0) {
                return null;
            }
            int suspendedThreadIndex = 0;
            do {
                if (suspendedThread != threads[suspendedThreadIndex]) continue;
                treePath = TreePath.child(treePath, suspendedThread.getText(), suspendedThreadIndex);
                treePath.setElement(suspendedThread);
                IStackFrame topStackFrame = suspendedThread.getTopStackFrame();
                if (topStackFrame instanceof IntrpStackFrame) return this.getStackFrameTreePath(treePath, (IntrpStackFrame)topStackFrame, 0, false);
                return null;
            } while (++suspendedThreadIndex != threads.length);
            return null;
        }
        catch (DebugException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public Launch getLaunch() {
        return this.launch;
    }

    public boolean isGroupThreadsByKind() {
        return this.groupThreadsByKind;
    }

    public void setGroupThreadsByKind(boolean groupThreadsByKind) {
        this.groupThreadsByKind = groupThreadsByKind;
    }
}

