/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.debug;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.interpreter.DVTRunLaunchCache;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTSelectionChangedEvent;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTDebugContextProvider;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTDebugLazyTreeLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTDebugLazyTreeModel;

public class DVTDebugLazyTreeViewer
extends Viewer
implements IDVTLazyView {
    private LazyTree lazyTree;
    private DVTDebugLazyTreeModel model;
    private DVTDebugLazyTreeLabelProvider labelProvider = new DVTDebugLazyTreeLabelProvider();
    private boolean isGroupThreadsByKind;
    private TreePath focusedTreePath;
    private Control viewerControl;
    private DVTDebugContextProvider contextProvider;
    private SelectionListener lazyTreeSelectionListener;
    private IDebugEventSetListener debugEventListener;
    private ILaunchesListener launchListener;
    private Job refreshOnDebugEventJob;
    private IntrpDebugThread suspendedThread;
    private int debugEventKind;

    public DVTDebugLazyTreeViewer(Composite parent) {
        this.viewerControl = new Composite(parent, 0);
    }

    public Control getControl() {
        if (this.lazyTree != null) {
            return this.lazyTree.getTree();
        }
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.viewerControl);
        Composite lazyTreeComposite = new Composite((Composite)this.viewerControl, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)lazyTreeComposite);
        lazyTreeComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.lazyTree = new LazyTree(this);
        this.lazyTree.setLabelProvider((ILabelProvider)this.labelProvider, false);
        this.lazyTree.install(lazyTreeComposite);
        this.addListeners();
        if (DVTRunLaunchCache.getInstance().isDVTRunInProgress()) {
            this.restoreContext();
        }
        return this.viewerControl;
    }

    public void setContextProvider(DVTDebugContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    private void addListeners() {
        this.lazyTreeSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().asyncExec(() -> {
                    Widget item = selectionEvent.item;
                    if (!(item instanceof TreeItem)) {
                        return;
                    }
                    Object treeItemData = ((TreeItem)item).getData();
                    if (!(treeItemData instanceof TreePath)) {
                        return;
                    }
                    Object element = ((TreePath)treeItemData).getElement();
                    if (element == null) {
                        return;
                    }
                    DVTDebugLazyTreeViewer.this.setSelection((ISelection)new StructuredSelection(element));
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.refreshOnDebugEventJob = new Job("Refresh DVTDebugView Job"){

            protected IStatus run(IProgressMonitor monitor) {
                if (2 == DVTDebugLazyTreeViewer.this.debugEventKind) {
                    DVTDebugLazyTreeViewer.this.refreshOnSuspend(DVTDebugLazyTreeViewer.this.suspendedThread);
                } else if (1 == DVTDebugLazyTreeViewer.this.debugEventKind) {
                    DVTDebugLazyTreeViewer.this.refreshOnResume();
                }
                return Status.OK_STATUS;
            }
        };
        this.debugEventListener = events -> {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                Object source = event.getSource();
                if (source instanceof IntrpDebugThread) {
                    this.refreshOnDebugEventJob.cancel();
                    switch (event.getKind()) {
                        case 2: {
                            this.suspendedThread = (IntrpDebugThread)source;
                            this.debugEventKind = 2;
                            this.refreshOnDebugEventJob.schedule();
                            break;
                        }
                        case 1: {
                            this.suspendedThread = null;
                            this.debugEventKind = 1;
                            this.refreshOnDebugEventJob.schedule(100L);
                            break;
                        }
                    }
                }
                ++n2;
            }
        };
        this.launchListener = new ILaunchesListener(){

            public void launchesAdded(ILaunch[] launches) {
                DVTDebugLazyTreeViewer.this.setInput(launches[0]);
            }

            public void launchesRemoved(ILaunch[] launches) {
                if (DVTDebugLazyTreeViewer.this.contextProvider != null) {
                    DVTDebugLazyTreeViewer.this.contextProvider.fireContextChanged((ISelection)new StructuredSelection());
                }
                DVTDebugLazyTreeViewer.this.clean();
            }

            public void launchesChanged(ILaunch[] launches) {
            }
        };
        this.lazyTree.addSelectionListener(this.lazyTreeSelectionListener);
        DebugPlugin.getDefault().addDebugEventListener(this.debugEventListener);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.launchListener);
    }

    private void restoreContext() {
        ILaunch launch = DVTRunLaunchCache.getInstance().getLaunch();
        if (!(launch instanceof Launch)) {
            return;
        }
        IDebugTarget debugTarget = launch.getDebugTarget();
        if (!(debugTarget instanceof IntrpDebugTarget)) {
            return;
        }
        this.model = new DVTDebugLazyTreeModel((Launch)launch);
        this.model.setGroupThreadsByKind(this.isGroupThreadsByKind);
        IntrpDebugThread firstSuspendedThread = null;
        IThread[] threads = ((IntrpDebugTarget)debugTarget).getThreads();
        int i = 0;
        while (i < threads.length) {
            IThread thread = threads[i];
            if (thread instanceof IntrpDebugThread && thread.isSuspended() && !thread.isTerminated()) {
                firstSuspendedThread = (IntrpDebugThread)thread;
                break;
            }
            ++i;
        }
        if (firstSuspendedThread != null) {
            this.refreshOnSuspend(firstSuspendedThread);
        } else {
            this.refresh();
        }
    }

    public Object getInput() {
        if (this.model == null) {
            return null;
        }
        return this.model.getLaunch();
    }

    public ISelection getSelection() {
        TreePath selection = this.lazyTree.getSelection();
        if (selection == null) {
            return null;
        }
        Object selectionElement = selection.getElement();
        if (selectionElement == null) {
            return null;
        }
        return new StructuredSelection(selectionElement);
    }

    public void refresh() {
        this.lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.model, false, false, false, this.getObjection()));
    }

    private void refreshOnResume() {
        this.setSelection((ISelection)new StructuredSelection());
        this.refresh();
    }

    private void refreshOnSuspend(IntrpDebugThread suspendedThread) {
        if (this.model == null) {
            return;
        }
        this.focusedTreePath = this.model.getSuspendTreePath(suspendedThread);
        if (this.focusedTreePath == null) {
            return;
        }
        this.lazyTree.doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(this.focusedTreePath, this.focusedTreePath.getParent(), false, true, this.getObjection()));
    }

    public void refreshOnToggleGroupThreadsByKind(boolean isGroupThreadsByKind) {
        this.isGroupThreadsByKind = isGroupThreadsByKind;
        if (this.model == null) {
            return;
        }
        this.model.setGroupThreadsByKind(isGroupThreadsByKind);
        this.lazyTree.doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(this.focusedTreePath, this.focusedTreePath.getParent(), false, true, this.getObjection()));
    }

    public void setInput(Object input) {
        if (!(input instanceof Launch)) {
            return;
        }
        this.model = new DVTDebugLazyTreeModel((Launch)input);
        this.model.setGroupThreadsByKind(this.isGroupThreadsByKind);
        this.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.contextProvider == null) {
            return;
        }
        this.contextProvider.fireContextChanged(selection);
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object element = ((StructuredSelection)selection).getFirstElement();
        if (!(element instanceof IntrpStackFrame)) {
            return;
        }
        TreePath treePath = ((IntrpStackFrame)element).getTreePath();
        if (treePath == null) {
            return;
        }
        this.focusedTreePath = treePath;
    }

    public void clean() {
        this.model = null;
        this.focusedTreePath = null;
        this.suspendedThread = null;
        this.debugEventKind = 0;
        this.lazyTree.doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(this.getObjection()));
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener(this.debugEventListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.launchListener);
        this.lazyTreeSelectionListener = null;
        this.debugEventListener = null;
        this.launchListener = null;
        this.lazyTree = null;
        this.model = null;
        this.labelProvider = null;
        this.focusedTreePath = null;
        this.viewerControl = null;
        this.contextProvider = null;
        this.refreshOnDebugEventJob = null;
        this.suspendedThread = null;
        this.debugEventKind = 0;
    }

    @Override
    public void fireSelectionChanged(SelectionChangedEvent event) {
        if (!(event instanceof DVTSelectionChangedEvent)) {
            return;
        }
        ISelection selection = event.getSelection();
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object selectionFirstElement = ((StructuredSelection)selection).getFirstElement();
        if (!(selectionFirstElement instanceof DVTTreeElementWrapper)) {
            return;
        }
        Object element = ((DVTTreeElementWrapper)selectionFirstElement).getRfElement();
        if (element == null) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection(element));
    }

    @Override
    public LazyTree getLazyTree() {
        return this.lazyTree;
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.model;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_DVT_DEBUG_VIEW;
    }

    @Override
    public Objection getObjection() {
        return Objection.DVT_DEBUG_VIEW;
    }

    @Override
    public String getMessageText() {
        return "Start a debug session to populate this view";
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public void swapToMessageComposite() {
    }

    @Override
    public void swapToTreeComposite() {
    }

    @Override
    public void createToolBar() {
    }

    @Override
    public IProject getProject() {
        return null;
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public ILazyTreeTestUtils getLazyTreeTestUtils() {
        return null;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    @Override
    public boolean supportsDecorations() {
        return false;
    }
}

