/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.debug;

import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.DebugCommandAction;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTDebugContextProvider;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTDebugLazyTreeViewer;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTDropToFrameCommandAction;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTResumeCommandAction;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTStepIntoCommandAction;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTStepOverCommandAction;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTStepReturnCommandAction;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTSuspendCommandAction;
import ro.amiq.dvt.ui.views.lazy.views.debug.DVTTerminateCommandAction;

public class DVTDebugView
extends AbstractDebugView {
    public static final String ID = "ro.amiq.dvt.ui.views.DVTDebugView";
    private DVTDebugContextProvider contextProvider;

    protected Viewer createViewer(Composite parent) {
        return new DVTDebugLazyTreeViewer(parent);
    }

    private void createContextProvider() throws Exception {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            throw new Exception("Failed to create context provider");
        }
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow == null) {
            throw new Exception("Failed to create context provider");
        }
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(activeWindow);
        if (contextService == null) {
            throw new Exception("Failed to create context provider");
        }
        this.contextProvider = new DVTDebugContextProvider(this);
        contextService.addDebugContextProvider((IDebugContextProvider)this.contextProvider);
        ((DVTDebugLazyTreeViewer)this.getViewer()).setContextProvider(this.contextProvider);
    }

    protected void createActions() {
        this.addDebugCommandAction("RESUME", new DVTResumeCommandAction());
        this.addDebugCommandAction("SUSPEND", new DVTSuspendCommandAction());
        this.addDebugCommandAction("TERMINATE", new DVTTerminateCommandAction());
        this.addDebugCommandAction("STEP INTO", new DVTStepIntoCommandAction());
        this.addDebugCommandAction("STEP OVER", new DVTStepOverCommandAction());
        this.addDebugCommandAction("STEP RETURN", new DVTStepReturnCommandAction());
        this.addDebugCommandAction("DROP TO FRAME", new DVTDropToFrameCommandAction());
        try {
            this.createContextProvider();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addDebugCommandAction(String actionID, DebugCommandAction debugCommandAction) {
        debugCommandAction.init((IWorkbenchPart)this);
        this.setAction(actionID, (IAction)debugCommandAction);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add(this.getAction("RESUME"));
        menu.add(this.getAction("SUSPEND"));
        menu.add(this.getAction("TERMINATE"));
        menu.add(this.getAction("STEP INTO"));
        menu.add(this.getAction("STEP OVER"));
        menu.add(this.getAction("STEP RETURN"));
        menu.add(this.getAction("DROP TO FRAME"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected String getHelpContextId() {
        return null;
    }

    public void toggleGroupThreadsByKind(boolean isGroupThreadsByKind) {
        DVTDebugLazyTreeViewer viewer = (DVTDebugLazyTreeViewer)this.getViewer();
        viewer.refreshOnToggleGroupThreadsByKind(isGroupThreadsByKind);
    }

    public void dispose() {
        DVTDebugLazyTreeViewer viewer = (DVTDebugLazyTreeViewer)this.getViewer();
        viewer.dispose();
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextProvider((IDebugContextProvider)this.contextProvider);
        this.contextProvider = null;
        super.dispose();
    }
}

