/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.ui.views.lazy.tree.ITrimmedTreePath;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.LazyTreeStatistics;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;

public class DHTrimmedTreePath
extends TreePath
implements ITrimmedTreePath {
    private TreePath relativeToTreePath;

    private DHTrimmedTreePath(TreePath parent, String[] segments, int[] indices, TreePath relativeToTreePath) {
        this.segments = segments;
        this.setIndices(indices);
        this.parent = parent;
        this.relativeToTreePath = relativeToTreePath;
        LazyTreeStatistics.INSTANCE.registerTreePath("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
    }

    public static DHTrimmedTreePath of(TreePath parent, String[] segments, int[] indices, TreePath relativeToTreePath, Comparator<TreePath> comparator) {
        return new DHTrimmedTreePath(parent, segments, indices, relativeToTreePath);
    }

    public static DHTrimmedTreePath child(TreePath parent, String name, int index, TreePath relativeToTreePath) {
        if (parent == null) {
            return DHTrimmedTreePath.of(parent, new String[]{name}, new int[]{index}, relativeToTreePath, null);
        }
        if (parent == TreePath.TOP_DUMMY_TREE_PATH) {
            return DHTrimmedTreePath.of(parent, new String[]{name}, new int[]{index}, relativeToTreePath, null);
        }
        String[] segments = new String[parent.getSegments().length + 1];
        System.arraycopy(parent.getSegments(), 0, segments, 0, parent.getSegments().length);
        segments[segments.length - 1] = name;
        int[] indices = new int[parent.getIndices().length + 1];
        System.arraycopy(parent.getIndices(), 0, indices, 0, parent.getIndices().length);
        indices[indices.length - 1] = index;
        return DHTrimmedTreePath.of(parent, segments, indices, relativeToTreePath, null);
    }

    @Override
    public TreePath getRelativeToPath() {
        return this.relativeToTreePath;
    }

    @Override
    public List<TreePath> getParentsRelativeTo() {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (this.getRelativeToPath() == null) {
            return TreePath.parentsList(this, false);
        }
        ElementPath relativeToElementPath = TreePathUtils.getElementPathFromTreePath(this.getRelativeToPath());
        TreePath parent = this;
        while ((parent = parent.parent()) != null) {
            ElementPath parentElementPath;
            if (parent == TreePath.TOP_DUMMY_TREE_PATH || !relativeToElementPath.isPrefixOf(parentElementPath = TreePathUtils.getElementPathFromTreePath(parent))) continue;
            result.add(parent);
        }
        return result;
    }

    @Override
    public void setRelativeToPath(TreePath relativeToPath) {
        this.relativeToTreePath = relativeToPath;
    }

    public List<String> getSegmentsToRoot() {
        ArrayList<String> segmentsToRoot = new ArrayList<String>(3);
        String[] allSegments = this.getSegments();
        if (allSegments == null || allSegments.length == 0) {
            return segmentsToRoot;
        }
        if (this.relativeToTreePath == null) {
            return Arrays.asList(allSegments);
        }
        String[] relativeToTreePathSegments = this.relativeToTreePath.getSegments();
        if (relativeToTreePathSegments == null || relativeToTreePathSegments.length == 0) {
            return segmentsToRoot;
        }
        int i = relativeToTreePathSegments.length - 1;
        while (i < allSegments.length) {
            segmentsToRoot.add(allSegments[i]);
            ++i;
        }
        return segmentsToRoot;
    }
}

