/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RootDesignElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.refactor.connect.DVTDesignHierarchyHook;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.designhierarchy.IDHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyViewSelectTopDialogElement;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTDHLabelProvider
extends DVTBaseLabelProvider
implements IDHLabelProvider {
    private Map<String, ImageDescriptor> fDecoratorsMap = new HashMap<String, ImageDescriptor>();
    private boolean isBuildConfigSelectedTop = true;
    private boolean prependLibrary = PrefConst.getDHViewPrependLibrary();
    private boolean showUPF = PrefConst.getDHViewShowUPF();
    private boolean hideGenerates = PrefConst.getDHViewHideGenerates();

    public void setPrependLibrary(boolean prependLibrary) {
        this.prependLibrary = prependLibrary;
    }

    public void setShowUPF(boolean showUPF) {
        this.showUPF = showUPF;
    }

    public void setHideGenerates(boolean hideGenerates) {
        this.hideGenerates = hideGenerates;
    }

    public boolean getHideGenerates() {
        return this.hideGenerates;
    }

    @Override
    public String getText(Object element) {
        if (element instanceof RootDesignElement) {
            return "$root";
        }
        return this.getText(element, this.prependLibrary, this.showUPF);
    }

    @Override
    public String getText(Object element, boolean prependLibrary, boolean showUPF) {
        String result = this.internalGetText(element, prependLibrary, showUPF, false);
        if (result == null) {
            result = "";
        }
        if (DVTDesignHierarchyHook.gatherAndDisplayTestInfo) {
            IDVTElementWrapper dvtWrapper = (IDVTElementWrapper)element;
            result = DVTStringUtil.appendString(result, " ", dvtWrapper.getUniqueID());
        }
        return result;
    }

    public String getTextForLabel(Object element) {
        String result = this.internalGetText(element, this.prependLibrary, this.showUPF, true);
        if (result == null) {
            result = "";
        }
        if (DVTDesignHierarchyHook.gatherAndDisplayTestInfo) {
            IDVTElementWrapper dvtWrapper = (IDVTElementWrapper)element;
            result = DVTStringUtil.appendString(result, " ", dvtWrapper.getUniqueID());
        }
        return result;
    }

    private final String internalGetText(Object wrapper, boolean prependLibrary, boolean showUPF, boolean isLabelInfo) {
        if (wrapper == null) {
            return "";
        }
        if (wrapper instanceof RootDesignElement) {
            return "$root";
        }
        Object element = null;
        TreePath treePath = null;
        if (wrapper instanceof TreePath) {
            treePath = (TreePath)wrapper;
        } else if (wrapper instanceof IDVTElementWrapper) {
            treePath = (TreePath)((IDVTElementWrapper)wrapper).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
        }
        if (treePath != null) {
            Object treePathElement;
            element = treePathElement = treePath.getElement();
            if (treePathElement instanceof IRfNamedElement && !(treePathElement instanceof DummyElement)) {
                wrapper = new DVTTreeElementWrapper(treePathElement);
                ((DVTTreeElementWrapper)wrapper).setAdditionalInfo(IDVTElementWrapper.Attribute.TREE_PATH, treePath);
                if (isLabelInfo && treePathElement instanceof IRfInstanceElement) {
                    IRfDesignElement designElement = null;
                    IRfDesignElement candidateComponent = ((IRfInstanceElement)treePathElement).getVHDLPreElaborationDesign();
                    ((DVTTreeElementWrapper)wrapper).setInstanceType(designElement);
                    ((DVTTreeElementWrapper)wrapper).setAssociatedElements(DesignUtils.getDesignKind(candidateComponent) == IRfNamedElement.ElementKind.VHDL_COMPONENT ? candidateComponent : null, null, null);
                }
            } else {
                wrapper = new DVTTreeElementWrapper(treePathElement);
            }
        } else if (wrapper instanceof IDVTElementWrapper) {
            element = ((IDVTElementWrapper)wrapper).getRfElement();
        } else if (wrapper instanceof LazyDesignHierarchyViewSelectTopDialogElement) {
            RootDesignElement rootDesignElement = ((LazyDesignHierarchyViewSelectTopDialogElement)wrapper).getRootConfig();
            if (rootDesignElement != null) {
                return "$root";
            }
            element = ((LazyDesignHierarchyViewSelectTopDialogElement)wrapper).getElement();
            wrapper = new DVTTreeElementWrapper(element);
        }
        IDVTElementWrapper dvtWrapper = (IDVTElementWrapper)wrapper;
        if (element instanceof IDVTElementWrapper) {
            return (String)((IDVTElementWrapper)element).getRfElement();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof IRfDefElement) {
            return ((IRfDefElement)element).getInfo();
        }
        if (element instanceof IRfNamedElement) {
            String configName = "";
            String upfLabel = "";
            if (showUPF) {
                upfLabel = this.computePfLabel(element, dvtWrapper);
            }
            String labelText = null;
            IRfNamedElement instanceType = null;
            if (element instanceof IRfInstanceElement) {
                ELManager elManager = ((IRfInstanceElement)element).getRfProject().getELManager();
                ELInstance elInstance = elManager.getMemory().instanceFor(TreePathUtils.getElementPathFromTreePath(treePath));
                IRfNamedElement binding = elInstance.getBinding(false);
                IRfNamedElement iRfNamedElement = instanceType = binding instanceof ErrorDesignElement && !(binding instanceof ErrorDesignElement.BlackBoxErrorDesignElement) ? null : binding;
            }
            if (treePath != null) {
                if (element instanceof IRfBlockElement) {
                    labelText = treePath.getLastSegment();
                } else if (element instanceof IRfInstanceElement && ((IRfInstanceElement)element).isArray()) {
                    labelText = String.valueOf(treePath.getLastSegment()) + " : " + DHViewUtils.getLabelText(instanceType, null, null, prependLibrary, showUPF);
                }
            }
            if (labelText == null) {
                labelText = DHViewUtils.getLabelText((IRfNamedElement)element, dvtWrapper.getConnectComponent(), instanceType, prependLibrary, showUPF);
            }
            String shallowLabel = "";
            if (instanceType != null && instanceType.isShallowCompiled() || instanceType == null && element != null && ((IRfNamedElement)element).isShallowCompiled()) {
                shallowLabel = "[S] ";
            } else if (instanceType != null && instanceType.isIncrementalShallowCompiled() || instanceType == null && element != null && ((IRfNamedElement)element).isIncrementalShallowCompiled()) {
                shallowLabel = "[iS] ";
            }
            return String.valueOf(shallowLabel) + upfLabel + labelText + configName;
        }
        return null;
    }

    private String computePfLabel(Object obj, IDVTElementWrapper dvtWrapper) {
        if (!this.isBuildConfigSelectedTop || !(obj instanceof IRfNamedElement) || dvtWrapper == null) {
            return "";
        }
        DVTPFModel pfModel = this.getUpfModel(dvtWrapper.getProject());
        if (pfModel == null) {
            return "";
        }
        if (!pfModel.hasPowerDomains()) {
            return "";
        }
        String path = "";
        TreePath treePath = dvtWrapper.getRfElement() instanceof TreePath ? (TreePath)dvtWrapper.getRfElement() : (TreePath)dvtWrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
        path = treePath != null ? TreePathUtils.getElementPathFromTreePath(treePath).toString("/") : dvtWrapper.getInstancePath().toString("/");
        DVTPFInfo pfInfo = pfModel.getPDInfoForInstance(path);
        if (pfInfo != null) {
            String powerDomainName = pfInfo.getPowerDomainName();
            dvtWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.POWER_DOMAIN_NAME, powerDomainName);
            dvtWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.POWER_DOMAIN_BG_RGB, pfInfo.getPowerDomainBgRGB());
            dvtWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.POWER_DOMAIN_FG_RGB, pfInfo.getPowerDomainFgRGB());
            return "[PD : " + powerDomainName + "] ";
        }
        dvtWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.POWER_DOMAIN_NAME, "");
        dvtWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.POWER_DOMAIN_BG_RGB, null);
        dvtWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.POWER_DOMAIN_FG_RGB, null);
        return "";
    }

    private RGB computePfColorForTreePath(TreePath treePath, boolean fg) {
        if (treePath == null || !(treePath.getElement() instanceof IRfNamedElement)) {
            return null;
        }
        IRfNamedElement element = (IRfNamedElement)treePath.getElement();
        if (element == null || element.getRfProject() == null) {
            return null;
        }
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return null;
        }
        DVTPFModel pfModel = this.getUpfModel(rfProject.getProject());
        if (pfModel == null) {
            return null;
        }
        if (!pfModel.hasPowerDomains()) {
            return null;
        }
        String path = treePath.toString("/");
        DVTPFInfo pfInfo = pfModel.getPDInfoForInstance(path);
        if (pfInfo == null) {
            return null;
        }
        return fg ? pfInfo.getPowerDomainFgRGB() : pfInfo.getPowerDomainBgRGB();
    }

    private DVTPFModel getUpfModel(IProject iproject) {
        if (iproject == null) {
            return null;
        }
        RfMixedLangProject rfMLP = RfMixedLangManager.getInstance().getRfMixedLangProject(iproject, false);
        if (rfMLP == null) {
            return null;
        }
        return rfMLP.getPFModel();
    }

    @Override
    public Image getImage(Object wrapper) {
        if (wrapper == null || wrapper instanceof String) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (wrapper instanceof RootDesignElement) {
            return DVTImages.imageCache.getImage(DVTImages.DESIGN_HIERARCHY_TOP);
        }
        Object element = null;
        TreePath treePath = null;
        if (wrapper instanceof TreePath) {
            treePath = (TreePath)wrapper;
        } else if (wrapper instanceof IDVTElementWrapper) {
            treePath = (TreePath)((IDVTElementWrapper)wrapper).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
        }
        if (treePath != null) {
            Object treePathElement;
            element = treePathElement = treePath.getElement();
            wrapper = new DVTTreeElementWrapper(treePathElement);
        } else if (wrapper instanceof IDVTElementWrapper) {
            element = ((IDVTElementWrapper)wrapper).getRfElement();
            if (element instanceof RootDesignElement) {
                return DVTImages.imageCache.getImage(DVTImages.DESIGN_HIERARCHY_TOP);
            }
        } else if (wrapper instanceof LazyDesignHierarchyViewSelectTopDialogElement) {
            RootDesignElement rootDesignElement = ((LazyDesignHierarchyViewSelectTopDialogElement)wrapper).getRootConfig();
            if (rootDesignElement != null) {
                return DVTImages.imageCache.getImage(DVTImages.DESIGN_HIERARCHY_TOP);
            }
            element = ((LazyDesignHierarchyViewSelectTopDialogElement)wrapper).getElement();
            wrapper = new DVTTreeElementWrapper(element);
        }
        if (element == null) {
            return null;
        }
        IDVTElementWrapper wrapp = (IDVTElementWrapper)wrapper;
        Image result = null;
        if (element == DummyElement.RECURRENCE_NODE) {
            result = DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
        } else if (element instanceof IDVTElementWrapper) {
            result = DVTImages.imageCache.getImage(DVTImages.NONE);
        } else if (element instanceof RfDummyElement) {
            result = DVTImages.imageCache.getImage(DVTImages.NONE);
        } else if (element instanceof String) {
            result = DVTImages.imageCache.getImage(DVTImages.NONE);
        } else {
            IRfDesignElement architecture;
            IRfNamedElement namedElement = (IRfNamedElement)element;
            IRfNamedElement instanceType = null;
            if (namedElement instanceof IRfInstanceElement) {
                ELManager elManager = namedElement.getRfProject().getELManager();
                ELInstance elInstance = elManager.getMemory().instanceFor(TreePathUtils.getElementPathFromTreePath(treePath));
                IRfNamedElement binding = elInstance.getBinding(false);
                IRfNamedElement iRfNamedElement = instanceType = binding instanceof ErrorDesignElement && !(binding instanceof ErrorDesignElement.BlackBoxErrorDesignElement) ? null : binding;
            }
            if (element instanceof IRfInstanceElement && instanceType == null && ((IRfInstanceElement)element).getPredefinedGate() == null) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ANY_DESIGN_INSTANCE_WARNING);
            }
            if (namedElement instanceof IRfDesignElement && ((IRfDesignElement)namedElement).getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY && (architecture = ((IRfDesignElement)namedElement).getArchitecture()) != null) {
                namedElement = architecture;
            }
            if ((result = element instanceof IRfInstanceElement && instanceType != null && LanguageKind.VHDL != wrapp.getLanguageKind() ? DesignUtils.getDesignImage(instanceType) : namedElement.getImage()) == null) {
                result = DVTImages.imageCache.getImage(DVTImages.NONE);
            }
        }
        if (result != null && this.fDecorator != null && wrapp.getOverlayStatus()) {
            result = this.fDecorator.decorateImage(result, wrapper);
        }
        if (result != null) {
            ImageDescriptor decorator;
            String slashPathToRootName;
            String string = slashPathToRootName = wrapp.getRfElement() instanceof TreePath ? ((TreePath)wrapp.getRfElement()).toString("/") : null;
            if (slashPathToRootName != null && (decorator = this.fDecoratorsMap.get(slashPathToRootName)) != null) {
                result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, decorator, 0));
            }
        }
        return result;
    }

    @Override
    public void setDecorators(Map<String, ImageDescriptor> decorators) {
        this.fDecoratorsMap = decorators;
    }

    @Override
    public Color getWrapperBackground(Object element) {
        if (!PrefConst.getDHViewShowPDColor() || !PrefConst.getDHViewShowPDColorBackground()) {
            return super.getBackground(element);
        }
        if (!(element instanceof IDVTElementWrapper) && !(element instanceof TreePath)) {
            return super.getBackground(element);
        }
        Color PDcolor = this.getWrapperPDColor(element, false);
        return PDcolor == null ? super.getBackground(element) : PDcolor;
    }

    @Override
    public Color getWrapperForeground(Object element) {
        if (!PrefConst.getDHViewShowPDColor() || !PrefConst.getDHViewShowPDColorText()) {
            return super.getForeground(element);
        }
        if (!(element instanceof IDVTElementWrapper) && !(element instanceof TreePath)) {
            return super.getForeground(element);
        }
        Color color = this.getWrapperPDColor(element, true);
        return color == null ? super.getForeground(element) : color;
    }

    private Color getWrapperPDColor(Object obj, boolean fg) {
        Object element = null;
        RGB powerDomainRGB = null;
        if (obj instanceof IDVTElementWrapper) {
            IDVTElementWrapper wrapper = (IDVTElementWrapper)obj;
            element = wrapper.getRfElement();
            if (!(element instanceof IRfNamedElement)) {
                return null;
            }
            this.computePfLabel(element, wrapper);
            powerDomainRGB = (RGB)wrapper.getAdditionalInfo((Object)(fg ? IDVTElementWrapper.Attribute.POWER_DOMAIN_FG_RGB : IDVTElementWrapper.Attribute.POWER_DOMAIN_BG_RGB));
        } else if (obj instanceof TreePath) {
            powerDomainRGB = this.computePfColorForTreePath((TreePath)obj, fg);
        }
        if (powerDomainRGB == null) {
            return null;
        }
        return DVTColorUtil.INSTANCE.getColor(powerDomainRGB);
    }
}

