/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.BCXmlTopSaver;
import ro.amiq.dvt.ui.views.BCXmlTopSaverViewType;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.GetTopsResult;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDHUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.NamedElementAndConfigInfo;

public class LazyDHUtils
extends LazyDHUtilsCommon {
    private static LazyDHUtils INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LazyDHUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new LazyDHUtils();
            }
        }
        return INSTANCE;
    }

    @Override
    public GetTopsResult getTops(IProject project) {
        if (project == null) {
            return null;
        }
        String bcTop = BuildConfigManager.getDesignHierarchyTop(project);
        if (bcTop == null || bcTop.isEmpty()) {
            return this.getTopFromBuildConfig(project);
        }
        HistoryItemType historyItemType = HistoryItemType.DESIGN_HIERARCHY_ELABORATION;
        HistoryItem historyItemFromBCXml = BCXmlTopSaver.INSTANCE.getHistoryItemFromBCXml(bcTop, project, historyItemType);
        NamedElementAndConfigInfo topAndConfig = BCXmlTopSaver.INSTANCE.getNamedElementAndConfigFromHistoryItem(historyItemFromBCXml, project, BCXmlTopSaverViewType.DESIGN_HIERARCHY_ELABORATION);
        return this.getTopNamedElement(topAndConfig);
    }

    @Override
    public List<IRfDesignElement> getTopsForElab(RfMixedLangProject rfProject) {
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return Collections.emptyList();
        }
        List<IRfDesignElement> tops = elManager.getTopDesigns();
        if (tops == null || tops.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(tops, (o1, o2) -> {
            String o1Name = o1.getName();
            String o2Name = o2.getName();
            return o1Name.compareTo(o2Name);
        });
        return tops;
    }
}

