/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.GetTopsResult;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.GetTopsResultType;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.NamedElementAndConfigInfo;

public abstract class LazyDHUtilsCommon {
    public static final String $ROOT = "$root";

    public TreePath computeTreeRootNonElab(IProject project) {
        return this.computeTreeRootInternal(project, false, false);
    }

    public TreePath computeTreeRootForElab(IProject project, boolean isLastTop, boolean isTrimMode) {
        return this.computeTreeRootInternal(project, isLastTop, isTrimMode);
    }

    private TreePath computeTreeRootInternal(IProject project, boolean isLastTop, boolean isTrimMode) {
        GetTopsResult topsResult = this.getTops(project);
        if (topsResult == null) {
            return null;
        }
        List<IRfNamedElement> tops = topsResult.getTops();
        if (tops == null || tops.isEmpty()) {
            return null;
        }
        IRfNamedElement top = tops.get(isLastTop ? tops.size() - 1 : 0);
        if (top == null) {
            return null;
        }
        if (isTrimMode) {
            if (DesignUtils.getDesignKind(top) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || DesignUtils.getDesignKind(top) == IRfNamedElement.ElementKind.VHDL_CONFIGURATION) {
                top = ((IRfEntityComplement)((Object)top)).getEntity();
            }
            return TreePathUtils.getElabTopTrimmedTreePath(project, top);
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        IRfNamedElement baseTop = top;
        if (DesignUtils.getDesignKind(top) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || DesignUtils.getDesignKind(top) == IRfNamedElement.ElementKind.VHDL_CONFIGURATION) {
            baseTop = ((IRfEntityComplement)((Object)top)).getEntity();
        }
        TreePath childTreePath = TreePath.child(null, baseTop.getName(), 0);
        childTreePath.setElement(top);
        return childTreePath;
    }

    protected GetTopsResult getTopFromBuildConfig(IProject project) {
        List<IRfDesignElement> allSelectedTops = this.getAllSelectedTops(project);
        if (allSelectedTops == null) {
            return null;
        }
        return new GetTopsResult(GetTopsResultType.COMPUTED_FROM_BUILD_CONFIG, new ArrayList<IRfNamedElement>(allSelectedTops));
    }

    public List<IRfDesignElement> getAllSelectedTops(IProject project) {
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        List<IRfDesignElement> allSelectedTops = this.getTopsForElab(mixedLangProject);
        if (allSelectedTops == null || allSelectedTops.isEmpty()) {
            return null;
        }
        return allSelectedTops;
    }

    protected GetTopsResult getTopNamedElement(NamedElementAndConfigInfo topAndConfig) {
        if (topAndConfig == null) {
            return null;
        }
        IRfNamedElement top = topAndConfig.getNamedElement();
        if (top == null) {
            return null;
        }
        String configName = topAndConfig.getConfigName() == null ? "DEFAULT_CONFIG" : topAndConfig.getConfigName();
        List<IRfNamedElement> tops = Collections.singletonList(top);
        GetTopsResult getTopsResult = new GetTopsResult(GetTopsResultType.RECOVERD_FROM_BUILD_CONFIG_XML, tops);
        getTopsResult.setConfigName(configName);
        return getTopsResult;
    }

    public static List<IRfNamedElement> getDHPortsAndParamsDesignElement(IRfNamedElement selectedElement, IRfNamedElement selectedDesign) {
        List<IRfPortElement> ports;
        List<? extends IRfNamedElement> parameters;
        ArrayList<IRfNamedElement> results = new ArrayList<IRfNamedElement>();
        List<? extends IRfNamedElement> list = parameters = selectedDesign instanceof IRfDesignElement ? ((IRfDesignElement)selectedDesign).getLocalParameters() : null;
        if (parameters != null && !parameters.isEmpty()) {
            ArrayList<? extends IRfNamedElement> parametersCopy = new ArrayList<IRfNamedElement>(parameters);
            Collections.sort(parametersCopy, new DHViewUtilsCommon.SignalViewComparator(null, true));
            results.addAll(parametersCopy);
        }
        if (!(ports = DesignUtils.getPorts(DesignUtils.DesignRequest.of(selectedElement, selectedDesign), false, null)).isEmpty()) {
            Collections.sort(ports, new DHViewUtilsCommon.SignalViewComparator(null, true));
            results.addAll(ports);
        }
        return results;
    }

    public abstract GetTopsResult getTops(IProject var1);

    public abstract List<IRfDesignElement> getTopsForElab(RfMixedLangProject var1);
}

