/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.actions.CanceledTraceException;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.trace.connections.TCEngine;
import ro.amiq.dvt.ui.trace.connections.TCViewMessages;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTMembersViewContentProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHPortsLabelProvider;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewMessages;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DVTCopyHierarchyPathAction;
import ro.amiq.dvt.ui.views.designhierarchy.IDesignHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DHTrimmedTreePath;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTAddDriversToWaveViewDHPortsViewAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTAddLoadsToWaveViewDHPortsViewAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTAddToWaveViewDHPortsViewAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTDHPortsLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRevealInWaveViewAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyPortsViewCommon;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.StringMatcher;

public class LazyDesignHierarchyPortsView
extends LazyDesignHierarchyPortsViewCommon
implements IDesignHierarchyPortsView {
    public static final String TEXT_FILTER_SWTBOT_ID = String.valueOf(LazyDesignHierarchyPortsView.class.getCanonicalName()) + ".textFilterSWTBotId";
    private TableViewer table;
    private IDVTElementWrapper selectedWrapperPath;
    private final Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap = new IdentityHashMap<IRfInstanceElement, Set<DummyPort>>();
    private StringMatcher portOrGenericToPromote;
    private IMembersLabelProvider labelProvider;
    private IRfNamedElement selectedElement;

    private static List<IDVTElementWrapper> getHelpMsg() {
        return new ArrayList<IDVTElementWrapper>(INPUT_DESIGN_HIERARCHY_PORTS_VIEW);
    }

    public LazyDesignHierarchyPortsView(LazyDesignHierarchyView provider) {
        super(provider);
    }

    @Override
    public void initAndShow(Composite parent, String filterText) {
        this.setSite((IWorkbenchPartSite)this.lazyView.getViewSite());
        this.setSelectionChangedListeners(this.lazyView.getSelectionChangedListeners());
        this.createPartControl(parent);
        if (filterText != null && !filterText.isEmpty()) {
            this.initTextFilterSilent("default-filter", filterText);
        }
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: name");
        this.setTextFilterSWTBotId("default-filter", TEXT_FILTER_SWTBOT_ID);
        Composite tableComposite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        tableComposite.setLayoutData((Object)compositeGridData);
        tableComposite.setLayout((Layout)new FillLayout(256));
        this.table = new TableViewer(tableComposite, 268436226);
        this.table.setContentProvider((IContentProvider)new DVTMembersViewContentProvider());
        this.labelProvider = new DVTDHPortsLabelProvider(this);
        this.table.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof Table) {
                    LazyDesignHierarchyPortsView.this.setFocus();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                LazyDesignHierarchyPortsView.this.gotoSelectedElement("default-tree");
            }
        });
        this.getControl().addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.getControl().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event != null) {
                    ObjectionManager.getInstance().clear(Objection.DESIGN_HIERARCHY_PORTS_VIEW_SELECTION);
                }
            }
        });
        this.createContextMenu();
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    private void createContextMenu() {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.activateContext("ro.amiq.dvt.ui.trace.connections.actions.context");
        MenuManager menuMgr = this.installContextMenuAndSelectionListener(this.getControl());
        if (menuMgr == null) {
            return;
        }
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LazyDesignHierarchyPortsView.this.fillContextMenu(manager);
            }
        });
    }

    private void startTraceJobForSelectedPort(final TCOperation traceOperation, boolean blocking) {
        if (!TCViewUtils.shouldContinueWithTraceOperation(TCViewUtils.TraceMessageDialogType.QUESTION)) {
            return;
        }
        final IRfPortElement port = this.getSelectedPort();
        if (port == null) {
            return;
        }
        if (this.selectedPath == null) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(TCViewMessages.fJobText){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", -1);
                try {
                    IRfNamedElement namedElement = LazyDesignHierarchyPortsView.this.selectedPath.getNamedElement();
                    if (namedElement == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IRfSingleLangProject rfProject = namedElement.getRfProject();
                    if (rfProject == null) {
                        return Status.CANCEL_STATUS;
                    }
                    ElementPath dhTopPath = TreePathUtils.getTopParentElementPath(LazyDesignHierarchyPortsView.this.selectedPath, LazyDesignHierarchyPortsView.this.selectedPath instanceof DHTrimmedTreePath);
                    ElementPath selectedInstanceElementPath = TreePathUtils.getElementPathFromTreePath(LazyDesignHierarchyPortsView.this.selectedPath, true);
                    TCEngine.INSTANCE.runFromHierarchy(traceOperation, port, new IdentityHashMap<IRfInstanceElement, Set<DummyPort>>(LazyDesignHierarchyPortsView.this.dummyPortMap), monitor, dhTopPath, selectedInstanceElementPath);
                }
                catch (CanceledTraceException canceledTraceException) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)port.getRfProject().getProject());
        job.schedule(0L);
        if (blocking) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    @Override
    public void testStartTraceJobforSelectedPort(TCOperation traceOperation) {
        this.startTraceJobForSelectedPort(traceOperation, false);
    }

    public String getTCMenuItemLabel(TCOperation operation) {
        switch (operation) {
            case DRIVE: {
                return TCViewMessages.fTraceDriveText;
            }
            case LOAD: {
                return TCViewMessages.fTraceLoadText;
            }
            case DRIVE_AND_LOAD: {
                return TCViewMessages.fTraceDriveAndLoadText;
            }
        }
        return "";
    }

    private void fillContextMenu(IMenuManager mgr) {
        TreePath selection = this.lazyView.getLazyTree().getSelection();
        this.addToWaveAction(mgr, selection, this.getSelection());
        final IRfPortElement port = this.getSelectedPort();
        if (port == null) {
            return;
        }
        IContributionItem[] existingActions = mgr.getItems();
        mgr.removeAll();
        mgr.add((IContributionItem)new Separator());
        IContributionItem[] iContributionItemArray = existingActions;
        int n = existingActions.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem existingAction = iContributionItemArray[n2];
            mgr.add(existingAction);
            ++n2;
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)new DVTCopyHierarchyPathAction(this.lazyView.getLazyTree().getTree(), this.getProject(), port));
        if (selection == null) {
            return;
        }
        if (DVTRefactorDesignElementUtils.shouldNotShowConnectInEditorActions(port, this.getProject())) {
            return;
        }
        IRfNamedElement namedElement = selection.getNamedElement();
        if (!(namedElement instanceof IRfInstanceElement)) {
            return;
        }
        IRfInstanceElement instance = (IRfInstanceElement)namedElement;
        Boolean[] isPortConnected = DVTRefactorDesignElementUtils.isPortConnected(port, instance);
        if (isPortConnected[0].booleanValue()) {
            return;
        }
        mgr.add((IContributionItem)new Separator());
        if (port != null && port.isOutput()) {
            mgr.add((IAction)new Action("Connect Output Port"){

                public void run() {
                    LazyDesignHierarchyPortsView.this.onSelectOutputInstancePort(port);
                }
            });
        }
        if (port != null && port.isInput()) {
            mgr.add((IAction)new Action("Connect Input Port"){

                public void run() {
                    LazyDesignHierarchyPortsView.this.onSelectInputInstancePort(port);
                }
            });
        }
        ObjectionManager.getInstance().clear(Objection.DESIGN_HIERARCHY_CONTEXT_MENU);
    }

    public void addToWaveAction(IMenuManager mgr, TreePath dhSelection, ISelection iSelection) {
        IProject project = this.lazyView.getProject();
        if (project == null) {
            return;
        }
        if (!DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project)) {
            return;
        }
        DVTAddToWaveViewDHPortsViewAction addToWaveAction = new DVTAddToWaveViewDHPortsViewAction(dhSelection, iSelection);
        DVTAddDriversToWaveViewDHPortsViewAction addDriversToWave = new DVTAddDriversToWaveViewDHPortsViewAction(dhSelection, iSelection, this.getProject());
        DVTAddLoadsToWaveViewDHPortsViewAction addLoadsToWave = new DVTAddLoadsToWaveViewDHPortsViewAction(dhSelection, iSelection, this.getProject());
        DVTRevealInWaveViewAction revealInDVTWaveView = new DVTRevealInWaveViewAction(dhSelection, iSelection);
        IContributionItem[] existingActions = mgr.getItems();
        mgr.removeAll();
        mgr.add((IContributionItem)new Separator());
        MenuManager waveViewer = new MenuManager("Waveform Viewer", "waveViewer");
        waveViewer.add((IAction)addToWaveAction);
        IRfPortElement selectedPort = this.getSelectedPort();
        if (selectedPort != null) {
            waveViewer.add((IAction)addDriversToWave);
            waveViewer.add((IAction)addLoadsToWave);
            waveViewer.add((IContributionItem)new Separator());
            waveViewer.add((IAction)revealInDVTWaveView);
        }
        mgr.add((IContributionItem)waveViewer);
        IContributionItem[] iContributionItemArray = existingActions;
        int n = existingActions.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem existingAction = iContributionItemArray[n2];
            mgr.add(existingAction);
            ++n2;
        }
    }

    protected void onSelectInputInstancePort(IRfPortElement port) {
        TreePath selection = this.lazyView.getLazyTree().getSelection();
        if (selection == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "Please select a port from the ports View.", 2, new String[]{"OK"}, 0);
                dialog.open();
            });
            return;
        }
        this.lazyView.selectDstAction(selection, port);
    }

    protected void onSelectOutputInstancePort(IRfPortElement port) {
        TreePath selection = this.lazyView.getLazyTree().getSelection();
        if (selection == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "Please select a port from the ports View.", 2, new String[]{"OK"}, 0);
                dialog.open();
            });
            return;
        }
        this.lazyView.selectSrcAction(selection, port);
    }

    @Override
    public IProject getProject() {
        if (this.lazyView == null || this.lazyView.getProject() == null) {
            return super.getProject();
        }
        return this.lazyView.getProject();
    }

    @Override
    public void doTraceOperationAction(TCOperation operation) {
        switch (operation) {
            case DRIVE: {
                this.startTraceJobForSelectedPort(TCOperation.DRIVE, false);
                break;
            }
            case LOAD: {
                this.startTraceJobForSelectedPort(TCOperation.LOAD, false);
                break;
            }
            case DRIVE_AND_LOAD: {
                this.startTraceJobForSelectedPort(TCOperation.DRIVE_AND_LOAD, false);
                break;
            }
        }
    }

    @Override
    public void updatePorts(IDVTElementWrapper wrapper, String portToPromote) {
    }

    @Override
    public void updatePortsUsingTreePath(TreePath path, String portToPromote) {
        if (path == null || !(path.getElement() instanceof IRfNamedElement)) {
            this.cleanView(true);
            return;
        }
        this.portOrGenericToPromote = portToPromote == null ? null : ViewsUtils.createCamelCaseOrRegexMatcher(portToPromote, true, false);
        this.selectedPath = path;
        ((DHPortsLabelProvider)this.labelProvider).setShowUPF(PrefConst.getDHViewShowUPF());
        this.labelProvider.setBoldMatcher(this.portOrGenericToPromote);
        IRfNamedElement iRfNamedElement = this.selectedElement = path.getElement() instanceof IRfNamedElement ? (IRfNamedElement)path.getElement() : null;
        if (this.selectedElement instanceof RfDummyElement) {
            this.selectedElement = null;
        }
        this.selectedWrapperPath = LazyDesignHierarchyPortsView.computeSelectedWrapperFromPath(path, this.selectedElement);
        this.dummyPortMap.clear();
        this.showFilteredPorts();
    }

    @Override
    public void cleanView(boolean showEmptyMessage) {
        this.selectedPath = null;
        this.selectedWrapperPath = null;
        this.selectedElement = null;
        this.portOrGenericToPromote = null;
        this.labelProvider.setBoldMatcher(this.portOrGenericToPromote);
        this.dummyPortMap.clear();
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return;
        }
        boolean noMatchesFound = this.isFiltered();
        List elements = LazyDesignHierarchyPortsView.getHelpMsg();
        if (!showEmptyMessage) {
            elements = new ArrayList<IDVTElementWrapper>();
        }
        if (noMatchesFound) {
            elements = NO_MATCHES_FOUND;
        }
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return;
        }
        this.table.setInput((Object)elements);
        this.table.setSelection(null);
    }

    private void showFilteredPorts() {
        boolean noMatchesFound;
        if (this.selectedElement == null || this.selectedWrapperPath == null) {
            this.cleanView(true);
            return;
        }
        List elements = LazyDesignHierarchyPortsView.getOrderedPorts(this.getStringMatcher("default-filter"), this.selectedWrapperPath, this.labelProvider, this.selectedElement, this.portOrGenericToPromote, this.dummyPortMap);
        boolean bl = noMatchesFound = this.isFiltered() && elements.isEmpty();
        if (elements.isEmpty()) {
            elements.add(new BasicElementWrapper(DHViewMessages.fDHPortsViewNoPorts));
        }
        if (noMatchesFound) {
            elements = NO_MATCHES_FOUND;
        }
        this.table.setInput((Object)elements);
        this.table.setSelection(null);
        ObjectionManager.getInstance().clearForMembers(this);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        this.setBreadcrumbData();
        IRfNamedElement selectedPortOrParam = this.getSelectedNamedElement();
        DesignUtils.DesignRequest designRequest = DesignUtils.DesignRequest.of(this.selectedElement, DHViewUtils.getDesignHintFromWrapper(this.selectedWrapperPath));
        if (selectedPortOrParam instanceof IRfFieldElement && (((IRfFieldElement)selectedPortOrParam).isParameter() || ((IRfFieldElement)selectedPortOrParam).isTypeParameter()) && designRequest != null) {
            DVTRfUtils.goToGenericConnectionOrDeclaration((IRfFieldElement)selectedPortOrParam, this.selectedElement.getRfProject(), this.selectedPath, true);
        } else {
            DVTRfUtils.goToPortConnectionOrDeclaration(selectedPortOrParam, designRequest, this.dummyPortMap, true);
            IDesignPathProvider.updatePathManagerForActiveEditor(this.selectedPath);
        }
    }

    private void setBreadcrumbData() {
        try {
            if (this.selectedPath == null) {
                return;
            }
            Object element = this.selectedPath.getElement();
            if (element == null) {
                return;
            }
            if (!(element instanceof IRfNamedElement) || element instanceof RfDummyElement) {
                return;
            }
            IRfDefElement declaration = ((IRfNamedElement)element).getDeclaration();
            if (declaration == null || declaration.getDefFile() == null) {
                return;
            }
            IResource file = (IResource)declaration.getDefFile().getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        this.showFilteredPorts();
    }

    @Override
    public Control getControl() {
        if (this.table == null) {
            return null;
        }
        return this.table.getControl();
    }

    @Override
    public List<?> testHelpGetInput() {
        List input = (List)this.table.getInput();
        ArrayList<IRfNamedElement> ports = new ArrayList<IRfNamedElement>();
        for (Object obj : input) {
            Object elem;
            if (!(obj instanceof IDVTElementWrapper) || !((elem = ((IDVTElementWrapper)obj).getRfElement()) instanceof IRfNamedElement)) continue;
            ports.add((IRfNamedElement)elem);
        }
        return ports;
    }

    @Override
    public void testHelpSelectByIndex(int index, boolean emulateUserSelection) {
        Table t = this.table.getTable();
        TableItem item = t.getItem(index);
        t.setSelection(item);
        t.showSelection();
        t.notifyListeners(13, (Event)new DVTSyntheticEvent(emulateUserSelection));
    }

    @Override
    public void selectPortInTableByName(String portName) {
        Table t;
        Object elem;
        Object obj;
        if (this.table == null || this.table.getInput() == null) {
            return;
        }
        List portList = (List)this.table.getInput();
        if (portList.isEmpty()) {
            return;
        }
        Object firstWrapper = portList.get(0);
        if (!(firstWrapper instanceof IDVTElementWrapper)) {
            return;
        }
        Object first = ((IDVTElementWrapper)firstWrapper).getRfElement();
        int i = 0;
        int foundPortIndex = -1;
        if (first instanceof String) {
            i = 0;
            while (i < portList.size()) {
                obj = portList.get(i);
                if (obj instanceof IDVTElementWrapper && (elem = ((IDVTElementWrapper)obj).getRfElement()) instanceof String && ((String)elem).equals(portName)) {
                    foundPortIndex = i;
                }
                ++i;
            }
        }
        if (first instanceof IRfPortElement || first instanceof IRfFieldElement) {
            i = 0;
            while (i < portList.size()) {
                obj = portList.get(i);
                if (obj instanceof IDVTElementWrapper && (elem = ((IDVTElementWrapper)obj).getRfElement()) instanceof IRfPortElement) {
                    String PortName = ((IRfPortElement)elem).getName();
                    if (portName != null && PortName.equals(portName)) {
                        foundPortIndex = i;
                    }
                }
                ++i;
            }
        }
        if (foundPortIndex != -1 && (t = this.table.getTable()) != null && !t.isDisposed()) {
            t.setSelection(foundPortIndex);
            t.showSelection();
            t.select(foundPortIndex);
            t.notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        }
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public Tree getTree(String treeId) {
        return null;
    }

    @Override
    public boolean isFocused() {
        if (this.getControl() == null) {
            return false;
        }
        return this.getControl().isFocusControl();
    }

    @Override
    public void dispose() {
        this.selectedPath = null;
        this.selectedWrapperPath = null;
        this.selectedElement = null;
        this.portOrGenericToPromote = null;
        this.labelProvider.setBoldMatcher(this.portOrGenericToPromote);
        this.dummyPortMap.clear();
    }

    @Override
    public IRfPortElement getSelectedPort() {
        IDVTElementWrapper wrapper = this.getSelectedWrapper(null);
        if (wrapper == null) {
            return null;
        }
        Object elem = wrapper.getRfElement();
        if (!(elem instanceof IRfPortElement)) {
            return null;
        }
        return (IRfPortElement)elem;
    }

    public IRfNamedElement getSelectedNamedElement() {
        IDVTElementWrapper wrapper = this.getSelectedWrapper(null);
        if (wrapper == null) {
            return null;
        }
        Object elem = wrapper.getRfElement();
        if (!(elem instanceof IRfNamedElement)) {
            return null;
        }
        return (IRfNamedElement)elem;
    }

    @Override
    public IDVTElementWrapper getSelectedWrapper(String treeId) {
        StructuredSelection sel = (StructuredSelection)this.getSelection(treeId);
        if (sel == null || sel.size() != 1) {
            return null;
        }
        Object elem = sel.getFirstElement();
        if (!(elem instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)elem;
    }

    @Override
    public ISelection getSelection(String treeId) {
        return this.getSelection();
    }

    @Override
    public ISelection getSelection() {
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return null;
        }
        return this.table.getSelection();
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return null;
    }

    @Override
    public void update(BuildEvents updateEvent) {
        if (this.lazyView == null) {
            return;
        }
        LazyDesignHierarchyView designHierarchyView = this.lazyView;
        if (designHierarchyView == null) {
            return;
        }
        TreePath element = designHierarchyView.getLazyTree().getSelection();
        this.updatePortsUsingTreePath(element, designHierarchyView.getTreeSearchPort());
    }

    @Override
    public void clean() {
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public Control getControlToColorBg() {
        return null;
    }

    @Override
    public Control getControlToColorFg() {
        return null;
    }

    @Override
    public boolean isViewVisible() {
        if (this.lazyView == null) {
            return false;
        }
        LazyDesignHierarchyView parentView = this.lazyView;
        return parentView != null;
    }

    @Override
    public IDVTView getParentView() {
        if (this.lazyView == null) {
            return null;
        }
        return this.lazyView;
    }

    @Override
    public List<?> getInput() {
        List input = (List)this.table.getInput();
        ArrayList<IRfNamedElement> ports = new ArrayList<IRfNamedElement>();
        for (Object obj : input) {
            Object elem;
            if (!(obj instanceof IDVTElementWrapper) || !((elem = ((IDVTElementWrapper)obj).getRfElement()) instanceof IRfNamedElement)) continue;
            ports.add((IRfNamedElement)elem);
        }
        return ports;
    }

    @Override
    public List<IRfPortElement> getPortsInput() {
        List input = (List)this.table.getInput();
        ArrayList<IRfPortElement> ports = new ArrayList<IRfPortElement>();
        for (Object obj : input) {
            Object elem;
            if (!(obj instanceof IDVTElementWrapper) || !((elem = ((IDVTElementWrapper)obj).getRfElement()) instanceof IRfPortElement)) continue;
            ports.add((IRfPortElement)elem);
        }
        return ports;
    }
}

