/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.ui.editor.contentasisst.DVTPositionalTooltipsUtils;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.DVTElementWrapperOpt;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class LazyDesignHierarchyPortsViewCommon
extends AbstractFilteredView {
    public static final String ID = "ro.amiq.dvt.ui.views.lazydesignhierarchy.LazyDesignHierarchyPortsView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.NO_INFORMATION);
    protected TreePath selectedPath;
    protected final LazyDesignHierarchyView lazyView;

    public LazyDesignHierarchyPortsViewCommon(LazyDesignHierarchyView provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.valueOf(LazyDesignHierarchyPortsView.class.getName()) + " requires non-null " + LazyDesignHierarchyView.class.getName());
        }
        this.lazyView = provider;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    public void setSelectedPath(TreePath path) {
        this.selectedPath = path;
    }

    public String getParamValue(IRfNamedElement param) {
        if (param == null) {
            return null;
        }
        IProject project = this.lazyView.getProject();
        if (project == null) {
            return null;
        }
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (rfMixedLangProject == null) {
            return null;
        }
        ELManager manager = rfMixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        IELMemory memory = manager.getMemory();
        if (memory == null) {
            return null;
        }
        ElementPath elementPath = this.getSelectedElementPath();
        if (elementPath == null) {
            return null;
        }
        ELParamValues paramValuesFor = memory.paramValuesFor(elementPath);
        if (paramValuesFor == null) {
            return null;
        }
        return DVTPositionalTooltipsUtils.getParamValueString(param, manager, elementPath, paramValuesFor, true);
    }

    public String getInterfaceInstanceText(IRfPortElement element) {
        IProject project = this.lazyView.getProject();
        if (project == null) {
            return null;
        }
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (rfMixedLangProject == null) {
            return null;
        }
        ELManager manager = rfMixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        ElementPath elementPath = this.getSelectedElementPath();
        if (elementPath == null) {
            return null;
        }
        ELSpecialization.InterfacePortInstance actualInstance = manager.getInterfacePortInstance(elementPath, element);
        return actualInstance != null ? actualInstance.getInstance().getHierarchyPath().toString() : null;
    }

    public ElementPath getSelectedElementPath() {
        return TreePathUtils.getElementPathFromTreePath(this.selectedPath);
    }

    public static IDVTElementWrapper computeSelectedWrapperFromPath(TreePath path, IRfNamedElement selectedElement) {
        IRfSingleLangProject rfProject;
        ElementPath elementPathFromTreePath = TreePathUtils.getElementPathFromTreePath(path);
        IRfSingleLangProject iRfSingleLangProject = rfProject = selectedElement != null ? selectedElement.getRfProject() : null;
        if (rfProject == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(rfProject.getProject(), false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        if (elementPathFromTreePath == null || elementPathFromTreePath.isEmpty()) {
            return null;
        }
        ELInstance instance = manager.getMemory().instanceFor(elementPathFromTreePath);
        if (instance == null) {
            return null;
        }
        DVTElementWrapperOpt wrapper = new DVTElementWrapperOpt(instance.getDescription());
        wrapper.setInstanceType((IRfDesignElement)instance.getBinding(false));
        wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TREE_PATH, path);
        return wrapper;
    }

    public static List<IDVTElementWrapper> getOrderedPorts(StringMatcher stringMatcher, IDVTElementWrapper selectedWrapperPath, IMembersLabelProvider labelProvider, IRfNamedElement selectedElement, StringMatcher portOrGenericToPromote, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        List<IRfPortElement> ports;
        List<? extends IRfNamedElement> parameters;
        ArrayList<IDVTElementWrapper> results = new ArrayList<IDVTElementWrapper>();
        IRfNamedElement selectedDesign = DHViewUtils.getDesignHintFromWrapper(selectedWrapperPath);
        List<? extends IRfNamedElement> list = parameters = selectedDesign instanceof IRfDesignElement ? ((IRfDesignElement)selectedDesign).getLocalParameters() : null;
        if (parameters != null && !parameters.isEmpty()) {
            ArrayList<? extends IRfNamedElement> parametersCopy = new ArrayList<IRfNamedElement>(parameters);
            Collections.sort(parametersCopy, new DHViewUtilsCommon.SignalViewComparator(portOrGenericToPromote, true));
            for (IRfNamedElement iRfNamedElement : parametersCopy) {
                BasicElementWrapper bw = new BasicElementWrapper(iRfNamedElement);
                if (stringMatcher != null && !ViewsUtils.matchCamelCaseOrRegex(stringMatcher, labelProvider.getText(bw))) continue;
                results.add(bw);
            }
        }
        if (!(ports = DesignUtils.getPorts(DesignUtils.DesignRequest.of(selectedElement, selectedDesign), false, dummyPortMap)).isEmpty()) {
            Object v = selectedWrapperPath.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
            ElementPath elementPath = v instanceof TreePath ? TreePathUtils.getElementPathFromTreePath((TreePath)v) : null;
            DVTPFInfo pdInfo = LazyDesignHierarchyPortsViewCommon.getPFInfoForPort(selectedElement, elementPath);
            Collections.sort(ports, new DHViewUtilsCommon.SignalViewComparator(portOrGenericToPromote, true));
            for (IRfPortElement port : ports) {
                BasicElementWrapper bw = new BasicElementWrapper(port);
                if (pdInfo != null) {
                    String retentionRuleName;
                    bw.setAdditionalInfo(IDVTElementWrapper.Attribute.POWER_DOMAIN_NAME, pdInfo.getPowerDomainName());
                    ElementPath portPath = ElementPath.join(elementPath, port.getName());
                    String isolationStrategyName = pdInfo.getIsolationStrategyByElement(portPath);
                    if (isolationStrategyName != null) {
                        bw.setAdditionalInfo(IDVTElementWrapper.Attribute.PF_RULE_NAME, isolationStrategyName);
                        DVTPFIsolationStrategyInfo isolationStrategyByName = pdInfo.getIsolationStrategyByName(isolationStrategyName);
                        if (isolationStrategyByName != null) {
                            bw.setAdditionalInfo(IDVTElementWrapper.Attribute.CLAMP_VALUE, isolationStrategyByName.getClampValue().toUpperCase());
                        }
                    }
                    if ((retentionRuleName = pdInfo.getRetentionRuleByElement(portPath)) != null) {
                        bw.setAdditionalInfo(IDVTElementWrapper.Attribute.PF_RULE_NAME, retentionRuleName);
                    }
                }
                bw.setAdditionalInfo(IDVTElementWrapper.Attribute.PORT_INSTANCE, selectedWrapperPath);
                if (!ViewsUtils.matchCamelCaseOrRegex(stringMatcher, labelProvider.getText(bw))) continue;
                results.add(bw);
            }
        }
        return results;
    }

    private static DVTPFInfo getPFInfoForPort(IRfNamedElement selectedElement, ElementPath elementPath) {
        IRfSingleLangProject rfProject;
        IRfSingleLangProject iRfSingleLangProject = rfProject = selectedElement != null ? selectedElement.getRfProject() : null;
        if (rfProject == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(rfProject.getProject(), false);
        if (mixedLangProject == null) {
            return null;
        }
        DVTPFModel pfModel = mixedLangProject.getPFModel();
        if (pfModel == null) {
            return null;
        }
        return pfModel.getPDInfoForInstance(elementPath);
    }
}

