/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.designhierarchy.DVTCopyHierarchyPathAction;
import ro.amiq.dvt.ui.views.designhierarchy.IDesignHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;
import ro.amiq.dvt.utils.Utils;

@ForTestingOrDebuggingOnly
public class LazyDesignHierarchyTestUtils
implements ILazyTreeTestUtils {
    private DVTLazyView lazyView;

    public LazyDesignHierarchyTestUtils(DVTLazyView lazyTree) {
        this.lazyView = lazyTree;
    }

    public List<TreePath> testGetViewContent() {
        return this.getLazyTree().getViewContent();
    }

    public List<TreePath> testRevealInView(String searchedInstanceName) {
        if (!(this.lazyView instanceof LazyDesignHierarchyView)) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.lazyView.getProject(), false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        String[] pathSegments = searchedInstanceName.split("/");
        TreePath lastParent = TreePath.TOP_DUMMY_TREE_PATH;
        int i = 0;
        while (i < pathSegments.length) {
            TreePath currPath;
            String[] newSegments = new String[i + 1];
            System.arraycopy(pathSegments, 0, newSegments, 0, i + 1);
            lastParent = currPath = TreePathUtils.createTreePathFromElInstance(lastParent, manager.getMemory().instanceFor(ElementPath.create(newSegments)), false);
            ++i;
        }
        ((LazyDesignHierarchyView)this.lazyView).revealInDesignHierarchyView(lastParent);
        ArrayList<Objection> objections = new ArrayList<Objection>();
        Objection objection = this.getObjection();
        objections.add(objection);
        Objection[] objs = new Objection[objections.size()];
        ObjectionManager.getInstance().waitFor(objections.toArray(objs));
        return this.getLazyTree().getViewContent();
    }

    @Override
    public LazyTree getLazyTree() {
        return this.lazyView.getLazyTree();
    }

    public String testHelpCopyHierarchyPathAction() {
        new DVTCopyHierarchyPathAction(this.getLazyTree().getTree(), this.lazyView.getProject()).run();
        return Utils.pasteFromClipboard();
    }

    public List<?> testHelpGetInstancePorts() {
        if (!(this.lazyView instanceof LazyDesignHierarchyView)) {
            return null;
        }
        IDesignHierarchyPortsView portsView = ((LazyDesignHierarchyView)this.lazyView).getPortsView();
        if (!(portsView instanceof LazyDesignHierarchyPortsView)) {
            return null;
        }
        return portsView.testHelpGetInput();
    }

    public void testHelpSelectPortByIndex(int index, boolean emulateUserSelection) {
        if (!(this.lazyView instanceof LazyDesignHierarchyView)) {
            return;
        }
        IDesignHierarchyPortsView portsView = ((LazyDesignHierarchyView)this.lazyView).getPortsView();
        if (!(portsView instanceof LazyDesignHierarchyPortsView)) {
            return;
        }
        ((LazyDesignHierarchyPortsView)portsView).testHelpSelectByIndex(index, emulateUserSelection);
    }

    public String testHelpCopyHierarchyWirePathAction() {
        if (!(this.lazyView instanceof LazyDesignHierarchyView)) {
            return null;
        }
        IDesignHierarchyPortsView portsView = ((LazyDesignHierarchyView)this.lazyView).getPortsView();
        if (!(portsView instanceof LazyDesignHierarchyPortsView)) {
            return null;
        }
        if (portsView == null || portsView.getControl().isDisposed()) {
            return "";
        }
        ISelection selection = portsView.getSelection();
        if (!(selection instanceof StructuredSelection)) {
            return "";
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (!(firstElement instanceof BasicElementWrapper)) {
            return "";
        }
        BasicElementWrapper wrapper = (BasicElementWrapper)firstElement;
        Object element = wrapper.getRfElement();
        if (!(element instanceof IRfPortElement)) {
            return "";
        }
        IRfPortElement selectedPort = (IRfPortElement)element;
        new DVTCopyHierarchyPathAction(this.getLazyTree().getTree(), this.lazyView.getProject(), selectedPort).run();
        return Utils.pasteFromClipboard();
    }

    @Override
    public void testSetSelection(TreePath path) {
        this.getLazyTree().testSetSelection(path);
    }

    public void testHelpTracePortInHierarchy(TCOperation btnToClick) {
        if (!(this.lazyView instanceof LazyDesignHierarchyView)) {
            return;
        }
        IDesignHierarchyPortsView portsView = ((LazyDesignHierarchyView)this.lazyView).getPortsView();
        if (!(portsView instanceof LazyDesignHierarchyPortsView)) {
            return;
        }
        if (portsView == null || portsView.getControl().isDisposed()) {
            return;
        }
        portsView.testStartTraceJobforSelectedPort(btnToClick);
    }

    public Composite testHelpGetControlParent() {
        return ((LazyDesignHierarchyView)this.lazyView).testGetControlParent();
    }

    public Action testGetShowPortsViewAction() {
        if (!(this.lazyView instanceof LazyDesignHierarchyView)) {
            return null;
        }
        return ((LazyDesignHierarchyView)this.lazyView).testGetPortsViewAction();
    }

    @Override
    public boolean selectInLazyTree(String searchedInstanceName, int instanceCount) {
        Tree designHierarchyTree = this.testGetViewTree();
        if (designHierarchyTree == null) {
            return false;
        }
        TreeItem[] treeItems = designHierarchyTree.getItems();
        if (treeItems == null || treeItems.length == 0) {
            return false;
        }
        TreeItem searchedTreeItem = this.searchTreeItemInTree(treeItems, searchedInstanceName, new AtomicInteger(instanceCount));
        if (searchedTreeItem == null) {
            throw new RuntimeException("Unable to select non-existing node " + searchedInstanceName);
        }
        Object data = searchedTreeItem.getData();
        TreePath searchedPath = null;
        if (data instanceof TreePath) {
            searchedPath = (TreePath)data;
        }
        if (searchedPath == null) {
            throw new RuntimeException("Unable to select non-existing node " + searchedInstanceName);
        }
        designHierarchyTree.setSelection(searchedTreeItem);
        this.testSetSelection(searchedPath);
        designHierarchyTree.showSelection();
        designHierarchyTree.notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        return true;
    }

    public boolean testSendSelectionEvent(TreeItem selection) {
        Tree designHierarchyTree = this.testGetViewTree();
        if (designHierarchyTree == null) {
            return false;
        }
        Object data = selection.getData();
        if (!(data instanceof TreePath)) {
            return false;
        }
        designHierarchyTree.setSelection(selection);
        this.testSetSelection((TreePath)data);
        designHierarchyTree.showSelection();
        designHierarchyTree.notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        return true;
    }

    @Override
    public DVTLazyView getLazyView() {
        return this.lazyView;
    }

    @Override
    public Objection getObjection() {
        return Objection.DESIGN_HIERARCHY;
    }

    public List<TreePath> getViewContent() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree != null) {
            return lazyTree.getViewContent();
        }
        return Collections.emptyList();
    }

    public ILabelProvider getLabelProvider() {
        return this.lazyView.getLabelProvider();
    }
}

