/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryAction;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.views.BCXmlTopSaver;
import ro.amiq.dvt.ui.views.BCXmlTopSaverViewType;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTXmlSaveConfig;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DVTCopyHierarchyPathAction;
import ro.amiq.dvt.ui.views.designhierarchy.IDesignHierarchyPortsView;
import ro.amiq.dvt.ui.views.designhierarchy.UPFPrefDialog;
import ro.amiq.dvt.ui.views.lazy.tree.IELModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeResetForTopActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTAddAllSignalsToWaveViewDHViewAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTAddPortsToWaveViewDHViewAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.GetTopsResult;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.GetTopsResultType;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.HideGeneratesAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDHUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyViewCommon;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyViewSelectTopAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyELShowInstancesOfModuleDHModel;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyELTrimDesignHierarchy;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyElDesignHierarchyModel;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyPortsViewAction;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.NamedElementAndConfigInfo;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.PortsViewMode;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.PrependLibraryAction;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;

public class LazyDesignHierarchyView
extends LazyDesignHierarchyViewCommon {
    public static final String TEXT_FILTER_SWTBOT_ID = String.valueOf(LazyDesignHierarchyView.class.getCanonicalName()) + ".textFilterSWTBotId";
    private static final String SELECT_TOP = "Click the \"Select Top\" button or place the editor cursor on a module/entity and press Shift + F4";
    protected SashForm mainSashForm;
    protected SashForm upperSashForm;
    private Composite childComposite;
    protected Composite sashChildTree;
    protected Composite sashChildPorts;
    protected int[] sashWeights = new int[]{2, 1};
    protected Label indicationGUIFiltered;
    protected boolean hasGUIFilteredElements;
    protected Label labelInfo;
    protected IDesignHierarchyPortsView portsView;
    private PortsViewMode portsViewMode = this.getPortsModeFromPref(false);
    private Composite controlParent;
    private LazyPortsViewAction portsViewAction;
    private Action cancelAction;
    private final LazyDesignHierarchyTestUtils lazyTreeTestUtils = new LazyDesignHierarchyTestUtils(this);
    private DHHistoryAction historyAction;
    private LazyDesignHierarchyViewSelectTopAction selectTopAction;
    private boolean isSearchTextEmpty = true;

    @Override
    public void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        this.childComposite = new Composite(parent, 0);
        this.childComposite.setLayoutData((Object)new GridData(1808));
        this.childComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.mainSashForm = new SashForm(this.childComposite, 512);
        this.mainSashForm.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.mainSashForm.setFont(this.childComposite.getFont());
        this.mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)this.mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        Composite labelComposite = new Composite(fUpperSashFormComposite, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.indicationGUIFiltered = new Label(labelComposite, 0);
        this.indicationGUIFiltered.setImage(DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI));
        this.indicationGUIFiltered.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.indicationGUIFiltered.setToolTipText("Content Filters matched!");
        this.indicationGUIFiltered.setEnabled(this.hasGUIFilteredElements);
        this.labelInfo = new Label(labelComposite, 16384);
        this.labelInfo.setFont(labelComposite.getFont());
        this.labelInfo.setLayoutData((Object)new GridData(768));
        this.computeLabelInfo(this.labelInfo, null, true);
        this.upperSashForm = new SashForm(fUpperSashFormComposite, 512);
        this.upperSashForm.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree = new Composite((Composite)this.upperSashForm, 0);
        this.sashChildTree.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        Text filterText = this.createNewTextFilter(this.sashChildTree);
        if (filterText != null) {
            filterText.setMessage("Filter by: hierarchical name .port");
            Utils.setWidgetSWTBotId((Widget)filterText, TEXT_FILTER_SWTBOT_ID);
        }
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        lazyTree.setSearchBar(filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), false);
        lazyTree.install(this.sashChildTree);
        lazyTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LazyDesignHierarchyView.this.updatePortsView();
            }
        });
        if (this.shouldShowPortsView()) {
            this.showPortsView(this.getPortsModeFromPref(true));
        }
    }

    private void updatePortsView() {
        if (!this.hasPortsView()) {
            return;
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        TreePath selection = lazyTree.getSelection();
        if (selection == null || this.portsView == null) {
            return;
        }
        this.portsView.updatePortsUsingTreePath(selection, this.getTreeSearchPort());
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file then click the \"Select Top\" button.";
        }
        if (this.getModel(IModel.class) != null || this.getModel(IELModel.class) != null) {
            if (!this.getTextFilter("default-filter").getText().isEmpty()) {
                return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
            }
            return SELECT_TOP;
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    public boolean shouldShowSelectTopOption() {
        boolean shouldShowButton;
        boolean isProjectSelected = this.getProject() != null && this.getProject().isAccessible() && ro.amiq.dvt.utils.Utils.hasDvtNature(this.getProject());
        boolean bl = shouldShowButton = this.getModel(IModel.class) != null || this.getModel(IELModel.class) != null;
        return isProjectSelected && shouldShowButton && this.isSearchTextEmpty;
    }

    @Override
    public void selectTop() {
        this.selectTopAction.runWithEvent(null);
    }

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        TreeItem[] sel = this.getLazyTree().getTree().getSelection();
        if (sel == null || sel.length == 0 || !(sel[0].getData() instanceof TreePath)) {
            return;
        }
        TreePath wrapper = (TreePath)sel[0].getData();
        if (wrapper == null) {
            return;
        }
        Object element = wrapper.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof DummyInstance) {
            element = ((DummyInstance)element).getGenericDesign(null);
        }
        if (element instanceof RfDummyElement) {
            return;
        }
        if (!(element instanceof IRfNamedElement)) {
            return;
        }
        this.setDataForBreadcrumb(wrapper);
        DVTRfUtils.goToDeclaration((IRfNamedElement)element, true);
        IDesignPathProvider.updatePathManagerForActiveEditor(wrapper);
    }

    private void setDataForBreadcrumb(TreePath treePath) {
        try {
            if (treePath == null) {
                return;
            }
            Object element = treePath.getElement();
            if (!(element instanceof IRfNamedElement) || element instanceof RfDummyElement) {
                return;
            }
            IRfNamedElement namedElement = (IRfNamedElement)element;
            IRfDefElement declaration = namedElement.getDeclaration();
            if (declaration == null || declaration.getDefFile() == null) {
                return;
            }
            IResource file = (IResource)declaration.getDefFile().getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void computeLabelInfo(Label label, TreePath selectedTop, boolean resetTop) {
        if (label == null || label.isDisposed()) {
            return;
        }
        if (!resetTop && this.lazyElDesignHierarchyModel instanceof LazyELShowInstancesOfModuleDHModel && selectedTop != null) {
            this.setShowInstancesLabel(selectedTop.getNamedElement(), label);
            return;
        }
        String labelText = "";
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            label.setText("[no DVT Project or file selected]");
            return;
        }
        labelText = String.valueOf(labelText) + "[" + project.getName() + "]";
        labelText = String.valueOf(labelText) + " " + this.getInputElementNameForLabel(selectedTop) + " ";
        labelText = String.valueOf(labelText) + this.getNumOfInstancesForLabel();
        label.setText(labelText);
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
        final TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        this.addToWaveAction(manager, selection);
        if (!DVTRefactorDesignElementUtils.shouldNotShowConnectActions(selection.getNamedElement(), this.getProject())) {
            Action selectSource = new Action("Connect Output"){

                public void run() {
                    LazyDesignHierarchyView.this.selectSrcAction(selection, null);
                }
            };
            Action selectDestination = new Action("Connect Input"){

                public void run() {
                    LazyDesignHierarchyView.this.selectDstAction(selection, null);
                }
            };
            manager.add((IAction)selectSource);
            manager.add((IAction)selectDestination);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new DVTCopyHierarchyPathAction(this.getLazyTree().getTree(), this.getProject()));
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        this.cancelAction = new Action("", DVTImages.STOP_CURRENT_BUILD_PROCESS){

            public void run() {
                LazyDesignHierarchyView.this.getLazyTree().cancelOperations();
                this.setEnabled(false);
            }
        };
        this.cancelAction.setEnabled(false);
        this.cancelAction.setToolTipText("Cancel Current Operation");
        toolBarManager.add((IAction)this.cancelAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.selectTopAction = new LazyDesignHierarchyViewSelectTopAction(this, this.childComposite);
        toolBarManager.add((IAction)this.selectTopAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.historyAction = new DHHistoryAction();
        toolBarManager.add((IAction)this.historyAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.portsViewAction = new LazyPortsViewAction(this);
        toolBarManager.add((IAction)this.portsViewAction);
        toolBarManager.add((IContributionItem)new Separator());
        ShowUPFDialogAction showUPFAction = new ShowUPFDialogAction();
        showUPFAction.setEnabled(true);
        toolBarManager.add((IAction)showUPFAction);
        LazyTree lazyTree = this.getLazyTree();
        toolBarManager.add((IAction)new PrependLibraryAction(lazyTree));
        toolBarManager.add((IContributionItem)new Separator());
        HideGeneratesAction hideGeneratesAction = new HideGeneratesAction(lazyTree);
        hideGeneratesAction.setEnabled(true);
        toolBarManager.add((IAction)hideGeneratesAction);
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
        toolBarManager.update(true);
    }

    public void addToHistory(HistoryItem historyItem) {
        if (historyItem == null) {
            return;
        }
        this.historyAction.addElement(historyItem);
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            IProject project = this.getProject();
            if (project == null || !project.isAccessible()) {
                this.clean();
                return;
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && !DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                return;
            }
            if (project.hasNature("ro.amiq.vlogdt.VlogNature") && !DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        boolean resetSelection = updateEvent == null;
        boolean resetTop = updateEvent == null || updateEvent != BuildEvents.INCREMENTAL_BUILD;
        ProjectColorUtils.setFgBg(this, this.getProject().getName());
        GetTopsResult topsResult = LazyDHUtils.getInstance().getTops(this.getProject());
        if (resetTop && topsResult != null && GetTopsResultType.RECOVERD_FROM_BUILD_CONFIG_XML == topsResult.getResultType() && topsResult.getTops() != null && !topsResult.getTops().isEmpty()) {
            IRfNamedElement topNamedElement = topsResult.getTops().get(0);
            TreePath topTreePath = TreePathUtils.getElabTopTrimmedTreePath(this.getProject(), topNamedElement);
            this.lazyElDesignHierarchyModel = new LazyELTrimDesignHierarchy(topTreePath, this.getProject());
        } else if (this.lazyElDesignHierarchyModel == null || resetSelection) {
            this.lazyElDesignHierarchyModel = new LazyElDesignHierarchyModel(this.getProject());
        }
        this.lazyElDesignHierarchyModel.resetNumOfElements();
        this.computeLabelInfo(this.labelInfo, null, resetTop);
        if (this.hasPortsView()) {
            this.portsView.updatePortsUsingTreePath(null, this.getTreeSearchPort());
        }
        lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.lazyElDesignHierarchyModel, resetSelection, resetTop, false, Objection.DESIGN_HIERARCHY));
    }

    @Override
    public void clean() {
        this.computeLabelInfo(this.labelInfo, null, true);
        if (this.hasPortsView()) {
            this.portsView.updatePortsUsingTreePath(null, this.getTreeSearchPort());
        }
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.DESIGN_HIERARCHY));
        }
        this.lazyElDesignHierarchyModel = null;
    }

    @Override
    public Control getControlToColorBg() {
        return this.labelInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.labelInfo;
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.isSearchTextEmpty = this.getTextFilter("default-filter").getText().isEmpty();
        if (this.hasPortsView() && this.isFiltered()) {
            this.portsView.updatePortsUsingTreePath(null, this.getTreeSearchPort());
        }
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(false, Objection.DESIGN_HIERARCHY));
    }

    public boolean hasPortsView() {
        return this.portsView != null && this.portsViewMode != PortsViewMode.HIDE;
    }

    public boolean shouldShowPortsView() {
        return this.portsViewMode != PortsViewMode.HIDE;
    }

    public PortsViewMode getPortsViewMode() {
        return this.portsViewMode;
    }

    public PortsViewMode getPortsModeFromPref(boolean noHide) {
        boolean showPorts = PrefConst.getDHViewShowPorts();
        if (!showPorts && !noHide) {
            return PortsViewMode.HIDE;
        }
        return PrefConst.getDHViewShowPortsBelow() ? PortsViewMode.BELOW : PortsViewMode.RIGHT;
    }

    public void setShowPortsView(PortsViewMode mode) {
        this.portsViewMode = mode;
        PrefConst.setDHViewShowPorts(mode != PortsViewMode.HIDE);
        if (mode != PortsViewMode.HIDE) {
            PrefConst.setDHViewShowPortsBelow(mode == PortsViewMode.BELOW);
        }
    }

    void hidePortsView() {
        this.setShowPortsView(PortsViewMode.HIDE);
        Composite parent = this.upperSashForm.getParent();
        SashForm oldSash = this.upperSashForm;
        int[] oldWeights = oldSash.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.sashWeights = oldWeights;
        }
        this.upperSashForm = new SashForm(parent, oldSash.getStyle());
        this.upperSashForm.setLayout(oldSash.getLayout());
        this.upperSashForm.setLayoutData(oldSash.getLayoutData());
        this.sashChildTree.setParent((Composite)this.upperSashForm);
        if (this.sashChildPorts != null) {
            this.sashChildPorts.dispose();
        }
        this.sashChildPorts = null;
        if (this.portsView != null && !this.portsView.getControl().isDisposed()) {
            this.portsView.dispose();
        }
        this.portsView = null;
        oldSash.dispose();
        parent.layout();
    }

    public void showPortsView(PortsViewMode mode) {
        this.setShowPortsView(mode);
        if (this.upperSashForm == null) {
            return;
        }
        Composite parent = this.upperSashForm.getParent();
        SashForm oldSash = this.upperSashForm;
        int[] oldWeights = oldSash.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.sashWeights = oldWeights;
        }
        this.upperSashForm = new SashForm(parent, mode == PortsViewMode.BELOW ? 512 : 256);
        this.upperSashForm.setLayout(oldSash.getLayout());
        this.upperSashForm.setLayoutData(oldSash.getLayoutData());
        this.sashChildTree.setParent((Composite)this.upperSashForm);
        if (this.sashChildPorts == null) {
            this.sashChildPorts = new Composite((Composite)this.upperSashForm, 0);
            this.sashChildPorts.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
            this.sashChildPorts.setFont(this.mainSashForm.getFont());
            this.sashChildPorts.setLayoutData((Object)new GridData(1808));
            this.portsView = new LazyDesignHierarchyPortsView(this);
            this.portsView.initAndShow(this.sashChildPorts, "");
            this.sashChildPorts.layout();
            this.upperSashForm.setWeights(this.sashWeights);
        } else {
            this.sashChildPorts.setParent((Composite)this.upperSashForm);
        }
        oldSash.dispose();
        parent.layout();
        TreePath selection = this.getLazyTree().getSelection();
        this.portsView.updatePortsUsingTreePath(selection, this.getTreeSearchPort());
    }

    public void doTraceOperationAction(TCOperation operation) {
        if (!this.hasPortsView()) {
            return;
        }
        if (!this.portsView.isFocused()) {
            return;
        }
        this.portsView.doTraceOperationAction(operation);
    }

    public boolean canDoTraceOperationAction() {
        return this.hasPortsView() && this.portsView != null;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public IProject getProject() {
        if (this.dataContainer == null || this.dataContainer.getProject() == null) {
            return null;
        }
        return this.dataContainer.getProject();
    }

    public void resetForTop(TreePath top) {
        try {
            IProject project = this.getProject();
            if (project == null || !project.isAccessible()) {
                this.clean();
                return;
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && !DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                return;
            }
            if (project.hasNature("ro.amiq.vlogdt.VlogNature") && !DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        if (top != null) {
            this.createAndSaveHistoryItemFromElement(top);
        }
        if (this.lazyElDesignHierarchyModel instanceof LazyELTrimDesignHierarchy) {
            ((LazyELTrimDesignHierarchy)this.lazyElDesignHierarchyModel).setTopTreePath(top);
        } else {
            this.lazyElDesignHierarchyModel = new LazyELTrimDesignHierarchy(top, this.getProject());
        }
        this.lazyElDesignHierarchyModel.resetNumOfElements();
        this.computeLabelInfo(this.labelInfo, top, true);
        if (this.hasPortsView()) {
            this.portsView.updatePortsUsingTreePath(null, this.getTreeSearchPort());
        }
        this.getLazyTree().doAction(LazyTreeAction.RESET_FOR_TOP, new LazyTreeResetForTopActionArguments(top, Objection.DESIGN_HIERARCHY));
    }

    public void revealInDesignHierarchyView(TreePath treePath) {
        this.lazyElDesignHierarchyModel = new LazyElDesignHierarchyModel(this.getProject());
        this.getLazyTree().doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(treePath, false, Objection.DESIGN_HIERARCHY));
        if (this.hasPortsView()) {
            this.portsView.updatePortsUsingTreePath(treePath, this.getTreeSearchPort());
        }
    }

    public boolean isMatched(TreePath treePath) {
        return this.getLazyTree().isMatched(treePath);
    }

    public void showInstancesForModule(IRfNamedElement designElement) {
        if (!(this.lazyElDesignHierarchyModel instanceof LazyELShowInstancesOfModuleDHModel)) {
            this.lazyElDesignHierarchyModel = new LazyELShowInstancesOfModuleDHModel(designElement);
        } else {
            ((LazyELShowInstancesOfModuleDHModel)this.lazyElDesignHierarchyModel).setModuleTreePath(designElement);
            ((LazyELShowInstancesOfModuleDHModel)this.lazyElDesignHierarchyModel).resetCache();
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        List<? extends DVTRfNameTypeScopeHelper> elementScope = RfMixedLangManager.getInstance().getDefOfScopeElement(designElement);
        DVTXmlSaveConfig config = new DVTXmlSaveConfig(elementScope);
        config.setTopElementName(designElement.getName());
        HistoryItemType historyItemType = HistoryItemType.SHOW_INSTANCES_IN_DESIGN_HIERARCHY;
        HistoryItem historyItem = BCXmlTopSaver.INSTANCE.createHistoryItem(config, this.getProject(), historyItemType);
        if (historyItem == null) {
            return;
        }
        this.addToHistory(historyItem);
        this.setShowInstancesLabel(designElement, this.labelInfo);
        lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.lazyElDesignHierarchyModel, true, true, false, Objection.DESIGN_HIERARCHY));
    }

    private void setShowInstancesLabel(IRfNamedElement designElement, Label label) {
        long numOfElements;
        if (!(designElement instanceof IRfDesignElement)) {
            return;
        }
        String labelText = "";
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            label.setText("[no DVT Project or file selected]");
            return;
        }
        labelText = String.valueOf(labelText) + "[" + project.getName() + "]";
        labelText = String.valueOf(labelText) + " instances of '";
        IRfDesignElement architecture = ((IRfDesignElement)designElement).getArchitecture();
        if (architecture != null) {
            labelText = String.valueOf(labelText) + architecture.getName() + " of ";
        }
        labelText = String.valueOf(labelText) + designElement.getName() + "'";
        if (this.lazyElDesignHierarchyModel != null && (numOfElements = this.lazyElDesignHierarchyModel.getNumberOfElements()) > 0L) {
            labelText = String.valueOf(labelText) + " [" + numOfElements + (numOfElements == 1L ? " instance]" : " instances]");
        }
        label.setText(labelText);
    }

    private void createAndSaveHistoryItemFromElement(TreePath topPath) {
        if (topPath == null || topPath.getNamedElement() == null) {
            return;
        }
        IRfNamedElement top = topPath.getNamedElement();
        List<? extends DVTRfNameTypeScopeHelper> elementScope = RfMixedLangManager.getInstance().getDefOfScopeElement(top);
        DVTXmlSaveConfig config = new DVTXmlSaveConfig(elementScope);
        config.setTopElementName(top.getName());
        config.setTreePath(topPath);
        HistoryItemType historyItemType = HistoryItemType.DESIGN_HIERARCHY_ELABORATION;
        HistoryItem historyItem = BCXmlTopSaver.INSTANCE.createHistoryItem(config, this.getProject(), historyItemType);
        if (historyItem == null) {
            return;
        }
        this.addToHistory(historyItem);
        BCXmlTopSaver.INSTANCE.writeTopToBCXML(historyItem, BCXmlTopSaverViewType.DESIGN_HIERARCHY_ELABORATION);
    }

    public IDVTElementWrapper getFirstVisibleElement() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return null;
        }
        TreePath firstElement = lazyTree.getFirstVisibleElement();
        if (firstElement == null) {
            return null;
        }
        return new DVTTreeElementWrapper(firstElement.getElement());
    }

    public IDVTElementWrapper getRoot() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return null;
        }
        TreePath root = lazyTree.getRoot();
        if (root == null) {
            return null;
        }
        return new DVTTreeElementWrapper(root.getElement());
    }

    @Override
    public ISelection getSelection() {
        if (this.hasPortsView() && this.portsView.isFocused()) {
            return this.portsView.getSelection();
        }
        return super.getSelection();
    }

    @Override
    public void setCancelActionEnabled(boolean isEnabled) {
        this.cancelAction.setEnabled(isEnabled);
    }

    public int getMatchCacheSize() {
        return this.getLazyTree().getMatchCacheSize();
    }

    public int getLazyTreeCacheSize() {
        return this.getLazyTree().getLazyTreeCacheSize();
    }

    public IDesignHierarchyPortsView getPortsView() {
        return this.portsView;
    }

    protected Composite testGetControlParent() {
        return this.controlParent;
    }

    protected LazyPortsViewAction testGetPortsViewAction() {
        return this.portsViewAction;
    }

    @Override
    public LazyDesignHierarchyTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    @Override
    public void selectionChanged() {
        this.updatePortsView();
    }

    public void showAllTops() {
        BuildConfigManager.removeDesignHierarchyTop(this.getProject(), true);
        this.getLazyTree().doAction(LazyTreeAction.SHOW_ALL_TOPS, new LazyTreeActionArguments(Objection.DESIGN_HIERARCHY));
        if (!(this.lazyElDesignHierarchyModel instanceof LazyElDesignHierarchyModel)) {
            this.lazyElDesignHierarchyModel = new LazyElDesignHierarchyModel(this.getProject());
        }
        this.lazyElDesignHierarchyModel.resetNumOfElements();
        this.computeLabelInfo(this.labelInfo, null, true);
        if (this.hasPortsView()) {
            this.portsView.updatePortsUsingTreePath(null, this.getTreeSearchPort());
        }
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_DESIGN_HIERARCHY;
    }

    @Override
    public long getTotalNumOfNodes() {
        return this.lazyElDesignHierarchyModel == null ? -1L : this.lazyElDesignHierarchyModel.getNumberOfElements();
    }

    @Override
    public boolean hasTotalNumOfNodes() {
        return this.lazyElDesignHierarchyModel != null;
    }

    @Override
    public Objection getObjection() {
        return Objection.DESIGN_HIERARCHY;
    }

    public void selectSrcAction(TreePath src, IRfPortElement port) {
        RefactoringConnectView view = (RefactoringConnectView)ViewsUtils.getViewById("ro.amiq.dvt.ui.views.RefactoringConnectView", true);
        if (view == null) {
            return;
        }
        IProject project = this.getProject();
        if (src == null) {
            return;
        }
        String[] segments = src.getSegments();
        if (segments == null) {
            return;
        }
        IRfNamedElement elementFromSegments = DVTRefactorDesignElementUtils.getElementFromSegments(segments, project);
        if (elementFromSegments instanceof DummyInstance) {
            elementFromSegments = ((DummyInstance)elementFromSegments).design;
        }
        if (view.setProject(project)) {
            view.setSrcPath(segments, port);
        }
    }

    public void selectDstAction(TreePath dst, IRfPortElement port) {
        RefactoringConnectView view = (RefactoringConnectView)ViewsUtils.getViewById("ro.amiq.dvt.ui.views.RefactoringConnectView", true);
        if (view == null) {
            return;
        }
        IProject project = this.getProject();
        if (dst == null) {
            return;
        }
        String[] segments = dst.getSegments();
        if (segments == null) {
            return;
        }
        IRfNamedElement elementFromSegments = DVTRefactorDesignElementUtils.getElementFromSegments(segments, project);
        if (elementFromSegments instanceof DummyInstance) {
            elementFromSegments = ((DummyInstance)elementFromSegments).design;
        }
        if (view.setProject(project)) {
            view.setDstPath(segments, port);
        }
    }

    public void addToWaveAction(IMenuManager mgr, TreePath dhSelection) {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        if (!DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project)) {
            return;
        }
        MenuManager waveViewer = new MenuManager("Waveform Viewer", "waveViewer");
        DVTAddPortsToWaveViewDHViewAction addPortsToWaveAction = new DVTAddPortsToWaveViewDHViewAction(dhSelection);
        waveViewer.add((IAction)addPortsToWaveAction);
        DVTAddAllSignalsToWaveViewDHViewAction addAllSignalsToWaveAction = new DVTAddAllSignalsToWaveViewDHViewAction(dhSelection);
        waveViewer.add((IAction)addAllSignalsToWaveAction);
        IContributionItem[] existingActions = mgr.getItems();
        mgr.removeAll();
        mgr.add((IContributionItem)waveViewer);
        mgr.add((IContributionItem)new Separator());
        IContributionItem[] iContributionItemArray = existingActions;
        int n = existingActions.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem existingAction = iContributionItemArray[n2];
            mgr.add(existingAction);
            ++n2;
        }
    }

    public class DHHistoryAction
    extends HistoryAction {
        @Override
        public void openHistoryItem(HistoryItem item) {
            if (item == null) {
                return;
            }
            NamedElementAndConfigInfo namedElementAndConfigFromHistoryItem = BCXmlTopSaver.INSTANCE.getNamedElementAndConfigFromHistoryItem(item, LazyDesignHierarchyView.this.getProject(), BCXmlTopSaverViewType.DESIGN_HIERARCHY_ELABORATION);
            if (namedElementAndConfigFromHistoryItem == null) {
                return;
            }
            IRfNamedElement namedElementFromHistoryItem = namedElementAndConfigFromHistoryItem.getNamedElement();
            if (namedElementFromHistoryItem == null) {
                return;
            }
            if (namedElementFromHistoryItem instanceof IRfDesignElement && (((IRfDesignElement)namedElementFromHistoryItem).getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || ((IRfDesignElement)namedElementFromHistoryItem).getKind() == IRfNamedElement.ElementKind.VHDL_CONFIGURATION)) {
                namedElementFromHistoryItem = ((IRfEntityComplement)((Object)namedElementFromHistoryItem)).getEntity();
            }
            TreePath historyItemTreePath = TreePathUtils.getElabTopTrimmedTreePath(LazyDesignHierarchyView.this.getProject(), namedElementFromHistoryItem);
            HistoryItemType historyItemType = BCXmlTopSaver.INSTANCE.getHistoryItemTypeFromHistoryItem(item, LazyDesignHierarchyView.this.getProject(), BCXmlTopSaverViewType.DESIGN_HIERARCHY_ELABORATION);
            if (historyItemType == HistoryItemType.SHOW_INSTANCES_IN_DESIGN_HIERARCHY) {
                LazyDesignHierarchyView.this.showInstancesForModule(namedElementFromHistoryItem);
                return;
            }
            LazyDesignHierarchyView.this.resetForTop(historyItemTreePath);
        }

        @Override
        public boolean checkHistoryItem(HistoryItem item) {
            return true;
        }
    }

    private class ShowUPFDialogAction
    extends Action {
        private UPFPrefDialog dialog;

        public ShowUPFDialogAction() {
            super("Show PD", 1);
            this.setImageDescriptor(DVTImages.POWER_DOMAINS);
        }

        public void runWithEvent(Event event) {
            if (!(event.widget instanceof ToolItem)) {
                return;
            }
            ToolItem item = (ToolItem)event.widget;
            Rectangle itemBounds = item.getBounds();
            Point location = item.getParent().toDisplay(itemBounds.x - itemBounds.width - 5, itemBounds.y);
            this.dialog = new UPFPrefDialog(event.display.getActiveShell(), LazyDesignHierarchyView.this.getLazyTree(), location);
            this.dialog.open();
        }
    }
}

