/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTElementWrapperOpt;
import ro.amiq.dvt.ui.views.DVTViewManagerCommon;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IELModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTDHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.GetTopsResult;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDHUtils;

public abstract class LazyDesignHierarchyViewCommon
extends DVTLazyView {
    public static final String ID = "ro.amiq.dvt.ui.views.LazyDesignHierarchyView";
    protected IELModel lazyElDesignHierarchyModel;
    protected DVTDHLabelProvider labelProvider = new DVTDHLabelProvider();
    protected ViewDataContainer dataContainer;
    protected boolean dirty;
    private boolean hasContentFilters;

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.dataContainer = dataContainer;
        this.hasContentFilters = this.getProject() != null && DVTViewManagerCommon.hasGuiFilters(this.getProject(), ViewSet.ViewName.DESIGN_HIERARCHY);
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    @Override
    public List<? extends IRfNamedElement> getPorts(TreePath path) {
        List<IRfPortElement> ports;
        List<? extends IRfNamedElement> parameters;
        if (path == null) {
            return null;
        }
        Object rfElement = path.getElement();
        if (!(rfElement instanceof IRfNamedElement)) {
            return null;
        }
        DVTElementWrapperOpt wrapper = null;
        ElementPath elementPathFromTreePath = TreePathUtils.getElementPathFromTreePath(path);
        ArrayList<? extends IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.getProject(), true);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        if (elementPathFromTreePath == null || elementPathFromTreePath.isEmpty()) {
            return null;
        }
        ELInstance instance = manager.getMemory().instanceFor(elementPathFromTreePath);
        if (instance == null) {
            return null;
        }
        wrapper = new DVTElementWrapperOpt(instance.getDescription());
        IRfDesignElement binding = (IRfDesignElement)instance.getBinding(false);
        ((IDVTElementWrapper)wrapper).setInstanceType(binding);
        List<? extends IRfNamedElement> list = parameters = binding != null ? binding.getLocalParameters() : null;
        if (parameters != null && !parameters.isEmpty()) {
            result.addAll(parameters);
        }
        if ((ports = DesignUtils.getPorts(DesignUtils.DesignRequest.of((IRfNamedElement)rfElement, DHViewUtils.getDesignHintFromWrapper(wrapper)), false, new IdentityHashMap<IRfInstanceElement, Set<DummyPort>>())) != null && !ports.isEmpty()) {
            result.addAll(ports);
        }
        return result;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return Collections.emptyList();
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        if (modelClass == null) {
            return null;
        }
        if (modelClass == IELModel.class) {
            return this.lazyElDesignHierarchyModel;
        }
        return null;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    @Override
    public boolean supportsDecorations() {
        return false;
    }

    @Override
    public String getTreeSearchPort() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getSearchPort();
    }

    public String getInputElementNameForLabel(TreePath selectedTop) {
        String inputElementName = "";
        if (selectedTop == null) {
            List<IRfNamedElement> tops;
            GetTopsResult topsResult = LazyDHUtils.getInstance().getTops(this.getProject());
            if (topsResult != null && (tops = topsResult.getTops()).size() == 1 && tops.get(0) != null) {
                IRfNamedElement topElement = tops.get(0);
                if (topElement instanceof IRfBlockElement && ((IRfBlockElement)topElement).getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                    IRfDesignElement entity = ((IRfBlockElement)topElement).getEntity();
                    if (entity != null) {
                        inputElementName = String.valueOf(((IRfBlockElement)topElement).getName()) + " of " + entity.getName();
                    }
                } else if (topElement instanceof IRfDesignElement && ((IRfDesignElement)topElement).getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY) {
                    IRfDesignElement architecture = ((IRfDesignElement)topElement).getArchitecture();
                    if (architecture != null) {
                        inputElementName = String.valueOf(architecture.getName()) + " of " + ((IRfDesignElement)topElement).getName();
                    }
                } else {
                    inputElementName = topElement.getName();
                }
            }
        } else {
            String topName;
            inputElementName = topName = selectedTop.getLastSegment();
            Object topElement = selectedTop.getElement();
            if (topElement instanceof IRfBlockElement && ((IRfBlockElement)topElement).getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                IRfDesignElement entity = ((IRfBlockElement)topElement).getEntity();
                if (entity != null) {
                    inputElementName = String.valueOf(((IRfBlockElement)topElement).getName()) + " of " + entity.getName();
                }
            } else if (topElement instanceof IRfDesignElement && ((IRfDesignElement)topElement).getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY) {
                IRfDesignElement architecture = ((IRfDesignElement)topElement).getArchitecture();
                if (architecture != null) {
                    inputElementName = String.valueOf(architecture.getName()) + " of " + ((IRfDesignElement)topElement).getName();
                }
            } else if (topElement instanceof IRfInstanceElement) {
                inputElementName = ((DVTDHLabelProvider)this.getLabelProvider()).getTextForLabel(selectedTop);
            }
        }
        if (inputElementName == null) {
            return "";
        }
        return inputElementName;
    }

    public String getNumOfInstancesForLabel() {
        long numOfElements;
        long l = numOfElements = this.lazyElDesignHierarchyModel == null ? 0L : this.lazyElDesignHierarchyModel.getNumberOfElements();
        if (numOfElements > 0L) {
            return "[" + numOfElements + (numOfElements == 1L ? " instance]" : " instances]");
        }
        return "";
    }
}

